/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifj;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.TextWrapper;
import oracle.bali.ewt.text.WordWrapper;
import oracle.sysman.oii.oiif.oiifj.OiifjAdvertisementPanel;
import oracle.sysman.oii.oiif.oiifj.OiifjAnimationPanel;
import oracle.sysman.oii.oiif.oiifr.OiifrProgressActionListener;
import oracle.sysman.oii.oiif.oiifr.OiifrProgressPhases;
import oracle.sysman.oii.oiip.oiipg.OiipgBootstrap;
import oracle.sysman.oii.oiix.OiixLanguage;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifjProgressPanel
extends JPanel
implements OiifrProgressActionListener,
KeyListener {
    private static final int INSETS = 0;
    private JProgressBar m_progressBar = null;
    private DefaultBoundedRangeModel m_oRangemodel = null;
    private OiifjAdvertisementPanel m_adImagePanel = null;
    private JTextArea m_status = null;
    private String m_sStatusText = null;
    private Font m_plainFont = null;
    private Font m_boldFont = null;
    private int m_curPhase = 0;
    private boolean m_bSuspend = false;
    private long m_totalBytes = 0L;
    private boolean m_useNewProgress = false;
    private JButton m_stopButton = null;
    private long m_currentBytes = 0L;
    private long m_adTotalBytes = 0L;
    private OiifjProgressPainter m_oPainter = null;
    private Thread m_oPainterThread = null;
    private boolean m_bPaintRequired = false;
    private MultiLineLabel[] m_oPhaseLabels = null;
    private OiifjAnimationPanel[] m_checkMarks = null;
    private MultiLineLabel m_curProductLabel = null;

    public OiifjProgressPanel(int phases) {
        this(phases, 100L);
    }

    public OiifjProgressPanel(int phases, long totalBytes) {
        this.m_totalBytes = totalBytes;
        this.m_curPhase = 0;
        this.m_adImagePanel = null;
        this.m_plainFont = new Font("Dialog", 0, 11);
        this.m_boldFont = new Font("Dialog", OiixLanguage.getFontStyle(1), 11);
        this.m_useNewProgress = false;
        TextWrapper twrap = WordWrapper.getTextWrapper();
        int v_iNumRows = 0;
        for (int i = 0; i < OiifrProgressPhases.NUM_PHASES; ++i) {
            int iCurPhase = 1 << i;
            if ((phases & iCurPhase) <= 0) continue;
            ++v_iNumRows;
        }
        JPanel statusPanel = new JPanel(new GridLayout(v_iNumRows + 1, 1, 0, 5));
        this.m_curProductLabel = new MultiLineLabel(twrap, "");
        this.m_curProductLabel.setPreferredAspectRatio(0.0f);
        this.m_curProductLabel.setFont(this.m_boldFont);
        statusPanel.add((Component)this.m_curProductLabel);
        this.m_checkMarks = new OiifjAnimationPanel[OiifrProgressPhases.NUM_PHASES];
        this.m_oPhaseLabels = new MultiLineLabel[OiifrProgressPhases.NUM_PHASES];
        for (int i = 0; i < OiifrProgressPhases.NUM_PHASES; ++i) {
            int iCurPhase = 1 << i;
            if ((phases & iCurPhase) <= 0) continue;
            JPanel phasePanel = new JPanel(new BorderLayout(5, 5));
            this.m_oPhaseLabels[i] = new MultiLineLabel(twrap, OiifrProgressPhases.getPhasePendingString(iCurPhase));
            this.m_oPhaseLabels[i].setPreferredAspectRatio(0.0f);
            this.m_oPhaseLabels[i].setFont(this.m_plainFont);
            phasePanel.add((Component)this.m_oPhaseLabels[i], "Center");
            this.m_checkMarks[i] = new OiifjAnimationPanel();
            phasePanel.add((Component)this.m_checkMarks[i], "West");
            statusPanel.add(phasePanel);
        }
        this.m_progressBar = new JProgressBar();
        this.m_oRangemodel = new DefaultBoundedRangeModel(0, 100, 0, 100);
        this.m_progressBar.setModel(this.m_oRangemodel);
        JPanel textWrapper = new JPanel(new BorderLayout());
        textWrapper.setBorder(new EmptyBorder(0, 0, 0, 0));
        textWrapper.setAlignmentX(0.0f);
        this.m_status = new JTextArea("");
        this.m_status.setWrapStyleWord(true);
        this.m_status.setBackground(new Color(204, 204, 204));
        textWrapper.setBackground(new Color(204, 204, 204));
        this.m_status.addKeyListener(this);
        this.m_status.setFocusable(true);
        this.m_status.setEditable(false);
        this.m_status.setRows(1);
        this.m_status.setFont(this.m_plainFont);
        textWrapper.add((Component)this.m_status, "Center");
        JPanel topPanel = new JPanel(new BorderLayout(5, 17));
        topPanel.add((Component)statusPanel, "Center");
        topPanel.add((Component)textWrapper, "South");
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)topPanel, "Center");
        this.add((Component)this.m_progressBar, "South");
        this.validate();
        OiipgBootstrap pgb = new OiipgBootstrap();
        this.m_bPaintRequired = pgb.isRepaintRequired();
        this.m_oPainter = new OiifjProgressPainter();
    }

    public void setStopButton(JButton p_stopButton) {
        this.m_stopButton = p_stopButton;
        if (this.m_stopButton != null) {
            this.m_stopButton.requestFocus();
        }
    }

    public void setTotalBytes(long bytes) {
        this.m_totalBytes = bytes;
    }

    public void startProgressPainter() {
        this.m_oPainter = new OiifjProgressPainter();
        this.m_oPainterThread = new Thread(this.m_oPainter);
        this.m_oPainterThread.start();
        if (this.m_stopButton != null) {
            this.m_stopButton.requestFocus();
        }
    }

    public void reset(boolean direction) {
        int value = direction ? 1 : 100;
        this.updatePercentage(value);
        if (this.m_adImagePanel != null) {
            this.m_adImagePanel.reset();
        }
    }

    public int getPhase() {
        return this.m_curPhase;
    }

    public void setAdImagePanel(OiifjAdvertisementPanel adImagePanel) {
        this.m_adImagePanel = adImagePanel;
    }

    public void onCurrentComponent(String Comp) {
        Object[] msgArr = new String[]{Comp};
        int iPhaseIdx = OiifrProgressPhases.getPhaseIndex(this.m_curPhase);
        this.m_oPhaseLabels[iPhaseIdx].setText(OiifrProgressPhases.getComponentInProgressString(this.m_curPhase, msgArr));
        this.validate();
    }

    public void addPercentage(int percent) {
        if (this.m_adImagePanel != null) {
            this.m_adImagePanel.addPercent(percent);
        }
        int value = this.m_oRangemodel.getValue() + percent;
        this.m_currentBytes += (long)percent * this.m_totalBytes / 100L;
        value = Math.min(value, 99);
        this.updatePercentage(value);
    }

    private void setPercentage(int newPercent) {
        int currentPercent = this.m_oRangemodel.getValue();
        if (currentPercent >= newPercent) {
            return;
        }
        this.setProgressPercentage(newPercent);
        this.setAdPercentage(newPercent);
    }

    private void setProgressPercentage(int newPercent) {
        int currentPercent = this.m_oRangemodel.getValue();
        if (currentPercent >= newPercent) {
            return;
        }
        this.updatePercentage(newPercent);
    }

    private void setAdPercentage(int newPercent) {
        if (this.m_adImagePanel != null) {
            this.m_adImagePanel.setPercent(newPercent);
        }
    }

    public void addBytes(int bytes) {
        if (bytes == 0) {
            return;
        }
        this.m_useNewProgress = true;
        if (this.m_totalBytes > 0L) {
            this.m_currentBytes += (long)bytes;
            double dPercent = (double)this.m_currentBytes * 100.0 / (double)this.m_totalBytes;
            int percent = dPercent < 50.0 ? (int)Math.ceil(dPercent) : (int)dPercent;
            percent = Math.min(percent, 99);
            this.setPercentage(percent);
        } else {
            this.setPercentage(100);
        }
    }

    public boolean isNewProgressUsed() {
        return this.m_useNewProgress;
    }

    public void onStartDeinstall() {
        this.m_currentBytes = 0L;
        this.updatePercentage(0);
    }

    private void updatePercentage(int percent) {
        this.m_oRangemodel.setValue(percent);
        if (this.m_bPaintRequired) {
            this.m_progressBar.repaint();
        }
        if (percent >= 100) {
            this.m_oPainter.stopOperation();
        }
    }

    public void onDoneDeinstall() {
    }

    public void setStatus(String status) {
        if (!this.m_bSuspend) {
            this.m_sStatusText = status;
            this.m_oPainter.setTextDirty(true);
        }
    }

    public void setStatusText(String status) {
        this.m_status.setText(status);
    }

    public void onDoneProgress() {
        this.updatePercentage(100);
        this.m_sStatusText = "";
    }

    public void removeBytes(int nBytes) {
    }

    public void onSuspend() {
        this.m_bSuspend = true;
        this.m_oPainter.suspendOperation(true);
    }

    public void onResume() {
        this.m_bSuspend = false;
        this.m_oPainter.suspendOperation(false);
    }

    public void setTitle(String title) {
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyChar() == '\t') {
            this.m_status.setFocusable(false);
            this.m_status.setFocusable(true);
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void onStartPhase(int phase) {
        if (this.m_adImagePanel != null) {
            this.m_adImagePanel.setAllowAddPercent(true);
        }
        int iPhaseIdx = OiifrProgressPhases.getPhaseIndex(phase);
        this.m_curPhase = phase;
        if (this.m_oPhaseLabels[iPhaseIdx] != null) {
            this.m_oPhaseLabels[iPhaseIdx].setText(OiifrProgressPhases.getPhaseInProgressString(phase));
            this.m_oPhaseLabels[iPhaseIdx].setFont(this.m_boldFont);
            this.m_checkMarks[iPhaseIdx].startAnimation();
        }
    }

    public void onDonePhase(int phase) {
        int iPhaseIdx = OiifrProgressPhases.getPhaseIndex(phase);
        if (this.m_oPhaseLabels[iPhaseIdx] != null) {
            this.m_oPhaseLabels[iPhaseIdx].setFont(this.m_plainFont);
            this.m_oPhaseLabels[iPhaseIdx].setText(OiifrProgressPhases.getPhaseDoneString(phase));
            this.m_checkMarks[iPhaseIdx].stopAnimation();
        }
    }

    public void dispose() {
        if (this.m_oPainterThread != null) {
            this.m_oPainter.stopOperation();
            this.m_oPainterThread = null;
        }
    }

    public void setCurProduct(String sName) {
        this.m_curProductLabel.setText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CHAIN_INSTALLING_PRODUCT", new String[]{sName}));
    }

    class OiifjProgressPainter
    implements Runnable {
        private boolean m_bStopped = false;
        private boolean m_bSuspended = false;
        private boolean m_bTextDirty = false;

        OiifjProgressPainter() {
        }

        public void run() {
            while (!this.isStopped()) {
                if (!this.isSuspended() && this.isTextDirty()) {
                    OiifjProgressPanel.this.m_status.setText(OiifjProgressPanel.this.m_sStatusText);
                    this.setTextDirty(false);
                    OiifjProgressPanel.this.m_status.validate();
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    this.stopOperation();
                }
            }
        }

        void setTextDirty(boolean bDirty) {
            this.m_bTextDirty = bDirty;
        }

        boolean isTextDirty() {
            return this.m_bTextDirty;
        }

        void suspendOperation(boolean bSuspend) {
            this.m_bSuspended = bSuspend;
        }

        boolean isSuspended() {
            return this.m_bSuspended;
        }

        void stopOperation() {
            this.m_bStopped = true;
        }

        boolean isStopped() {
            return this.m_bStopped;
        }
    }
}

