/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifj;

import java.awt.Component;
import java.awt.Font;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.bali.ewt.shuttle.ShuttleEvent;
import oracle.bali.ewt.shuttle.ShuttleListener;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.sysman.oii.oiic.OiicInstallSession;
import oracle.sysman.oii.oiic.OiicLangAddonSession;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiif.oiifj.OiifjWizPanel;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiix.OiixLanguage;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiifjWizLangsPanel
extends OiifjWizPanel
implements ShuttleListener {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 256;
    private final int HGAP = 5;
    private final int VGAP = 5;
    private final int VIS_LINES = 15;
    private Vector m_langs;
    private JList m_availableList;
    private JList m_selectedList;
    private ListPicker m_availablePick;
    private ListPicker m_selectedPick;
    private Shuttle m_shuttle;
    private MultiLineLabel m_promptLabel;
    private OiicInstallSession m_session;
    private OiiiCompInstallID[] m_displayedComps;
    private DefaultListModel m_availableModel;
    private DefaultListModel m_selectedModel;

    public OiifjWizLangsPanel() {
        super(OiixResourceBundle.getString("S_LANG_SEL"));
    }

    public OiifjWizLangsPanel(OiicPullSession session) {
        this();
        this.m_session = (OiicInstallSession)session;
        this.createPanelElements();
    }

    public void createPanelElements() {
        boolean bInitRequired = false;
        if (this.m_wcde != null) {
            this.m_session = (OiicInstallSession)this.m_wcde.getVarOwner().getSession();
            bInitRequired = true;
        }
        String prompt = null;
        prompt = !OiicPullSession.isLangAddonMode() ? OiixResourceBundle.getString("S_LANG_SELS_PROMPT") : OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFP1008");
        this.m_promptLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), prompt);
        this.m_promptLabel.setFont(new Font(OiixResourceBundle.getFont(), 0, 14));
        this.m_promptLabel.setPreferredAspectRatio(0.0f);
        this.mainPanel.add((Component)this.m_promptLabel, "North");
        String labelStr = OiixResourceBundle.getString("S_AVAIL_LANGS_LABEL");
        JLabel availLabel = new JLabel(labelStr);
        labelStr = OiixResourceBundle.getString("S_SEL_LANGS_LABEL");
        JLabel selectLabel = new JLabel(labelStr);
        this.m_availableModel = new DefaultListModel();
        this.m_availableList = new JList(this.m_availableModel);
        availLabel.setLabelFor(this.m_availableList);
        this.m_selectedModel = new DefaultListModel();
        this.m_selectedList = new JList(this.m_selectedModel);
        selectLabel.setLabelFor(this.m_selectedList);
        this.m_availablePick = new ListPicker(this.m_availableList);
        this.m_selectedPick = new ListPicker(this.m_selectedList);
        this.m_shuttle = new Shuttle();
        this.m_availablePick.setItemsSorted(true);
        this.m_selectedPick.setItemsSorted(true);
        this.m_shuttle.add((Component)availLabel, (Object)"FromHeader");
        this.m_shuttle.add((Component)selectLabel, (Object)"ToHeader");
        this.m_shuttle.setFromPicker((ItemPicker)this.m_availablePick);
        this.m_shuttle.setToPicker((ItemPicker)this.m_selectedPick);
        this.m_shuttle.setMoveAllAllowed(true);
        this.m_shuttle.setMode(0);
        this.m_shuttle.setHorizontalLayout(true);
        this.m_shuttle.addShuttleListener((ShuttleListener)this);
        this.mainPanel.add((Component)this.m_shuttle, "Center");
        if (bInitRequired) {
            this.init();
        }
    }

    public void init() {
        if (!OiicPullSession.isLangAddonMode()) {
            OiiiCompInstallID[] topLevelIDs = this.m_session.getSelTopLevelCompIDs();
            if (!OiixVectorOps.arraysEqual(this.m_displayedComps, topLevelIDs)) {
                String prompt;
                this.m_displayedComps = topLevelIDs;
                if (topLevelIDs.length > 1) {
                    prompt = OiixResourceBundle.getString("S_LANG_SELS_PROMPT");
                } else {
                    prompt = OiixResourceBundle.getString("S_LANG_SEL_PROMPT");
                    Object[] arr = new String[]{this.m_session.getStgCompDisplayName(topLevelIDs[0])};
                    prompt = MessageFormat.format(prompt, arr);
                    this.setSubTitleLabel((String)arr[0]);
                }
                this.m_promptLabel.setText(prompt);
                this.m_langs = new Vector();
                for (int i = 0; i < topLevelIDs.length; ++i) {
                    OiixVectorOps.unionInPlace(this.m_langs, this.m_session.getStgCompLangs(topLevelIDs[i]));
                }
                OiicSessionContext oContext = this.m_session.getSessionContext();
                OiisVariable oLangs = oContext.getVariable("SELECTED_LANGUAGES");
                String[] strLang = (String[])oLangs.getValue();
                Vector vSelLangs = OiixLanguage.getLangsVector(strLang);
                this.populateLists(this.m_langs, vSelLangs);
            }
        } else {
            this.m_langs = new Vector();
            this.m_langs = ((OiicLangAddonSession)this.m_session).getAvailableLangs();
            String prompt = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFP1008");
            this.m_promptLabel.setText(prompt);
            OiicSessionContext oContext = this.m_session.getSessionContext();
            OiisVariable oLangs = oContext.getVariable("SELECTED_LANGUAGES");
            String[] strLang = (String[])oLangs.getValue();
            Vector vSelLangs = OiixLanguage.getLangsVector(strLang);
            this.populateLists(this.m_langs, vSelLangs);
        }
        this.m_availableList.invalidate();
        this.m_selectedList.invalidate();
    }

    public void populateLists(Vector langs, Vector vSelLangs) {
        this.m_availableList.removeAll();
        this.m_selectedList.removeAll();
        Vector<String> vSort = null;
        if (langs != null) {
            int i;
            for (i = 0; i < langs.size(); ++i) {
                String displayString = null;
                Locale l = (Locale)langs.elementAt(i);
                displayString = OiixLanguage.getDisplayName(l);
                if (displayString == null) {
                    displayString = l.getDisplayLanguage();
                }
                if (vSort == null) {
                    vSort = new Vector<String>();
                }
                vSort.add(displayString);
            }
            vSort = OiixVectorOps.sort(vSort);
            for (i = 0; i < vSort.size(); ++i) {
                this.m_availableModel.addElement((String)vSort.elementAt(i));
            }
            if (vSelLangs != null) {
                for (i = 0; i < vSelLangs.size(); ++i) {
                    Locale l = (Locale)vSelLangs.elementAt(i);
                    String displayString = OiixLanguage.getDisplayName(l);
                    if (displayString == null) {
                        displayString = l.getDisplayLanguage();
                    }
                    try {
                        this.m_availableModel.removeElement(displayString);
                        this.m_selectedModel.addElement(displayString);
                        continue;
                    }
                    catch (IllegalArgumentException ie) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public Vector getSelectedLangs() {
        Vector<Locale> selLangs = new Vector<Locale>();
        int availSize = this.m_langs.size();
        int selectedSize = this.m_selectedList.getModel().getSize();
        block0: for (int i = 0; i < selectedSize; ++i) {
            for (int j = 0; j < availSize; ++j) {
                Locale currAvailLang = (Locale)this.m_langs.elementAt(j);
                String displayString = OiixLanguage.getDisplayName(currAvailLang);
                if (displayString == null) {
                    displayString = currAvailLang.getDisplayLanguage();
                }
                if (!((String)this.m_selectedModel.getElementAt(i)).equals(displayString)) continue;
                selLangs.addElement(currAvailLang);
                continue block0;
            }
        }
        return selLangs;
    }

    public void setSelectedLangs(Vector langs) {
        this.m_selectedList.removeAll();
        for (int i = 0; i < langs.size(); ++i) {
            Locale l = (Locale)langs.elementAt(i);
            String displayString = OiixLanguage.getDisplayName(l);
            if (displayString == null) {
                displayString = l.getDisplayLanguage(l);
            }
            this.m_selectedModel.addElement(displayString);
        }
    }

    public void shuttleItemsRemoved(ShuttleEvent shuttleEvent) {
        Transferable[] items = shuttleEvent.getItems();
        String item = null;
        for (int i = 0; i < items.length; ++i) {
            try {
                item = (String)items[i].getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Locale englishLocale = OiixLanguage.ENGLISH;
            if (!item.equalsIgnoreCase(OiixLanguage.getDisplayName(englishLocale))) continue;
            String message = OiixResourceBundle.getString("S_ENGLISH_DESELECT_ERR");
            OiifmAlert.displayAlert(OiixResourceBundle.getString("S_WARNING"), message, 40, 1, 1, 10);
            this.m_availableModel.removeElement(item);
            this.m_selectedModel.addElement(item);
            break;
        }
    }

    public void shuttleItemsMoved(ShuttleEvent shuttleEvent) {
    }

    public void shuttleItemsReordered(ShuttleEvent shuttleEvent) {
    }

    public String[] getSelectedLanguages() {
        Vector v = this.getSelectedLangs();
        String[] strList = null;
        try {
            if (v.indexOf(OiixLanguage.ENGLISH) == -1 && !OiicPullSession.isLangAddonMode()) {
                v.addElement(OiixLanguage.ENGLISH);
            }
            strList = OiixLanguage.getStringArray(v);
            strList = OiixLanguage.getUpdatedLangs23(strList);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return strList;
    }

    public void setSelectedLanguages(String[] selLangs) {
        Vector vSelLangs = OiixLanguage.getLangsVector(selLangs);
        this.populateLists(this.m_langs, vSelLangs);
    }
}

