/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifm;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import oracle.ewt.dataSource.TwoDDataSource;
import oracle.ewt.graphics.Appearance;
import oracle.ewt.grid.AppearanceManager;
import oracle.ewt.grid.BooleanInputHandler;
import oracle.ewt.grid.CellInputHandler;
import oracle.ewt.grid.CheckPainter;
import oracle.ewt.grid.ComplexAppearanceManager;
import oracle.ewt.grid.Grid;
import oracle.ewt.grid.NullInputHandler;
import oracle.ewt.grid.ProxyInputHandler;
import oracle.ewt.painter.AbstractPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;
import oracle.ewt.painter.TextPainter;
import oracle.sysman.oii.oiif.oiifb.OiifbConfigToolInfo;
import oracle.sysman.oii.oiif.oiifb.OiifbConfigToolInfoPerSession;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifmConfigToolsGrid
extends Grid {
    public static final int NUM_COLUMNS = 4;
    public static final int PREF_ROWS = 3;
    public static final int TOOL_SELECTION_COL = 0;
    public static final int TOOL_NAME_COL = 1;
    public static final int TOOL_STATUS_COL = 2;
    public static final int TOOL_TYPE_COL = 3;
    private static String[] s_statusStr = new String[]{"S_PENDING", "S_INPROGRESS", "S_WAITING", "S_SUCCEEDED", "S_FAILED", "S_CANCELED", "S_SKIPPED"};
    private static String[] s_typeStr = new String[]{"S_TOOLTYPE_RECOMMENDED", "S_TOOLTYPE_OPTIONAL"};
    private ComplexAppearanceManager m_cAppMgr = new ComplexAppearanceManager();

    public OiifmConfigToolsGrid() {
    }

    public OiifmConfigToolsGrid(TwoDDataSource dataSource) {
        super(dataSource);
        this.setDefaultPainter((Painter)new TextPainter());
        this.setColumnPainter(0, (Painter)new OiifmCheckBoxPainter());
        this.setColumnCellInputHandler(0, (CellInputHandler)new OiifmToolSelectionInputHandler(BooleanInputHandler.getCellInputHandler()));
        this.setColumnPainter(1, (Painter)new OiifmToolNamePainter());
        this.setColumnPainter(2, (Painter)new OiifmToolStatusPainter());
        this.setColumnPainter(3, (Painter)new OiifmToolTypePainter());
        this.setDefaultInputHandler(NullInputHandler.getCellInputHandler());
        this.setVerticalSeparatorsVisible(false);
        this.setPreferredRowsOnScreen(3);
        this.setAppearanceManager((AppearanceManager)this.m_cAppMgr);
        this.handleGridAppearance();
    }

    private void handleGridAppearance() {
        TwoDDataSource dataSource = this.getDataSource();
        int rows = dataSource.getRowCount();
        for (int i = 0; i < rows; ++i) {
            if (null != this.getToolInfo(i)) continue;
            Appearance appr = this.m_cAppMgr.getRowAppearance(i);
            appr.setBackground(Color.lightGray);
            this.m_cAppMgr.setRowAppearance(i, appr);
        }
    }

    protected int getCellPaintState(int baseState, int column, int row) {
        if (null == this.getToolInfo(row)) {
            baseState |= 4;
        } else if (!this.isCellEnabled(column, row)) {
            baseState |= 1;
        }
        return baseState;
    }

    boolean isCellEnabled(int column, int row) {
        boolean bEnabled = true;
        OiifbConfigToolInfo toolInfo = this.getToolInfo(row);
        if (null == toolInfo) {
            bEnabled = false;
        } else if (column == 0) {
            int nStatus = toolInfo.getToolStatus();
            if (nStatus == 0 || nStatus == 1 || nStatus == 3) {
                bEnabled = false;
            } else if (toolInfo.getToolType() == 0) {
                bEnabled = false;
            }
        }
        return bEnabled;
    }

    public int getToolStatus(int toolIndex) {
        int nStatus = -1;
        if (null != this.getToolInfo(toolIndex)) {
            nStatus = this.getToolInfo(toolIndex).getToolStatus();
        }
        return nStatus;
    }

    private OiifbConfigToolInfo getToolInfo(int toolIndex) {
        OiifbConfigToolInfo toolInfo = null;
        if (this.getDataSource().getData(2, toolIndex) instanceof OiifbConfigToolInfo) {
            toolInfo = (OiifbConfigToolInfo)this.getDataSource().getData(2, toolIndex);
        }
        return toolInfo;
    }

    private class OiifmCheckBoxPainter
    extends AbstractPainter {
        private CheckPainter checkBoxPainter = (CheckPainter)CheckPainter.getPainter();

        public Dimension getMinimumSize(PaintContext context) {
            return this.checkBoxPainter.getMinimumSize(context);
        }

        public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
            Object data = this.getData(context);
            if (null == data) {
                new TextPainter().paint(context, g, x, y, width, height);
            } else if (data instanceof Boolean) {
                this.checkBoxPainter.paint(context, g, x, y, width, height);
            }
        }
    }

    private class OiifmToolSelectionInputHandler
    extends ProxyInputHandler {
        public OiifmToolSelectionInputHandler(CellInputHandler defaultHandler) {
            super(defaultHandler);
        }

        public CellInputHandler getCellInputHandler(Grid grid, int column, int row) {
            if (!OiifmConfigToolsGrid.this.isCellEnabled(column, row)) {
                return NullInputHandler.getCellInputHandler();
            }
            return super.getCellInputHandler(grid, column, row);
        }
    }

    private class OiifmToolNamePainter
    extends TextPainter {
        private OiifmToolNamePainter() {
        }

        protected String getStringData(PaintContext context) {
            String sName = "";
            Object data = this.getData(context);
            if (data instanceof OiifbConfigToolInfo) {
                sName = ((OiifbConfigToolInfo)data).getExternalName();
            }
            if (data instanceof OiifbConfigToolInfoPerSession) {
                sName = ((OiifbConfigToolInfoPerSession)data).getTopLevelCompExtName();
            }
            return sName;
        }
    }

    private class OiifmToolTypePainter
    extends TextPainter {
        private OiifmToolTypePainter() {
        }

        protected String getStringData(PaintContext context) {
            String sType = "";
            Object data = this.getData(context);
            if (data instanceof OiifbConfigToolInfo) {
                int nType = ((OiifbConfigToolInfo)data).getToolType();
                sType = OiixResourceBundle.getString(s_typeStr[nType]);
            }
            return sType;
        }
    }

    private class OiifmToolStatusPainter
    extends TextPainter {
        private OiifmToolStatusPainter() {
        }

        protected String getStringData(PaintContext context) {
            String sStatus = "";
            Object data = this.getData(context);
            if (data instanceof OiifbConfigToolInfo) {
                int nStatus = ((OiifbConfigToolInfo)data).getToolStatus();
                sStatus = OiixResourceBundle.getString(s_statusStr[nStatus]);
            }
            return sStatus;
        }

        protected int paintText(PaintContext context, Graphics g, FontMetrics metrics, String text, int x, int y, int availableWidth, float alignmentX, int mnemonicIndex) {
            int nStatus;
            Color currentColor = g.getColor();
            Object data = this.getData(context);
            if (data instanceof OiifbConfigToolInfo && (nStatus = ((OiifbConfigToolInfo)data).getToolStatus()) == 4) {
                g.setColor(Color.red);
            }
            int iRet = super.paintText(context, g, metrics, text, x, y, availableWidth, alignmentX, mnemonicIndex);
            g.setColor(currentColor);
            return iRet;
        }
    }
}

