/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifm;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import oracle.ewt.graphics.FontUtils;

public class OiifmNavigationBarLayout
implements LayoutManager {
    public static final String CANCEL_CONSTRAINT = "Cancel";
    public static final String HELP_CONSTRAINT = "Help";
    public static final String BACK_CONSTRAINT = "Back";
    public static final String NEXT_CONSTRAINT = "Next";
    public static final String INSTALL_CONSTRAINT = "Install";
    public static final String VIEW_CONSTRAINT = "View";
    private Component _cancel;
    private Component _help;
    private Component _back;
    private Component _next;
    private Component _finish;
    private Component _view;
    private int m_interiorGap;

    public OiifmNavigationBarLayout(int interiorGap) {
        this.m_interiorGap = interiorGap;
    }

    public void layoutContainer(Container target) {
        int newTotalWidth;
        boolean bContainerSmaller;
        Insets containerInsets = target.getInsets();
        Dimension cellSize = this.getCellSize(target);
        int cellWidth = cellSize.width;
        int cellHeight = cellSize.height;
        int totCellWidth = cellWidth + this.m_interiorGap;
        int right = target.getSize().width - containerInsets.right;
        int left = containerInsets.left;
        int rightX = right;
        int y = containerInsets.top;
        int nButtonSize = 5 * totCellWidth + this._view.getPreferredSize().width;
        int nContainerWidth = right - left;
        int cellCorrection = 0;
        boolean bl = bContainerSmaller = nContainerWidth < nButtonSize;
        if (bContainerSmaller && nContainerWidth > (newTotalWidth = this._view.getPreferredSize().width + this._cancel.getPreferredSize().width + this._finish.getPreferredSize().width + this._next.getPreferredSize().width + this._back.getPreferredSize().width + this._help.getPreferredSize().width + 5 * this.m_interiorGap)) {
            cellCorrection = (nContainerWidth - newTotalWidth) / 5;
        }
        int cellPreferredWidth = this.getCellPreferredWidth(bContainerSmaller, this._cancel, cellWidth, cellCorrection);
        int x = rightX - cellPreferredWidth;
        this._cancel.setBounds(x, y, cellPreferredWidth, cellHeight);
        rightX -= cellPreferredWidth + this.m_interiorGap;
        cellPreferredWidth = this.getCellPreferredWidth(bContainerSmaller, this._finish, cellWidth, cellCorrection);
        x = rightX - cellPreferredWidth;
        this._finish.setBounds(x, y, cellPreferredWidth, cellHeight);
        rightX -= cellPreferredWidth + this.m_interiorGap;
        cellPreferredWidth = this.getCellPreferredWidth(bContainerSmaller, this._next, cellWidth, cellCorrection);
        x = rightX - cellPreferredWidth;
        this._next.setBounds(x, y, cellPreferredWidth, cellHeight);
        rightX -= cellPreferredWidth;
        cellPreferredWidth = this.getCellPreferredWidth(bContainerSmaller, this._back, cellWidth, cellCorrection);
        x = rightX - cellPreferredWidth + 1;
        this._back.setBounds(x, y, cellPreferredWidth, cellHeight);
        rightX -= cellPreferredWidth + this.m_interiorGap;
        cellPreferredWidth = this.getCellPreferredWidth(bContainerSmaller, this._help, cellWidth, cellCorrection);
        x = containerInsets.left;
        this._help.setBounds(x, y, cellPreferredWidth, cellHeight);
        x += cellPreferredWidth + this.m_interiorGap;
        int preferredWidth = this._view.getPreferredSize().width;
        x += (rightX - x - preferredWidth) / 2;
        this._view.setBounds(x, y, preferredWidth, cellHeight);
    }

    private int getCellPreferredWidth(boolean bContainerSmaller, Component _cell, int defaultPreferredWidth, int cellCorrection) {
        if (bContainerSmaller) {
            return _cell.getPreferredSize().width + cellCorrection;
        }
        return defaultPreferredWidth;
    }

    public void addLayoutComponent(String name, Component comp) {
        if (VIEW_CONSTRAINT.equals(name)) {
            this._view = comp;
        } else if (CANCEL_CONSTRAINT.equals(name)) {
            this._cancel = comp;
        } else if (HELP_CONSTRAINT.equals(name)) {
            this._help = comp;
        } else if (INSTALL_CONSTRAINT.equals(name)) {
            this._finish = comp;
        } else if (NEXT_CONSTRAINT.equals(name)) {
            this._next = comp;
        } else if (BACK_CONSTRAINT.equals(name)) {
            this._back = comp;
        }
    }

    protected Dimension getCellSize(Container container) {
        int maxWidth = 0;
        int maxHeight = 0;
        Component[] comps = new Component[]{this._cancel, this._finish, this._next, this._back, this._help};
        int numChildren = comps.length;
        for (int i = 0; i < numChildren; ++i) {
            Component currChild = comps[i];
            Dimension childSize = currChild.getPreferredSize();
            if (maxHeight < childSize.height) {
                maxHeight = childSize.height;
            }
            if (maxWidth >= childSize.width) continue;
            maxWidth = childSize.width;
        }
        Font font = container.getFont();
        if (font != null) {
            maxWidth += FontUtils.getAverageWidth((Font)font);
        }
        return new Dimension(maxWidth, maxHeight);
    }

    public void removeLayoutComponent(Component p0) {
    }

    public Dimension preferredLayoutSize(Container target) {
        Dimension cellSize = this.getCellSize(target);
        return new Dimension(cellSize.width * 5, cellSize.height);
    }

    public Dimension minimumLayoutSize(Container p0) {
        return new Dimension(0, 0);
    }
}

