/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifm;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import oracle.ewt.EwtContainer;
import oracle.ewt.dialog.directory.DirectoryDrive;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.util.WindowUtils;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifm.OiifmCursorUtil;
import oracle.sysman.oii.oiif.oiifm.OiifmDirectoryDlg;
import oracle.sysman.oii.oiif.oiifm.OiifmProdHomeListener;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiis.OiisCompInstallation;
import oracle.sysman.oii.oiis.OiisProdHomeVar;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiix.OiixLanguage;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifmProdHomePanel
extends EwtContainer
implements ActionListener {
    private static final int HGAP = 2;
    private static final int VGAP = 0;
    private LWTextField m_prodHomeText;
    private LWLabel m_prodHomeLabel;
    private LWButton m_browseButton;
    private LWLabel m_prompt;
    private boolean m_editable;
    private GridBagLayout m_gridbag;
    private GridBagConstraints m_constraints;
    private OiisCompInstallation m_compInstall;
    private Cursor waitCursor;
    private Cursor defCursor;
    private String m_compName;
    private Font font = new Font(OiixResourceBundle.getFont(), 0, 11);
    private Font font_bold = new Font(OiixResourceBundle.getFont(), OiixLanguage.getFontStyle(1), 11);
    private boolean m_bVisible;
    private OiifmProdHomeListener m_listener;

    public OiifmProdHomePanel() {
        String str = OiixResourceBundle.getString("S_LOC_PLACEHOLDER");
        this.m_prodHomeText = new LWTextField(str);
        this.m_prodHomeText.addActionListener((ActionListener)this);
        this.m_prodHomeText.setFont(this.font);
        str = OiixResourceBundle.getString("S_CHANGE_LOC_BUTTON");
        this.m_browseButton = new LWButton(str);
        this.m_browseButton.addActionListener((ActionListener)this);
        this.m_browseButton.setFont(this.font);
        this.m_browseButton.setRightmost(true);
        this.m_gridbag = new GridBagLayout();
        this.m_constraints = new GridBagConstraints();
        this.m_constraints.insets = new Insets(0, 2, 0, 2);
        this.m_constraints.weighty = 1.0;
        str = OiixResourceBundle.getString("S_PRODHOME_LABEL");
        Object[] strarr = new String[]{OiixResourceBundle.getString("S_SEL_PRODUCT")};
        str = MessageFormat.format(str, strarr);
        this.m_prompt = new LWLabel(str);
        this.m_prompt.setFont(this.font_bold);
        this.m_constraints.weightx = 1.0;
        this.m_constraints.gridwidth = 0;
        this.m_constraints.anchor = 16;
        this.m_gridbag.setConstraints((Component)this.m_prompt, this.m_constraints);
        this.add((Component)this.m_prompt);
        this.setLayout(this.m_gridbag);
        str = OiixResourceBundle.getString("S_NOT_APPLICABLE");
        this.m_prodHomeLabel = new LWLabel(str);
        this.m_prodHomeLabel.setFont(this.font);
        this.m_constraints.weightx = 1.0;
        this.m_constraints.gridwidth = 0;
        this.m_constraints.anchor = 18;
        this.m_constraints.fill = 2;
        this.m_gridbag.setConstraints((Component)this.m_prodHomeLabel, this.m_constraints);
        this.add((Component)this.m_prodHomeLabel);
        this.m_editable = false;
        this.waitCursor = Cursor.getPredefinedCursor(3);
        this.defCursor = Cursor.getPredefinedCursor(0);
        this.m_bVisible = true;
        this.validate();
    }

    public void setDisplayProdHome(String prodHomeStr, boolean editable) {
    }

    public void setDisplayProdHome() {
        boolean wasEditable = this.m_editable;
        OiisProdHomeVar oVar = this.m_compInstall.getProdHome();
        this.m_editable = oVar.isEditable();
        String prodHomeStr = (String)oVar.getValue();
        if (this.m_editable) {
            this.m_prodHomeText.setText(prodHomeStr);
            if (!wasEditable) {
                this.remove((Component)this.m_prodHomeLabel);
                this.m_constraints.weightx = 1.0;
                this.m_constraints.gridwidth = -1;
                this.m_constraints.anchor = 18;
                this.m_constraints.fill = 2;
                this.m_gridbag.setConstraints((Component)this.m_prodHomeText, this.m_constraints);
                this.add((Component)this.m_prodHomeText);
                this.m_constraints.weightx = 0.0;
                this.m_constraints.gridwidth = 0;
                this.m_constraints.anchor = 12;
                this.m_constraints.fill = 0;
                this.m_gridbag.setConstraints((Component)this.m_browseButton, this.m_constraints);
                this.add((Component)this.m_browseButton);
            }
            this.validate();
        } else {
            this.m_prodHomeLabel.setText(prodHomeStr);
            if (wasEditable) {
                this.remove((Component)this.m_prodHomeText);
                this.remove((Component)this.m_browseButton);
                this.m_constraints.weightx = 1.0;
                this.m_constraints.gridwidth = 0;
                this.m_constraints.anchor = 18;
                this.m_constraints.fill = 2;
                this.m_gridbag.setConstraints((Component)this.m_prodHomeLabel, this.m_constraints);
                this.add((Component)this.m_prodHomeLabel);
            }
            this.validate();
        }
    }

    public String getDisplayProdHome() {
        String phStr = this.m_editable ? this.m_prodHomeText.getText() : this.m_prodHomeLabel.getText();
        phStr = phStr != null ? phStr.trim() : "";
        return phStr;
    }

    public void setCompName(String compName) {
        this.m_compName = compName;
        String str = OiixResourceBundle.getString("S_PRODHOME_LABEL");
        Object[] strarr = new String[]{compName};
        str = MessageFormat.format(str, strarr);
        this.m_prompt.setText(str);
    }

    public void setCompInstall(OiisCompInstallation compInstall) {
        this.m_compInstall = compInstall;
        this.setDisplayProdHome();
    }

    public OiisCompInstallation getCompInstall() {
        return this.m_compInstall;
    }

    public void validateProdHome() throws OiisVarSettingException {
        if (this.m_editable && this.m_bVisible) {
            String ph = this.m_prodHomeText.getText();
            ph = ph != null ? ph.trim() : "";
            String sPath = OiixPathOps.getStandardForm(ph);
            sPath = OiixPathOps.getNativeForm(sPath);
            OiisProdHomeVar oVar = this.m_compInstall.getProdHome();
            try {
                oVar.setValue(sPath);
            }
            catch (OiifbCancelException ie) {
                // empty catch block
            }
        }
    }

    public void setProdHomeListener(OiifmProdHomeListener listener) {
        this.m_listener = listener;
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        OiifmCursorUtil.setCursor(this.waitCursor, (Component)((Object)this));
        if (source == this.m_browseButton) {
            File curDir;
            String defaultDir;
            OiipgFileSystem pgFS = new OiipgFileSystem();
            String str = OiixResourceBundle.getString("S_DIR_BROWSE");
            Frame f = WindowUtils.parentFrame((Component)((Object)this));
            OiifmDirectoryDlg dirDlg = new OiifmDirectoryDlg(f, str);
            dirDlg.setCenterOver(f);
            dirDlg.setCreateAllowed(true);
            str = OiixResourceBundle.getString("S_DIR_BROWSE_PROMPT");
            Object[] strarr = new String[]{this.m_compName};
            str = MessageFormat.format(str, strarr);
            dirDlg.setMessage(str);
            DirectoryDrive[] volumes = pgFS.getDirectoryDrives();
            if (volumes != null) {
                dirDlg.setDrives(volumes);
            }
            if ((defaultDir = this.getDisplayProdHome()).length() == 0) {
                curDir = new File(System.getProperty("user.dir"));
            } else {
                curDir = new File(defaultDir);
                if (!curDir.exists()) {
                    curDir = new File(System.getProperty("user.dir"));
                } else {
                    try {
                        String sFileName = OiixPathOps.getFileCanonicalPath(defaultDir);
                        curDir = new File(sFileName);
                    }
                    catch (IOException ie) {
                        // empty catch block
                    }
                }
            }
            OiifmCursorUtil.setCursor(this.defCursor, (Component)((Object)this));
            File chosenDir = dirDlg.runDialog(curDir);
            if (chosenDir != null) {
                this.m_prodHomeText.setText(chosenDir.getAbsolutePath());
                if (this.m_listener != null) {
                    this.m_listener.displayProdHomeChanged(curDir.getAbsolutePath());
                }
            }
        } else if (source == this.m_prodHomeText && this.m_listener != null) {
            OiisProdHomeVar oVar = this.m_compInstall.getProdHome();
            this.m_listener.displayProdHomeChanged((String)oVar.getValue());
        }
        OiifmCursorUtil.setCursor(this.defCursor, (Component)((Object)this));
    }

    public void setVisible(boolean visible) {
        this.m_bVisible = visible;
        this.m_prompt.setVisible(visible);
        if (this.m_editable) {
            this.m_prodHomeText.setVisible(visible);
            this.m_browseButton.setVisible(visible);
        } else {
            this.m_prodHomeLabel.setVisible(visible);
        }
    }

    public String getVolumeName() {
        String pHome = this.getDisplayProdHome();
        OiipgFileSystem pfs = new OiipgFileSystem();
        return pfs.getVolumeName(pHome);
    }

    public void dispose() {
        this.m_listener = null;
        this.m_compInstall = null;
    }
}

