/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifm;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import oracle.ewt.EwtComponent;
import oracle.ewt.dTree.DTreeDeferringRoot;
import oracle.ewt.dTree.DTreeItem;
import oracle.ewt.dTree.DTreeItemFactory;
import oracle.ewt.dTree.DTreeRootItem;
import oracle.ewt.dTree.DTreeSimpleRoot;
import oracle.ewt.dataSource.OneDDataSource;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.scrolling.scrollBox.ScrollBox;
import oracle.sysman.oii.oiif.oiifm.OiifmImage;
import oracle.sysman.oii.oiif.oiifm.OiifmPubInvDS;
import oracle.sysman.oii.oiif.oiifm.OiifmPubInvTree;
import oracle.sysman.oii.oiig.OiigAvailSoftware;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifmPubInvNavigator
extends EwtComponent
implements ItemListener {
    private final int TOPLEVEL = 0;
    private final int ALLSETS = 1;
    private String m_pubURL;
    private OiigAvailSoftware m_availSoftware;
    private LWCheckbox m_showBox = null;
    private LWCheckbox m_hideExistBox = null;
    private ScrollBox m_topScrollbox = null;
    private ScrollBox m_allScrollbox = null;
    private boolean m_bShowTop;
    private Image m_icon;
    private boolean m_bHideExistProds = false;
    private OiifmPubInvTree m_topSetsTree = null;
    private OiifmPubInvTree m_allSetsTree = null;

    public OiifmPubInvNavigator(String pubURL, OiigAvailSoftware availSoftware) {
        this.m_pubURL = pubURL;
        this.m_availSoftware = availSoftware;
        this.setLayout(new BorderLayout());
    }

    public void init() {
        this.m_showBox = new LWCheckbox(OiixResourceBundle.getString("S_SHOW_TOP_LEVEL_SETS"));
        this.m_showBox.addItemListener((ItemListener)this);
        this.m_bShowTop = true;
        this.m_showBox.setState(true);
        this.m_hideExistBox = new LWCheckbox(OiixResourceBundle.getString("S_HIDE_EXIST_COMPS"));
        this.m_hideExistBox.addItemListener((ItemListener)this);
        this.m_hideExistBox.setState(this.m_bHideExistProds);
        OiifmImage imgBundle = new OiifmImage(null, "Oiir");
        this.m_icon = imgBundle.getImage("7001");
        this.refreshTree(this.m_bShowTop);
        LWContainer chPanel = new LWContainer();
        chPanel.setLayout((LayoutManager)new BorderLayout());
        this.add("South", (Component)chPanel);
        chPanel.add("West", (Component)this.m_showBox);
        chPanel.add("East", (Component)this.m_hideExistBox);
        this.validate();
    }

    public boolean isHideExistProds() {
        return this.m_bHideExistProds;
    }

    public void setHideExistProds(boolean bHideExistProds) {
        if (this.m_bHideExistProds != bHideExistProds) {
            if (this.m_topSetsTree != null) {
                this.m_topSetsTree.setHideExistProds(bHideExistProds);
            }
            if (this.m_allSetsTree != null) {
                this.m_allSetsTree.setHideExistProds(bHideExistProds);
            }
            this.m_hideExistBox.setState(bHideExistProds);
        }
        this.m_bHideExistProds = bHideExistProds;
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.m_showBox) {
            this.m_bShowTop = this.m_showBox.getState();
            this.refreshTree(this.m_bShowTop);
        }
        if (e.getSource() == this.m_hideExistBox) {
            this.setHideExistProds(this.m_hideExistBox.getState());
            this.refreshTree(this.m_bShowTop);
        }
    }

    private void refreshTree(boolean showTop) {
        if (showTop) {
            if (this.m_topScrollbox == null) {
                this.setupTree(0);
            }
            if (this.m_allScrollbox != null) {
                this.remove((Component)this.m_allScrollbox);
            }
            this.add("Center", (Component)this.m_topScrollbox);
        } else {
            this.m_availSoftware.updateFully();
            if (this.m_allScrollbox == null) {
                this.setupTree(1);
            }
            this.remove((Component)this.m_topScrollbox);
            this.add("Center", (Component)this.m_allScrollbox);
        }
        this.validate();
    }

    private void setupTree(int objType) {
        OiifmPubInvDS ds = null;
        OiifmPubInvTree tree = null;
        DTreeSimpleRoot invisibleRoot = null;
        tree = new OiifmPubInvTree();
        tree.init(this.m_availSoftware);
        tree.setHideExistProds(this.m_bHideExistProds);
        ds = new OiifmPubInvDS(tree, objType);
        DTreeDeferringRoot network = new DTreeDeferringRoot(this.m_pubURL, this.m_icon, (OneDDataSource)ds, (DTreeItemFactory)ds);
        invisibleRoot = new DTreeSimpleRoot();
        invisibleRoot.addItem((DTreeItem)network, -1);
        tree.setRoot((DTreeRootItem)invisibleRoot);
        network.setExpanded(true);
        if (objType == 0) {
            this.m_topScrollbox = new ScrollBox((Component)((Object)tree), 0, 0);
            this.m_topSetsTree = tree;
        } else {
            this.m_allScrollbox = new ScrollBox((Component)((Object)tree), 0, 0);
            this.m_allSetsTree = tree;
        }
    }
}

