/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifm;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.sysman.oii.oiic.OiicGlobalContext;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiif.oiifm.OiifmIRootShInfo;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterOps;
import oracle.sysman.oii.oiip.oiipg.OiipgRemoteOpsException;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixPathOps;

public class OiifmRootShInfo
implements OiifmIRootShInfo {
    public static final String ROOT_EXECUTED_FILE = "/root_executed";
    public static final String STRINGLIST_DELIMITER = ",";
    String m_bRootShLocation = null;
    boolean m_bCluster = false;
    boolean m_bExecuted = false;
    List m_oNodesNotExecuted = null;
    String m_sCustomRootShMessage = null;

    public OiifmRootShInfo(OiicGlobalContext oGContext, String sKey) {
        String sNodeList = oGContext.getVariableValue(sKey, "REMOTE_NODES");
        String[] nodeList = OiixFunctionOps.explodeString(sNodeList, STRINGLIST_DELIMITER);
        if (nodeList != null && nodeList.length > 0) {
            this.m_oNodesNotExecuted = new ArrayList();
            String sLocalNode = oGContext.getVariableValue(sKey, "LOCAL_NODE");
            if (null != sLocalNode && sLocalNode.trim().length() > 0) {
                this.m_oNodesNotExecuted.add(0, oGContext.getVariableValue(sKey, "LOCAL_NODE"));
                this.m_bCluster = true;
            }
            for (int i = 1; i < nodeList.length + 1; ++i) {
                if (nodeList[i - 1] == null || nodeList[i - 1].trim().length() <= 0) continue;
                this.m_oNodesNotExecuted.add(i, nodeList[i - 1]);
                this.m_bCluster = true;
            }
        } else {
            sNodeList = oGContext.getVariableValue(sKey, "CLUSTER_NODES");
            if (sNodeList != null && sNodeList.length() > 0) {
                this.m_oNodesNotExecuted = new ArrayList();
                String sLocalNode = oGContext.getVariableValue(sKey, "LOCAL_NODE");
                if (null != sLocalNode && sLocalNode.trim().length() > 0) {
                    this.m_oNodesNotExecuted.add(0, oGContext.getVariableValue(sKey, "LOCAL_NODE"));
                    this.m_bCluster = true;
                }
            }
        }
        this.m_bRootShLocation = oGContext.getVariableValue(sKey, "ROOTSH_LOCATION");
        this.m_sCustomRootShMessage = oGContext.getVariableValue(sKey, "SHOW_CUSTOM_ROOTSH_MESSAGE");
    }

    public OiifmRootShInfo(OiicSessionContext oSContext) {
        OiicPullSession oSession = oSContext.getSession();
        if (oSession.isAddNodeMode()) {
            String[] asNewNodes = (String[])oSContext.getVarValue("CLUSTER_NEW_NODES");
            if (asNewNodes != null && asNewNodes.length > 0) {
                this.m_oNodesNotExecuted = new ArrayList();
                for (int i = 0; i < asNewNodes.length; ++i) {
                    if (asNewNodes[i] == null || asNewNodes[i].trim().length() <= 0) continue;
                    this.m_oNodesNotExecuted.add(i, asNewNodes[i]);
                    this.m_bCluster = true;
                }
            }
        } else {
            String[] sNodeList = (String[])oSContext.getVarValue("REMOTE_NODES");
            if (sNodeList != null && sNodeList.length > 0) {
                this.m_oNodesNotExecuted = new ArrayList();
                String sLocalNode = (String)oSContext.getVarValue("LOCAL_NODE");
                if (null != sLocalNode && sLocalNode.trim().length() > 0) {
                    this.m_oNodesNotExecuted.add(0, (String)oSContext.getVarValue("LOCAL_NODE"));
                    this.m_bCluster = true;
                }
                for (int i = 1; i < sNodeList.length + 1; ++i) {
                    if (sNodeList[i - 1] == null || sNodeList[i - 1].trim().length() <= 0) continue;
                    this.m_oNodesNotExecuted.add(i, sNodeList[i - 1]);
                }
            } else {
                sNodeList = (String[])oSContext.getVarValue("CLUSTER_NODES");
                if (sNodeList != null && sNodeList.length > 0) {
                    this.m_oNodesNotExecuted = new ArrayList();
                    String sLocalNode = (String)oSContext.getVarValue("LOCAL_NODE");
                    if (null != sLocalNode && sLocalNode.trim().length() > 0) {
                        this.m_oNodesNotExecuted.add(0, (String)oSContext.getVarValue("LOCAL_NODE"));
                        this.m_bCluster = true;
                    }
                }
            }
        }
        this.m_bRootShLocation = (String)oSContext.getVarValue("ROOTSH_LOCATION");
        this.m_sCustomRootShMessage = (String)oSContext.getVarValue("SHOW_CUSTOM_ROOTSH_MESSAGE");
    }

    public OiifmRootShInfo(String sScriptLoc, String[] sNodeList) {
        if (sNodeList != null && sNodeList.length > 0) {
            this.m_bCluster = false;
            this.m_oNodesNotExecuted = new ArrayList();
            for (int i = 0; i < sNodeList.length; ++i) {
                if (sNodeList[i] == null || sNodeList[i].length() <= 0) continue;
                this.m_oNodesNotExecuted.add(i, sNodeList[i]);
                this.m_bCluster = true;
            }
        }
        this.m_bRootShLocation = sScriptLoc;
    }

    public String getRootShLocation() {
        return this.m_bRootShLocation;
    }

    public boolean isRootShExecuted() {
        return this.m_bExecuted;
    }

    public boolean isCluster() {
        return this.m_bCluster;
    }

    public String[] getNodeList() {
        if (this.m_oNodesNotExecuted != null) {
            int iSize = this.m_oNodesNotExecuted.size();
            String[] nodeList = new String[iSize];
            for (int i = 0; i < iSize; ++i) {
                nodeList[i] = (String)this.m_oNodesNotExecuted.get(i);
            }
            return nodeList;
        }
        return null;
    }

    public void validateRootShExecution(String targetFileLocation) {
        OiicGlobalContext gContext = OiicGlobalContext.getGlobalContext();
        Iterator iter = gContext.getKeys();
        ArrayList<String> homeList = null;
        int index = 0;
        while (iter.hasNext()) {
            homeList = new ArrayList<String>();
            String sKey = (String)iter.next();
            String sOHLoc = gContext.getVariableValue(sKey, "ORACLE_HOME");
            String fileName = OiixPathOps.getNativeForm(targetFileLocation + ROOT_EXECUTED_FILE);
            if (!this.isCluster()) {
                if (new File(fileName).exists()) continue;
                this.m_bExecuted = false;
                homeList.add(index++, sOHLoc);
                continue;
            }
            String[] nodeList = this.getNodeList();
            if (nodeList == null) continue;
            String clusterHomeNodeList = sOHLoc;
            for (int i = 0; i < nodeList.length; ++i) {
                try {
                    if (OiipgClusterOps.fileExistsOnNode(nodeList[i], fileName)) continue;
                    clusterHomeNodeList = clusterHomeNodeList + STRINGLIST_DELIMITER + nodeList[i];
                    continue;
                }
                catch (OiipgRemoteOpsException e) {
                    OiiolTextLogger.appendException(e);
                    e.printStackTrace();
                }
            }
            homeList.add(index++, clusterHomeNodeList);
            this.m_bExecuted = false;
        }
        if (homeList == null) {
            this.m_bExecuted = true;
        } else {
            this.m_oNodesNotExecuted = homeList;
        }
    }

    public String getCustomRootShMessage() {
        return this.m_sCustomRootShMessage;
    }

    public boolean isEqualLocation(OiifmRootShInfo otherRootShObject) {
        return this.m_bRootShLocation.compareTo(otherRootShObject.getRootShLocation()) == 0;
    }
}

