/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifm;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import oracle.ewt.dataSource.TwoDDataSource;
import oracle.ewt.graphics.Appearance;
import oracle.ewt.grid.AppearanceManager;
import oracle.ewt.grid.BooleanInputHandler;
import oracle.ewt.grid.CellInputHandler;
import oracle.ewt.grid.CheckPainter;
import oracle.ewt.grid.ComplexAppearanceManager;
import oracle.ewt.grid.Grid;
import oracle.ewt.grid.GridSelection;
import oracle.ewt.grid.NullInputHandler;
import oracle.ewt.grid.ProxyInputHandler;
import oracle.ewt.grid.SingleRowSelection;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;
import oracle.ewt.painter.TextPainter;
import oracle.sysman.oii.oiif.oiifm.OiifmICellStateSelector;

public class OiifmSelNodeGrid
extends Grid {
    public static final int PREF_ROWS = 8;
    public static final int NODE_SELECTION_COL = 0;
    public static final int NODE_NAME_COL = 1;
    public static final int NODE_STATUS_COL = 2;
    public static final int NUM_COLS_WITH_STATUS = 3;
    public static final int NUM_COLS_WITHOUT_STATUS = 2;
    private OiifmICellStateSelector m_oCellStateSelector = null;

    public OiifmSelNodeGrid() {
    }

    public OiifmSelNodeGrid(TwoDDataSource dataSource) {
        super(dataSource);
        this.setDefaultPainter((Painter)new TextPainter());
        this.setColumnPainter(0, CheckPainter.getPainter());
        this.setColumnCellInputHandler(0, (CellInputHandler)new OiifmNodeSelectionInputHandler(BooleanInputHandler.getCellInputHandler()));
        this.setColumnPainter(1, (Painter)new OiifmNodeNamePainter());
        if (2 < dataSource.getColumnCount()) {
            this.setColumnPainter(2, (Painter)new OiifmNodeStatusPainter());
        }
        this.setDefaultInputHandler(NullInputHandler.getCellInputHandler());
        this.setVerticalSeparatorsVisible(false);
        this.setPreferredRowsOnScreen(8);
        this.setHorizontalSeparatorsVisible(false);
        this.setDrawFocusCellHighlite(false);
        this.setScrollByColumn(true);
        this.setScrollByRow(true);
        this.setEnabled(true);
        ComplexAppearanceManager am = new ComplexAppearanceManager();
        this.setAppearanceManager((AppearanceManager)am);
        Appearance appearance = am.getColumnAppearance(0);
        appearance.setHorizontalJustify(3);
        am.setColumnAppearance(0, appearance);
        SingleRowSelection rowSelObj = new SingleRowSelection();
        rowSelObj.setParent((Grid)this);
        this.setGridSelection((GridSelection)rowSelObj);
    }

    protected int getCellPaintState(int baseState, int column, int row) {
        if (!this.isCellEnabled(column, row)) {
            baseState |= 1;
        }
        return baseState;
    }

    public void setCellStateSelector(OiifmICellStateSelector oCellStateSelector) {
        this.m_oCellStateSelector = oCellStateSelector;
        this.setColumnPainter(0, CheckPainter.getPainter());
        this.setColumnCellInputHandler(0, (CellInputHandler)new OiifmNodeSelectionInputHandler(BooleanInputHandler.getCellInputHandler()));
    }

    public final boolean isErrorCell(int column, int row) {
        boolean bErrorCell = true;
        if (this.m_oCellStateSelector != null) {
            bErrorCell = this.m_oCellStateSelector.isErrorCell(column, row);
        }
        return bErrorCell;
    }

    public final boolean isCellEnabled(int column, int row) {
        boolean bCellEnabled = true;
        if (this.m_oCellStateSelector != null) {
            bCellEnabled = this.m_oCellStateSelector.isCellEnabled(column, row);
        }
        return bCellEnabled;
    }

    public final boolean isNodeSelected(int p_iNodeIndex) {
        Boolean oSelected = (Boolean)this.getDataSource().getData(0, p_iNodeIndex);
        return oSelected;
    }

    private class OiifmNodeSelectionInputHandler
    extends ProxyInputHandler {
        public OiifmNodeSelectionInputHandler(CellInputHandler defaultHandler) {
            super(defaultHandler);
        }

        public CellInputHandler getCellInputHandler(Grid grid, int column, int row) {
            return OiifmSelNodeGrid.this.isCellEnabled(column, row) ? super.getCellInputHandler(grid, column, row) : NullInputHandler.getCellInputHandler();
        }
    }

    private class OiifmNodeNamePainter
    extends TextPainter {
        private OiifmNodeNamePainter() {
        }

        protected String getStringData(PaintContext context) {
            return this.getData(context).toString();
        }
    }

    private class OiifmNodeStatusPainter
    extends TextPainter {
        private OiifmNodeStatusPainter() {
        }

        protected String getStringData(PaintContext context) {
            return this.getData(context).toString();
        }

        protected int paintText(PaintContext context, Graphics g, FontMetrics metrics, String text, int x, int y, int availableWidth, float alignmentX, int mnemonicIndex) {
            Color currentColor = g.getColor();
            g.setColor(Color.red);
            int iRet = super.paintText(context, g, metrics, text, x, y, availableWidth, alignmentX, mnemonicIndex);
            g.setColor(currentColor);
            return iRet;
        }
    }
}

