/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifm;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import oracle.sysman.oii.oiic.OiicInstVersion;
import oracle.sysman.oii.oiif.oiifm.OiifmImage;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixLanguage;
import oracle.sysman.oii.oiix.OiixOraparam;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifmSplashScreen
extends Window
implements ImageObserver {
    private static String SPLASH_SCREEN = "splashScr.gif";
    private static Properties m_splashProperties = OiifmSplashScreen.loadProperties();
    static String tempVal = m_splashProperties.getProperty("splash.height");
    private static final int HEIGHT = tempVal == null ? 251 : new Integer(tempVal);
    static String tempVal1 = m_splashProperties.getProperty("splash.width");
    private static final int WIDTH = tempVal1 == null ? 382 : new Integer(tempVal1);
    private static final int S_TITLE_SIZE = new Integer(m_splashProperties.getProperty("splash.title_font_size"));
    private static final int S_VERSION_SIZE = new Integer(m_splashProperties.getProperty("splash.version_font_size"));
    private static final int S_COPYRIGHT_SIZE = new Integer(m_splashProperties.getProperty("splash.copyright_font_size"));
    private static final String S_TITLE_FONT = m_splashProperties.getProperty("splash.title_font_name");
    private static final String S_VERSION_FONT = m_splashProperties.getProperty("splash.version_font_name");
    private static final String S_COPYRIGHT_FONT = m_splashProperties.getProperty("splash.copyright_font_name");
    private static final int S_TITLE_FONT_STYLE = 0;
    private static final int S_VERSION_FONT_STYLE = 0;
    private static final int S_COPYRIGHT_FONT_STYLE = 0;
    private Image m_Image = null;
    private Font m_fontCompanyName = new Font(S_TITLE_FONT, OiixLanguage.getFontStyle(1), 30);
    private Font m_fontProductName = new Font(S_TITLE_FONT, OiixLanguage.getFontStyle(0), S_TITLE_SIZE);
    private Font m_fontProductVersion = new Font(S_VERSION_FONT, OiixLanguage.getFontStyle(0), S_VERSION_SIZE);
    private Font m_fontCopyright = new Font(S_COPYRIGHT_FONT, OiixLanguage.getFontStyle(0), S_COPYRIGHT_SIZE);
    private String m_sCompanyName = "Oracle";
    private String m_sProductName = null;
    private String m_sProductVersion = "12";
    String[] sArgs = new String[]{OiicInstVersion.getCopyrightCurrentYear()};
    private String m_sCopyright = OiixResourceBundle.getString("S_COPYRIGHT", this.sArgs);
    private String m_sCopyright2 = OiixResourceBundle.getString("S_COPYRIGHT2");
    private int m_nXCompanyName = -1;
    private int m_nYCompanyName = -1;
    private int m_nXProductName = -1;
    private int m_nYProductName = -1;
    private int m_nXProductVersion = -1;
    private int m_nYProductVersion = -1;
    private int m_nXCopyright = -1;
    private int m_nXCopyright2 = -1;
    private int m_nYCopyright = -1;
    private int m_nYCopyright2 = -1;
    String writeProp = m_splashProperties.getProperty("splash.writetitle");
    private boolean m_bWriteTitle = new Boolean(this.writeProp);
    private boolean m_bOneClick;

    public OiifmSplashScreen(Frame parent) {
        this(parent, "Universal Installer");
    }

    public OiifmSplashScreen(Frame parent, String sProdName) {
        super(parent);
        this.m_sProductName = sProdName;
        this.m_bOneClick = Boolean.getBoolean("oracle.installer.oneclick");
        String sSplashImage = System.getProperty("oracle.installer.splashimage");
        if (sSplashImage != null) {
            this.m_Image = OiifmImage.getImageFromAbsolutePath(sSplashImage, false);
            this.m_bWriteTitle = false;
            this.m_bOneClick |= sSplashImage.endsWith("10gOneClickbusybar.gif");
        } else {
            String sImageName = OiixOraparam.getSplashImage();
            if (sImageName == null || sImageName.length() == 0) {
                sImageName = SPLASH_SCREEN;
            }
            this.m_Image = OiifmImage.getImageFromAbsolutePath(sImageName, false);
            this.m_bOneClick |= sImageName.endsWith("10gOneClickbusybar.gif");
        }
        this.setSize(WIDTH, HEIGHT);
        this.init();
    }

    public OiifmSplashScreen(Frame parent, String sProdName, String sImgLoc) {
        super(parent);
        this.m_sProductName = sProdName;
        URL url = null;
        String sSplashImage = System.getProperty("oracle.installer.splashimage");
        if (sSplashImage != null) {
            url = this.getClass().getResource(sSplashImage);
        }
        if (url == null) {
            url = this.getClass().getResource(sImgLoc);
        } else {
            this.m_bWriteTitle = false;
        }
        this.m_Image = this.getImage(url);
        this.setSize(WIDTH, HEIGHT);
        this.init();
    }

    public void update(Graphics g) {
        this.toBack();
        this.paint(g);
    }

    public void paint(Graphics g) {
        Font curFont = g.getFont();
        g.setColor(Color.black);
        if (this.m_Image != null) {
            BufferedImage bufImg = (BufferedImage)this.createImage(WIDTH, HEIGHT);
            Graphics2D g2d = bufImg.createGraphics();
            g2d.drawImage(this.m_Image, 0, 0, this);
            if (this.m_bWriteTitle) {
                g2d.setFont(this.m_fontCompanyName);
                g2d.drawString(this.m_sCompanyName, this.m_nXCompanyName, this.m_nYCompanyName);
                g2d.setFont(this.m_fontProductName);
                g2d.drawString(this.m_sProductName, this.m_nXProductName, this.m_nYProductName);
                g2d.setFont(this.m_fontProductVersion);
                g2d.drawString(this.m_sProductVersion, this.m_nXProductVersion, this.m_nYProductVersion);
                g2d.setFont(this.m_fontCopyright);
                g2d.drawString(this.m_sCopyright, this.m_nXCopyright, this.m_nYCopyright);
                g2d.drawString(this.m_sCopyright2, this.m_nXCopyright2, this.m_nYCopyright2);
            }
            if (this.m_bOneClick) {
                g2d.setFont(new Font(curFont.getName(), OiixLanguage.getFontStyle(1), 12));
                Color c = g2d.getColor();
                g2d.setColor(Color.WHITE);
                g2d.drawString(OiixResourceBundle.getString("OUI-3478735-1"), 10, 15);
                g2d.setFont(new Font(curFont.getName(), OiixLanguage.getFontStyle(0), 13));
                g2d.setColor(c);
                FontMetrics fm = g2d.getFontMetrics();
                int wid = fm.charWidth('W');
                int width = this.getWidth();
                int charsPerLine = this.getWidth() / wid;
                String txt = OiixResourceBundle.getString("OUI-3478735-2");
                int height = fm.getHeight();
                int currHeight = 120;
                int idx = -1;
                boolean newidx = false;
                String line = txt.substring(idx + 1, txt.length());
                int lineLength = fm.stringWidth(line);
                while (lineLength > width) {
                    int idx2 = -1;
                    int last = line.length();
                    do {
                        last = idx2;
                    } while (fm.stringWidth(line.substring(0, idx2 = line.indexOf(32, idx2 + 1))) < width);
                    String toDraw = line.substring(0, last);
                    int diff = width - fm.stringWidth(toDraw);
                    g2d.drawString(toDraw, diff / 2, currHeight);
                    currHeight += height;
                    line = line.substring(last);
                    lineLength = fm.stringWidth(line);
                }
                int diff = width - fm.stringWidth(line);
                g2d.drawString(line, diff / 2, currHeight);
            }
            g.drawImage(bufImg, 0, 0, this);
            g2d.dispose();
        } else {
            g.setFont(new Font(curFont.getName(), OiixLanguage.getFontStyle(3), 20));
            g.drawString(OiixResourceBundle.getString("S_LOADING"), 150, 100);
        }
    }

    public Image getImage(URL sLocation) {
        Image img = Toolkit.getDefaultToolkit().getImage(sLocation);
        return img;
    }

    public void init() {
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(this.m_Image, 0);
        mediaTracker.checkAll(true);
        int maxWidth = Toolkit.getDefaultToolkit().getScreenSize().width;
        int maxHeight = Toolkit.getDefaultToolkit().getScreenSize().height;
        this.setLocation(maxWidth / 2 - 220, maxHeight / 2 - 160);
        FontMetrics fontMetricsOracle = this.getFontMetrics(this.m_fontCompanyName);
        int nWidth = fontMetricsOracle.stringWidth(this.m_sCompanyName);
        this.m_nXCompanyName = (WIDTH - nWidth) / 2;
        this.m_nYCompanyName = HEIGHT / 2 - fontMetricsOracle.getMaxDescent() - 10;
        FontMetrics fontMetricsProdName = this.getFontMetrics(this.m_fontProductName);
        nWidth = fontMetricsProdName.stringWidth(this.m_sProductName);
        this.m_nXProductName = (WIDTH - nWidth) / 2;
        this.m_nYProductName = HEIGHT / 2 + fontMetricsProdName.getMaxAscent() - 10;
        FontMetrics fontMetricsVersion = this.getFontMetrics(this.m_fontProductVersion);
        nWidth = fontMetricsVersion.stringWidth(this.m_sProductVersion);
        this.m_nXProductVersion = (WIDTH - nWidth) / 2;
        this.m_nYProductVersion = this.m_nYProductName + fontMetricsProdName.getDescent() + fontMetricsVersion.getAscent();
        FontMetrics fontMetricsCopyright = this.getFontMetrics(this.m_fontCopyright);
        nWidth = fontMetricsCopyright.stringWidth(this.m_sCopyright);
        this.m_nXCopyright = (WIDTH - nWidth) / 2;
        nWidth = fontMetricsCopyright.stringWidth(this.m_sCopyright2);
        this.m_nXCopyright2 = (WIDTH - nWidth) / 2;
        this.m_nYCopyright = HEIGHT - 5 - fontMetricsCopyright.getDescent();
        this.m_nYCopyright2 = HEIGHT - 20 - fontMetricsCopyright.getDescent();
        try {
            mediaTracker.waitForID(0, 10000L);
        }
        catch (InterruptedException e) {
            System.err.println("Unable to load splash screen image");
        }
    }

    private static Properties loadProperties() {
        Properties splashProps = new Properties();
        String ouiLoc = System.getProperty("oracle.installer.oui_loc");
        String imagePropertyFile = OiixFunctionOps.concatPath(ouiLoc, "instImages");
        imagePropertyFile = OiixFunctionOps.concatPath(imagePropertyFile, "images.properties");
        FileInputStream propertyInputStream = null;
        try {
            propertyInputStream = new FileInputStream(imagePropertyFile);
        }
        catch (FileNotFoundException fe) {
            fe.printStackTrace();
        }
        if (propertyInputStream != null) {
            try {
                splashProps.load(propertyInputStream);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return splashProps;
    }
}

