/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifm;

import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import oracle.sysman.oii.oiif.oiifp.OiifpConfigTablePanel;
import oracle.sysman.oii.oiix.OiixBufferOutputStream;
import oracle.sysman.oii.oiix.OiixStreamListener;

public class OiifmStreamTextAreaListener
implements OiixStreamListener {
    private int m_lastLen;
    private int m_curLen;
    private OiixBufferOutputStream m_bos;
    private OiifpConfigTablePanel.DetailsTextArea m_textArea = null;
    private OiifmTextUpdater m_txtUpdater;
    private static final int WIDTH = 550;
    private static final int HEIGHT = 500;

    public OiifmStreamTextAreaListener(OiixBufferOutputStream bos, OiifpConfigTablePanel.DetailsTextArea textArea) {
        this.m_bos = bos;
        this.m_textArea = textArea;
        String streamContents = this.m_bos.getContents();
        if (this.m_textArea != null) {
            this.m_textArea.append(streamContents);
        }
        this.m_lastLen = this.m_curLen = streamContents.length();
        this.m_txtUpdater = new OiifmTextUpdater();
        new Thread(this.m_txtUpdater).start();
        this.m_bos.setStreamListener(this);
    }

    public void stopListening() {
        this.m_txtUpdater.setDone(true);
    }

    public synchronized void newChar(int newLen, char newChar) {
        this.m_curLen = newLen;
    }

    public synchronized int getLength() {
        return this.m_curLen;
    }

    private class OiifmTextUpdater
    implements Runnable {
        private boolean m_done = false;

        OiifmTextUpdater() {
        }

        public synchronized void setDone(boolean done) {
            this.m_done = done;
        }

        private synchronized boolean getDone() {
            return this.m_done;
        }

        private String formatNewlines(String s) {
            StringBuffer sBuff = new StringBuffer(s.length());
            try {
                for (int i = 0; i < s.length(); ++i) {
                    char c = s.charAt(i);
                    if (c != '\r') {
                        if (c == '\u0000') continue;
                        sBuff.append(c);
                        continue;
                    }
                    if (i + 1 < s.length() && s.charAt(i + 1) == '\n') continue;
                    sBuff.append('\n');
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return sBuff.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Object object = OiifmStreamTextAreaListener.this.m_textArea.getLock();
                synchronized (object) {
                    do {
                        Thread.currentThread();
                        Thread.sleep(100L);
                        int curLen = OiifmStreamTextAreaListener.this.getLength();
                        if (curLen <= OiifmStreamTextAreaListener.this.m_lastLen) continue;
                        char[] copyArr = OiifmStreamTextAreaListener.this.m_bos.getChars(OiifmStreamTextAreaListener.this.m_lastLen, curLen - 1);
                        final String copyStr = this.formatNewlines(new String(copyArr));
                        if (OiifmStreamTextAreaListener.this.m_textArea != null) {
                            try {
                                SwingUtilities.invokeAndWait(new Runnable(){

                                    public void run() {
                                        OiifmStreamTextAreaListener.this.m_textArea.append(copyStr);
                                    }
                                });
                            }
                            catch (InvocationTargetException e) {
                                e.printStackTrace();
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                        OiifmStreamTextAreaListener.this.m_lastLen = curLen;
                    } while (!this.getDone());
                }
                OiifmStreamTextAreaListener.this.m_bos.resetStreamListener();
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
        }
    }
}

