/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JLabel;

class AccessFocusLabel
extends JLabel {
    private boolean bFocusable = false;
    private boolean bFocused = false;

    public AccessFocusLabel() {
    }

    public AccessFocusLabel(String label) {
        this();
        this.setText(label);
    }

    public AccessFocusLabel(boolean focusable) {
        this();
        this.setLabelFocus(focusable);
    }

    public AccessFocusLabel(boolean isFocusable, String sName, String sDesc) {
        this(isFocusable);
        this.setLabelAccessContext(sName, sDesc);
    }

    public void setLabelAccessContext(String sName, String sDesc) {
        if (sName == "" && this.getAccessibleContext().getAccessibleName() == null && this.getText() != "") {
            this.getAccessibleContext().setAccessibleName(this.getText());
        }
        if (sDesc == "" && this.getAccessibleContext().getAccessibleDescription() == null && this.getToolTipText() != "") {
            this.getAccessibleContext().setAccessibleDescription(this.getToolTipText());
        }
        if (sName != "") {
            this.getAccessibleContext().setAccessibleName(sName);
        }
        if (sDesc != "") {
            this.getAccessibleContext().setAccessibleDescription(sDesc);
        }
    }

    public void setLabelFocus(boolean bFocus) {
        this.bFocusable = bFocus;
        this.setRequestFocusEnabled(bFocus);
        if (bFocus) {
            this.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent event) {
                    AccessFocusLabel.this.bFocused = true;
                    AccessFocusLabel.this.repaint();
                }

                public void focusLost(FocusEvent event) {
                    AccessFocusLabel.this.bFocused = false;
                    AccessFocusLabel.this.repaint();
                }
            });
        }
        this.repaint();
    }

    public void setLabelAccessAndFocus(boolean bFocus, String sName, String sDesc) {
        this.setLabelFocus(bFocus);
        this.setLabelAccessContext(sName, sDesc);
    }

    public boolean isFocusTraversable() {
        return this.bFocusable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintComponent(Graphics g) {
        if (this.ui != null) {
            try {
                this.ui.update(g, this);
                Object var3_2 = null;
                g.dispose();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                g.dispose();
                throw throwable;
            }
        }
        if (this.bFocused) {
            Dimension size = this.getSize();
            g.setColor(Color.BLUE);
            g.drawRect(0, 0, size.width - 1, size.height - 1);
        }
    }
}

