/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifp;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.LWList;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.textWrapper.TextWrapper;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.sysman.oii.oiif.oiifb.OiifbConfigListener;
import oracle.sysman.oii.oiif.oiifb.OiifbReadmeListener;
import oracle.sysman.oii.oiif.oiifm.OiifmCursorUtil;
import oracle.sysman.oii.oiif.oiifp.OiifpWizPanel;
import oracle.sysman.oii.oiix.OiixBufferOutputStream;
import oracle.sysman.oii.oiix.OiixLanguage;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixWorkNotifiable;

public class OiifpConfigReadmePanel
extends OiifpWizPanel
implements ActionListener,
KeyListener,
OiixWorkNotifiable {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 256;
    private final int HGAP = 15;
    private final int VGAP = 5;
    private final int VIS_LINES = 15;
    private LWList m_list;
    private boolean m_isReadme;
    private OiifbConfigListener m_configListener;
    private OiifbReadmeListener m_readmeListener;

    public OiifpConfigReadmePanel(String[] items, boolean isReadme) {
        super("");
        String label;
        String prompt;
        String title;
        Font font_italic = new Font(OiixResourceBundle.getFont(), OiixLanguage.getFontStyle(2), 12);
        this.m_isReadme = isReadme;
        if (isReadme) {
            title = OiixResourceBundle.getString("S_READMES");
            prompt = OiixResourceBundle.getString("S_README_PROMPT");
            label = OiixResourceBundle.getString("S_README_LABEL");
        } else {
            title = OiixResourceBundle.getString("S_OPT_TOOLS");
            prompt = OiixResourceBundle.getString("S_CONFIG_PROMPT");
            label = OiixResourceBundle.getString("S_CONFIG_LABEL");
        }
        this.setTitleLabel(title);
        TextWrapper twrap = WordWrapper.getTextWrapper();
        MultiLineLabel promptLabel = new MultiLineLabel(twrap, prompt);
        promptLabel.setPreferredAspectRatio(0.0f);
        this.mainPanel.add((Component)promptLabel, (Object)"North");
        this.dlgPanel.setLayout((LayoutManager)new BorderLayout(15, 5));
        GridLayout gLayout = new GridLayout(1, 2, 15, 5);
        LWLabel listLabel = new LWLabel(label);
        this.dlgPanel.add((Component)listLabel, (Object)"North");
        this.m_list = new LWList(15, false);
        this.m_list.addActionListener((ActionListener)this);
        this.m_list.addKeyListener((KeyListener)this);
        this.populateLists(items);
        this.dlgPanel.add((Component)this.m_list, (Object)"Center");
        prompt = OiixResourceBundle.getString("S_CLICK_DONE");
        LWLabel bodyLabel4 = new LWLabel(prompt);
        bodyLabel4.setFont(font_italic);
        this.mainPanel.add((Component)bodyLabel4, (Object)"South");
    }

    public void populateLists(String[] items) {
        this.m_list.removeAll();
        if (items != null) {
            for (int i = 0; i < items.length; ++i) {
                this.m_list.add(items[i]);
            }
            if (items.length > 0) {
                this.m_list.select(0);
            }
        }
    }

    private void displayConfig() {
        OiifmCursorUtil.setCursor(3, (Component)((Object)this));
        OiixBufferOutputStream results = new OiixBufferOutputStream();
        int itemIndex = this.m_list.getSelectedIndex();
        String itemLabel = this.m_list.getSelectedItem();
        if (itemIndex >= 0 && this.m_configListener != null) {
            this.m_configListener.onSelectConfig(itemLabel, itemIndex, 3, results);
        }
        OiifmCursorUtil.setCursor(0, (Component)((Object)this));
    }

    private void displayReadme() {
        OiifmCursorUtil.setCursor(3, (Component)((Object)this));
        int itemIndex = this.m_list.getSelectedIndex();
        String itemLabel = this.m_list.getSelectedItem();
        if (itemIndex >= 0 && this.m_readmeListener != null) {
            this.m_readmeListener.onSelectReadme(itemLabel, itemIndex);
        }
        OiifmCursorUtil.setCursor(0, (Component)((Object)this));
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.m_list) {
            if (this.m_isReadme) {
                this.displayReadme();
            } else {
                this.displayConfig();
            }
        }
    }

    public void keyTyped(KeyEvent event) {
        Object source = event.getSource();
        char charTyped = event.getKeyChar();
        if (charTyped == ' ' && source == this.m_list) {
            if (this.m_isReadme) {
                this.displayReadme();
            } else {
                this.displayConfig();
            }
        }
    }

    public void keyPressed(KeyEvent event) {
    }

    public void keyReleased(KeyEvent event) {
    }

    public void setConfigListener(OiifbConfigListener cListener) {
        this.m_configListener = cListener;
    }

    public void setReadmeListener(OiifbReadmeListener rListener) {
        this.m_readmeListener = rListener;
    }

    public void workStarted(Object o) {
    }

    public void workCompleted(Object o) {
        this.m_configListener.clearClient();
    }
}

