/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifp;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import oracle.ewt.EwtContainer;
import oracle.ewt.dTree.DTreeItem;
import oracle.ewt.dTree.DTreeSimpleRoot;
import oracle.ewt.laf.oracle.ScrollBoxBorderPainter;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.scrolling.scrollBox.ScrollBox;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.sysman.oii.oiic.OiicDeinstallSession;
import oracle.sysman.oii.oiic.OiicDelSession;
import oracle.sysman.oii.oiic.OiicDestageSession;
import oracle.sysman.oii.oiic.OiicInstallSession;
import oracle.sysman.oii.oiic.OiicInstaller;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiic.OiicSessionPlan;
import oracle.sysman.oii.oiic.OiicSessionWrapper;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifd.OiifdConfirmRemoveDlg;
import oracle.sysman.oii.oiif.oiifd.OiifdInvInfoPanel;
import oracle.sysman.oii.oiif.oiifd.OiifdInventoryDialog;
import oracle.sysman.oii.oiif.oiifj.OiifjDetailsDlg;
import oracle.sysman.oii.oiif.oiifj.OiifjRemoveDlg;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiif.oiifm.OiifmCheckTreeItem;
import oracle.sysman.oii.oiif.oiifm.OiifmConstrainedMLLabel;
import oracle.sysman.oii.oiif.oiifm.OiifmCursorUtil;
import oracle.sysman.oii.oiif.oiifm.OiifmDetailsAlert;
import oracle.sysman.oii.oiif.oiifm.OiifmInfo;
import oracle.sysman.oii.oiif.oiifm.OiifmTreeItem;
import oracle.sysman.oii.oiif.oiifp.OiifpInventoryTree;
import oracle.sysman.oii.oiii.OiiiAreaInventory;
import oracle.sysman.oii.oiii.OiiiCompIdOhPair;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiInstallOneoffInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallPatchInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallPatchSetInvEntry;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiii.OiiiPatchInstallID;
import oracle.sysman.oii.oiii.OiiiPatchSetInstallID;
import oracle.sysman.oii.oiii.OiiiStageInventory;
import oracle.sysman.oii.oiio.oiiod.OiiodDepEngineHelper;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgOracleHomes;
import oracle.sysman.oii.oiip.oiipg.OiipgReadRGS;
import oracle.sysman.oii.oiip.oiipg.OiipgRgsEntry;
import oracle.sysman.oii.oiix.OiixInstantiateOps;
import oracle.sysman.oii.oiix.OiixLanguage;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiifpContentsTabPanel
extends EwtContainer
implements ActionListener {
    public static final int REMOVE = 0;
    public static final int CANCEL = 1;
    public static final int HELP = 2;
    private static final int WIDTH = 450;
    private static final int HEIGHT = 420;
    private static final int INSETS = 10;
    private static final int LIST_ITEM_GAP = 5;
    private static final int BUTTON_GAP = 10;
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 32;
    private LWButton m_remove = null;
    private LWButton m_details = null;
    private OiifpInventoryTree m_invTree = null;
    private OiifdInvInfoPanel m_iPanel = null;
    private LWContainer m_invPanel = null;
    private EwtContainer m_noprodsPanel = null;
    private LWContainer m_centerPanel = null;
    private ScrollBox m_scrollbox = null;
    private int m_buttonPressed = -1;
    private Dimension m_prefSize = null;
    private boolean m_viewOnly = false;
    private Vector m_vRemoveCompIds = null;
    private OiiiAreaInventory m_inventory = null;
    private OiiiInstallAreaControl invAreaControl = null;
    private Vector m_rmComps = null;
    private ArrayList m_rmHomes = null;
    private OiifdConfirmRemoveDlg confirm = null;
    private OiifjRemoveDlg m_removeDlg = null;
    private OiifdInventoryDialog m_invDlg = null;
    private OiiiCompIdOhPair m_currentSelectedComponent = null;
    private boolean m_bCurrentCompIsHome = false;
    private OiicDelSession m_delSession = null;
    private boolean m_bDeinstallSession = false;
    private boolean m_bEnableRemove = false;
    private boolean m_bEnableDetails = true;
    private boolean m_bShowConfirmation = true;
    private boolean m_bShowProgress = true;
    private Frame m_Frame = null;
    private static final int ARRAY_INDEX_FOR_ATTRIBUTE = 0;
    private static final int ARRAY_INDEX_FOR_VALUE = 1;
    private static final int SINGLE_VALUED_ATTRIBUTES_COUNT = 4;
    private static final String EMPTY_STRING = "";
    private boolean m_bShowEmptyHomes = false;
    private boolean m_bEmptyHomeExists = false;
    private LWCheckbox m_cbShowEmptyHomes = null;
    private boolean m_bCanSetOHProp = false;
    private String m_customDeinstallCommand = null;
    private boolean m_bCustomDeinstall = false;
    private int m_customDeinstallHomes = 0;

    public OiifpContentsTabPanel(Frame f, OiifdInventoryDialog invDlg, boolean viewOnly, boolean bDeinstallSession, boolean bShowConfirmation, boolean bShowProgress) {
        boolean v_bVar;
        OiicInstaller installer = OiicInstaller.getOiicInstallerInstance();
        Properties dProps = installer.getDefaultsOverriden();
        if (dProps != null && dProps.getProperty("oracle.installer.compsdeinstall") != null) {
            this.m_bCanSetOHProp = true;
        }
        this.m_Frame = f;
        this.m_invDlg = invDlg;
        Font twelveFont = new Font(OiixResourceBundle.getFont(), 0, 12);
        this.invAreaControl = (OiiiInstallAreaControl)OiiiInstallAreaControl.getInventoryAreaControl();
        this.m_inventory = null != this.invAreaControl ? this.invAreaControl.getAreaInventory() : null;
        this.m_viewOnly = viewOnly;
        this.setLayout(new BorderLayout());
        this.m_centerPanel = new LWContainer();
        this.m_centerPanel.setLayout((LayoutManager)new BorderLayout(5, 5));
        this.m_centerPanel.setBorderPainter((BorderPainter)new FixedBorderPainter(10, 10, 10, 10));
        this.add((Component)this.m_centerPanel, "Center");
        String pStr = OiixResourceBundle.getString("S_INST_PRODS_PROMPT");
        MultiLineLabel label1 = new MultiLineLabel(WordWrapper.getTextWrapper(), pStr);
        label1.setPreferredAspectRatio(0.0f);
        label1.setFont(twelveFont);
        this.m_centerPanel.add((Component)label1, (Object)"North");
        this.m_invPanel = this.createInventoryPanel();
        this.m_noprodsPanel = this.createNoProdsPanel();
        boolean bl = v_bVar = 0 < this.m_invTree.getSimpleRoot().getItemCount();
        if (v_bVar) {
            this.m_centerPanel.add((Component)this.m_invPanel, (Object)"Center");
        } else {
            this.m_centerPanel.add((Component)this.m_noprodsPanel, (Object)"Center");
        }
        this.m_invDlg.enableSave(v_bVar);
        this.m_cbShowEmptyHomes = new LWCheckbox(OiixResourceBundle.getString("S_SHOW_EMPTY_HOMES"));
        this.m_cbShowEmptyHomes.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                OiifpContentsTabPanel.this.m_bShowEmptyHomes = e.getStateChange() == 1;
                OiifpContentsTabPanel.this.refreshTree();
            }
        });
        LWContainer bottomPanel = new LWContainer();
        bottomPanel.setLayout((LayoutManager)new BorderLayout(5, 5));
        bottomPanel.add((Component)this.m_cbShowEmptyHomes, (Object)"North");
        bottomPanel.add((Component)this.createUserInstructionsPanel(), (Object)"Center");
        bottomPanel.add((Component)this.createButtonPanel(), (Object)"South");
        this.m_centerPanel.add((Component)bottomPanel, (Object)"South");
        this.m_prefSize = new Dimension(450, 420);
        this.m_bDeinstallSession = bDeinstallSession;
        this.m_bShowProgress = bShowProgress;
        this.m_bShowConfirmation = bShowConfirmation;
        if (this.m_bDeinstallSession) {
            String sWelcome = System.getProperty("oracle.installer.welcome");
            if (sWelcome.equalsIgnoreCase("true")) {
                f.setVisible(true);
                f.repaint();
            } else {
                f.setVisible(false);
            }
        }
        this.validate();
    }

    public void setCurrentSelectedComponent(OiiiCompIdOhPair selectedComponent) {
        this.m_currentSelectedComponent = selectedComponent;
    }

    public OiiiCompIdOhPair getCurrentSelectedComponent() {
        return this.m_currentSelectedComponent;
    }

    public void setCurrentComponentIsHome(boolean bHomeSelected) {
        this.m_bCurrentCompIsHome = bHomeSelected;
    }

    public void enableDetailsButton(boolean enable) {
        this.m_details.setEnabled(enable);
    }

    private LWContainer createInventoryPanel() {
        LWContainer treePanel = new LWContainer();
        treePanel.setLayout((LayoutManager)new BorderLayout(5, 5));
        this.m_invTree = new OiifpInventoryTree();
        this.m_scrollbox = new ScrollBox((Component)((Object)this.m_invTree), 0, 0);
        ScrollBoxBorderPainter sborder = new ScrollBoxBorderPainter();
        this.m_scrollbox.setBorderPainter((BorderPainter)sborder);
        this.m_scrollbox.setBackground(Color.white);
        treePanel.add((Component)this.m_scrollbox, (Object)"Center");
        OiifmInfo info = new OiifmInfo();
        this.m_iPanel = new OiifdInvInfoPanel(info);
        treePanel.add((Component)((Object)this.m_iPanel), (Object)"South");
        return treePanel;
    }

    private EwtContainer createNoProdsPanel() {
        EwtContainer panel = new EwtContainer();
        panel.setLayout((LayoutManager)new BorderLayout());
        ScrollBoxBorderPainter fborder = new ScrollBoxBorderPainter();
        panel.setBorderPainter((BorderPainter)fborder);
        panel.setBackground(Color.white);
        String str = OiixResourceBundle.getString("S_NO_INST_PRODS_PROMPT");
        LWLabel npLabel = new LWLabel(str);
        panel.add((Component)npLabel, (Object)"North");
        return panel;
    }

    private LWComponent createUserInstructionsPanel() {
        String v_sKey = this.m_viewOnly ? "S_NO_REM_PRODS_PROMPT" : "S_REM_PRODS_PROMPT";
        String removePrompt = OiixResourceBundle.getString(v_sKey);
        String detailsPrompt = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFD1000");
        String prompt = removePrompt + "\n\n" + detailsPrompt;
        OiifmConstrainedMLLabel label = new OiifmConstrainedMLLabel(WordWrapper.getTextWrapper(), prompt);
        label.setPreferredAspectRatio(0.0f);
        return label;
    }

    private LWContainer createButtonPanel() {
        LWContainer buttonPanel = new LWContainer();
        buttonPanel.setLayout((LayoutManager)new FlowLayout(2, 0, 5));
        this.m_details = new LWButton(OiixResourceBundle.getString("S_DETAILS_BUTTON"));
        this.m_details.setEnabled(false);
        this.m_details.addActionListener((ActionListener)this);
        buttonPanel.add((Component)this.m_details);
        this.m_remove = new LWButton(OiixResourceBundle.getString("S_REMOVE_BUTTON"));
        this.m_remove.setEnabled(false);
        this.m_remove.addActionListener((ActionListener)this);
        buttonPanel.add((Component)this.m_remove);
        return buttonPanel;
    }

    private void fillInventoryTree() {
        if (this.m_inventory instanceof OiiiInstallInventory) {
            this.addHomes();
            this.addTLComps(this.m_bDeinstallSession);
            this.addZombieComps();
        }
        this.add33Comps();
        if (!this.m_bShowEmptyHomes) {
            this.m_invTree.cleanupTree();
        }
        this.m_invTree.setInvDlg(this);
        this.setRemoveEnabled(this.m_bEnableRemove);
    }

    private void addHomes() {
        int[] anGroupTypes = new int[]{0, 1};
        String[] asGroupLabels = new String[]{OiixResourceBundle.getString("S_ORACLE_HOMES_LABEL"), OiixResourceBundle.getString("S_APPLTOPS_LABEL")};
        DTreeSimpleRoot root = this.m_invTree.getSimpleRoot();
        if (!this.m_inventory.getAllCompsVect(0).isEmpty()) {
            int nGroupType = 2;
            String sLabel = OiixResourceBundle.getString("S_INDEP_PRODS_LABEL");
            OiifmTreeItem treeItem = new OiifmTreeItem(sLabel, null, new Integer(nGroupType));
            root.addItem((DTreeItem)treeItem);
        }
        DTreeSimpleRoot oRootItem = this.m_invTree.getSimpleRoot();
        for (int i = 0; i < anGroupTypes.length; ++i) {
            Vector OHs = ((OiiiInstallInventory)this.m_inventory).getHomes(anGroupTypes[i]);
            if (OHs.isEmpty()) continue;
            OiifmTreeItem oGroupNode = new OiifmTreeItem(asGroupLabels[i], null, new Integer(anGroupTypes[i]));
            oRootItem.addItem((DTreeItem)oGroupNode);
            oGroupNode.setExpanded(true);
            for (int j = 0; j < OHs.size(); ++j) {
                int nNodeListSize;
                OiicInstallSession instSession;
                OiiiOracleHomeInfo currOH = (OiiiOracleHomeInfo)OHs.elementAt(j);
                OiicSessionWrapper sessions = OiicInstaller.getSessionWrapper();
                if (sessions.getCurSession() instanceof OiicInstallSession && (instSession = (OiicInstallSession)sessions.getCurSession()).getOhLocName().containsKey(OiixPathOps.getNativeCanonicalPath(currOH.getLocation()))) continue;
                ((OiiiInstallInventory)this.m_inventory).setOHProperties(currOH);
                String displayName = currOH.getName();
                if (displayName == null || 0 >= displayName.trim().length()) {
                    displayName = currOH.getLocation();
                }
                OiifmCheckTreeItem OHtreeItem = new OiifmCheckTreeItem(displayName, this.m_invTree.getStateIcons(), currOH, 0);
                OHtreeItem.setCheckListener(this.m_invTree);
                OHtreeItem.setOnState(1);
                Vector vNodeList = currOH.getNodeList();
                if (vNodeList != null && (nNodeListSize = vNodeList.size()) != 0) {
                    String sNodeNameLabel = OiixResourceBundle.getString("S_CLUSTER_NODES");
                    OiifmTreeItem oNodeNameItem = new OiifmTreeItem(sNodeNameLabel, null, null);
                    OiifmTreeItem oClusterNodetreeItem = null;
                    for (int k = 0; k < nNodeListSize; ++k) {
                        oClusterNodetreeItem = new OiifmTreeItem((String)vNodeList.elementAt(k), null, (String)vNodeList.elementAt(k));
                        oNodeNameItem.addItem((DTreeItem)oClusterNodetreeItem);
                    }
                    oNodeNameItem.setExpanded(false);
                    OHtreeItem.addItem((DTreeItem)oNodeNameItem);
                }
                OHtreeItem.setToolTipText(currOH.getLocation());
                oGroupNode.addItem((DTreeItem)OHtreeItem);
            }
        }
    }

    private void addTLComps(boolean bFull) {
        this.m_bEmptyHomeExists = false;
        DTreeSimpleRoot oRootItem = this.m_invTree.getSimpleRoot();
        int nIter = bFull ? -1 : 2;
        int nItemCount = oRootItem.getItemCount();
        for (int i = 0; i < nItemCount; ++i) {
            OiifmTreeItem oGroupNode = (OiifmTreeItem)oRootItem.getItem(i);
            int nGroupType = (Integer)oGroupNode.getID();
            OiiiInstallInventory inventory = (OiiiInstallInventory)this.m_inventory;
            if (nGroupType == 2) {
                Vector compIdsVect = this.m_inventory.getTopLevelComps(0);
                Vector compOhVect = OiiiCompIdOhPair.createCompIdOhVector(compIdsVect, 0);
                this.fillSubTree(oGroupNode, compOhVect, nIter, true);
                Vector vOneoffs = inventory.getAllOneoffInvEntries(0);
                this.addOneoffs(vOneoffs, oGroupNode);
                continue;
            }
            int nHomeCount = oGroupNode.getItemCount();
            for (int j = 0; j < nHomeCount; ++j) {
                OiifmTreeItem oHomeNode = (OiifmTreeItem)oGroupNode.getItem(j);
                Object oNodeData = oHomeNode.getID();
                if (!(oNodeData instanceof OiiiOracleHomeInfo)) continue;
                int nOhIndex = ((OiiiOracleHomeInfo)oNodeData).getIndex();
                Vector compIdsVect = this.m_inventory.getTopLevelComps(nOhIndex);
                if (compIdsVect.isEmpty()) {
                    this.m_bEmptyHomeExists = true;
                }
                Vector compOhVect = OiiiCompIdOhPair.createCompIdOhVector(compIdsVect, nOhIndex);
                this.fillSubTree(oHomeNode, compOhVect, nIter, inventory.allowCompsDeinstall((OiiiOracleHomeInfo)oNodeData, this.m_bCanSetOHProp));
                this.addOneoffs((OiiiOracleHomeInfo)oNodeData, oHomeNode);
            }
        }
    }

    private void addZombieComps() {
        DTreeSimpleRoot oRootItem = this.m_invTree.getSimpleRoot();
        int nItemCount = oRootItem.getItemCount();
        OiiiInstallInventory inventory = (OiiiInstallInventory)this.m_inventory;
        for (int i = 0; i < nItemCount; ++i) {
            OiifmTreeItem oGroupNode = (OiifmTreeItem)oRootItem.getItem(i);
            int nGroupType = (Integer)oGroupNode.getID();
            if (nGroupType == 2) {
                int nOhIndex = 0;
                this.addZombieCompsForHome(nOhIndex, oGroupNode, true);
                continue;
            }
            int nHomeCount = oGroupNode.getItemCount();
            for (int j = 0; j < nHomeCount; ++j) {
                OiifmTreeItem oHomeNode = (OiifmTreeItem)oGroupNode.getItem(j);
                Object oNodeData = oHomeNode.getID();
                if (!(oNodeData instanceof OiiiOracleHomeInfo)) continue;
                int nOhIndex = ((OiiiOracleHomeInfo)oNodeData).getIndex();
                this.addZombieCompsForHome(nOhIndex, oHomeNode, inventory.allowCompsDeinstall((OiiiOracleHomeInfo)oNodeData, this.m_bCanSetOHProp));
            }
        }
    }

    private void addZombieCompsForHome(int ohIndex, OiifmTreeItem oParent, boolean compsDeinstall) {
        Vector compInvEntryVect = OiiodDepEngineHelper.getUnrefComps(this.m_inventory, ohIndex);
        if (compInvEntryVect != null) {
            for (int j = 0; j < compInvEntryVect.size(); ++j) {
                OiiiCompInvEntry currEntry = (OiiiCompInvEntry)compInvEntryVect.elementAt(j);
                OiiiCompInstallID currCompID = currEntry.getCompInstallID();
                OiiiCompIdOhPair currIdOhPair = new OiiiCompIdOhPair(currCompID, ohIndex);
                boolean bCompSelect = false;
                if (this.m_bDeinstallSession) {
                    OiicDeinstallSession ods = (OiicDeinstallSession)this.m_delSession;
                    bCompSelect = ods.isCompInDeinstallList(currIdOhPair);
                }
                if (this.childExistsRecurse(oParent, currIdOhPair)) continue;
                String compLabel = currEntry.getFullDisplayName();
                OiifmCheckTreeItem treeItem = new OiifmCheckTreeItem(compLabel, this.m_invTree.getStateIcons(), currIdOhPair, compsDeinstall ? (bCompSelect ? 1 : 0) : 3);
                treeItem.setExpanded(bCompSelect);
                treeItem.setOnState(1);
                treeItem.setCheckListener(this.m_invTree);
                oParent.addItem((DTreeItem)treeItem);
                if (bCompSelect) {
                    this.m_invTree.setCheckItemState(treeItem, 1);
                    treeItem.setExpanded(true);
                    this.m_bEnableRemove = true;
                }
                this.setTooltips(currEntry, treeItem);
                this.addPatch(currEntry, treeItem, ohIndex);
                Vector compIdOhVector = this.m_inventory.getCurrentEntryDeps(currCompID, ohIndex);
                this.fillSubTree(treeItem, compIdOhVector, 2, compsDeinstall);
            }
        }
    }

    private void add33Comps() {
        Vector homesList = null;
        int v_iHomeListSize = 0;
        try {
            homesList = OiipgOracleHomes.getOsdOracleHomeInfo();
            v_iHomeListSize = null != homesList ? homesList.size() : 0;
        }
        catch (Exception e) {
            // empty catch block
        }
        if (0 < v_iHomeListSize) {
            OiifmTreeItem oOracleHomesNode = this.getOracleHomesNode();
            if (null == oOracleHomesNode) {
                return;
            }
            for (int i = 0; i < v_iHomeListSize; ++i) {
                OiifmTreeItem OHtreeItem;
                OiiiOracleHomeInfo inf = (OiiiOracleHomeInfo)homesList.elementAt(i);
                String dispName = inf.getName();
                String string = dispName = null != dispName ? dispName.trim() : EMPTY_STRING;
                if (0 == dispName.length()) {
                    dispName = inf.getLocation().trim();
                }
                if ((OHtreeItem = this.m_invTree.findChildWithLabel(oOracleHomesNode, dispName)) == null) {
                    OHtreeItem = new OiifmTreeItem(dispName, null, inf);
                    OHtreeItem.setToolTipText(inf.getLocation());
                    oOracleHomesNode.addItem((DTreeItem)OHtreeItem);
                }
                Vector oldComps = null;
                try {
                    OiipgReadRGS rrgs = new OiipgReadRGS();
                    rrgs.init(inf.getLocation());
                    rrgs.doReadRgs();
                    oldComps = rrgs.getRgsTable();
                }
                catch (Exception e) {
                    // empty catch block
                }
                int size = null != oldComps ? oldComps.size() : 0;
                for (int j = 0; j < size; ++j) {
                    OiipgRgsEntry rgsEntry = (OiipgRgsEntry)oldComps.elementAt(j);
                    String label = rgsEntry.getInterfaceLabel();
                    label = label.replace('\"', ' ');
                    label = label.trim();
                    String ver = rgsEntry.getVersion();
                    ver = ver.replace('\"', ' ');
                    ver = ver.trim();
                    label = label + " " + ver;
                    OiifmTreeItem treeItem = new OiifmTreeItem(label, null, null);
                    Font f = new Font(OiixResourceBundle.getFont(), OiixLanguage.getFontStyle(2), 12);
                    treeItem.setFont(f);
                    OHtreeItem.addItem((DTreeItem)treeItem);
                    treeItem.setExpanded(false);
                }
                OHtreeItem.setExpanded(false);
            }
        }
    }

    private OiifmTreeItem getOracleHomesNode() {
        OiifmTreeItem oHomesNode = null;
        DTreeSimpleRoot oRootItem = this.m_invTree.getSimpleRoot();
        int nItemCount = oRootItem.getItemCount();
        for (int i = 0; i < nItemCount; ++i) {
            OiifmTreeItem oGroupNode = (OiifmTreeItem)oRootItem.getItem(i);
            int nGroupType = (Integer)oGroupNode.getID();
            if (nGroupType != 0) continue;
            oHomesNode = oGroupNode;
            break;
        }
        return oHomesNode;
    }

    public void fillSubTree(OiifmTreeItem parent, Vector comps, int nIter, boolean compsDeinstall) {
        if (nIter == 0) {
            return;
        }
        if (comps != null) {
            for (int i = 0; i < comps.size(); ++i) {
                OiiiCompIdOhPair currIdOhPair = (OiiiCompIdOhPair)comps.elementAt(i);
                OiifmTreeItem childItem = this.findChild(parent, currIdOhPair);
                if (childItem == null) {
                    OiifmTreeItem treeItem;
                    OiiiCompInstallID currComp = currIdOhPair.getCompID();
                    int currOHIndex = currIdOhPair.getOHIndex();
                    OiiiCompInvEntry entry = this.m_inventory.getCompInvEntry(currComp, currOHIndex);
                    String compLabel = entry.getFullDisplayName();
                    if (this.sameOH(parent, currOHIndex)) {
                        if (currComp.getCompType() != 4) {
                            treeItem = null;
                            boolean bCompSelect = false;
                            if (!compsDeinstall) {
                                treeItem = new OiifmCheckTreeItem(compLabel, this.m_invTree.getStateIcons(), currIdOhPair, 3);
                            } else if (this.m_bDeinstallSession) {
                                OiicDeinstallSession ods = (OiicDeinstallSession)this.m_delSession;
                                bCompSelect = ods.isCompInDeinstallList(currIdOhPair);
                                if (bCompSelect) {
                                    treeItem = new OiifmCheckTreeItem(compLabel, this.m_invTree.getStateIcons(), currIdOhPair, 1);
                                    treeItem.setExpanded(true);
                                    this.m_bEnableRemove = true;
                                } else {
                                    treeItem = new OiifmCheckTreeItem(compLabel, this.m_invTree.getStateIcons(), currIdOhPair, 0);
                                    treeItem.setExpanded(false);
                                }
                            } else {
                                treeItem = new OiifmCheckTreeItem(compLabel, this.m_invTree.getStateIcons(), currIdOhPair, 0);
                                treeItem.setExpanded(false);
                            }
                            ((OiifmCheckTreeItem)treeItem).setOnState(1);
                            ((OiifmCheckTreeItem)treeItem).setCheckListener(this.m_invTree);
                            parent.addItem((DTreeItem)treeItem);
                            this.setTooltips(entry, treeItem);
                            this.addPatch(entry, treeItem, currOHIndex);
                            Vector compIdOhVector = this.m_inventory.getCurrentEntryDeps(currComp, currOHIndex);
                            this.fillSubTree(treeItem, compIdOhVector, nIter - 1, compsDeinstall);
                            this.addOneoffs((OiiiInstallCompInvEntry)entry, treeItem);
                            continue;
                        }
                        treeItem = new OiifmTreeItem(compLabel, null, currIdOhPair);
                        parent.addItem((DTreeItem)treeItem);
                        treeItem.setExpanded(false);
                        this.setTooltips(entry, treeItem);
                        this.addPatch(entry, treeItem, currOHIndex);
                        continue;
                    }
                    compLabel = " {" + compLabel + "} ";
                    treeItem = new OiifmTreeItem(compLabel, null, currIdOhPair);
                    parent.addItem((DTreeItem)treeItem);
                    treeItem.setExpanded(false);
                    this.setTooltips(entry, treeItem);
                    continue;
                }
                this.addChildren(childItem, nIter - 1, compsDeinstall);
            }
        }
    }

    public void addChildren(OiifmTreeItem item, int nIter) {
        this.addChildren(item, nIter, this.m_bCanSetOHProp);
    }

    public void addChildren(OiifmTreeItem item, int nIter, boolean compsDeinstall) {
        OiifmCheckTreeItem treeItem;
        if (item instanceof OiifmCheckTreeItem && (treeItem = (OiifmCheckTreeItem)item).getID() instanceof OiiiCompIdOhPair) {
            OiiiCompIdOhPair currIdOhPair = (OiiiCompIdOhPair)treeItem.getID();
            OiiiCompInstallID currComp = currIdOhPair.getCompID();
            int currOHIndex = currIdOhPair.getOHIndex();
            Vector compIdOhVector = this.m_inventory.getCurrentEntryDeps(currComp, currOHIndex);
            OiiiInstallInventory inventory = (OiiiInstallInventory)this.m_inventory;
            OiiiOracleHomeInfo homeInfo = inventory.getHomeInfo(currOHIndex);
            compsDeinstall = inventory.allowCompsDeinstall(homeInfo, this.m_bCanSetOHProp);
            this.fillSubTree(treeItem, compIdOhVector, nIter, compsDeinstall);
        }
    }

    private void addPatch(OiiiCompInvEntry entry, OiifmTreeItem treeItem, int currOHIndex) {
        if (entry instanceof OiiiInstallPatchSetInvEntry) {
            OiiiInstallPatchSetInvEntry ie = (OiiiInstallPatchSetInvEntry)entry;
            Vector vPatchIds = ie.getPatches();
            int nSize = vPatchIds.size();
            for (int i = 0; i < nSize; ++i) {
                OiiiPatchInstallID pID = (OiiiPatchInstallID)vPatchIds.elementAt(i);
                OiiiCompInvEntry iepe = this.m_inventory.getCompInvEntry(pID, currOHIndex);
                if (iepe == null) continue;
                String compLabel = " {" + iepe.getFullDisplayName() + "} ";
                OiiiCompIdOhPair pPair = new OiiiCompIdOhPair(pID, currOHIndex);
                OiifmTreeItem patchItem = new OiifmTreeItem(compLabel, null, pPair);
                treeItem.addItem((DTreeItem)patchItem);
                patchItem.setExpanded(false);
                this.setTooltips(entry, patchItem);
            }
            return;
        }
        if (entry instanceof OiiiInstallCompInvEntry) {
            OiiiInstallCompInvEntry ie = (OiiiInstallCompInvEntry)entry;
            OiiiInstallPatchInvEntry iepe = ie.getPatchInvEntry();
            if (iepe != null) {
                String compLabel = iepe.getFullDisplayName();
                OiiiCompInstallID pid = iepe.getCompInstallID();
                OiiiCompIdOhPair pPair = new OiiiCompIdOhPair(pid, currOHIndex);
                OiifmTreeItem patchItem = new OiifmTreeItem(compLabel, null, pPair);
                treeItem.addItem((DTreeItem)patchItem);
                patchItem.setExpanded(false);
                this.setTooltips(entry, patchItem);
                this.addOneoffs(iepe, patchItem);
            }
            return;
        }
    }

    private boolean sameOH(OiifmTreeItem treeitem, int OHIndex) {
        Object id = treeitem.getID();
        return id != null ? this.getOHIndex(id) == OHIndex : OHIndex == 0;
    }

    private OiifmTreeItem getOHRoot(OiiiCompIdOhPair idOhPair) {
        int OHIndex = idOhPair.getOHIndex();
        DTreeSimpleRoot root = this.m_invTree.getSimpleRoot();
        for (int i = 0; i < root.getItemCount(); ++i) {
            OiifmTreeItem currRoot = (OiifmTreeItem)root.getItem(i);
            if (!(currRoot.getID() == null ? OHIndex == 0 : this.getOHIndex(currRoot.getID()) == OHIndex)) continue;
            return currRoot;
        }
        return null;
    }

    private OiifmTreeItem findChild(OiifmTreeItem parent, OiiiCompIdOhPair idOhPair) {
        if (parent != null) {
            for (int i = 0; i < parent.getItemCount(); ++i) {
                OiifmTreeItem currChild = (OiifmTreeItem)parent.getItem(i);
                Object childObj = currChild.getID();
                if (!(childObj instanceof OiiiCompIdOhPair) || !((OiiiCompIdOhPair)childObj).equals(idOhPair)) continue;
                return currChild;
            }
        }
        return null;
    }

    private boolean childExistsRecurse(OiifmTreeItem parent, OiiiCompIdOhPair idOhPair) {
        if (parent != null) {
            for (int i = 0; i < parent.getItemCount(); ++i) {
                OiifmTreeItem currChild = (OiifmTreeItem)parent.getItem(i);
                Object childObj = currChild.getID();
                if (childObj instanceof OiiiCompIdOhPair && ((OiiiCompIdOhPair)childObj).equals(idOhPair)) {
                    return true;
                }
                if (!this.childExistsRecurse(currChild, idOhPair)) continue;
                return true;
            }
        }
        return false;
    }

    public int getOHIndex(Object id) {
        if (id != null) {
            if (id instanceof OiiiOracleHomeInfo) {
                return ((OiiiOracleHomeInfo)id).getIndex();
            }
            if (id instanceof OiiiCompIdOhPair) {
                return ((OiiiCompIdOhPair)id).getOHIndex();
            }
        }
        return 0;
    }

    public void refreshTree() {
        int prev = this.m_invTree.getSimpleRoot().getItemCount();
        this.m_invTree.setVisible(false);
        this.m_invTree.removeAll();
        this.fillInventoryTree();
        int now = this.m_invTree.getSimpleRoot().getItemCount();
        if (now > 0 && prev == 0) {
            this.m_centerPanel.remove((Component)this.m_noprodsPanel);
            this.m_centerPanel.add((Component)this.m_invPanel, (Object)"Center");
            this.m_invDlg.enableSave(true);
        }
        if (now == 0 && prev > 0) {
            this.m_centerPanel.remove((Component)this.m_invPanel);
            this.m_centerPanel.add((Component)this.m_noprodsPanel, (Object)"Center");
            this.m_invDlg.enableSave(false);
        }
        this.m_cbShowEmptyHomes.setEnabled(this.m_bEmptyHomeExists);
        if (now == 0) {
            this.m_details.setEnabled(false);
        }
        this.m_invTree.setVisible(true);
        this.validate();
    }

    private boolean constructCompHomeList(List rmList) {
        this.m_rmComps = new Vector(rmList.size());
        this.m_rmHomes = new ArrayList();
        boolean clusterRmHome = false;
        int clusterRmHomeIndex = -10;
        int index = 0;
        ArrayList<Integer> ohList = new ArrayList<Integer>();
        Iterator iter = rmList.iterator();
        while (iter.hasNext()) {
            OiifmTreeItem item = (OiifmTreeItem)((Object)iter.next());
            Object oID = item.getID();
            if (oID instanceof OiiiOracleHomeInfo) {
                if (clusterRmHome) {
                    return false;
                }
                OiiiOracleHomeInfo homeInfo = (OiiiOracleHomeInfo)oID;
                Vector nodeList = homeInfo.getNodeList();
                if (nodeList != null && nodeList.size() > 0) {
                    if (this.m_rmHomes.size() > 0) {
                        return false;
                    }
                    clusterRmHome = true;
                    clusterRmHomeIndex = homeInfo.getIndex();
                }
                Vector tlComps = this.m_inventory.getTopLevelComps(homeInfo.getIndex());
                for (int i = 0; i < tlComps.size(); ++i) {
                    OiiiCompIdOhPair idOh;
                    OiiiCompInstallID cid = (OiiiCompInstallID)tlComps.elementAt(i);
                    if (cid instanceof OiiiPatchSetInstallID || this.m_rmComps.indexOf(idOh = new OiiiCompIdOhPair(cid, homeInfo.getIndex())) != -1) continue;
                    this.m_rmComps.add(idOh);
                }
                this.m_rmHomes.add(homeInfo);
                continue;
            }
            OiiiCompIdOhPair comp = (OiiiCompIdOhPair)oID;
            index = comp.getOHIndex();
            OiiiOracleHomeInfo homeInfo = ((OiiiInstallInventory)this.m_inventory).getHomeInfo(index);
            if (homeInfo != null) {
                Integer indexInt;
                Vector nodeList = homeInfo.getNodeList();
                if (clusterRmHome) {
                    if (clusterRmHomeIndex != index) {
                        return false;
                    }
                } else if (nodeList != null && nodeList.size() > 0) {
                    if (this.m_rmHomes.size() > 0 || ohList.size() > 0) {
                        return false;
                    }
                    clusterRmHome = true;
                    clusterRmHomeIndex = index;
                }
                if (!ohList.contains(indexInt = new Integer(index))) {
                    ohList.add(indexInt);
                }
            }
            if (this.m_rmComps.contains(oID)) continue;
            this.m_rmComps.add(oID);
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private void onRemove() {
        if (!this.constructCompHomeList(this.m_invTree.getItemsToRemove())) {
            msg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-22005");
            OiifmAlert.displayAlert(OiixResourceBundle.getString("S_WARNING"), msg, 30, 1, 1, 10);
            this.m_remove.setEnabled(true);
            return;
        }
        this.customDeinstallCheck(this.m_invTree.getItemsToRemove());
        if (this.m_bCustomDeinstall) {
            if (this.m_customDeinstallHomes > 1) {
                msg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-22026");
                OiifmAlert.displayAlert(OiixResourceBundle.getString("S_WARNING"), msg, 30, 1, 1, 10);
                this.m_remove.setEnabled(true);
                return;
            }
            if (this.m_customDeinstallHomes == 1) {
                args = new String[]{this.m_customDeinstallCommand};
                msg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-22025", args);
                OiifmAlert.displayAlert(OiixResourceBundle.getString("S_WARNING"), msg, 30, 1, 1, 10);
                this.m_remove.setEnabled(true);
                return;
            }
        }
        if (this.confirm == null) {
            this.confirm = new OiifdConfirmRemoveDlg(this.m_Frame, this.m_inventory);
        }
        this.confirm.initialize(this.m_rmComps, this.m_rmHomes);
        result = 0;
        if (!this.m_bDeinstallSession || this.m_bShowConfirmation) {
            result = this.confirm.doModal();
        }
        switch (result) {
            case 0: {
                delSession = (OiicDeinstallSession)this.getDelSession();
                sessionPlan = new OiicSessionPlan();
                sessionPlan.clearPlan();
                delSession.setSessionPlan(sessionPlan);
                delComps = this.confirm.getCompsToDeinstall();
                bCurrSelDein = false;
                try {
                    if (this.m_currentSelectedComponent == null || !this.m_details.isEnabled()) ** GOTO lbl50
                    selCompId = this.m_currentSelectedComponent.getCompID();
                    numDeinstalls = delComps.size();
                    for (i = 0; i < numDeinstalls; ++i) {
                        currIdOhPair = (OiiiCompIdOhPair)delComps.elementAt(i);
                        currComp = currIdOhPair.getCompID();
                        if (!currComp.equals(selCompId)) continue;
                        bCurrSelDein = true;
                        break;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
lbl50:
                // 4 sources

                delOneoffs = this.confirm.getOneoffsToDeinstall();
                delHomes = this.confirm.getHomesToRemove();
                try {
                    this.deinstall(delComps, delOneoffs, delHomes, sessionPlan, delSession);
                }
                catch (OiifbEndIterateException ex) {
                    ex.printStackTrace();
                }
                if (!bCurrSelDein) break;
                this.m_details.setEnabled(false);
                break;
            }
            case 1: {
                this.m_remove.setEnabled(true);
            }
        }
        if (this.confirm != null) {
            this.confirm.dispose();
            this.confirm = null;
        }
    }

    private void onDetails() {
        if (this.m_currentSelectedComponent == null || this.m_bCurrentCompIsHome) {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("In onDetails() of OiifpContentsTabPanel, Current Selected Component = null, returning", OiiolTextLogger.LOG_DETAILED);
            }
            this.m_details.setEnabled(false);
            return;
        }
        String[] installedLanguagesArray = null;
        String[] referencerArray = null;
        OiiiInstallInventory installInventory = null;
        OiiiCompInstallID compId = this.m_currentSelectedComponent.getCompID();
        String componentInternalName = compId.getName();
        int oracleHomeIndex = this.m_currentSelectedComponent.getOHIndex();
        if (this.m_inventory instanceof OiiiInstallInventory) {
            installInventory = (OiiiInstallInventory)this.m_inventory;
        }
        int ohIndex = this.m_currentSelectedComponent.getOHIndex();
        OiiiOracleHomeInfo oInfo = null;
        oInfo = installInventory.getHomeInfo(ohIndex);
        String compOracleHome = null;
        compOracleHome = oInfo != null ? oInfo.getName() : (compId.isNOHComp() ? OiixResourceBundle.getString("S_LANGADDON_DETAILS_NOH") : OiixResourceBundle.getString("S_NOT_AVAIL"));
        OiiiInstallCompInvEntry installCompInvEntry = installInventory.getInstallCompInvEntry(compId, oracleHomeIndex);
        String componentExternalNameAndVersion = installCompInvEntry.getFullDisplayName(true);
        Vector installedLanguages = installCompInvEntry.getLanguages();
        installedLanguagesArray = new String[installedLanguages.size()];
        for (int j = 0; j < installedLanguagesArray.length; ++j) {
            Locale installedLocale = (Locale)installedLanguages.elementAt(j);
            installedLanguagesArray[j] = OiixLanguage.getDisplayName(installedLocale);
        }
        Date installDateAndTime = installCompInvEntry.getInstallTime();
        Vector referencerList = installCompInvEntry.getReferencers();
        referencerArray = new String[referencerList.size()];
        for (int k = 0; k < referencerList.size(); ++k) {
            OiiiCompIdOhPair referencerIdOhPair = (OiiiCompIdOhPair)referencerList.elementAt(k);
            OiiiCompInstallID referencerCompId = referencerIdOhPair.getCompID();
            OiiiInstallCompInvEntry referencerInstallCompInvEntry = installInventory.getInstallCompInvEntry(referencerCompId, oracleHomeIndex);
            referencerArray[k] = referencerInstallCompInvEntry.getName();
        }
        int numVals = 4 + installedLanguagesArray.length + referencerArray.length;
        String[][] attrValPairs = new String[numVals][2];
        attrValPairs[0][0] = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFP1003");
        attrValPairs[0][1] = componentInternalName;
        attrValPairs[1][0] = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFP1004");
        attrValPairs[1][1] = componentExternalNameAndVersion;
        attrValPairs[2][0] = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFP1006");
        attrValPairs[2][1] = DateFormat.getDateTimeInstance(0, 0, OiixLanguage.getDefaultLocale()).format(installDateAndTime);
        attrValPairs[3][0] = OiixResourceBundle.getString("S_OH_NAME");
        attrValPairs[3][1] = compOracleHome;
        int numLangs = installedLanguagesArray.length;
        for (int i = 0; i < numLangs; ++i) {
            if (i == 0) {
                attrValPairs[4][0] = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFP1005");
                if (numLangs > 1) {
                    attrValPairs[4][1] = "1. " + installedLanguagesArray[0];
                    continue;
                }
                attrValPairs[4][1] = installedLanguagesArray[0];
                continue;
            }
            attrValPairs[4 + i][0] = EMPTY_STRING;
            attrValPairs[4 + i][1] = i + 1 + ". " + installedLanguagesArray[i];
        }
        int numRefs = referencerArray.length;
        for (int i = 0; i < referencerArray.length; ++i) {
            if (i == 0) {
                attrValPairs[4 + numLangs][0] = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFP1007");
                if (numRefs > 1) {
                    attrValPairs[4 + numLangs][1] = "1. " + referencerArray[0];
                    continue;
                }
                attrValPairs[4 + numLangs][1] = referencerArray[0];
                continue;
            }
            attrValPairs[4 + numLangs + i][0] = EMPTY_STRING;
            attrValPairs[4 + numLangs + i][1] = i + 1 + ". " + referencerArray[i];
        }
        OiifjDetailsDlg detailsDlg = new OiifjDetailsDlg(this.m_Frame, attrValPairs);
        detailsDlg.show();
    }

    private void deinstall(Vector delComps, Vector delOneoffs, List delHomes, OiicSessionPlan sessionPlan, OiicDeinstallSession delSession) throws OiifbEndIterateException {
        OiicInstallSession instSession;
        if (this.m_bDeinstallSession && !this.m_bShowProgress && null != this.m_delSession) {
            if (null == this.m_removeDlg) {
                this.m_removeDlg = new OiifjRemoveDlg(this.m_Frame);
                this.m_removeDlg.setVisible(false);
            }
            this.m_delSession.setRemoveDialog(this.m_removeDlg);
            ((OiicDeinstallSession)this.m_delSession).silentDeinstall(delComps, delOneoffs, this.m_inventory, this.invAreaControl);
            ((OiicDeinstallSession)this.m_delSession).clearDeinstallList();
            this.refreshTree();
            this.setInfo(new OiifmInfo());
            this.addToDeinstallList(delComps);
            this.m_remove.setEnabled(false);
            return;
        }
        boolean bLockGrabbed = false;
        OiicSessionWrapper sessions = OiicInstaller.getSessionWrapper();
        if (sessions.getCurSession() instanceof OiicInstallSession && (instSession = (OiicInstallSession)sessions.getCurSession()).isLockGrabbed()) {
            bLockGrabbed = true;
        }
        if (!bLockGrabbed && !(bLockGrabbed = delSession.grabWriterLock(this.invAreaControl))) {
            this.m_remove.setEnabled(true);
            return;
        }
        Vector vErrorComps = new Vector(5, 5);
        StringBuffer errMsg = new StringBuffer(EMPTY_STRING);
        if (!delSession.prepareForDeinstall(this.m_inventory, delComps, delOneoffs, delHomes, sessionPlan, vErrorComps, errMsg)) {
            String sMsg = errMsg.toString();
            OiifmDetailsAlert.displayError(this.m_Frame, OiixResourceBundle.getString("S_ERROR"), sMsg, vErrorComps);
            if (bLockGrabbed) {
                this.invAreaControl.releaseWriterLock();
            }
            this.m_remove.setEnabled(true);
            return;
        }
        if (null == this.m_removeDlg) {
            this.m_removeDlg = new OiifjRemoveDlg(this.m_Frame);
            this.m_removeDlg.setVisible(false);
        }
        this.m_removeDlg.setTotalBytes(delComps.size());
        OiicSessionInterfaceManager interfaceManager = OiicSessionInterfaceManager.getInterfaceManager();
        interfaceManager.setProgressListener(this.m_removeDlg.getProgressActionListener());
        delSession.startInstall();
        this.m_removeDlg.doModal();
        if (this.m_bDeinstallSession) {
            delSession.clearDeinstallList();
        }
        this.refreshTree();
        this.setInfo(new OiifmInfo());
        this.addToDeinstallList(delComps);
        this.m_remove.setEnabled(false);
        if (bLockGrabbed) {
            this.invAreaControl.releaseWriterLock();
        }
    }

    public void setShowConfirmation(boolean bShowConfirmation) {
        this.m_bShowConfirmation = bShowConfirmation;
    }

    public void setShowProgress(boolean bShowProgress) {
        this.m_bShowProgress = bShowProgress;
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.m_remove) {
            OiifmCursorUtil.setCursor(3, (Component)((Object)this));
            this.m_invTree.setEnabled(false);
            this.m_remove.setEnabled(false);
            this.onRemove();
            this.m_invTree.setEnabled(true);
            OiifmCursorUtil.setCursor(0, (Component)((Object)this));
        }
        if (source == this.m_details) {
            this.onDetails();
        }
        if (source instanceof Component && ((Component)source).isFocusTraversable()) {
            ((Component)source).requestFocus();
        }
    }

    public void saveAs(PrintWriter writer) throws IOException {
        boolean bRemovEnabled = this.m_remove.isEnabled();
        this.m_invTree.setEnabled(false);
        this.setRemoveEnabled(false);
        this.saveTreeToFile(writer);
        if (bRemovEnabled) {
            this.setRemoveEnabled(true);
        }
        this.m_invTree.setEnabled(true);
    }

    void helpClicked() {
    }

    private void saveTreeToFile(PrintWriter writer) throws IOException {
        this.addTLComps(true);
        InetAddress netAddress = InetAddress.getLocalHost();
        Object[] args = new Object[]{netAddress};
        String title = OiixResourceBundle.getString("S_LOG_INV_TITLE");
        title = MessageFormat.format(title, args);
        writer.println(title);
        writer.println(EMPTY_STRING);
        this.m_invTree.logTree(null, EMPTY_STRING, 0, writer);
        writer.flush();
    }

    public void addToDeinstallList(Vector v) {
        OiixVectorOps.unionInPlace(this.m_vRemoveCompIds, v);
    }

    public Vector getDeinstallComps() {
        return this.m_vRemoveCompIds;
    }

    public void prepareInvTree() {
        this.m_vRemoveCompIds = new Vector();
        this.refreshTree();
        this.m_centerPanel.invalidate();
    }

    public void disposeRemoveDlg() {
        if (null != this.m_removeDlg) {
            this.m_removeDlg.dispose();
            this.m_removeDlg = null;
        }
    }

    public Dimension getPreferredSize() {
        return this.m_prefSize;
    }

    public void setRemoveEnabled(boolean enabled) {
        if (this.m_remove != null && !this.m_viewOnly) {
            this.m_remove.setEnabled(enabled);
        }
    }

    public void setCompInfoDisplay(OiiiCompIdOhPair compInfo) {
        OiiiInstallInventory i;
        OiiiInstallCompInvEntry entry;
        OiifmInfo info = new OiifmInfo();
        if (compInfo != null && this.m_inventory instanceof OiiiInstallInventory && (entry = (i = (OiiiInstallInventory)this.m_inventory).getInstallCompInvEntry(compInfo.getCompID(), compInfo.getOHIndex())) != null) {
            info.loc = entry.getProdHomeLoc();
            info.desc = entry.getDescription();
        }
        this.setInfo(info);
    }

    public void setInfo(OiifmInfo info) {
        if (this.m_iPanel != null) {
            this.m_iPanel.setInfo(info);
            this.m_iPanel.validate();
        }
    }

    public void setTooltips(OiiiCompInvEntry entry, OiifmTreeItem item) {
        String description = entry.getDescription();
        if (description == null || 0 >= description.length()) {
            description = item.getLabel();
        }
        item.setToolTipText(description);
    }

    public void dispose() {
        this.removeAll();
        this.m_iPanel = null;
        this.m_invPanel = null;
        this.m_noprodsPanel = null;
        this.m_centerPanel = null;
        this.m_scrollbox.removeAll();
        this.m_scrollbox = null;
        this.m_invTree.dispose();
        this.m_invTree = null;
        this.m_vRemoveCompIds = null;
        this.m_prefSize = null;
    }

    public void setDelSession(OiicDelSession delSession) {
        this.m_delSession = delSession;
    }

    public OiicDelSession getDelSession() {
        if (null == this.m_removeDlg) {
            this.m_removeDlg = new OiifjRemoveDlg(this.m_Frame);
            this.m_removeDlg.setVisible(false);
        }
        if (null != this.m_delSession) {
            this.m_delSession.setRemoveDialog(this.m_removeDlg);
            return this.m_delSession;
        }
        OiicDelSession delSession = null;
        delSession = this.m_inventory instanceof OiiiStageInventory ? new OiicDestageSession(this.m_removeDlg) : new OiicDeinstallSession(this.m_removeDlg);
        return delSession;
    }

    private void addOneoffs(OiiiInstallCompInvEntry entry, OiifmTreeItem treeItem) {
        Vector vOneoffs = entry.getOneoffsVect();
        int iSize = vOneoffs.size();
        for (int i = 0; i < iSize; ++i) {
            OiiiInstallOneoffInvEntry ooEntry = (OiiiInstallOneoffInvEntry)vOneoffs.elementAt(i);
            OiifmTreeItem oti = new OiifmTreeItem(ooEntry.getDisplayString(), null, ooEntry.getOneoffIdOhPair());
            treeItem.addItem((DTreeItem)oti);
        }
    }

    private void addOneoffs(OiiiOracleHomeInfo oInfo, OiifmTreeItem treeItem) {
        Vector vOneoffs = ((OiiiInstallInventory)this.m_inventory).getAllOneoffInvEntries(oInfo);
        this.addOneoffs(vOneoffs, treeItem);
    }

    private void addOneoffs(Vector vOneoffs, OiifmTreeItem treeItem) {
        OiifmTreeItem oneoffParent = new OiifmTreeItem(OiixResourceBundle.getString("S_ONEOFF_LABEL"), null, null);
        int iSize = vOneoffs.size();
        if (iSize > 0) {
            for (int i = 0; i < iSize; ++i) {
                OiiiInstallOneoffInvEntry ooEntry = (OiiiInstallOneoffInvEntry)vOneoffs.elementAt(i);
                OiifmTreeItem oti = new OiifmTreeItem(ooEntry.getDisplayString(), null, ooEntry.getOneoffIdOhPair());
                oneoffParent.addItem((DTreeItem)oti);
            }
            treeItem.addItem((DTreeItem)oneoffParent);
        }
    }

    public OiiiInstallInventory getInventory() {
        return this.m_inventory instanceof OiiiInstallInventory ? (OiiiInstallInventory)this.m_inventory : null;
    }

    private void customDeinstallCheck(List rmList) {
        this.m_bCustomDeinstall = false;
        this.m_customDeinstallHomes = 0;
        Iterator iter = rmList.iterator();
        while (iter.hasNext()) {
            String customDeinstall;
            OiiiOracleHomeInfo homeInfo;
            OiifmTreeItem item = (OiifmTreeItem)((Object)iter.next());
            Object oID = item.getID();
            if (!(oID instanceof OiiiOracleHomeInfo) || (homeInfo = (OiiiOracleHomeInfo)oID) == null) continue;
            ++this.m_customDeinstallHomes;
            Properties homeProps = homeInfo.getHomeProperties();
            if (homeProps == null || (customDeinstall = homeProps.getProperty("oracle.install.customizedeinstall")) == null || !customDeinstall.equalsIgnoreCase("true")) continue;
            this.m_bCustomDeinstall = true;
            this.m_customDeinstallCommand = homeProps.getProperty("oracle.install.customdeinstallcommand");
            HashMap<String, String> oSearchReplaceMap = new HashMap<String, String>();
            String delimiter = "%";
            String key = delimiter + "ORACLE_HOME" + delimiter;
            String value = homeInfo.getLocation();
            oSearchReplaceMap.put(key, value);
            this.m_customDeinstallCommand = OiixInstantiateOps.processString(this.m_customDeinstallCommand, oSearchReplaceMap, delimiter);
            if (this.m_customDeinstallHomes <= 1) continue;
            break;
        }
    }
}

