/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifp;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.Vector;
import oracle.ewt.lwAWT.BufferedDialog;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.util.WindowUtils;
import oracle.sysman.oii.oiic.OiicInstallSession;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiif.oiifj.OiifjLangsDlg;
import oracle.sysman.oii.oiif.oiifm.OiifmInfo;
import oracle.sysman.oii.oiif.oiifm.OiifmSingleSelectPanel;
import oracle.sysman.oii.oiif.oiifp.OiifpWizPanel;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiStageCompInvEntry;
import oracle.sysman.oii.oiii.OiiiStageInventory;
import oracle.sysman.oii.oiis.OiisCompInstallation;
import oracle.sysman.oii.oiis.OiisDepInfo;
import oracle.sysman.oii.oiis.OiisDepMode;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiix.OiixLanguage;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifpDepModesPanel
extends OiifpWizPanel
implements ItemListener,
ActionListener {
    private static final int INSETS = 5;
    private String[] m_depModeIDs;
    private OiifmSingleSelectPanel m_modePanel;
    private LWContainer m_coverPanel;
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 256;
    private OiicInstallSession m_instSession;
    private int m_selPos = 0;
    private LWButton m_langsButton;
    private Vector m_depModes;

    public OiifpDepModesPanel() {
        super("");
    }

    public void createPanelElements() {
        this.m_instSession = (OiicInstallSession)this.m_wcde.getVarOwner().getSession();
        this.dlgPanel.setLayout((LayoutManager)new BorderLayout());
        this.init();
    }

    public void init() {
        this.setTitleLabel(OiixResourceBundle.getString("S_INSTALL_TYPE"));
        OiicSessionContext sessionContext = this.m_instSession.getSessionContext();
        OiisVariable oLangs = sessionContext.getVariable("SELECTED_LANGUAGES");
        if (!oLangs.getAdvice()) {
            String[] strList = (String[])oLangs.getValue();
            Vector vect = OiixLanguage.getLangsVector(strList);
            this.m_instSession.setSelectedLanguages(vect);
        }
        this.dlgPanel.removeAll();
        OiiiCompInstallID tlComp = this.m_instSession.getSelTopLevelCompID();
        OiiiStageCompInvEntry entry = this.getCompInvEntry(tlComp);
        OiisDepInfo tlDepInfo = entry.getDepInfo();
        if (tlDepInfo == null) {
            OiisCompInstallation oCompInstall = this.m_instSession.getCompInstall(tlComp);
            tlDepInfo = oCompInstall.getDepInfo();
        }
        this.m_depModes = tlDepInfo.getDeps().getDepModes();
        if (tlDepInfo.getDepMode("Custom") == null) {
            this.m_depModes.addElement(tlDepInfo.getCustomDepMode());
        }
        int numDepModes = this.m_depModes.size();
        this.m_depModeIDs = new String[numDepModes];
        OiifmInfo[] modeInfo = new OiifmInfo[numDepModes];
        for (int i = 0; i < numDepModes; ++i) {
            Object[] args;
            OiisDepMode mode = (OiisDepMode)this.m_depModes.elementAt(i);
            modeInfo[i] = new OiifmInfo();
            if (mode.getInternalName().equalsIgnoreCase("Custom")) {
                args = new Object[]{mode.getName(false)};
                modeInfo[i].depmode = OiixResourceBundle.getString("S_DEP_MODE_NAME_WITHOUT_SIZE", args);
                modeInfo[i].name = null;
            } else {
                args = new Object[]{mode.getName(false), this.getModeSize(mode.getInternalName())};
                modeInfo[i].depmode = OiixResourceBundle.getString("S_DEP_MODE_NAME_WITH_SIZE", args);
                modeInfo[i].name = null;
            }
            modeInfo[i].desc = mode.getDescription();
            this.m_depModeIDs[i] = mode.getInternalName();
        }
        String prompt = OiixResourceBundle.getString("S_INSTALL_TYPE_PROMPT");
        Object[] arr = new String[]{entry.getFullDisplayName()};
        prompt = MessageFormat.format(prompt, arr);
        this.m_modePanel = new OiifmSingleSelectPanel(prompt, modeInfo);
        this.m_modePanel.setInfoHelpID("OiifdInstallTypeInfoDlg");
        this.m_modePanel.setInfoTitleID("S_INSTALL_TYPE_INFO_LABEL");
        this.m_modePanel.addItemListener(this);
        this.m_modePanel.setSelection(0);
        this.m_coverPanel = new LWContainer();
        this.dlgPanel.add((Component)this.m_coverPanel, (Object)"Center");
        if (!oLangs.getAdvice()) {
            LWContainer bottomPanel = new LWContainer();
            bottomPanel.setLayout((LayoutManager)new BorderLayout());
            this.m_langsButton = new LWButton(OiixResourceBundle.getString("S_CHANGE_LANGUAGES_BUTTON"));
            this.m_langsButton.addActionListener((ActionListener)this);
            this.m_langsButton.setRightmost(true);
            this.m_langsButton.setLeftmost(true);
            bottomPanel.add((Component)this.m_langsButton, (Object)"East");
            this.dlgPanel.add((Component)bottomPanel, (Object)"South");
        }
        this.setSubTitleLabel((String)arr[0]);
        this.m_instSession.getWizardDialog().setViewOnly(true);
        this.validate();
    }

    private void updatePanel() {
        int numDepModes = this.m_depModes.size();
        OiifmInfo[] modeInfo = new OiifmInfo[numDepModes];
        for (int i = 0; i < numDepModes; ++i) {
            Object[] args;
            OiisDepMode mode = (OiisDepMode)this.m_depModes.elementAt(i);
            modeInfo[i] = new OiifmInfo();
            if (mode.getInternalName().equalsIgnoreCase("Custom")) {
                args = new Object[]{mode.getName()};
                modeInfo[i].depmode = OiixResourceBundle.getString("S_DEP_MODE_NAME_WITHOUT_SIZE", args);
                modeInfo[i].name = null;
                continue;
            }
            args = new Object[]{mode.getName(), this.getModeSize(mode.getInternalName())};
            modeInfo[i].depmode = OiixResourceBundle.getString("S_DEP_MODE_NAME_WITH_SIZE", args);
            modeInfo[i].name = null;
        }
        String index = this.getInstallType();
        this.m_modePanel.updateChoices(modeInfo);
        this.setInstallType(index);
        this.validate();
    }

    private int getDepModeIndex(String nMode) {
        int nIndex = 0;
        for (int i = 0; i < this.m_depModeIDs.length; ++i) {
            String oDepMode = this.m_depModeIDs[i];
            if (!oDepMode.equalsIgnoreCase(nMode)) continue;
            nIndex = i;
            break;
        }
        return nIndex;
    }

    private String getModeSize(String modeId) {
        OiiiCompInstallID id = this.m_instSession.getSelTopLevelCompID();
        OiiiStageCompInvEntry entry = this.getCompInvEntry(id);
        Long s = entry.getSize(new Integer(OiixPlatform.getCurrentPlatform()), modeId);
        return OiixPathOps.getDiskSpaceString(s, 1);
    }

    public void validate() {
        if (this.getParent() != null && this.m_coverPanel != null) {
            Dimension cDim = this.m_coverPanel.getSize();
            if (this.modePanelTooTall(cDim)) {
                this.m_modePanel.forceListDisplay();
                this.m_modePanel.setSelection(0);
            }
            this.dlgPanel.remove((Component)this.m_coverPanel);
            this.dlgPanel.add((Component)((Object)this.m_modePanel));
            this.m_coverPanel = null;
        }
        super.validate();
    }

    private boolean modePanelTooTall(Dimension maxDim) {
        BufferedDialog dummyDlg = new BufferedDialog(WindowUtils.parentFrame((Component)((Object)this)));
        dummyDlg.setLayout((LayoutManager)new BorderLayout());
        dummyDlg.add((Component)((Object)this.m_modePanel));
        dummyDlg.pack();
        Insets i = dummyDlg.getInsets();
        Dimension dDim = new Dimension(maxDim.width + i.left + i.right, maxDim.height + i.top + i.bottom);
        dummyDlg.setSize(dDim);
        dummyDlg.validate();
        Dimension pDim = this.m_modePanel.getPreferredSize();
        if (pDim.height > maxDim.height) {
            dummyDlg.remove((Component)((Object)this.m_modePanel));
            dummyDlg.dispose();
            return true;
        }
        return false;
    }

    public void setInstallType(String oDepMode) {
        if (oDepMode != null) {
            int nIndex = this.getDepModeIndex(oDepMode);
            this.m_modePanel.setSelection(nIndex);
        }
    }

    public void setTopLevelInstallType(String[] oDepModes) {
        if (oDepModes != null && oDepModes.length > 0) {
            this.setInstallType(oDepModes[0]);
        }
    }

    public String getInstallType() {
        int index = this.m_modePanel.getSelectionIndex();
        String modeID = index != -1 ? this.m_depModeIDs[index] : "Custom";
        this.m_selPos = index;
        return modeID;
    }

    public String[] getTopLevelInstallType() {
        String[] retIntArr = new String[]{this.getInstallType()};
        return retIntArr;
    }

    public void itemStateChanged(ItemEvent event) {
        Object source = event.getItem();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_langsButton) {
            OiifjLangsDlg dlg = new OiifjLangsDlg((Frame)((Object)this.m_instSession.getMainFrame()), this.m_instSession);
            dlg.doModal();
            OiicSessionContext sessionContext = this.m_instSession.getSessionContext();
            OiisVariable oSelLangs = sessionContext.getVariable("SELECTED_LANGUAGES");
            String[] strLang = (String[])oSelLangs.getValue();
            Vector vLangs = OiixLanguage.getLangsVector(strLang);
            this.m_instSession.setSelectedLanguages(vLangs);
            this.updatePanel();
        }
    }

    private OiiiStageCompInvEntry getCompInvEntry(OiiiCompInstallID cid) {
        OiiiStageInventory i = this.m_instSession.getSourceAccess().getStageInventory();
        OiiiStageCompInvEntry entry = i.getStageCompInvEntry(cid);
        return entry;
    }
}

