/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifp;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.PrintWriter;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import oracle.bali.ewt.text.WordWrapper;
import oracle.ewt.button.PushButton;
import oracle.ewt.dataSource.ArrayOneDDataSource;
import oracle.ewt.dataSource.OneDDataSource;
import oracle.ewt.dataSource.TwoDDataSource;
import oracle.ewt.grid.BooleanInputHandler;
import oracle.ewt.grid.Cell;
import oracle.ewt.grid.CellInputHandler;
import oracle.ewt.grid.CheckPainter;
import oracle.ewt.grid.Grid;
import oracle.ewt.grid.GridCellSelectListener;
import oracle.ewt.grid.GridEvent;
import oracle.ewt.grid.GridSelection;
import oracle.ewt.grid.NullInputHandler;
import oracle.ewt.grid.SingleRowSelection;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.scrolling.scrollBox.ScrollBox;
import oracle.ewt.table.SpreadTable;
import oracle.ewt.table.TableEvent;
import oracle.ewt.table.TableRowSelectListener;
import oracle.ewt.table.TableScrollBox;
import oracle.sysman.oii.oiif.oiifj.OiifjConstrainedMLLabel;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiif.oiifm.OiifmImage;
import oracle.sysman.oii.oiif.oiifp.OiifpHomeSelectorGridDataSource;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiip.oiipg.OiipgEnvironment;
import oracle.sysman.oii.oiip.osd.win32.OiipwWin32NativeCalls;
import oracle.sysman.oii.oiix.OiixEnvironmentOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixSpawnException;
import oracle.sysman.oii.oiix.OiixSpawner;

public class OiifpEnvironmentTabPanel
extends JPanel
implements ActionListener,
TableRowSelectListener,
GridCellSelectListener {
    private OiifpHomeSelectorGridDataSource m_HSDS;
    private SpreadTable m_oGrid;
    private PushButton m_btnUp;
    private PushButton m_btnDown;
    private PushButton m_apply;
    private int[] colSize = new int[]{40, 130, 182};
    private static final int SELECT = 0;
    private static final int HOMES = 1;
    private static final int PATH = 2;
    private static final boolean[] ENABLE_COLUMNS = new boolean[]{true, false};
    private SingleRowSelection m_oRowSelection;
    private CellInputHandler m_oSelectCellInputHandler;
    private static int SHIFT_UP = 0;
    private static int SHIFT_DOWN = 1;
    private JPanel m_detailPanel;
    private JTextArea m_txtPath;
    private TableScrollBox m_sScrollPanel;
    private OneDDataSource m_cds;
    private Dimension m_gridSize;
    private static final int WIDTH = 450;
    private static final int HEIGHT = 480;
    private static final String S_PATH = "PATH";
    private OiiiInstallInventory m_inventory;
    private boolean bUnixPlat = false;

    public OiifpEnvironmentTabPanel(OiiiInstallInventory inv) {
        this.m_inventory = inv;
        this.init();
        this.initControls();
    }

    private void initControls() {
        JPanel gridPanel = new JPanel();
        OiifpEnvironmentTabPanel oiifpEnvironmentTabPanel = this;
        String sInvLoc = oiifpEnvironmentTabPanel.m_HSDS.getCentralInv();
        String sCentInv = "";
        if (sInvLoc != null) {
            sCentInv = OiixResourceBundle.getString("S_CENTRAL_INV_LABEL", new String[]{sInvLoc});
        }
        if (this.m_HSDS.getRowCount() == 0 || sInvLoc == null) {
            this.removeAll();
            String sLabel = OiixResourceBundle.getString("S_NO_HOMES_LABEL");
            this.setLayout(new FlowLayout(0));
            OiifjConstrainedMLLabel mlb = new OiifjConstrainedMLLabel(WordWrapper.getTextWrapper(), sCentInv + sLabel);
            this.add((Component)((Object)mlb));
            return;
        }
        String prompt = sCentInv + OiixResourceBundle.getString("S_HOME_SELECTOR_GRID_LABEL");
        OiifjConstrainedMLLabel label = new OiifjConstrainedMLLabel(WordWrapper.getTextWrapper(), prompt);
        label.setPreferredAspectRatio(0.0f);
        JPanel topGrid = new JPanel();
        topGrid.setLayout(new BorderLayout());
        topGrid.add((Component)((Object)label), "North");
        gridPanel.setLayout(new BorderLayout());
        this.m_oGrid.setScrollByColumn(true);
        this.m_oGrid.setScrollByRow(true);
        gridPanel.add("Center", (Component)this.m_sScrollPanel);
        this.setLayout(new GridLayout(2, 1, 10, 0));
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        this.m_detailPanel = new JPanel();
        this.m_detailPanel.setLayout(gridbag);
        EmptyBorder tenPixelMargin = new EmptyBorder(10, 10, 0, 10);
        topGrid.setBorder(tenPixelMargin);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weighty = 1.0;
        constraints.weightx = 1.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.fill = 1;
        gridbag.setConstraints(gridPanel, constraints);
        this.m_detailPanel.add(gridPanel);
        JPanel btnUDPanel = new JPanel();
        btnUDPanel.setLayout(new GridLayout(2, 1, 5, 5));
        btnUDPanel.add((Component)this.m_btnUp);
        btnUDPanel.add((Component)this.m_btnDown);
        constraints.gridx = 1;
        constraints.weighty = 1.0;
        constraints.weightx = 0.05;
        constraints.gridwidth = 0;
        constraints.anchor = 13;
        constraints.fill = 0;
        gridbag.setConstraints(btnUDPanel, constraints);
        this.m_detailPanel.add(btnUDPanel);
        topGrid.add((Component)this.m_detailPanel, "Center");
        this.add(topGrid);
        JPanel btnPanel = new JPanel();
        btnPanel.setLayout(new FlowLayout(2, 0, 5));
        this.m_txtPath = new JTextArea(OiipwWin32NativeCalls.expandEnvironmentStrings(this.m_HSDS.getSystemPath(false)), 5, 56);
        this.m_txtPath.setEditable(false);
        this.m_txtPath.setFocusable(false);
        ScrollBox scrolldesc = new ScrollBox((Component)this.m_txtPath, 0, 1);
        JPanel txtPanel = new JPanel();
        LWLabel lblPath = new LWLabel(OiixResourceBundle.getString("S_ENV_PATH_LABEL"), 1);
        txtPanel.setLayout(new BorderLayout());
        txtPanel.add((Component)lblPath, "North");
        txtPanel.add((Component)scrolldesc, "Center");
        btnPanel.add((Component)this.m_apply);
        txtPanel.add((Component)btnPanel, "South");
        JPanel txtBtnPanel = new JPanel();
        txtBtnPanel.setBorder(tenPixelMargin);
        txtBtnPanel.setLayout(new BorderLayout());
        txtBtnPanel.add((Component)txtPanel, "Center");
        this.add(txtBtnPanel);
        this.setBtnStates();
    }

    public OiifpHomeSelectorGridDataSource getDataSource() {
        return this.m_HSDS;
    }

    public void saveAs(PrintWriter writer) {
        this.m_HSDS.saveAs(writer);
    }

    private void init() {
        if (this.m_cds == null) {
            this.m_cds = this.initColumnHeaderDataSource();
        }
        Image imageDown = null;
        boolean bImageLoaded = true;
        OiifmImage imgBundle = new OiifmImage(this, "Oiir");
        Image imageUp = imgBundle.getImage("6000");
        if (imageUp != null) {
            this.m_btnUp = new PushButton(imageUp);
        } else {
            bImageLoaded = false;
        }
        if (bImageLoaded) {
            imageDown = imgBundle.getImage("6001");
            if (imageDown != null) {
                this.m_btnDown = new PushButton(imageDown);
            } else {
                bImageLoaded = false;
            }
        }
        if (!bImageLoaded) {
            this.m_btnUp = new PushButton(imageUp);
            this.m_btnDown = new PushButton(imageDown);
        }
        this.m_apply = new PushButton(OiixResourceBundle.getString("S_APPLY_BTN"));
        this.m_apply.setSize(450, 480);
        this.m_HSDS = new OiifpHomeSelectorGridDataSource(this.m_inventory);
        this.m_oGrid = new SpreadTable((TwoDDataSource)this.m_HSDS, this.m_cds, null);
        this.m_oGrid.getGrid().setColumnPainter(0, CheckPainter.getPainter());
        SpreadTable cGrid = this.m_oGrid;
        this.m_sScrollPanel = new TableScrollBox((Component)cGrid, 0, 0);
        this.m_oGrid.setDefaultColumnWidth(100);
        this.m_oGrid.setHorizontalSeparatorsVisible(true);
        this.m_oGrid.setVerticalSeparatorsVisible(true);
        this.m_oGrid.setColumnWidth(0, this.colSize[0]);
        this.m_oGrid.setColumnWidth(1, this.colSize[1]);
        this.m_oGrid.setColumnWidth(2, this.colSize[2]);
        Grid grid = this.m_oGrid.getGrid();
        this.m_oRowSelection = new SingleRowSelection();
        this.m_oRowSelection.setParent(grid);
        grid.setGridSelection((GridSelection)this.m_oRowSelection);
        this.m_oSelectCellInputHandler = BooleanInputHandler.getCellInputHandler();
        grid.setColumnCellInputHandler(0, this.m_oSelectCellInputHandler);
        grid.setColumnCellInputHandler(1, NullInputHandler.getCellInputHandler());
        grid.setColumnCellInputHandler(2, NullInputHandler.getCellInputHandler());
        this.m_gridSize = this.m_oGrid.getSize();
        if (this.m_oGrid.getGrid().getRowCount() > 0) {
            Cell cell = this.m_oGrid.getGrid().getFocusCell();
            this.m_oRowSelection.setRowSelected(0, true);
        }
        this.setListeners();
        this.setBtnStates();
    }

    private void setListeners() {
        this.m_oGrid.addRowSelectListener((TableRowSelectListener)this);
        this.m_oGrid.setEnabled(true);
        this.m_btnUp.addActionListener((ActionListener)this);
        this.m_btnDown.addActionListener((ActionListener)this);
        this.m_apply.addActionListener((ActionListener)this);
    }

    private OneDDataSource initColumnHeaderDataSource() {
        Object[] items = new String[]{OiixResourceBundle.getString("S_SELECT"), OiixResourceBundle.getString("S_HOME"), OiixResourceBundle.getString("S_PATH")};
        return new ArrayOneDDataSource(items);
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.m_apply) {
            this.m_apply.setEnabled(false);
            this.setPath();
            this.executeScript();
            this.m_apply.setEnabled(true);
            return;
        }
        if (evt.getSource() == this.m_btnUp) {
            this.shiftHome(SHIFT_UP);
        }
        if (evt.getSource() == this.m_btnDown) {
            this.shiftHome(SHIFT_DOWN);
        }
        this.setBtnStates();
    }

    private void setBtnStates() {
        if (this.m_HSDS.getRowCount() == 0) {
            this.m_btnUp.setEnabled(false);
            this.m_btnDown.setEnabled(false);
            return;
        }
        int[] nSelItems = this.m_oRowSelection.getSelectedRows();
        if (nSelItems == null || this.m_oGrid.getGrid().getRowCount() == 1) {
            this.m_btnUp.setEnabled(false);
            this.m_btnDown.setEnabled(false);
        } else {
            this.m_btnUp.setEnabled(true);
            this.m_btnDown.setEnabled(true);
            if (nSelItems[0] == 0) {
                this.m_btnUp.setEnabled(false);
            } else if (nSelItems[0] == this.m_oGrid.getGrid().getRowCount() - 1) {
                this.m_btnDown.setEnabled(false);
            }
        }
    }

    private void executeScript() {
        File f;
        String sScriptLoc = this.m_HSDS.getScriptLoc();
        if (sScriptLoc != null && sScriptLoc.length() > 0 && (f = new File(sScriptLoc)).exists()) {
            try {
                String cwd = OiixEnvironmentOps.getCurrentWorkingDir();
                String sDir = f.getParent();
                OiixEnvironmentOps.changeDir(sDir);
                OiixSpawner spawner = new OiixSpawner();
                spawner.execute(sScriptLoc);
                OiixEnvironmentOps.changeDir(cwd);
            }
            catch (OiixSpawnException e) {
                Object[] args = new String[]{sScriptLoc};
                OiifmAlert.displayError(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-5000", args));
            }
        }
    }

    private void setPath() {
        String path = this.m_HSDS.getPathToSet();
        try {
            OiipgEnvironment.setSystemEnvironment(S_PATH, path);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        path = this.m_HSDS.getSystemPath(true);
        this.m_txtPath.removeAll();
        this.m_txtPath.setText(OiipwWin32NativeCalls.expandEnvironmentStrings(path));
    }

    public int getCurrentSelection() {
        if (this.m_oRowSelection != null && this.m_oRowSelection.getSelectedRows() != null) {
            return this.m_oRowSelection.getSelectedRows()[0];
        }
        return 0;
    }

    private void shiftHome(int direction) {
        int[] nSelItems = this.m_oRowSelection.getSelectedRows();
        if (nSelItems != null) {
            Cell cell = this.m_oGrid.getGrid().getFocusCell();
            Object data = null;
            if (cell.column == 0) {
                data = this.m_oSelectCellInputHandler.commitEdit(this.m_oGrid.getGrid(), cell.column, cell.row);
                this.m_HSDS.setData(cell.column, cell.row, data);
            }
            int iSelectedRow = nSelItems[0];
            if (direction == SHIFT_DOWN) {
                this.m_HSDS.moveRowDown(nSelItems[0]);
                this.m_oRowSelection.setRowSelected(nSelItems[0], false);
                iSelectedRow = nSelItems[0] + 1;
                this.m_oRowSelection.setRowSelected(nSelItems[0] + 1, true);
            } else {
                this.m_HSDS.moveRowUp(nSelItems[0]);
                this.m_oRowSelection.setRowSelected(nSelItems[0], false);
                iSelectedRow = nSelItems[0] - 1;
            }
            this.m_oRowSelection.setRowSelected(iSelectedRow, true);
            this.m_oGrid.getGrid().scrollRowIntoView(iSelectedRow);
        }
    }

    public void cellDeselected(GridEvent e) {
    }

    public void cellDeselecting(GridEvent e) {
    }

    public void cellSelected(GridEvent evt) {
        this.setBtnStates();
    }

    public void cellSelecting(GridEvent e) {
    }

    public void rowSelected(TableEvent evt) {
        this.setBtnStates();
    }

    public void rowSelecting(TableEvent evt) {
        this.setBtnStates();
    }

    public void rowDeselecting(TableEvent evt) {
        this.setBtnStates();
    }

    public void rowDeselected(TableEvent evt) {
        this.setBtnStates();
    }

    public void refresh() {
        this.m_HSDS.setHomes();
        if (this.m_HSDS.getRowCount() == 0) {
            this.initControls();
        } else {
            this.setBtnStates();
        }
    }

    public void dispose() {
        this.m_oGrid = null;
        this.removeAll();
        this.m_HSDS = null;
    }

    public static void main(String[] s) {
        Frame f = new Frame("Environment");
        OiifpEnvironmentTabPanel grid = new OiifpEnvironmentTabPanel(null);
        f.setBounds(0, 0, 450, 418);
        f.add(grid);
        f.show();
    }
}

