/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifp;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.ewt.dataSource.TwoDDataSource;
import oracle.ewt.dataSource.TwoDDataSourceEvent;
import oracle.ewt.dataSource.TwoDDataSourceListener;
import oracle.ewt.event.ListenerManager;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiil.OiilNativeException;
import oracle.sysman.oii.oiip.oiipg.OiipgEnvironment;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiip.oiipg.OiipgOracleHomes;
import oracle.sysman.oii.oiip.oiipg.OiipgPropertyLoader;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;

class OiifpHomeSelectorGridDataSource
implements TwoDDataSource {
    private ListenerManager _manager;
    private int _columns;
    private int _rows;
    private boolean _editable;
    private static final int SELECT = 0;
    private static final int HOMES = 1;
    private static final int PATH = 2;
    private String[] m_saHomes;
    private String[] m_saHomePath;
    private Boolean[] m_baSelect;
    private static int MAX_COLS = 3;
    private String m_sEnvPath = null;
    private static String PATH_SEP = System.getProperty("path.separator");
    private static String FILE_SEP = System.getProperty("file.separator");
    private static final String S_SELECTHOME_SCRIPT = "bin\\selecthome.bat";
    private static String S_LINE = null;
    private String m_sNewLine = "\r\n";
    private static String S_ORACLEHOME_COL_HEADER = "Oracle Home";
    private static String S_STATUS_COL_HEADER = "Status";
    private static String S_PATH = "PATH";
    private static String S_HOMESELECTOR_HEADING = "HOME SELECTION";
    private static String S_BIN_DIR = "bin";
    private OiiiInstallInventory m_inventory;

    public OiifpHomeSelectorGridDataSource(OiiiInstallInventory inv) {
        this.m_inventory = inv;
        this.setHomes();
    }

    String getSystemPath(boolean reload) {
        if (this.m_sEnvPath == null || reload) {
            this.m_sEnvPath = OiipgEnvironment.getSystemEnvironment(S_PATH);
        }
        return this.m_sEnvPath;
    }

    void setHomes() {
        Object[] aPath = null;
        Object[] aHomes = null;
        if (this.m_inventory != null) {
            Vector vHomeInfos = this.m_inventory.getHomes(0);
            int n = vHomeInfos.size();
            Vector<String> vPath = new Vector<String>(n);
            Vector<String> vHomes = new Vector<String>(n);
            for (int i = 0; i < n; ++i) {
                Vector vOneOffs;
                OiiiOracleHomeInfo oInfo = (OiiiOracleHomeInfo)vHomeInfos.elementAt(i);
                int nOhIndex = oInfo.getIndex();
                Vector vCompIds = this.m_inventory.getTopLevelComps(nOhIndex);
                if (vCompIds.size() == 0 && (vOneOffs = this.m_inventory.getAllOneoffInvEntries(oInfo)).size() == 0) continue;
                vPath.addElement(oInfo.getLocation());
                vHomes.addElement(oInfo.getName());
            }
            this._rows = vPath.size();
            aPath = new Object[this._rows];
            aHomes = new Object[this._rows];
            vPath.copyInto(aPath);
            vHomes.copyInto(aHomes);
        } else {
            try {
                aPath = OiipgOracleHomes.getAllOracleHomes();
                aHomes = OiipgOracleHomes.getAllOracleHomeNames();
                this._rows = aHomes.length;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this._columns = 3;
        this.m_saHomePath = new String[this._rows];
        this.m_saHomes = new String[this._rows];
        this.m_baSelect = new Boolean[this._rows];
        int[] order = new int[this._rows];
        int index = 0;
        StringTokenizer st = new StringTokenizer(this.getSystemPath(false), PATH_SEP);
        OiipgFileSystem fileSys = new OiipgFileSystem();
        while (st.hasMoreTokens()) {
            String sCurPath = st.nextToken();
            for (int i = 0; i < this._rows; ++i) {
                if (!fileSys.areLocsSame(aPath[i].toString() + FILE_SEP + S_BIN_DIR, sCurPath)) continue;
                boolean found = false;
                for (int j = 0; j < index; ++j) {
                    if (order[j] != i + 1) continue;
                    found = true;
                }
                if (found) continue;
                order[index] = i + 1;
                this.setData(0, index, new Boolean(true));
                this.setData(1, index, aHomes[i].toString());
                this.setData(2, index, aPath[i].toString());
                ++index;
            }
        }
        int index1 = index;
        for (int i = 0; i < this._rows; ++i) {
            boolean found = false;
            for (int j = 0; j < index; ++j) {
                if (order[j] != i + 1) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.setData(0, index1, new Boolean(false));
            this.setData(1, index1, aHomes[i].toString());
            this.setData(2, index1, aPath[i].toString());
            ++index1;
        }
    }

    public int getColumnCount() {
        return this._columns;
    }

    public int getRowCount() {
        return this._rows;
    }

    public Object getData(int columnIndex, int rowIndex) {
        Object retVal = null;
        switch (columnIndex) {
            case 0: {
                retVal = this.m_baSelect[rowIndex];
                break;
            }
            case 1: {
                retVal = this.m_saHomes[rowIndex].toString();
                break;
            }
            case 2: {
                retVal = this.m_saHomePath[rowIndex].toString();
            }
        }
        return retVal;
    }

    public void setData(int columnIndex, int rowIndex, Object data) {
        switch (columnIndex) {
            case 0: {
                if (!(data instanceof Boolean)) break;
                this.m_baSelect[rowIndex] = (Boolean)data;
                break;
            }
            case 1: {
                this.m_saHomes[rowIndex] = data.toString();
                break;
            }
            case 2: {
                this.m_saHomePath[rowIndex] = data.toString();
            }
        }
        this._invalidateCell(columnIndex, rowIndex);
    }

    public void addDataSourceListener(TwoDDataSourceListener listener) {
        if (this._manager == null) {
            this._manager = new ListenerManager();
        }
        this._manager.addListener((EventListener)listener);
    }

    public void removeDataSourceListener(TwoDDataSourceListener listener) {
        if (this._manager != null) {
            this._manager.removeListener((EventListener)listener);
        }
    }

    public void moveRowUp(int rowIndex) {
        try {
            this.swapRows(rowIndex - 1, rowIndex);
            if (this._manager != null) {
                this.sendTwoRowInvalidateEvent(rowIndex - 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void moveRowDown(int rowIndex) {
        try {
            this.swapRows(rowIndex, rowIndex + 1);
            if (this._manager != null) {
                this.sendTwoRowInvalidateEvent(rowIndex);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void swapRows(int row1, int row2) {
        for (int col = 0; col < MAX_COLS; ++col) {
            Object temp = this.getData(col, row1);
            this.setData(col, row1, this.getData(col, row2));
            this.setData(col, row2, temp);
        }
    }

    private void sendTwoRowInvalidateEvent(int startRow) {
        Enumeration e = this._manager.getListeners();
        if (e == null) {
            return;
        }
        TwoDDataSourceEvent event = new TwoDDataSourceEvent((Object)this, 2006, 0, this.getColumnCount(), startRow, 2);
        while (e.hasMoreElements()) {
            TwoDDataSourceListener listener = (TwoDDataSourceListener)e.nextElement();
            listener.invalidateRows(event);
        }
    }

    private void _invalidateCell(int column, int row) {
        Enumeration e;
        if (this._manager == null) {
            this._manager = new ListenerManager();
        }
        if ((e = this._manager.getListeners()) == null) {
            return;
        }
        TwoDDataSourceEvent event = new TwoDDataSourceEvent((Object)this, 2007, column, 1, row, 1);
        while (e.hasMoreElements()) {
            TwoDDataSourceListener listener = (TwoDDataSourceListener)e.nextElement();
            listener.invalidateCells(event);
        }
    }

    String getScriptLoc() {
        String sScriptLoc = "";
        for (int i = 0; i < this._rows; ++i) {
            if (!this.m_baSelect[i].equals(Boolean.TRUE)) continue;
            sScriptLoc = OiixPathOps.concatPath(this.m_saHomePath[i], S_SELECTHOME_SCRIPT);
            break;
        }
        return sScriptLoc;
    }

    String getPathToSet() {
        StringBuffer sNewPath = new StringBuffer();
        boolean bPrependPathSep = false;
        for (int i = 0; i < this._rows; ++i) {
            if (!this.m_baSelect[i].equals(Boolean.TRUE)) continue;
            if (bPrependPathSep) {
                sNewPath.append(PATH_SEP);
            } else {
                bPrependPathSep = true;
            }
            sNewPath.append(this.m_saHomePath[i] + FILE_SEP + S_BIN_DIR);
        }
        String[] allHomes = null;
        try {
            allHomes = OiipgOracleHomes.getAllOracleHomes();
        }
        catch (OiilNativeException e) {
            e.printStackTrace();
        }
        String[] asPathTkns = OiixFunctionOps.explodeString(this.getSystemPath(false), PATH_SEP);
        OiipgFileSystem fs = new OiipgFileSystem();
        for (int i = 0; i < asPathTkns.length; ++i) {
            boolean bRemoveFromPath = false;
            for (int j = 0; !bRemoveFromPath && j < allHomes.length; ++j) {
                if (!fs.areLocsSame(allHomes[j] + FILE_SEP + S_BIN_DIR, asPathTkns[i])) continue;
                bRemoveFromPath = true;
            }
            if (bRemoveFromPath) continue;
            if (bPrependPathSep) {
                sNewPath.append(PATH_SEP);
            } else {
                bPrependPathSep = true;
            }
            sNewPath.append(asPathTkns[i]);
        }
        return sNewPath.toString();
    }

    private String truncateFromPath(String path, String sHome) {
        String sHomePath = sHome + FILE_SEP + S_BIN_DIR + PATH_SEP;
        int index = -1;
        String retPath = path;
        while ((index = retPath.indexOf(sHomePath)) != -1) {
            retPath = path.substring(0, index);
            retPath = retPath + path.substring(index + sHomePath.length());
        }
        return retPath;
    }

    public void saveAs(PrintWriter writer) {
        StringBuffer sText = new StringBuffer();
        sText.append(this.getLine());
        sText.append(S_HOMESELECTOR_HEADING);
        sText.append(this.m_sNewLine);
        sText.append(this.getLine());
        sText.append(OiixResourceBundle.getString("S_CENTRAL_INV_LABEL", new String[]{OiifpHomeSelectorGridDataSource.getCentralInv()}));
        sText.append(this.m_sNewLine);
        sText.append(this.getLine());
        int homeWidth = this.getOracleHomeColumnWidth();
        sText.append(this.getStringToSize(S_ORACLEHOME_COL_HEADER, homeWidth));
        sText.append(S_STATUS_COL_HEADER);
        sText.append(this.m_sNewLine);
        sText.append(this.getLine());
        for (int i = 0; i < this._rows; ++i) {
            sText.append(this.getStringToSize(this.m_saHomes[i], homeWidth));
            sText.append(this.m_baSelect[i].equals(Boolean.TRUE) ? "Selected" : "Not Selected");
            sText.append(this.m_sNewLine);
        }
        sText.append(this.m_sNewLine);
        sText.append(this.getLine());
        sText.append(S_PATH + " = " + this.getSystemPath(true));
        sText.append(this.m_sNewLine);
        sText.append(this.getLine());
        writer.write(sText.toString());
    }

    String getStringToSize(String sHome, int width) {
        char[] cHome = new char[width];
        int homeNameLength = sHome.length();
        for (int i = 0; i < width; ++i) {
            cHome[i] = i < homeNameLength ? sHome.charAt(i) : (char)32;
        }
        return new String(cHome);
    }

    private int getOracleHomeColumnWidth() {
        int colWidth = S_ORACLEHOME_COL_HEADER.length() + 4;
        for (int i = 0; i < this._rows; ++i) {
            if (this.m_saHomes[i].length() + 4 <= colWidth) continue;
            colWidth = this.m_saHomes[i].length() + 4;
        }
        return colWidth;
    }

    private String getLine() {
        if (S_LINE == null) {
            StringBuffer line = new StringBuffer(80);
            for (int i = 0; i < 80; ++i) {
                line.append("-");
            }
            line.append(this.m_sNewLine);
            S_LINE = line.toString();
        }
        return S_LINE;
    }

    static String getCentralInv() {
        String sInvLoc = null;
        try {
            OiipgPropertyLoader pl = new OiipgPropertyLoader();
            sInvLoc = pl.getLocationFileLoc();
        }
        catch (IOException e) {
            sInvLoc = null;
        }
        return sInvLoc;
    }
}

