/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifp;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.sysman.oii.oiif.oiifp.OiifpComboBoxPanel;
import oracle.sysman.oii.oiif.oiifp.OiifpTextHintPanel;
import oracle.sysman.oii.oiif.oiifp.OiifpWizPanel;
import oracle.sysman.oii.oiif.oiifw.OiifwHostNameWCDE;
import oracle.sysman.oii.oiin.OiinNICInfo;
import oracle.sysman.oii.oiin.OiinNetOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifpHostNamePanel
extends OiifpWizPanel {
    private MultiLineLabel m_prompt;
    OiifpTextHintPanel m_textPanel;
    private OiifwHostNameWCDE m_hostWCDE;

    public OiifpHostNamePanel() {
        super(OiixResourceBundle.getString("S_HOSTNAME_TITLE"));
    }

    public void createPanelElements() {
        this.m_hostWCDE = (OiifwHostNameWCDE)this.getWizChainDlgElem();
        OiinNetOps oNetOps = OiinNetOps.getNetOps();
        boolean bMultiple = oNetOps.hasMultipleNICs();
        String sHostName = oNetOps.getHostName();
        String sHint = OiixResourceBundle.getString("S_HOSTNAME_HINT");
        String sPrompt = null;
        if (bMultiple) {
            sPrompt = OiixResourceBundle.getString(bMultiple ? "S_HOSTNAME_PANEL_MULTIPLE_HOST_PROMPT" : "S_HOSTNAME_PANEL_SINGLE_HOST_PROMPT");
        }
        this.m_prompt = new MultiLineLabel(WordWrapper.getTextWrapper(), sPrompt);
        this.mainPanel.add((Component)this.m_prompt, (Object)"North");
        this.dlgPanel.setLayout((LayoutManager)new GridLayout(3, 1));
        String sHostNameLabel = OiixResourceBundle.getString("S_HOSTNAME_PANEL_TEXT_LABEL");
        String sNICLabel = OiixResourceBundle.getString("S_HOSTNAME_NICINFO_LABEL");
        if (bMultiple) {
            this.dlgPanel.add((Component)this.getNICListPanel());
        }
        this.m_textPanel = new OiifpTextHintPanel(sHostName, OiixResourceBundle.getString("S_HOSTNAME_PANEL_TEXT_LABEL"), sHint, bMultiple);
        this.dlgPanel.add((Component)((Object)this.m_textPanel));
        this.dlgPanel.add((Component)new LWContainer());
        this.validate();
    }

    private LWContainer getNICListPanel() {
        OiinNetOps netOps = OiinNetOps.getNetOps();
        ArrayList al = netOps.getAllNICInfo();
        ArrayList<String> alElems = new ArrayList<String>(al.size());
        for (int i = 0; i < al.size(); ++i) {
            OiinNICInfo oInfo = (OiinNICInfo)al.get(i);
            alElems.add(oInfo.getDisplayName());
        }
        OiifpComboBoxPanel cbPanel = new OiifpComboBoxPanel(alElems, OiixResourceBundle.getString("S_HOSTNAME_NICINFO_LABEL"), false);
        return cbPanel;
    }

    public String getHostName() {
        return this.m_textPanel.getText();
    }

    public void setHostName(String sHostName) {
        this.m_textPanel.setText(sHostName);
    }

    public String getDisplayName() {
        String sTitle = OiixResourceBundle.getString("S_HOSTNAME_TITLE");
        return sTitle;
    }
}

