/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifp;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import oracle.ewt.button.PushButton;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.textWrapper.TextWrapper;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.ewt.util.WindowUtils;
import oracle.sysman.oii.oiic.OiicInstallSession;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiif.oiifb.OiifbStackLayout;
import oracle.sysman.oii.oiif.oiifj.OiifjDirectoryDlg;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiif.oiifm.OiifmCursorUtil;
import oracle.sysman.oii.oiif.oiifm.OiifmTitlePanel;
import oracle.sysman.oii.oiif.oiifp.OiifpComboBoxPanel;
import oracle.sysman.oii.oiif.oiifp.OiifpWizPanel;
import oracle.sysman.oii.oiif.oiifw.OiifwWizDialog;
import oracle.sysman.oii.oiii.OiiiInventoryException;
import oracle.sysman.oii.oiip.oiipg.OiipgBootstrap;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiix.OiixEnvironmentOps;
import oracle.sysman.oii.oiix.OiixLanguage;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifpInvLocationPanel
extends OiifpWizPanel
implements ActionListener {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 256;
    private static final int s_sComponentsLabelSize = 44;
    private OiifwWizDialog m_wd = null;
    private LWTextField m_textField = null;
    private PushButton m_browse = null;
    private LWLabel m_compLocLabel = null;
    private TextWrapper m_twrap = null;
    private Font m_font_plain = null;
    private OiifpComboBoxPanel m_cbPanel = null;
    private String m_layoutDesc = "Fill Left Top";
    private String m_strProdFileLoc = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_PROD_FILES_LOC");
    private boolean m_bIsUnix = false;
    private String m_sUserSpecifiedGroup = null;
    private static final int CONTENT_GAP = 3;

    public OiifpInvLocationPanel() {
        this("");
    }

    public OiifpInvLocationPanel(String defaultVal) {
        super("");
        this.m_font_plain = new Font(OiixResourceBundle.getFont(), OiixLanguage.getFontStyle(0), 12);
        this.m_twrap = WordWrapper.getTextWrapper();
        this.dlgPanel.setLayout((LayoutManager)new OiifbStackLayout(1));
        this.m_bIsUnix = new OiipgBootstrap().isUnixGroupNeeded();
        this.setTitleLabel(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", this.m_bIsUnix ? "S_SPECIFY_INVENTORY_LOC_AND_CREDENTIALS" : "S_SPECIFY_INVENTORY_LOC"));
        LWContainer invLocationPanel = this.createInventoryLocationPanel(defaultVal);
        this.dlgPanel.add(this.m_layoutDesc, (Component)invLocationPanel);
        if (this.m_bIsUnix) {
            LWContainer unixGroupPanel = this.createUnixGroupListPanel();
            this.dlgPanel.add(this.m_layoutDesc, (Component)unixGroupPanel);
        }
        this.validate();
    }

    public void setWizDialog(OiifwWizDialog wd) {
        this.m_wd = wd;
    }

    public String getUnixInstallGroup() {
        String v_strUnixGrpName = this.m_cbPanel.getSelectedItem();
        return v_strUnixGrpName != null ? v_strUnixGrpName.trim() : "";
    }

    public void setUnixInstallGroup(String sGrp) {
        this.m_sUserSpecifiedGroup = sGrp;
        this.m_cbPanel.setItems(this.getGroups());
        this.validate();
    }

    public String getInventoryLocation() {
        String v_strInvLocation = this.m_textField.getText();
        return null != v_strInvLocation ? v_strInvLocation.trim() : "";
    }

    public void setInventoryLocation(String p_strInvLocation) {
        this.m_textField.setText(p_strInvLocation != null ? p_strInvLocation.trim() : "");
    }

    private ArrayList getGroups() {
        String sActiveGrp;
        String v_strUser;
        String sCurGrp;
        OiicInstallSession oSession;
        OiisVariable oUnixGroup;
        String sUnixGroup;
        ArrayList<String> saGroup = new ArrayList<String>(4);
        if (this.m_sUserSpecifiedGroup != null && this.m_sUserSpecifiedGroup.length() > 0 && !saGroup.contains(this.m_sUserSpecifiedGroup)) {
            saGroup.add(this.m_sUserSpecifiedGroup);
        }
        if ((sUnixGroup = (String)(oUnixGroup = (oSession = (OiicInstallSession)OiicSessionInterfaceManager.getInterfaceManager().getSession()).getSessionContext().getVariable("UNIX_GROUP_NAME")).getValue()) != null && sUnixGroup.length() > 0) {
            saGroup.add(sUnixGroup);
        }
        if ((sCurGrp = OiixEnvironmentOps.ssgetCurrentGroupOfUserux(v_strUser = System.getProperty("user.name"))) != null && !sCurGrp.equals("ErrorException") && !saGroup.contains(sCurGrp)) {
            saGroup.add(sCurGrp);
        }
        if ((sActiveGrp = OiixEnvironmentOps.ssgetCurrentActiveUserGroupux(v_strUser)) != null && !sActiveGrp.equals("ErrorException") && !saGroup.contains(sActiveGrp)) {
            saGroup.add(sActiveGrp);
        }
        String[] sGroups = OiixEnvironmentOps.getUnixGroups();
        int nLength = sGroups.length;
        for (int i = 0; i < nLength; ++i) {
            if (saGroup.contains(sGroups[i])) continue;
            saGroup.add(sGroups[i]);
        }
        return saGroup;
    }

    public boolean validateInput() {
        String input = this.getInventoryLocation();
        boolean v_bRetVal = false;
        try {
            v_bRetVal = new OiipgBootstrap().validateInvLocForSetup(input);
        }
        catch (OiiiInventoryException e) {
            OiicSessionInterfaceManager.getInterfaceManager().showMessage(e.getMessage());
        }
        if (this.m_bIsUnix && v_bRetVal) {
            input = this.getUnixInstallGroup();
            v_bRetVal = this.validateUnixGroupNameForSetup(input);
        }
        return v_bRetVal;
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.m_browse) {
            this.onBrowse();
        }
    }

    private void onBrowse() {
        OiifmCursorUtil.setCursor(3, (Component)((Object)this));
        OiipgFileSystem pgFS = new OiipgFileSystem();
        OiifjDirectoryDlg dirDlg = new OiifjDirectoryDlg(WindowUtils.parentFrame((Component)((Object)this)), OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CHOOSE_DIR"));
        String defaultDir = this.getInventoryLocation();
        if (defaultDir.length() == 0) {
            defaultDir = File.separator;
        }
        File curDir = new File(defaultDir);
        OiifmCursorUtil.setCursor(0, (Component)((Object)this));
        File chosenDir = dirDlg.runDialog(curDir);
        if (chosenDir != null) {
            String dirStr = chosenDir.getAbsolutePath();
            this.m_textField.setText(dirStr);
        }
    }

    public void showAlert(String sMessage) {
        String sTitle = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_INVENTORY_LOC");
        OiifmAlert.displayError(sMessage, sTitle);
    }

    public boolean validateUnixGroupNameForSetup(String input) {
        return true;
    }

    private LWContainer createInventoryLocationPanel(String defaultVal) {
        LWContainer invLocationPanel = new LWContainer((LayoutManager)new BorderLayout(0, 0));
        String prompt = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_INV_LOC_INTRO") + " " + OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_PROD_FILES_SIZE");
        MultiLineLabel bodyLabel3 = new MultiLineLabel(this.m_twrap, prompt);
        bodyLabel3.setPreferredAspectRatio(0.0f);
        bodyLabel3.setFont(this.m_font_plain);
        LWContainer pPanel = new LWContainer((LayoutManager)new BorderLayout(0, 0));
        OiifmTitlePanel titlePanel = new OiifmTitlePanel((LWComponent)bodyLabel3, (LWComponent)pPanel);
        invLocationPanel.add((Component)((Object)titlePanel), (Object)"Center");
        prompt = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_INV_LOC_PROMPT");
        LWLabel invLocLabel = new LWLabel(prompt);
        pPanel.add((Component)invLocLabel, (Object)"North");
        LWContainer dPanel = new LWContainer();
        pPanel.add((Component)dPanel, (Object)"Center");
        GridBagLayout gridbag = new GridBagLayout();
        dPanel.setLayout((LayoutManager)gridbag);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(3, 0, 3, 3);
        c.anchor = 18;
        c.weightx = 0.99;
        c.weighty = 0.98;
        c.gridwidth = -1;
        c.fill = 2;
        this.m_textField = new LWTextField(defaultVal);
        gridbag.setConstraints((Component)this.m_textField, c);
        dPanel.add((Component)this.m_textField);
        invLocLabel.setLabelFor((Component)this.m_textField);
        c.weightx = 0.01;
        c.gridwidth = 0;
        String str = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_TO_BROWSE_BUTTON");
        this.m_browse = new PushButton(str);
        this.m_browse.setEnabled(true);
        this.m_browse.setFocusable(true);
        this.m_browse.addActionListener((ActionListener)this);
        this.m_browse.setRightmost(true);
        this.m_browse.setVisible(true);
        gridbag.setConstraints((Component)this.m_browse, c);
        dPanel.add((Component)this.m_browse);
        return invLocationPanel;
    }

    private LWContainer createUnixGroupListPanel() {
        LWContainer unixGroupPanel = new LWContainer((LayoutManager)new BorderLayout(0, 0));
        String prompt = "\n" + OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_UNIX_GROUP_PROMPT") + "\n";
        MultiLineLabel bodyLabel3 = new MultiLineLabel(this.m_twrap, prompt);
        bodyLabel3.setPreferredAspectRatio(0.0f);
        bodyLabel3.setFont(this.m_font_plain);
        LWContainer pPanel = new LWContainer((LayoutManager)new BorderLayout(0, 0));
        OiifmTitlePanel titlePanel = new OiifmTitlePanel((LWComponent)bodyLabel3, (LWComponent)pPanel);
        unixGroupPanel.add((Component)((Object)titlePanel), (Object)"Center");
        prompt = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_UNIX_GROUP_LABEL");
        LWLabel unixGrpLabel = new LWLabel(prompt);
        pPanel.add((Component)unixGrpLabel, (Object)"North");
        LWContainer dPanel = new LWContainer();
        pPanel.add((Component)dPanel, (Object)"Center");
        GridBagLayout gridbag = new GridBagLayout();
        dPanel.setLayout((LayoutManager)gridbag);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(3, 0, 3, 3);
        c.anchor = 18;
        c.weightx = 1.0;
        c.weighty = 0.98;
        c.gridwidth = -1;
        c.fill = 2;
        this.m_cbPanel = new OiifpComboBoxPanel(this.getGroups(), "", true, this.m_font_plain, null, 0, 310);
        gridbag.setConstraints((Component)((Object)this.m_cbPanel), c);
        dPanel.add((Component)((Object)this.m_cbPanel));
        unixGrpLabel.setLabelFor((Component)this.m_cbPanel.getComboBoxPanel());
        return unixGroupPanel;
    }

    public static void main(String[] args) {
        Frame f = new Frame();
        OiifpInvLocationPanel p = new OiifpInvLocationPanel("");
        f.add((Component)((Object)p));
        f.setSize(600, 600);
        f.setVisible(true);
    }
}

