/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifp;

import java.util.Enumeration;
import java.util.EventListener;
import java.util.Vector;
import oracle.ewt.dataSource.TwoDDataSource;
import oracle.ewt.dataSource.TwoDDataSourceEvent;
import oracle.ewt.dataSource.TwoDDataSourceListener;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.grid.ChoiceInputHandler;
import oracle.sysman.oii.oiic.OiicInstallSession;
import oracle.sysman.oii.oiif.oiifm.OiifmChoiceSelectListener;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiis.OiisCompInstallation;
import oracle.sysman.oii.oiis.OiisDepInfo;
import oracle.sysman.oii.oiis.OiisDepMode;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifpMultiDepModesDataSource
implements TwoDDataSource,
OiifmChoiceSelectListener {
    private ListenerManager m_manager;
    private int m_columns;
    private int m_rows;
    static final int COMPNAME = 0;
    static final int DEPMODES = 1;
    private OiicInstallSession m_instSession;
    private OiiiCompInstallID[] m_compIDs;
    private OiisDepInfo[] m_depInfos;
    private int[] m_numDepModes;
    private String[][] m_depModeIDs;
    private String[][] m_depModeNames;
    private String[] m_depModeIDSels;
    private int m_selRow;

    public OiifpMultiDepModesDataSource(OiicInstallSession instSession) {
        this.m_instSession = instSession;
        this.m_compIDs = this.m_instSession.getSelTopLevelCompIDs();
        this.m_rows = this.m_compIDs.length;
        System.out.println("In DataSource constructor : #comps : " + this.m_rows);
        this.m_columns = 2;
        this.m_depInfos = new OiisDepInfo[this.m_rows];
        this.m_depModeIDs = new String[this.m_rows][];
        this.m_depModeNames = new String[this.m_rows][];
        this.m_depModeIDSels = new String[this.m_rows];
        this.m_numDepModes = new int[this.m_rows];
        for (int i = 0; i < this.m_rows; ++i) {
            if (this.m_compIDs[i].getCompType() == 4) {
                this.m_numDepModes[i] = 0;
                this.m_depModeIDSels[i] = "Custom";
                this.m_depModeNames[i] = new String[1];
                this.m_depModeNames[i][0] = OiixResourceBundle.getString("S_INSTALL_TYPE_NA");
                continue;
            }
            OiisCompInstallation ci = this.m_instSession.getCompInstall(this.m_compIDs[i]);
            this.m_depInfos[i] = ci.getDepInfo();
            Vector depModes = this.m_depInfos[i].getDeps().getDepModes();
            this.m_depModeIDSels[i] = this.m_depInfos[i].getDepModeName();
            this.m_numDepModes[i] = depModes.size();
            this.m_depModeIDs[i] = new String[this.m_numDepModes[i]];
            this.m_depModeNames[i] = new String[this.m_numDepModes[i]];
            boolean foundDepID = false;
            for (int j = 0; j < this.m_numDepModes[i]; ++j) {
                OiisDepMode depMode = (OiisDepMode)depModes.elementAt(j);
                this.m_depModeIDs[i][j] = depMode.getInternalName();
                this.m_depModeNames[i][j] = depMode.getName();
                if (!this.m_depModeIDs[i][j].equalsIgnoreCase(this.m_depModeIDSels[i])) continue;
                foundDepID = true;
            }
            if (foundDepID) continue;
            this.m_depModeIDSels[i] = this.m_depModeIDs[i][0];
        }
        this.m_selRow = 0;
    }

    public void setTLDepModes(String[] nModes) {
        if (nModes == null) {
            return;
        }
        int numModes = Math.min(nModes.length, this.m_rows);
        block0: for (int i = 0; i < numModes; ++i) {
            if (nModes[i] == null) continue;
            String setMode = nModes[i];
            for (int j = 0; j < this.m_numDepModes[i]; ++j) {
                if (!this.m_depModeIDs[i][j].equalsIgnoreCase(setMode)) continue;
                this.m_depModeIDSels[i] = setMode;
                continue block0;
            }
        }
    }

    public String[] getTLDepModes() {
        return this.m_depModeIDSels;
    }

    public int getColumnCount() {
        return this.m_columns;
    }

    public int getRowCount() {
        return this.m_rows;
    }

    public Object getData(int columnIndex, int rowIndex) {
        if (columnIndex >= this.getColumnCount() || rowIndex >= this.getRowCount()) {
            throw new IllegalArgumentException();
        }
        String data = null;
        block0 : switch (columnIndex) {
            case 0: {
                data = this.m_instSession.getStgCompDisplayName(this.m_compIDs[rowIndex]);
                break;
            }
            case 1: {
                if (this.m_compIDs[rowIndex].getCompType() == 4) {
                    data = this.m_depModeNames[rowIndex][0];
                    break;
                }
                for (int j = 0; j < this.m_numDepModes[rowIndex]; ++j) {
                    if (!this.m_depModeIDs[rowIndex][j].equalsIgnoreCase(this.m_depModeIDSels[rowIndex])) continue;
                    data = this.m_depModeNames[rowIndex][j];
                    break block0;
                }
                break;
            }
        }
        return data;
    }

    public void selectionGained(ChoiceInputHandler oHandler, int rowIndex, int columnIndex) {
        if (columnIndex >= this.getColumnCount() || rowIndex >= this.getRowCount()) {
            throw new IllegalArgumentException();
        }
        if (columnIndex == 1) {
            oHandler.setItems(this.m_depModeNames[rowIndex]);
        }
        this.m_selRow = rowIndex;
    }

    public int getLastSelectedRow() {
        return this.m_selRow;
    }

    public void setData(int columnIndex, int rowIndex, Object data) {
        block0 : switch (columnIndex) {
            case 0: {
                break;
            }
            case 1: {
                if (this.m_compIDs[rowIndex].getCompType() == 4 || !(data instanceof String)) break;
                for (int j = 0; j < this.m_numDepModes[rowIndex]; ++j) {
                    if (!this.m_depModeNames[rowIndex][j].equals(data)) continue;
                    this.m_depModeIDSels[rowIndex] = this.m_depModeIDs[rowIndex][j];
                    break block0;
                }
                break;
            }
        }
        if (this.m_manager != null) {
            this.invalidateCell(columnIndex, rowIndex);
        }
    }

    public void addDataSourceListener(TwoDDataSourceListener listener) {
        if (this.m_manager == null) {
            this.m_manager = new ListenerManager();
        }
        this.m_manager.addListener((EventListener)listener);
    }

    public void removeDataSourceListener(TwoDDataSourceListener listener) {
        if (this.m_manager != null) {
            this.m_manager.removeListener((EventListener)listener);
        }
    }

    private void invalidateCell(int column, int row) {
        Enumeration e = this.m_manager.getListeners();
        if (e == null) {
            return;
        }
        TwoDDataSourceEvent event = new TwoDDataSourceEvent((Object)this, 2007, column, 1, row, 1);
        while (e.hasMoreElements()) {
            TwoDDataSourceListener listener = (TwoDDataSourceListener)e.nextElement();
            listener.invalidateCells(event);
        }
    }
}

