/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifp;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import oracle.ewt.dataSource.ArrayOneDDataSource;
import oracle.ewt.dataSource.OneDDataSource;
import oracle.ewt.dataSource.TwoDDataSource;
import oracle.ewt.grid.Cell;
import oracle.ewt.grid.CellInputHandler;
import oracle.ewt.grid.Grid;
import oracle.ewt.grid.NullInputHandler;
import oracle.ewt.grid.TextFieldInputHandler;
import oracle.ewt.lwAWT.LWChoice;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.table.SpreadTable;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.sysman.oii.oiic.OiicInstallSession;
import oracle.sysman.oii.oiif.oiifm.OiifmDynamicChoiceInputHandler;
import oracle.sysman.oii.oiif.oiifp.OiifpMultiDepModesDataSource;
import oracle.sysman.oii.oiif.oiifp.OiifpWizPanel;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiStageCompInvEntry;
import oracle.sysman.oii.oiii.OiiiStageInventory;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifpMultiDepModesPanel
extends OiifpWizPanel
implements ItemListener,
ActionListener,
FocusListener {
    private static final int INSETS = 5;
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 256;
    private OiicInstallSession m_instSession;
    private SpreadTable m_oGrid = null;
    private OiifpMultiDepModesDataSource m_dataSource;
    private OneDDataSource m_columnNames;
    private int COMPNAME = 0;
    private int DEPMODES = 1;
    private int[] colexpSize = new int[]{250, 120};
    private OiifmDynamicChoiceInputHandler m_choiceHandler;

    public OiifpMultiDepModesPanel(OiicInstallSession instSession) {
        super("");
        this.m_instSession = instSession;
        this.dlgPanel.setLayout((LayoutManager)new BorderLayout());
    }

    public void init() {
        this.setTitleLabel(OiixResourceBundle.getString("S_INSTALL_TYPE"));
        String prompt = OiixResourceBundle.getString("S_INSTALL_TYPES_PROMPT");
        MultiLineLabel m_promptLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), prompt);
        m_promptLabel.setPreferredAspectRatio(0.0f);
        this.dlgPanel.removeAll();
        if (this.m_oGrid != null) {
            this.remove((Component)this.m_oGrid);
        }
        this.removeFocusListener(this);
        this.m_columnNames = this.getColumnHeaderDataSource();
        this.m_dataSource = new OiifpMultiDepModesDataSource(this.m_instSession);
        this.m_oGrid = new SpreadTable((TwoDDataSource)this.m_dataSource, this.m_columnNames, null);
        this.m_oGrid.setDefaultColumnWidth(80);
        this.m_oGrid.addFocusListener((FocusListener)this);
        this.addFocusListener(this);
        this.m_oGrid.setHorizontalSeparatorsVisible(false);
        this.m_oGrid.setVerticalSeparatorsVisible(false);
        Grid grid = this.m_oGrid.getGrid();
        grid.addFocusListener((FocusListener)this);
        this.m_oGrid.setColumnWidth(this.COMPNAME, this.colexpSize[this.COMPNAME]);
        this.m_oGrid.setColumnWidth(this.DEPMODES, this.colexpSize[this.DEPMODES]);
        grid.setDefaultInputHandler(TextFieldInputHandler.getCellInputHandler());
        grid.setColumnCellInputHandler(this.COMPNAME, NullInputHandler.getCellInputHandler());
        this.m_choiceHandler = new OiifmDynamicChoiceInputHandler();
        this.m_choiceHandler.addSelectListener(this.m_dataSource);
        grid.setColumnCellInputHandler(this.DEPMODES, (CellInputHandler)this.m_choiceHandler);
        this.dlgPanel.add((Component)m_promptLabel, (Object)"North");
        this.dlgPanel.add((Component)this.m_oGrid, (Object)"Center");
        this.validate();
    }

    private OneDDataSource getColumnHeaderDataSource() {
        Object[] items = new String[]{OiixResourceBundle.getString("S_INSTALL_TYPES_COL_COMPNAME"), OiixResourceBundle.getString("S_INSTALL_TYPES_COL_DEPMODES")};
        return new ArrayOneDDataSource(items);
    }

    private String getModeSize(OiiiCompInstallID cid, String modeId) {
        OiiiStageInventory si = this.m_instSession.getSourceAccess().getStageInventory();
        OiiiStageCompInvEntry entry = si.getStageCompInvEntry(cid);
        Long s = entry.getSize(new Integer(OiixPlatform.getCurrentPlatform()), modeId);
        return OiixPathOps.getDiskSpaceString(s, 1);
    }

    public void validate() {
        if (this.getParent() != null) {
            // empty if block
        }
        super.validate();
    }

    public void setTLDepModes(String[] oDepModes) {
        if (oDepModes != null && this.m_dataSource != null) {
            this.m_dataSource.setTLDepModes(oDepModes);
        }
    }

    public String[] getTLDepModes() {
        if (this.m_dataSource != null) {
            return this.m_dataSource.getTLDepModes();
        }
        return null;
    }

    public int getLastSelectedRow() {
        int retVal = 0;
        if (this.m_dataSource != null) {
            retVal = this.m_dataSource.getLastSelectedRow();
        }
        return retVal;
    }

    public void itemStateChanged(ItemEvent event) {
        Object source = event.getItem();
    }

    public int[] getColumnsWidth() {
        Grid grid = this.m_oGrid.getGrid();
        for (int i = 0; i < this.colexpSize.length; ++i) {
        }
        return this.colexpSize;
    }

    public void refresh() {
        if (this.m_oGrid == null) {
            return;
        }
        this.getColumnsWidth();
        Cell cell = this.m_oGrid.getGrid().getFocusCell();
        if (this.m_choiceHandler == null || cell == null) {
            return;
        }
        LWChoice choice = (LWChoice)this.m_choiceHandler.getEditControl(this.m_oGrid.getGrid(), cell.column, cell.row);
        if (choice != null) {
            this.m_choiceHandler.commitEdit(this.m_oGrid.getGrid(), cell.column, cell.row);
            this.m_dataSource.setData(cell.column, cell.row, choice.getSelectedItem());
        }
    }

    public void actionPerformed(ActionEvent evt) {
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        if (e.getSource() == this.m_oGrid.getGrid()) {
            this.refresh();
        }
    }
}

