/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifp;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.ewt.button.ButtonBar;
import oracle.ewt.dataSource.ArrayOneDDataSource;
import oracle.ewt.dataSource.ArrayTwoDDataSource;
import oracle.ewt.dataSource.OneDDataSource;
import oracle.ewt.dataSource.TwoDDataSource;
import oracle.ewt.grid.GridEditListener;
import oracle.ewt.grid.GridEvent;
import oracle.ewt.header.Header;
import oracle.ewt.header.NullItemSelection;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWCheckboxGroup;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.table.TableScrollBox;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.sysman.oii.oiic.OiicClusterInstallInfo;
import oracle.sysman.oii.oiic.OiicClusterNode;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiif.oiifb.OiifbStackLayout;
import oracle.sysman.oii.oiif.oiifm.OiifmGraphicInterfaceManager;
import oracle.sysman.oii.oiif.oiifm.OiifmICellStateSelector;
import oracle.sysman.oii.oiif.oiifm.OiifmSelNodeGrid;
import oracle.sysman.oii.oiif.oiifm.OiifmSpreadTable;
import oracle.sysman.oii.oiif.oiifp.OiifpWizPanel;
import oracle.sysman.oii.oiif.oiifw.OiifwNodeSelWCDE;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixLanguage;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixUtilityOps;
import oracle.sysman.oii.oiix.OiixVectorOps;

public final class OiifpNodeSelPanel
extends OiifpWizPanel
implements ItemListener,
ActionListener,
GridEditListener,
OiifmICellStateSelector {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 256;
    private String[] m_selectedNodes = null;
    private String[] m_nodeList = null;
    MultiLineLabel m_lblStandAloneInstall = null;
    MultiLineLabel m_lblClusterInstall = null;
    private String[] m_asRemoteNodes = null;
    private String m_sLocalNode = null;
    private Map m_oReadOnlyNodes = new HashMap();
    private Map m_oInvalidNodes = new HashMap();
    private boolean m_bAllowRemoteNodesSelection = true;
    private boolean m_bNewHome = true;
    private boolean m_bShowCRSSoftwareVersion = false;
    private final int HGAP = 10;
    private final int VGAP = 5;
    private ArrayTwoDDataSource m_dataSource = null;
    private ArrayOneDDataSource m_headerSource = null;
    private LWButton m_btnDeselectAll = null;
    private LWButton m_btnSelectAll = null;
    private LWButton m_statusCheck = null;
    public LWCheckboxGroup m_installMode = null;
    private LWCheckbox m_cbxClusterInstall = null;
    private LWCheckbox m_cbxStandaloneInstall = null;
    private OiifmSpreadTable m_tblNodeList = null;
    private boolean m_bStandAlone = false;
    private boolean m_bShowStatus = false;
    private int m_iNumGridColumns = -1;
    private Map m_selectedNodesHashtable = new HashMap();

    public OiifpNodeSelPanel() {
        super(OiixResourceBundle.getString("S_NODE_SELECTION_TITLE"));
        this.setSubTitleLabel(OiixResourceBundle.getString("S_CLUSTER_MODE_SELECTION"));
    }

    public void setNewHome(Boolean oNewHome) {
        this.m_bNewHome = oNewHome;
        this.m_cbxClusterInstall.setEnabled(this.m_bNewHome);
        this.m_cbxStandaloneInstall.setEnabled(this.m_bNewHome);
    }

    public void setAllowRemoteNodeSelection(Boolean oAllowRemoteNodeSelection) {
        this.m_bAllowRemoteNodesSelection = oAllowRemoteNodeSelection;
        this.itemStateChangedPvt();
    }

    public void setSingleInstanceDescription(String sLabel) {
        this.m_lblStandAloneInstall.setText(sLabel);
    }

    public void setClusterInstallDescription(String sLabel) {
        this.m_lblClusterInstall.setText(sLabel);
    }

    public void setShowCRSSoftwareVersion(Boolean oShowCRSSoftwareVersion) {
        this.m_bShowCRSSoftwareVersion = oShowCRSSoftwareVersion;
    }

    public void setInvalidNodes(String[] asInvalidNodes) {
        if (asInvalidNodes != null) {
            for (int i = 0; i < asInvalidNodes.length; ++i) {
                this.m_oReadOnlyNodes.put(asInvalidNodes[i], asInvalidNodes[i]);
                this.m_oInvalidNodes.put(asInvalidNodes[i], asInvalidNodes[i]);
            }
            this.updateDataSources();
        }
    }

    private boolean isInvalidNode(String node) {
        return this.m_oInvalidNodes.get(node) != null;
    }

    private boolean isReadonlyNode(String node) {
        return this.m_oReadOnlyNodes.get(node) != null;
    }

    public void createPanelElements() {
        OiifwNodeSelWCDE nswcde = (OiifwNodeSelWCDE)this.m_wcde;
        this.m_nodeList = nswcde.getAllClusterNodes();
        this.m_bShowStatus = nswcde.showStatus();
        this.m_iNumGridColumns = this.m_bShowStatus ? 3 : 2;
        this.dlgPanel.setLayout((LayoutManager)new BorderLayout());
        this.m_installMode = new LWCheckboxGroup();
        this.m_cbxClusterInstall = new LWCheckbox(OiixResourceBundle.getString("S_CLUSTER_INSTALL"), true, this.m_installMode);
        this.m_cbxClusterInstall.addItemListener((ItemListener)this);
        Font font = new Font(OiixResourceBundle.getFont(), OiixLanguage.getFontStyle(0), 14);
        this.m_cbxClusterInstall.setFont(font);
        this.dlgPanel.add((Component)this.m_cbxClusterInstall, (Object)"North");
        this.dlgPanel.add((Component)this.createTablePanel(), (Object)"Center");
        this.dlgPanel.add((Component)this.createStandAlonePanel(), (Object)"South");
        OiifmGraphicInterfaceManager ogim = (OiifmGraphicInterfaceManager)OiicSessionInterfaceManager.getInterfaceManager();
        ogim.getWizardDialog().setViewOnly(true);
        this.validate();
    }

    private void itemStateChangedPvt() {
        this.m_tblNodeList.getGrid().setEnabled(this.isRemoteNodeSelectionAllowed());
        this.updateSelectionBtns();
    }

    private boolean isRemoteNodeSelectionAllowed() {
        return !this.m_bStandAlone && this.m_bAllowRemoteNodesSelection;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void itemStateChanged(ItemEvent event) {
        Object source = event.getSource();
        if (source == this.m_cbxStandaloneInstall) {
            if (!this.m_cbxStandaloneInstall.getState()) return;
            this.m_bStandAlone = true;
        } else if (source == this.m_cbxClusterInstall) {
            if (!this.m_cbxClusterInstall.getState()) return;
            this.m_bStandAlone = false;
        }
        this.itemStateChangedPvt();
    }

    private void updateDataSources() {
        int iDataSourceSize = null != this.m_dataSource ? this.m_dataSource.getRowCount() : 0;
        for (int i = 0; i < iDataSourceSize; ++i) {
            String sNodeName = (String)this.m_dataSource.getData(1, i);
            if (this.isNodeSelected(sNodeName)) {
                if (this.isInvalidNode(sNodeName)) {
                    this.m_dataSource.setData(0, i, (Object)OiixUtilityOps.booleanValueOf(false));
                    this.m_selectedNodesHashtable.remove(sNodeName);
                } else {
                    this.m_dataSource.setData(0, i, (Object)OiixUtilityOps.booleanValueOf(true));
                    this.m_selectedNodesHashtable.put(sNodeName, sNodeName);
                }
            }
            if (!this.m_bShowStatus && !this.m_bShowCRSSoftwareVersion) continue;
            this.m_dataSource.setData(2, i, (Object)this.getNodeStatus(this.m_nodeList[i]));
        }
        if (iDataSourceSize > 0) {
            this.m_tblNodeList.setDataSources((TwoDDataSource)this.m_dataSource, (OneDDataSource)this.m_headerSource, null);
        }
        this.itemStateChangedPvt();
    }

    public void setLocalNode(String sLocalNode) {
        this.m_sLocalNode = sLocalNode;
        this.m_oReadOnlyNodes.put(sLocalNode, sLocalNode);
        this.m_selectedNodesHashtable.put(sLocalNode, sLocalNode);
        this.updateDataSources();
    }

    public String getLocalNode() {
        return this.m_sLocalNode;
    }

    public void setRemoteNodes(String[] nodes) {
        this.m_asRemoteNodes = nodes;
        if (nodes != null && nodes.length > 0) {
            for (int i = 0; i < nodes.length; ++i) {
                if (null == nodes[i] || nodes[i].trim().length() <= 0) continue;
                this.m_selectedNodesHashtable.put(nodes[i], nodes[i]);
            }
            this.updateDataSources();
        }
    }

    public String[] getRemoteNodes() {
        if (this.m_bStandAlone) {
            return new String[0];
        }
        ArrayList<String> indices = new ArrayList<String>();
        for (int i = 0; i < this.m_nodeList.length; ++i) {
            if (!this.isNodeSelected(this.m_nodeList[i]) || this.m_nodeList[i].equals(this.m_sLocalNode)) continue;
            indices.add(this.m_nodeList[i]);
        }
        return OiixVectorOps.list2StrArr(indices);
    }

    public void setClusterNodes(String[] nodes) {
        int v_iNodeListSize;
        this.m_selectedNodes = nodes;
        int n = v_iNodeListSize = null != nodes ? nodes.length : 0;
        if (0 >= v_iNodeListSize) {
            this.m_bStandAlone = true;
            this.m_cbxClusterInstall.setState(!this.m_bStandAlone);
            this.m_cbxStandaloneInstall.setState(this.m_bStandAlone);
        } else {
            this.m_bStandAlone = false;
            this.m_cbxClusterInstall.setState(!this.m_bStandAlone);
            this.m_cbxStandaloneInstall.setState(this.m_bStandAlone);
        }
        this.itemStateChangedPvt();
    }

    public String[] getClusterNodes() {
        if (this.m_bStandAlone) {
            return new String[0];
        }
        if (this.m_bNewHome) {
            ArrayList<String> indices = new ArrayList<String>();
            for (int i = 0; i < this.m_nodeList.length; ++i) {
                if (!this.isNodeSelected(this.m_nodeList[i])) continue;
                indices.add(this.m_nodeList[i]);
            }
            return OiixVectorOps.list2StrArr(indices);
        }
        return this.m_selectedNodes;
    }

    private LWContainer createTablePanel() {
        LWContainer panel = new LWContainer();
        Font smallfont = new Font(OiixResourceBundle.getFont(), 0, 12);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 15, 0, 0);
        c.fill = 1;
        c.gridwidth = 0;
        c.weightx = 0.0;
        c.weighty = 0.5;
        String prompt = OiixResourceBundle.getString("S_NODE_SEL_DESC");
        this.m_lblClusterInstall = new MultiLineLabel(WordWrapper.getTextWrapper(), prompt);
        this.m_lblClusterInstall.setFont(smallfont);
        this.m_lblClusterInstall.setPreferredAspectRatio(0.0f);
        gridbag.setConstraints((Component)this.m_lblClusterInstall, c);
        panel.add((Component)this.m_lblClusterInstall);
        this.createDataSources();
        this.m_tblNodeList = OiifmSpreadTable.createSpreadTable((TwoDDataSource)this.m_dataSource, (OneDDataSource)this.m_headerSource, null, 2);
        this.m_tblNodeList.setColumnWidth(0, 20);
        this.m_tblNodeList.setColumnWidth(1, this.m_bShowStatus ? 220 : 559);
        if (this.m_bShowStatus) {
            this.m_tblNodeList.setColumnWidth(2, 339);
        }
        OiifmSelNodeGrid grid = (OiifmSelNodeGrid)this.m_tblNodeList.getGrid();
        grid.setCellStateSelector(this);
        grid.addEditListener(this);
        for (int i = 0; i < this.m_nodeList.length; ++i) {
            grid.setRowHeight(i, 20);
        }
        Header header = this.m_tblNodeList.getColumnHeader();
        header.setHeaderSelection(NullItemSelection.getHeaderSelection());
        header.setCanResizeItems(false);
        this.m_btnSelectAll = new LWButton(OiixResourceBundle.getString("S_SELECT_ALL"));
        this.m_btnSelectAll.setRightmost(true);
        this.m_btnSelectAll.setLeftmost(true);
        this.m_btnSelectAll.addActionListener((ActionListener)this);
        this.m_btnDeselectAll = new LWButton(OiixResourceBundle.getString("S_DESELECT_ALL"));
        this.m_btnDeselectAll.setLeftmost(true);
        this.m_btnDeselectAll.setRightmost(true);
        this.m_btnDeselectAll.addActionListener((ActionListener)this);
        ButtonBar bBar = new ButtonBar();
        bBar.add((Component)this.m_btnSelectAll);
        bBar.add((Component)this.m_btnDeselectAll);
        LWContainer tmpPanel = new LWContainer((LayoutManager)new OiifbStackLayout(1));
        TableScrollBox tableScroll = new TableScrollBox((Component)((Object)this.m_tblNodeList), 0, 0);
        tmpPanel.add("Top Left Wide Tall", (Component)tableScroll);
        tmpPanel.add("Top Right", (Component)bBar);
        c.weightx = 1.0;
        c.weighty = 1.0;
        gridbag.setConstraints((Component)tmpPanel, c);
        panel.add((Component)tmpPanel, (Object)"Center");
        this.updateSelectionBtns();
        panel.setLayout((LayoutManager)gridbag);
        return panel;
    }

    private LWContainer createStandAlonePanel() {
        LWContainer panel = new LWContainer();
        Font largefont = new Font(OiixResourceBundle.getFont(), 0, 14);
        Font smallfont = new Font(OiixResourceBundle.getFont(), 0, 12);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 1;
        c.gridwidth = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.m_cbxStandaloneInstall = new LWCheckbox(OiixResourceBundle.getString("S_NON_CLUSTER_INSTALL"), false, this.m_installMode);
        this.m_cbxStandaloneInstall.setFont(largefont);
        this.m_cbxStandaloneInstall.addItemListener((ItemListener)this);
        gridbag.setConstraints((Component)this.m_cbxStandaloneInstall, c);
        c.insets = new Insets(0, 15, 0, 0);
        c.weightx = 1.0;
        c.weighty = 1.0;
        String nonClusterPrompt = OiixResourceBundle.getString("S_NON_CLUSTER_DESC");
        this.m_lblStandAloneInstall = new MultiLineLabel(WordWrapper.getTextWrapper(), nonClusterPrompt);
        gridbag.setConstraints((Component)this.m_lblStandAloneInstall, c);
        panel.add((Component)this.m_cbxStandaloneInstall, (Object)"North");
        panel.add((Component)this.m_lblStandAloneInstall, (Object)"Center");
        panel.setLayout((LayoutManager)gridbag);
        return panel;
    }

    private void createDataSources() {
        Object[] headerItems = new String[this.m_iNumGridColumns];
        headerItems[0] = null;
        headerItems[1] = OiixResourceBundle.getString("S_ADDITIONAL_NODE_NAMES");
        if (this.m_bShowStatus) {
            headerItems[2] = OiixResourceBundle.getString("S_STATUS");
        }
        this.m_headerSource = new ArrayOneDDataSource(headerItems);
        this.m_dataSource = new ArrayTwoDDataSource(this.m_iNumGridColumns, this.m_nodeList.length);
        OiicClusterInstallInfo clusterInfo = OiicClusterInstallInfo.getClusterInstallInfo();
        for (int i = 0; i < this.m_nodeList.length; ++i) {
            OiicClusterNode cNode = clusterInfo.getClusterNode(this.m_nodeList[i]);
            boolean bLocalNode = cNode.isLocalNode();
            this.m_dataSource.setData(0, i, (Object)OiixUtilityOps.booleanValueOf(bLocalNode));
            this.m_dataSource.setData(1, i, (Object)this.m_nodeList[i]);
            if (bLocalNode) {
                this.m_selectedNodesHashtable.put(this.m_nodeList[i], this.m_nodeList[i]);
            }
            if (!this.m_bShowStatus) continue;
            this.m_dataSource.setData(2, i, (Object)this.getNodeStatus(this.m_nodeList[i]));
        }
    }

    private String getNodeStatus(String sNode) {
        OiicClusterInstallInfo clusterInfo = OiicClusterInstallInfo.getClusterInstallInfo();
        OiicClusterNode oNode = clusterInfo.getClusterNode(sNode);
        String availStatusStr = "";
        if (oNode != null) {
            if (this.m_bShowCRSSoftwareVersion && (availStatusStr = oNode.getVersion()) == null) {
                availStatusStr = "";
            }
            List availStatus = oNode.getAvailabilityErrorList();
            if (availStatusStr.length() > 0) {
                availStatusStr = availStatusStr + ", ";
            }
            if (null != availStatus && 0 < availStatus.size()) {
                String[] availStatusArr = OiixVectorOps.list2StrArr(availStatus);
                availStatusStr = availStatusStr + OiixFunctionOps.implodeList(availStatusArr, ",");
            } else {
                availStatusStr = availStatusStr + oNode.getAvailabilityStatusStr();
            }
        }
        return availStatusStr;
    }

    private final boolean isNodeSelected(String p_strNodeName) {
        boolean v_bSelected = false;
        if (null != p_strNodeName && null != this.m_selectedNodesHashtable && null != this.m_selectedNodesHashtable.get(p_strNodeName)) {
            v_bSelected = true;
        }
        return v_bSelected;
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        int rowCount = this.m_dataSource.getRowCount();
        OiifmSelNodeGrid grid = (OiifmSelNodeGrid)this.m_tblNodeList.getGrid();
        for (int i = 0; i < rowCount; ++i) {
            String v_strNodeName = (String)this.m_dataSource.getData(1, i);
            if (!grid.isCellEnabled(0, i)) continue;
            if (source == this.m_btnSelectAll) {
                if (this.isNodeSelected(v_strNodeName)) continue;
                this.m_dataSource.setData(0, i, (Object)OiixUtilityOps.booleanValueOf(true));
                this.m_selectedNodesHashtable.put(v_strNodeName, v_strNodeName);
                continue;
            }
            if (source != this.m_btnDeselectAll || !grid.isCellEnabled(0, i) || !this.isNodeSelected(v_strNodeName)) continue;
            this.m_dataSource.setData(0, i, (Object)OiixUtilityOps.booleanValueOf(false));
            this.m_selectedNodesHashtable.remove(v_strNodeName);
        }
        this.updateSelectionBtns();
    }

    public void cellEditing(GridEvent e) {
    }

    public void cellEdited(GridEvent e) {
        OiifmSelNodeGrid grid = (OiifmSelNodeGrid)this.m_tblNodeList.getGrid();
        if (this.m_tblNodeList.isEnabled()) {
            int v_iRow = grid.getFocusCell().row;
            boolean v_bSelected = grid.isNodeSelected(v_iRow);
            if (v_bSelected) {
                this.m_selectedNodesHashtable.put(this.m_nodeList[v_iRow], this.m_nodeList[v_iRow]);
            } else {
                this.m_selectedNodesHashtable.remove(this.m_nodeList[v_iRow]);
            }
            this.updateSelectionBtns();
        }
    }

    private void updateSelectionBtns() {
        boolean bRemoteNodeSelectionAllowed = this.isRemoteNodeSelectionAllowed();
        this.m_btnSelectAll.setEnabled(bRemoteNodeSelectionAllowed && this.m_nodeList.length - this.m_oInvalidNodes.size() > this.m_selectedNodesHashtable.size());
        this.m_btnDeselectAll.setEnabled(bRemoteNodeSelectionAllowed && this.m_selectedNodesHashtable.size() > (this.isNodeSelected(this.m_sLocalNode) ? 1 : 0));
    }

    public boolean isCellEnabled(int col, int row) {
        String sNodeName = (String)this.m_dataSource.getData(1, row);
        return !this.isReadonlyNode(sNodeName);
    }

    public boolean isErrorCell(int col, int row) {
        boolean bErrorCell = false;
        if (col == 2) {
            String sNodeName = (String)this.m_dataSource.getData(1, row);
            OiicClusterInstallInfo clusterInfo = OiicClusterInstallInfo.getClusterInstallInfo();
            OiicClusterNode oNode = clusterInfo.getClusterNode(sNodeName);
            bErrorCell = oNode != null ? !oNode.isAvailable() : true;
        }
        return bErrorCell;
    }
}

