/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifp;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Vector;
import oracle.ewt.button.PushButton;
import oracle.ewt.comboBox.ComboBox;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.textWrapper.TextWrapper;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.ewt.util.WindowUtils;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiif.oiifj.OiifjDirectoryDlg;
import oracle.sysman.oii.oiif.oiifm.OiifmCursorUtil;
import oracle.sysman.oii.oiif.oiifm.OiifmGraphicInterfaceManager;
import oracle.sysman.oii.oiif.oiifm.OiifmTitlePanel;
import oracle.sysman.oii.oiif.oiifp.OiifpWizPanel;
import oracle.sysman.oii.oiif.oiifw.OiifwOHLocWCDE;
import oracle.sysman.oii.oiif.oiifw.OiifwWizDialog;
import oracle.sysman.oii.oiig.OiigSourceConfigs;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiil.OiilNativeException;
import oracle.sysman.oii.oiip.oiipg.OiipgEnvironment;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiip.oiipg.OiipgOracleHomes;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixLanguage;
import oracle.sysman.oii.oiix.OiixOraparam;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifpOHLocPanel
extends OiifpWizPanel
implements ActionListener {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 256;
    private static boolean isBaseComboEditable = true;
    private final int CONTENT_GAP = 3;
    private final int PANEL_GAP = 10;
    private final int BUTTON_VGAP = 10;
    private OiifpHomePanel m_oOracleHomePanel = null;
    private OiifpBasePanel m_oOracleBasePanel = null;
    private OiifpHomePanel m_oApplTopPanel = null;
    private transient OiifwWizDialog m_wd;
    private OiiiInstallInventory m_inventory = null;
    private Font m_fontBold = null;
    private TextWrapper m_twrap = null;
    private OiiiOracleHomeInfo[] m_ohi = null;
    private OiipgFileSystem m_pgFS = null;
    private OiigSourceConfigs m_srcCfgs = null;
    private OiisVariableOwner m_vo = null;
    private String m_strHomeNameOld = null;
    private String m_strHomeLocOld = null;
    private String m_originalHome = null;
    private String m_OracleBaseLoc = null;
    private char m_cIsPanelDirty = (char)84;
    private boolean m_useOracle_Base = false;
    private String m_OracleBaseVar = "";
    private boolean m_bEnableControls = true;
    public static boolean m_bEnableBase = true;
    public static boolean bOracleBase = false;
    public boolean isOHEdited = false;
    private boolean m_bShowAppltop = false;

    public OiifpOHLocPanel() {
        super(bOracleBase ? OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_OB_DETAILS") : OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_OH_DETAILS"));
        this.m_pgFS = new OiipgFileSystem();
        this.init();
    }

    public void init() {
        String s = System.getProperty("oracle.installer.useORACLE_BASE");
        if (s != null && s.equalsIgnoreCase("true")) {
            this.m_useOracle_Base = true;
            this.m_OracleBaseVar = System.getProperty("oracle.installer.ORACLE_BASEvar", "ORACLE_BASE");
        }
    }

    public void createPanelElements() {
        OiifwOHLocWCDE ilwcde = (OiifwOHLocWCDE)this.m_wcde;
        this.m_bShowAppltop = ilwcde.isShowApplTop();
        this.m_vo = ilwcde.getVarOwner();
        this.m_srcCfgs = this.m_vo.getSession().getSourceConfigs();
        this.m_cIsPanelDirty = (char)78;
        OiiiInstallAreaControl invAreaControl = (OiiiInstallAreaControl)OiiiInstallAreaControl.getInventoryAreaControl();
        this.m_inventory = invAreaControl.getInstallInventory();
        this.m_twrap = WordWrapper.getTextWrapper();
        String sDefFontLabel = OiixResourceBundle.getFont();
        this.m_fontBold = new Font(sDefFontLabel, OiixLanguage.getFontStyle(1), 14);
        this.dlgPanel.setLayout((LayoutManager)new BorderLayout(0, 0));
        LWContainer locPanel = new LWContainer((LayoutManager)new GridLayout(2, 1));
        if (this.m_useOracle_Base) {
            locPanel.add((Component)this.createBasePanel());
        }
        LWContainer toPanel = this.createToPanel("", this.m_useOracle_Base);
        locPanel.add((Component)toPanel, (Object)"East");
        this.dlgPanel.add((Component)locPanel, (Object)"Center");
        LWContainer oPanel = new LWContainer((LayoutManager)new BorderLayout(0, 0));
        oPanel.add((Component)this.createOptionsPanel(), (Object)"East");
        this.dlgPanel.add((Component)oPanel, (Object)"South");
        OiifmGraphicInterfaceManager ogim = (OiifmGraphicInterfaceManager)OiicSessionInterfaceManager.getInterfaceManager();
        OiifwWizDialog wd = ogim.getWizardDialog();
        wd.setViewOnly(false);
        wd.setNavButtonState(8, true);
        wd.setNavButtonState(4, true);
        wd.setNavButtonState(1, true);
        wd.setNavButtonState(16, false);
        this.validate();
    }

    public void setReadOnlyOHLoc(Boolean oReadOnlyOHLoc) {
        this.m_bEnableControls = oReadOnlyOHLoc == false;
        this.m_oOracleHomePanel.enableControls(this.m_bEnableControls);
    }

    private LWContainer createBasePanel() {
        LWContainer aPanel = new LWContainer((LayoutManager)new BorderLayout(0, 0));
        Boolean b = new Boolean(true);
        int nRows = 1;
        if (b.booleanValue()) {
            String prompt = "";
            LWLabel bodyLabel3 = new LWLabel(prompt);
            bodyLabel3.setFont(this.m_fontBold);
            LWContainer oDestinationPanel = new LWContainer((LayoutManager)new GridLayout(nRows, 1));
            OiifmTitlePanel titlePanel = new OiifmTitlePanel((LWComponent)bodyLabel3, (LWComponent)oDestinationPanel);
            aPanel.add((Component)((Object)titlePanel), (Object)"North");
            String sPromptTag = OiicPullSession.isLangAddonMode() ? "OIIFP1010" : "S_TO_PROMPT_BASE";
            prompt = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", sPromptTag);
            this.m_oOracleBasePanel = new OiifpBasePanel(0, prompt);
            oDestinationPanel.add((Component)((Object)this.m_oOracleBasePanel));
        }
        return aPanel;
    }

    private LWContainer createToPanel(String to, boolean OracleBase) {
        LWContainer aPanel = new LWContainer((LayoutManager)new BorderLayout(10, 0));
        int nRows = this.m_bShowAppltop ? 2 : 1;
        String prompt = OracleBase ? OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_TO_ORACLE_HOME") : OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_TO");
        if (OracleBase) {
            LWLabel dummyLabel = new LWLabel("");
            aPanel.add((Component)dummyLabel, (Object)"West");
        }
        LWLabel bodyLabel3 = new LWLabel(prompt);
        bodyLabel3.setFont(this.m_fontBold);
        LWContainer oDestinationPanel = new LWContainer((LayoutManager)new GridLayout(nRows, 1));
        OiifmTitlePanel titlePanel = new OiifmTitlePanel((LWComponent)bodyLabel3, (LWComponent)oDestinationPanel, true);
        aPanel.add((Component)((Object)titlePanel));
        String sPromptTag = OracleBase ? (OiicPullSession.isLangAddonMode() ? "OIIFP1010" : "S_TO_PROMPT_HOME") : (OiicPullSession.isLangAddonMode() ? "OIIFP1010" : "S_TO_PROMPT");
        prompt = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", sPromptTag);
        this.m_oOracleHomePanel = new OiifpHomePanel(0, prompt);
        oDestinationPanel.add((Component)((Object)this.m_oOracleHomePanel));
        if (this.m_bShowAppltop) {
            prompt = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_APPLTOP_PROMPT");
            this.m_oApplTopPanel = new OiifpHomePanel(1, prompt);
            oDestinationPanel.add((Component)((Object)this.m_oApplTopPanel));
        }
        return aPanel;
    }

    private LWContainer createOptionsPanel() {
        LWContainer bPanel = new LWContainer();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.insets.bottom = 10;
        c.weightx = 1.0;
        c.fill = 2;
        c.gridwidth = 0;
        bPanel.setLayout((LayoutManager)gridbag);
        boolean bShowLanguageButton = ((OiifwOHLocWCDE)this.m_wcde).showLanguageButton();
        if (bShowLanguageButton) {
            String str = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CHANGE_LANGUAGES_BUTTON");
            this.m_languageButton = new PushButton(str);
            this.m_languageButton.setEnabled(true);
            this.m_languageButton.setFocusable(true);
            this.m_languageButton.setLeftmost(true);
            this.m_languageButton.setRightmost(true);
            this.m_languageButton.addActionListener((ActionListener)this);
            this.m_languageButton.setVisible(true);
            c.weighty = 0.9;
            c.anchor = 16;
            gridbag.setConstraints((Component)this.m_languageButton, c);
            bPanel.add((Component)this.m_languageButton);
        }
        return bPanel;
    }

    public void setWizDialog(OiifwWizDialog wd) {
        this.m_wd = wd;
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        OiifmCursorUtil.setCursor(this.waitCursor, (Component)((Object)this));
        OiifwWizDialog wd = this.getWizDialog();
        if (source == this.m_languageButton) {
            wd.onLanguage();
        }
        OiifmCursorUtil.setCursor(this.defCursor, (Component)((Object)this));
        if (source instanceof Component) {
            ((Component)source).requestFocus();
        }
    }

    public void updatePanel() {
        this.m_oOracleHomePanel.refreshCombos(0);
        if (this.m_oOracleBasePanel != null) {
            this.m_oOracleBasePanel.refreshCombos(0);
        }
        if (this.m_oApplTopPanel != null) {
            this.m_oApplTopPanel.refreshCombos(1);
        }
    }

    private String getCurrentHomePath(int nHomeType) {
        String val = null;
        String sHomeVarName = "ORACLE_HOME";
        switch (nHomeType) {
            case 0: {
                sHomeVarName = "ORACLE_HOME";
                break;
            }
            case 1: {
                sHomeVarName = "APPLTOP";
            }
        }
        OiisVariable oHome = this.m_vo.getVariable(sHomeVarName);
        if (null != oHome) {
            val = (String)oHome.getValue();
        }
        return val;
    }

    private String getCurrentBasePath() {
        String val = null;
        String sBaseVarName = "ORACLE_BASE";
        OiisVariable oBase = this.m_vo.getVariable(sBaseVarName);
        if (null != oBase) {
            val = (String)oBase.getValue();
        }
        return val;
    }

    private void checkOracleBaseLoc(String loc, String propVal) {
        this.m_oOracleBasePanel.checkOracleBase(loc, propVal);
    }

    private void setOriginalHome(String loc) {
        this.m_originalHome = loc;
    }

    private String getOriginalHome() {
        return this.m_originalHome;
    }

    private void computeNewBase(String newHome) {
        OiiiOracleHomeInfo ohi = this.m_inventory.getHomeWithLocation(newHome);
        if (ohi != null) {
            String obase = ohi.getAdditionalOracleHomeProperty(this.m_OracleBaseVar);
            if (obase != null && obase.trim().length() != 0) {
                this.setOracleBase(obase);
                this.setBaseComboEnable(false);
            } else {
                this.setBaseComboEnable(true);
            }
        } else {
            this.setBaseComboEnable(true);
        }
    }

    private void computeNewHome(String newBase) {
        if (this.isOHEdited) {
            return;
        }
        String location = this.getOriginalHome();
        String oldBase = this.getOracleBaseLoc();
        String newHome = OiixFunctionOps.replaceStr(location, oldBase, newBase);
        newHome = OiixPathOps.getNativeForm(newHome);
        newHome = OiixPathOps.getUnexpandedCanonicalPath(newHome);
        this.m_oOracleHomePanel.setHomeLocation(newHome);
    }

    private void refreshOHList() {
        Vector ouiOHs = this.m_inventory != null ? (Vector)this.m_inventory.getHomes().clone() : new Vector();
        Vector i33Homes = null;
        try {
            i33Homes = OiipgOracleHomes.getOsdOracleHomeInfo();
        }
        catch (OiilNativeException e) {
            i33Homes = null;
        }
        int ohsize = ouiOHs.size();
        if (i33Homes != null) {
            int i33Size = i33Homes.size();
            for (int j = 0; j < i33Size; ++j) {
                OiiiOracleHomeInfo i33Home = (OiiiOracleHomeInfo)i33Homes.elementAt(j);
                boolean homeExists = false;
                for (int k = 0; k < ohsize; ++k) {
                    OiiiOracleHomeInfo ohi = (OiiiOracleHomeInfo)ouiOHs.elementAt(k);
                    if (!this.m_pgFS.areLocsSame(ohi.getLocation(), i33Home.getLocation())) continue;
                    homeExists = true;
                }
                if (homeExists) continue;
                ouiOHs.addElement(i33Home);
            }
        }
        this.m_ohi = new OiiiOracleHomeInfo[ouiOHs.size()];
        ouiOHs.copyInto(this.m_ohi);
    }

    public String getOracleHome() {
        return this.m_oOracleHomePanel.getHomeLocation();
    }

    public String getOracleHomeName() {
        return this.m_oOracleHomePanel.getHomeName();
    }

    public String getOracleBase() {
        return this.m_oOracleBasePanel.getOracleBase();
    }

    public int getToLocationIndex() {
        return this.m_oOracleHomePanel.getSelectedHomeIndex(0);
    }

    public void setOracleHomeName(String name) {
        this.m_strHomeNameOld = name;
        this.m_oOracleHomePanel.setHomeName(name);
    }

    public void setOracleBaseLoc(String loc) {
        this.m_OracleBaseLoc = loc;
    }

    public String getOracleBaseLoc() {
        return this.m_OracleBaseLoc;
    }

    public void setOracleHome(String newLoc) {
        this.m_strHomeLocOld = newLoc;
        this.m_oOracleHomePanel.setHomeLocation(newLoc);
    }

    public void setOracleBase(String newLoc) {
        this.m_oOracleBasePanel.setBaseLocation(newLoc);
    }

    public void setBaseComboEnable(boolean enable) {
        if (this.m_oOracleBasePanel != null) {
            this.m_oOracleBasePanel.setBaseComboEnable(enable);
        }
    }

    public void updateEnabledComponentsStatus(boolean bButtonStatus) {
        super.updateEnabledComponentsStatus(bButtonStatus);
        if (null != this.m_oOracleHomePanel) {
            this.m_oOracleHomePanel.updateEnabledComponentsStatus(bButtonStatus);
        }
        if (null != this.m_oApplTopPanel) {
            this.m_oApplTopPanel.updateEnabledComponentsStatus(bButtonStatus);
        }
        if (null != this.m_oOracleBasePanel) {
            this.m_oOracleBasePanel.updateEnabledComponentsStatus(bButtonStatus);
        }
    }

    public void dispose() {
        this.m_vo = null;
        this.m_inventory = null;
        this.m_wd = null;
        if (null != this.m_oOracleHomePanel) {
            this.m_oOracleHomePanel.dispose();
            this.m_oOracleHomePanel = null;
        }
        if (null != this.m_oApplTopPanel) {
            this.m_oApplTopPanel.dispose();
            this.m_oApplTopPanel = null;
        }
    }

    static {
        String s = System.getProperty("oracle.installer.useORACLE_BASE");
        if (s != null && s.equalsIgnoreCase("true")) {
            bOracleBase = true;
        }
    }

    private class OiifpHomePanel
    extends LWContainer
    implements ActionListener,
    ItemListener,
    KeyListener,
    TextListener {
        private ComboBox m_oLocationCombo = null;
        private ComboBox m_oNameCombo = null;
        private ComboBox m_oBaseCombo = null;
        private PushButton m_oBrowseButton = null;
        private OiifjDirectoryDlg m_oDirDlg = null;
        private String m_lastNewName = "";
        private String m_lastNewHome = "";
        private int m_nHomeType = 0;

        public OiifpHomePanel(int nHomeType, String sPrompt) {
            this.m_nHomeType = nHomeType;
            this.setLayout(new BorderLayout(0, 0));
            if (null == OiifpOHLocPanel.this.m_twrap) {
                OiifpOHLocPanel.this.m_twrap = WordWrapper.getTextWrapper();
            }
            MultiLineLabel promptLabel = new MultiLineLabel(OiifpOHLocPanel.this.m_twrap, sPrompt);
            promptLabel.setPreferredAspectRatio(0.0f);
            this.add((Component)promptLabel, "North");
            LWContainer dPanel = new LWContainer();
            GridBagLayout gridbag = new GridBagLayout();
            dPanel.setLayout((LayoutManager)gridbag);
            this.add((Component)dPanel, "Center");
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(3, 0, 3, 3);
            c.anchor = 18;
            c.fill = 2;
            c.weightx = 0.01;
            c.weighty = 0.01;
            c.gridwidth = 1;
            String nameStr = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_NAME_LABEL");
            LWLabel nameLabel = new LWLabel(nameStr);
            gridbag.setConstraints((Component)nameLabel, c);
            dPanel.add((Component)nameLabel);
            c.weightx = 0.98;
            c.gridwidth = -1;
            this.m_oNameCombo = !OiicPullSession.isLangAddonMode() ? new ComboBox(true) : new ComboBox(false);
            this.m_oNameCombo.addItemListener((ItemListener)this);
            gridbag.setConstraints((Component)this.m_oNameCombo, c);
            dPanel.add((Component)this.m_oNameCombo);
            nameLabel.setLabelFor((Component)this.m_oNameCombo);
            c.weightx = 0.01;
            c.gridwidth = 0;
            LWContainer spacer = new LWContainer((LayoutManager)new BorderLayout(0, 0));
            gridbag.setConstraints((Component)spacer, c);
            dPanel.add((Component)spacer);
            c.weightx = 0.01;
            c.weighty = 0.99;
            c.gridwidth = 1;
            c.gridheight = 0;
            String locStr = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_TO_PATH_LABEL");
            LWLabel locLabel = new LWLabel(locStr);
            gridbag.setConstraints((Component)locLabel, c);
            dPanel.add((Component)locLabel);
            c.weightx = 0.98;
            c.gridwidth = -1;
            this.m_oLocationCombo = !OiicPullSession.isLangAddonMode() ? new ComboBox(true) : new ComboBox(false);
            this.m_oLocationCombo.addItemListener((ItemListener)this);
            this.m_oLocationCombo.addKeyListener((KeyListener)this);
            this.m_oLocationCombo.addTextListener((TextListener)this);
            gridbag.setConstraints((Component)this.m_oLocationCombo, c);
            dPanel.add((Component)this.m_oLocationCombo);
            locLabel.setLabelFor((Component)this.m_oLocationCombo);
            c.weightx = 0.01;
            c.gridwidth = 0;
            c.anchor = 12;
            String sPushButtonLabel = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_TO_BROWSE_BUTTON");
            this.m_oBrowseButton = new PushButton(sPushButtonLabel);
            this.m_oBrowseButton.setEnabled(true);
            this.m_oBrowseButton.addActionListener((ActionListener)this);
            this.m_oBrowseButton.setRightmost(true);
            this.m_oBrowseButton.setVisible(true);
            gridbag.setConstraints((Component)this.m_oBrowseButton, c);
            if (!OiicPullSession.isLangAddonMode()) {
                dPanel.add((Component)this.m_oBrowseButton);
            }
            this.refreshCombos(this.m_nHomeType);
        }

        public void keyTyped(KeyEvent e) {
            Object source = e.getSource();
            if (source == this.m_oLocationCombo) {
                OiifpOHLocPanel.this.isOHEdited = true;
            }
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }

        void enableControls(boolean bEnable) {
            this.m_oBrowseButton.setEnabled(bEnable);
            this.m_oLocationCombo.setEnabled(bEnable);
            this.m_oNameCombo.setEnabled(bEnable);
        }

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            OiifmCursorUtil.setCursor(OiifpOHLocPanel.this.waitCursor, (Component)((Object)this));
            if (source == this.m_oBrowseButton) {
                this.onBrowse();
            }
            OiifmCursorUtil.setCursor(OiifpOHLocPanel.this.defCursor, (Component)((Object)this));
        }

        private void onBrowse() {
            File chosenDir;
            OiipgFileSystem pgFS = new OiipgFileSystem();
            String sChooseDirLabel = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CHOOSE_DIR");
            this.m_oDirDlg = new OiifjDirectoryDlg(WindowUtils.parentFrame((Component)((Object)this)), sChooseDirLabel);
            String sOHomePrompt = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_OHOME_PROMPT");
            String selItem = this.m_oLocationCombo.getSelectedItem();
            selItem = null != selItem ? selItem.trim() : "";
            File curDir = null;
            if (0 < selItem.length()) {
                curDir = new File(selItem);
                if (curDir.exists()) {
                    try {
                        String sFileName = OiixPathOps.getFileCanonicalPath(selItem);
                        curDir = new File(sFileName);
                    }
                    catch (IOException ie) {
                        curDir = null;
                        ie.printStackTrace();
                    }
                } else {
                    curDir = null;
                }
            }
            if (null == curDir) {
                curDir = new File(System.getProperty("user.home"));
            }
            if ((chosenDir = this.m_oDirDlg.runDialog(curDir)) != null) {
                String dirStr = chosenDir.getAbsolutePath();
                OiifpOHLocPanel.this.comboSelect(this.m_oLocationCombo, dirStr);
                this.selectMatchingName(dirStr);
            }
            this.m_oDirDlg = null;
        }

        public void itemStateChanged(ItemEvent e) {
            Object source = e.getSource();
            if (e.getStateChange() == 1) {
                if (source == this.m_oLocationCombo) {
                    int selIndex = this.m_oLocationCombo.getSelectedIndex();
                    this.selectMatchingName(this.m_oLocationCombo.getSelectedItem());
                    OiifpOHLocPanel.this.isOHEdited = true;
                } else if (source == this.m_oNameCombo) {
                    int selIndex = this.m_oNameCombo.getSelectedIndex();
                    boolean isMatchingLocFound = this.selectMatchingLoc(this.m_oNameCombo.getSelectedItem());
                    if (isMatchingLocFound) {
                        OiifpOHLocPanel.this.isOHEdited = true;
                    }
                }
                if (OiifpOHLocPanel.this.m_useOracle_Base) {
                    OiifpOHLocPanel.this.checkOracleBaseLoc(this.m_oLocationCombo.getSelectedItem(), OiifpOHLocPanel.this.m_OracleBaseVar);
                }
            }
        }

        public void textValueChanged(TextEvent e) {
            Object source = e.getSource();
            if (source == this.m_oLocationCombo) {
                String sLoc = this.m_oLocationCombo.getSelectedItem();
                OiifpOHLocPanel.this.computeNewBase(sLoc);
            }
        }

        private boolean selectMatchingName(String sLocation) {
            for (int i = 0; i < OiifpOHLocPanel.this.m_ohi.length; ++i) {
                String name;
                OiiiOracleHomeInfo ohi = OiifpOHLocPanel.this.m_ohi[i];
                if (!OiifpOHLocPanel.this.m_pgFS.areLocsSame(ohi.getLocation(), sLocation) || ohi.getHomeType() != this.m_nHomeType || (name = ohi.getName()) == null || name.trim().length() <= 0) continue;
                name = name.trim();
                OiifpOHLocPanel.this.comboSelect(this.m_oNameCombo, name);
                return true;
            }
            this.m_lastNewHome = sLocation;
            return false;
        }

        private boolean selectMatchingLoc(String sHomeName) {
            for (int i = 0; i < OiifpOHLocPanel.this.m_ohi.length; ++i) {
                OiiiOracleHomeInfo ohi = OiifpOHLocPanel.this.m_ohi[i];
                String name = ohi.getName();
                if (ohi.getHomeType() != this.m_nHomeType || name == null || name.trim().length() <= 0 || !name.equalsIgnoreCase(sHomeName)) continue;
                String location = ohi.getLocation();
                OiifpOHLocPanel.this.comboSelect(this.m_oLocationCombo, location);
                return true;
            }
            this.m_lastNewName = sHomeName;
            return false;
        }

        public void refreshCombos(int nHomeType) {
            if (this.m_oLocationCombo.getItemCount() > 0) {
                this.m_oLocationCombo.removeAll();
            }
            if (this.m_oNameCombo.getItemCount() > 0) {
                this.m_oNameCombo.removeAll();
            }
            OiifpOHLocPanel.this.refreshOHList();
            int nHomesAdded = 0;
            for (int i = 0; i < OiifpOHLocPanel.this.m_ohi.length; ++i) {
                OiiiOracleHomeInfo ohi = OiifpOHLocPanel.this.m_ohi[i];
                if (ohi.getHomeType() != this.m_nHomeType) continue;
                this.m_oLocationCombo.insert(ohi.getLocation(), nHomesAdded);
                String name = ohi.getName();
                if (name != null && name.trim().length() > 0) {
                    this.m_oNameCombo.addItem(name.trim());
                }
                ++nHomesAdded;
            }
            String ohEnvPath = OiipgEnvironment.getEnv(OiiiOracleHomeInfo.getHomeEnvVar(this.m_nHomeType));
            if (ohEnvPath == null) {
                ohEnvPath = "";
            }
            String curOHome = OiifpOHLocPanel.this.getCurrentHomePath(this.m_nHomeType);
            boolean bGetRunningCountForPath = false;
            boolean bGetRunningCountForName = false;
            if (null != this.m_lastNewHome && this.m_lastNewHome.length() > 0) {
                bGetRunningCountForPath = false;
                bGetRunningCountForName = false;
            } else {
                if (null != curOHome && 0 < curOHome.length()) {
                    this.m_lastNewHome = curOHome;
                } else if (ohEnvPath.length() > 0) {
                    this.m_lastNewHome = ohEnvPath;
                } else {
                    String obase;
                    String loc = OiiiOracleHomeInfo.getDefHomeLocation(this.m_nHomeType);
                    this.m_lastNewHome = null != loc ? loc : "";
                    bGetRunningCountForPath = true;
                    if (OiifpOHLocPanel.this.m_useOracle_Base && (obase = OiixPathOps.getStandardForm(OiifpOHLocPanel.this.getOracleBaseLoc())) != null) {
                        String location = OiixOraparam.getOraparamProfileString("DEFAULT_HOME_LOCATION", null);
                        if (location == null || location.trim().length() == 0) {
                            location = OiixPathOps.getStandardForm("OraHome");
                        }
                        this.m_lastNewHome = OiixPathOps.concatPath(obase, location);
                        this.m_lastNewHome = OiixPathOps.getNativeForm(this.m_lastNewHome);
                    }
                }
                String name = OiiiOracleHomeInfo.getDefHomeName(OiifpOHLocPanel.this.m_inventory, this.m_nHomeType);
                bGetRunningCountForName = true;
                this.m_lastNewName = name;
            }
            if (!OiicPullSession.isLangAddonMode() && OiixOraparam.useRunningCountForDefaults()) {
                int idx = this.getRunningCount(this.m_lastNewHome, bGetRunningCountForPath, this.m_lastNewName, bGetRunningCountForName);
                if (bGetRunningCountForPath) {
                    this.m_lastNewHome = this.m_lastNewHome + "_" + idx;
                }
                if (bGetRunningCountForName) {
                    this.m_lastNewName = this.m_lastNewName + idx;
                }
            }
            OiifpOHLocPanel.this.setOriginalHome(this.m_lastNewHome);
            this.m_lastNewHome = OiixPathOps.getUnexpandedCanonicalPath(this.m_lastNewHome);
            OiifpOHLocPanel.this.comboSelect(this.m_oLocationCombo, this.m_lastNewHome);
            if (!this.selectMatchingName(this.m_lastNewHome)) {
                OiifpOHLocPanel.this.comboSelect(this.m_oNameCombo, this.m_lastNewName);
            }
        }

        private int getRunningCount(String sNewHome, boolean bGetRunningCountForPath, String sNewName, boolean bGetRunningCountForName) {
            int idx = 1;
            boolean bPathExists = true;
            boolean bNameExists = true;
            while (bPathExists || bNameExists) {
                if (bGetRunningCountForPath) {
                    String sPath = sNewHome + "_" + idx;
                    bPathExists = new File(sPath).exists();
                } else {
                    bPathExists = false;
                }
                if (bGetRunningCountForName) {
                    String sName = sNewName + idx;
                    bNameExists = OiifpOHLocPanel.this.m_inventory.getHomeWithName(sName) != null;
                } else {
                    bNameExists = false;
                }
                if (!bPathExists && !bNameExists) continue;
                ++idx;
            }
            return idx;
        }

        public String getHomeLocation() {
            String sLoc = this.m_oLocationCombo.getSelectedItem();
            String string = sLoc = null != sLoc ? sLoc.trim() : "";
            if (this.m_oLocationCombo.getSelectedIndex() < 0) {
                for (int i = 0; i < OiifpOHLocPanel.this.m_ohi.length; ++i) {
                    String storedLoc = OiifpOHLocPanel.this.m_ohi[i].getLocation();
                    if (!OiifpOHLocPanel.this.m_pgFS.areLocsSame(storedLoc, sLoc)) continue;
                    return storedLoc;
                }
            }
            return sLoc;
        }

        public String getHomeName() {
            String sName = this.m_oNameCombo.getSelectedItem();
            sName = null != sName ? sName.trim() : "";
            return sName;
        }

        public int getSelectedHomeIndex(int nHomeType) {
            Vector OHs;
            int nIndex = -1;
            if (OiifpOHLocPanel.this.m_inventory != null && (OHs = OiifpOHLocPanel.this.m_inventory.getHomes(this.m_nHomeType)) != null) {
                nIndex = OiiiOracleHomeInfo.getOHIndex(OHs, this.m_oLocationCombo.getSelectedItem());
            }
            return -1;
        }

        public void setHomeName(String sName) {
            OiifpOHLocPanel.this.comboSelect(this.m_oNameCombo, sName);
            if (!this.selectMatchingLoc(this.m_oNameCombo.getSelectedItem())) {
                this.m_lastNewName = sName;
            }
        }

        public void setHomeLocation(String sLoc) {
            if (sLoc != null) {
                OiifpOHLocPanel.this.comboSelect(this.m_oLocationCombo, sLoc);
            }
            if (OiifpOHLocPanel.this.m_useOracle_Base) {
                OiifpOHLocPanel.this.checkOracleBaseLoc(this.m_oLocationCombo.getSelectedItem(), OiifpOHLocPanel.this.m_OracleBaseVar);
            }
        }

        public void updateEnabledComponentsStatus(boolean p_bButtonStatus) {
            if (null != this.m_oBrowseButton) {
                this.m_oBrowseButton.setFocusable(p_bButtonStatus);
                this.m_oBrowseButton.setEnabled(p_bButtonStatus);
            }
            if (null != this.m_oLocationCombo) {
                this.m_oLocationCombo.setEnabled(p_bButtonStatus);
            }
            if (null != this.m_oNameCombo) {
                this.m_oNameCombo.setEnabled(p_bButtonStatus);
            }
            if (null != this.m_oDirDlg) {
                this.m_oDirDlg.setEnabled(p_bButtonStatus);
            }
        }

        public void dispose() {
            this.m_oLocationCombo = null;
            this.m_oNameCombo = null;
            this.m_oBrowseButton = null;
            this.m_lastNewName = null;
            this.m_lastNewHome = null;
        }
    }

    private class OiifpBasePanel
    extends LWContainer
    implements ActionListener,
    ItemListener,
    TextListener {
        private ComboBox m_oBaseCombo = null;
        private PushButton m_oBrowseButton = null;
        private OiifjDirectoryDlg m_oDirDlg = null;
        private String m_lastNewName = "";
        private String m_lastNewHome = "";
        private int m_nHomeType = 0;
        private String m_lastNewBase = "";

        public OiifpBasePanel(int nHomeType, String sPrompt) {
            this.setLayout(new BorderLayout(0, 0));
            if (null == OiifpOHLocPanel.this.m_twrap) {
                OiifpOHLocPanel.this.m_twrap = WordWrapper.getTextWrapper();
            }
            MultiLineLabel promptLabel = new MultiLineLabel(OiifpOHLocPanel.this.m_twrap, sPrompt);
            promptLabel.setPreferredAspectRatio(0.0f);
            this.add((Component)promptLabel, "North");
            LWContainer dPanel = new LWContainer();
            GridBagLayout gridbag = new GridBagLayout();
            dPanel.setLayout((LayoutManager)gridbag);
            this.add((Component)dPanel, "Center");
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(3, 0, 3, 3);
            c.anchor = 18;
            c.fill = 2;
            c.weightx = 0.01;
            c.weighty = 0.01;
            c.gridwidth = 1;
            String nameStr1 = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_BASE_LABEL");
            LWLabel nameLabel1 = new LWLabel(nameStr1);
            gridbag.setConstraints((Component)nameLabel1, c);
            dPanel.add((Component)nameLabel1);
            c.weightx = 0.98;
            c.gridwidth = -1;
            this.m_oBaseCombo = new ComboBox(true);
            this.m_oBaseCombo.addItemListener((ItemListener)this);
            this.m_oBaseCombo.addTextListener((TextListener)this);
            gridbag.setConstraints((Component)this.m_oBaseCombo, c);
            dPanel.add((Component)this.m_oBaseCombo);
            c.weightx = 0.01;
            c.gridwidth = 0;
            c.anchor = 12;
            String sPushButtonLabel = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_TO_BROWSE_BUTTON");
            this.m_oBrowseButton = new PushButton(sPushButtonLabel);
            this.m_oBrowseButton.setEnabled(true);
            this.m_oBrowseButton.addActionListener((ActionListener)this);
            this.m_oBrowseButton.setRightmost(true);
            this.m_oBrowseButton.setVisible(true);
            gridbag.setConstraints((Component)this.m_oBrowseButton, c);
            if (!OiicPullSession.isLangAddonMode()) {
                dPanel.add((Component)this.m_oBrowseButton);
            }
            this.m_nHomeType = nHomeType;
            this.refreshCombos(this.m_nHomeType);
        }

        public void setBaseComboEnable(boolean enable) {
            if (enable) {
                this.m_oBaseCombo.setEnabled(true);
            } else {
                this.m_oBaseCombo.setEnabled(false);
            }
        }

        public void checkOracleBase(String loc, String propVal) {
            for (int i = 0; i < OiifpOHLocPanel.this.m_ohi.length; ++i) {
                String ob;
                OiiiOracleHomeInfo ohi = OiifpOHLocPanel.this.m_ohi[i];
                String home = ohi.getLocation();
                if (loc == null || !loc.equalsIgnoreCase(home) || (ob = ohi.getAdditionalOracleHomeProperty(propVal)) == null) continue;
                OiifpOHLocPanel.this.comboSelect(this.m_oBaseCombo, ob);
                this.updateEnabledComponentsStatus(false);
                m_bEnableBase = false;
                this.m_oBaseCombo.setEnabled(false);
                return;
            }
            this.updateEnabledComponentsStatus(true);
            m_bEnableBase = true;
            this.m_oBaseCombo.setEnabled(true);
        }

        public void itemStateChanged(ItemEvent e) {
            Object source = e.getSource();
            if (e.getStateChange() == 1 && source == this.m_oBaseCombo) {
                int selIndex = this.m_oBaseCombo.getSelectedIndex();
                String sLoc = this.m_oBaseCombo.getSelectedItem();
                OiifpOHLocPanel.this.computeNewHome(sLoc);
            }
        }

        public void textValueChanged(TextEvent e) {
            Object source = e.getSource();
            if (source == this.m_oBaseCombo) {
                String sLoc = this.m_oBaseCombo.getSelectedItem();
                OiifpOHLocPanel.this.computeNewHome(sLoc);
            }
        }

        public void updateEnabledComponentsStatus(boolean p_bButtonStatus) {
            if (!m_bEnableBase) {
                return;
            }
            if (null != this.m_oBrowseButton) {
                this.m_oBrowseButton.setFocusable(p_bButtonStatus);
                this.m_oBrowseButton.setEnabled(p_bButtonStatus);
            }
            if (null != this.m_oBaseCombo) {
                this.m_oBaseCombo.setEnabled(p_bButtonStatus);
            }
        }

        public String getOracleBase() {
            String sLoc = this.m_oBaseCombo.getSelectedItem();
            sLoc = null != sLoc ? sLoc.trim() : "";
            return sLoc;
        }

        public void setBaseLocation(String sLoc) {
            if (sLoc != null) {
                OiifpOHLocPanel.this.comboSelect(this.m_oBaseCombo, sLoc);
            }
        }

        private void onBrowse() {
            File chosenDir;
            OiipgFileSystem pgFS = new OiipgFileSystem();
            String sChooseDirLabel = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CHOOSE_DIR");
            this.m_oDirDlg = new OiifjDirectoryDlg(WindowUtils.parentFrame((Component)((Object)this)), sChooseDirLabel);
            String sOHomePrompt = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_OHOME_PROMPT");
            String selItem = this.m_oBaseCombo.getSelectedItem();
            selItem = null != selItem ? selItem.trim() : "";
            File curDir = null;
            if (0 < selItem.length()) {
                curDir = new File(selItem);
                if (curDir.exists()) {
                    try {
                        String sFileName = OiixPathOps.getFileCanonicalPath(selItem);
                        curDir = new File(sFileName);
                    }
                    catch (IOException ie) {
                        curDir = null;
                        ie.printStackTrace();
                    }
                } else {
                    curDir = null;
                }
            }
            if (null == curDir) {
                curDir = new File(System.getProperty("user.home"));
            }
            if ((chosenDir = this.m_oDirDlg.runDialog(curDir)) != null) {
                String dirStr = chosenDir.getAbsolutePath();
                OiifpOHLocPanel.this.comboSelect(this.m_oBaseCombo, dirStr);
                OiifpOHLocPanel.this.computeNewHome(this.m_oBaseCombo.getSelectedItem());
            }
            this.m_oDirDlg = null;
        }

        public void refreshCombos(int nHomeType) {
            String loc;
            String curOBase;
            if (this.m_oBaseCombo.getItemCount() > 0) {
                this.m_oBaseCombo.removeAll();
            }
            OiifpOHLocPanel.this.refreshOHList();
            int nBasesAdded = 0;
            HashSet<String> baseUnique = new HashSet<String>();
            for (int i = 0; i < OiifpOHLocPanel.this.m_ohi.length; ++i) {
                String obase;
                OiiiOracleHomeInfo ohi = OiifpOHLocPanel.this.m_ohi[i];
                if (ohi.getHomeType() != this.m_nHomeType || (obase = ohi.getAdditionalOracleHomeProperty(OiifpOHLocPanel.this.m_OracleBaseVar)) == null || !baseUnique.add(obase)) continue;
                this.m_oBaseCombo.insert(obase, nBasesAdded);
                ++nBasesAdded;
            }
            String obEnvPath = OiipgEnvironment.getEnv(OiiiOracleHomeInfo.getBaseEnvVar());
            if (obEnvPath == null) {
                obEnvPath = "";
            }
            this.m_lastNewBase = null != (curOBase = OiifpOHLocPanel.this.getCurrentBasePath()) && 0 < curOBase.length() ? curOBase : (obEnvPath.length() > 0 ? obEnvPath : (null != (loc = OiiiOracleHomeInfo.getDefBaseLocation()) ? loc : ""));
            this.m_lastNewBase = OiixPathOps.getUnexpandedCanonicalPath(this.m_lastNewBase);
            OiifpOHLocPanel.this.comboSelect(this.m_oBaseCombo, this.m_lastNewBase);
            OiifpOHLocPanel.this.setOracleBaseLoc(this.m_lastNewBase);
            this.updateEnabledComponentsStatus(m_bEnableBase);
        }

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            OiifmCursorUtil.setCursor(OiifpOHLocPanel.this.waitCursor, (Component)((Object)this));
            if (source == this.m_oBrowseButton) {
                this.onBrowse();
            }
            OiifmCursorUtil.setCursor(OiifpOHLocPanel.this.defCursor, (Component)((Object)this));
        }
    }
}

