/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifp;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.text.MessageFormat;
import java.util.Vector;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.sysman.oii.oiic.OiicInstallSession;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiif.oiifm.OiifmPubInvNavigator;
import oracle.sysman.oii.oiif.oiifp.OiifpWizPanel;
import oracle.sysman.oii.oiig.OiigAvailSoftware;
import oracle.sysman.oii.oiig.OiigCompInfo;
import oracle.sysman.oii.oiig.OiigPubClient;
import oracle.sysman.oii.oiii.OiiiAreaInventory;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiCompInvEntry;
import oracle.sysman.oii.oiii.OiiiSourceAccess;
import oracle.sysman.oii.oiii.OiiiStageCompInvEntry;
import oracle.sysman.oii.oiii.OiiiStageInventory;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifpPubInvCompsSelPanel
extends OiifpWizPanel {
    private final int BORDER_VGAP = 5;
    private MultiLineLabel m_promptLabel;
    private Dimension m_preferredSize;
    private LWButton m_buttonLang;
    private boolean m_bMessageDisplayed = false;
    private OiicPullSession m_pullSession;
    private GridBagLayout m_gbLayout = new GridBagLayout();
    private OiifmPubInvNavigator m_navigator = null;
    private OiigAvailSoftware m_availSoftware = null;
    private boolean m_bHideExistProds = true;

    public OiifpPubInvCompsSelPanel(OiicPullSession pullSession) {
        super("");
        this.m_pullSession = pullSession;
        this.m_preferredSize = new Dimension(10, 10);
    }

    public void init() {
        ((BorderLayout)this.mainPanel.getLayout()).setVgap(5);
        this.mainPanel.removeAll();
        this.dlgPanel.removeAll();
        this.dlgPanel.setLayout((LayoutManager)this.m_gbLayout);
        this.mainPanel.add((Component)this.dlgPanel, (Object)"Center");
        OiigPubClient pubClient = this.m_pullSession.getPubClient();
        try {
            this.m_availSoftware = pubClient.getAvailSoftware();
            OiiiSourceAccess sacc = this.m_pullSession.getSourceAccess();
            OiiiStageInventory si = sacc.getStageInventory();
            OiiiAreaInventory filterInv = this.m_pullSession.getTargetAreaControl().getAreaInventory();
            int lkHmInd = -1;
            if (this.m_pullSession instanceof OiicInstallSession) {
                lkHmInd = ((OiicInstallSession)this.m_pullSession).getOHIndex();
            }
            this.m_availSoftware.initialize(pubClient, si, filterInv, lkHmInd);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this.m_navigator = new OiifmPubInvNavigator(pubClient.getPubURL(), this.m_availSoftware);
        this.m_navigator.init();
        this.m_navigator.setHideExistProds(this.m_bHideExistProds);
        String title = OiixResourceBundle.getString("S_PUBINV_AVAIL_PRODS");
        this.setTitleLabel(title);
        this.setSubTitleLabel(null);
        Object[] arr = new Object[]{pubClient.getPubURL()};
        String prompt = OiixResourceBundle.getString("S_PUBINV_CHOOSE_PROD_PROMPT");
        prompt = MessageFormat.format(prompt, arr);
        this.m_promptLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), prompt);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 2;
        c.anchor = 18;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 0, 8);
        c.ipadx = 0;
        c.ipady = 0;
        this.m_gbLayout.setConstraints((Component)this.m_promptLabel, c);
        this.dlgPanel.add((Component)this.m_promptLabel);
        c.gridy = 1;
        c.fill = 1;
        c.anchor = 18;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(0, 0, 0, 5);
        this.m_gbLayout.setConstraints((Component)((Object)this.m_navigator), c);
        this.dlgPanel.add((Component)((Object)this.m_navigator));
        this.validate();
    }

    public Dimension getPreferredSize() {
        return this.m_preferredSize;
    }

    private boolean isHideExistProds() {
        return this.m_bHideExistProds;
    }

    private void setHideExistProds(boolean bHideExistProds) {
        this.m_bHideExistProds = bHideExistProds;
        if (this.m_navigator != null) {
            this.m_navigator.setHideExistProds(this.m_bHideExistProds);
        }
    }

    private OiiiCompInvEntry getCompInvEntry(OiiiCompInstallID cid) {
        OiiiSourceAccess sacc = this.m_pullSession.getSourceAccess();
        OiiiStageInventory si = sacc.getStageInventory();
        return si.getStageCompInvEntry(cid);
    }

    public OiiiCompInstallID[] getTopLevelComps() {
        Vector<OiiiCompInstallID> vAllSelCompIDs = new Vector<OiiiCompInstallID>();
        long[] availCompIDS = this.m_availSoftware.getAllCompIDs();
        int length = availCompIDS.length;
        StringBuffer sAllCompID = new StringBuffer();
        if (length > 0) {
            System.out.println("*****************************************");
            for (int i = 0; i < length; ++i) {
                OiigCompInfo comp = this.m_availSoftware.getComp(availCompIDS[i]);
                if (comp == null || !comp.isSelected()) continue;
                OiiiStageCompInvEntry stgCompInvEntry = comp.getStageCompInvEntry();
                OiiiCompInstallID cid = stgCompInvEntry.getCompInstallID();
                System.out.println("Selected Comp: " + cid.getName());
                sAllCompID.append(cid.getName() + "\n");
                vAllSelCompIDs.addElement(cid);
            }
        }
        int numSelIDs = vAllSelCompIDs.size();
        Object[] selIDs = new OiiiCompInstallID[numSelIDs];
        vAllSelCompIDs.copyInto(selIDs);
        return selIDs;
    }
}

