/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifp;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.Vector;
import oracle.ewt.EwtContainer;
import oracle.ewt.button.PushButton;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWCheckboxGroup;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWPasswordField;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiif.oiifm.OiifmToolTipChoice;
import oracle.sysman.oii.oiif.oiifp.OiifpWizPanel;
import oracle.sysman.oii.oiig.OiigAuthCategory;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifpPubLoginPanel
extends OiifpWizPanel
implements ItemListener {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 256;
    private final int CONTENT_GAP = 3;
    private final int PANEL_GAP = 10;
    private final int BUTTON_VGAP = 10;
    private LWLabel m_ctxtPrompt = null;
    private LWLabel m_loginTypePrompt = null;
    private LWLabel m_categoryLabel = null;
    private LWLabel m_nameLabel = null;
    private OiifmToolTipChoice m_chCategory = null;
    private LWTextField m_tfName = null;
    private LWLabel m_pwdLabel = null;
    private LWPasswordField m_pfPwd = null;
    private PushButton m_settingsBtn;
    private String m_sCategory = null;
    private String m_sSubID = null;
    private String m_sPwd = null;
    private LWCheckbox m_anonyRadio = null;
    private LWCheckbox m_specifyRadio = null;
    private boolean m_bSpecified = false;
    private String m_sourceLoc;
    private Vector m_authCats = null;
    private GridBagLayout m_gbLayout = new GridBagLayout();

    public OiifpPubLoginPanel(OiisVariableOwner vo, Vector authCats) {
        super(OiixResourceBundle.getString("S_SUB_LOGIN"));
        this.dlgPanel.setLayout((LayoutManager)this.m_gbLayout);
        this.m_authCats = authCats;
        this.m_sCategory = ((OiigAuthCategory)authCats.firstElement()).getName();
        OiisVariable fromVar = vo.getVariable("FROM_LOCATION");
        this.m_sourceLoc = (String)fromVar.getValue();
        this.addControls();
        this.validate();
    }

    private void addControls() {
        String ctxtPrompt = OiixResourceBundle.getString("S_NEW_SERVER_PROMPT");
        this.m_ctxtPrompt = new LWLabel(MessageFormat.format(ctxtPrompt, this.m_sourceLoc));
        this.m_loginTypePrompt = new LWLabel(OiixResourceBundle.getString("S_LOGIN_TYPE_PROMPT"));
        LWCheckboxGroup selectGroup = new LWCheckboxGroup();
        this.m_anonyRadio = new LWCheckbox(OiixResourceBundle.getString("S_ANON_LABEL"), true, selectGroup);
        this.m_specifyRadio = new LWCheckbox(OiixResourceBundle.getString("S_REGISTERED_LABEL"), false, selectGroup);
        EwtContainer userPanel = new EwtContainer((LayoutManager)new GridBagLayout());
        userPanel.setBorderPainter((BorderPainter)new FixedBorderPainter(0, 0, 0, 100));
        this.m_categoryLabel = new LWLabel(OiixResourceBundle.getString("S_USER_CAT"));
        this.m_nameLabel = new LWLabel(OiixResourceBundle.getString("S_LOGIN_NAME"));
        this.m_pwdLabel = new LWLabel(OiixResourceBundle.getString("S_PASSWORD"));
        this.m_chCategory = new OiifmToolTipChoice();
        int numCats = this.m_authCats.size();
        for (int i = 0; i < numCats; ++i) {
            OiigAuthCategory authCat = (OiigAuthCategory)this.m_authCats.elementAt(i);
            this.m_chCategory.add(authCat.getName(), authCat.getDescription());
        }
        this.m_chCategory.select(0);
        this.m_tfName = new LWTextField(50);
        this.m_pfPwd = new LWPasswordField(50);
        EwtContainer settingsPanel = new EwtContainer((LayoutManager)new BorderLayout());
        this.m_settingsBtn = new PushButton(OiixResourceBundle.getString("S_SETTINGS"));
        this.m_settingsBtn.setLeftmost(true);
        this.m_settingsBtn.setRightmost(true);
        this.add((Component)this.m_ctxtPrompt, 0, 0, 1, 1, 0, 18, 0.0, 0.0, 12, 10, 2, 0, 0, 0);
        this.add((Component)this.m_loginTypePrompt, 0, 1, 1, 1, 0, 18, 0.0, 0.0, 12, 10, 2, 0, 0, 0);
        this.add((Component)this.m_anonyRadio, 0, 2, 1, 1, 0, 18, 0.0, 0.0, 2, 15, 2, 0, 0, 0);
        this.add((Component)this.m_specifyRadio, 0, 3, 1, 1, 0, 18, 0.0, 0.0, 2, 15, 2, 0, 0, 0);
        this.add((Component)userPanel, 0, 4, 1, 1, 1, 18, 1.0, 1.0, 2, 20, 5, 8, 0, 0);
        this.add(userPanel, (Component)this.m_nameLabel, 0, 0, 1, 1, 0, 18, 0.0, 0.0, 5, 8, 5, 0, 0, 0);
        this.add(userPanel, (Component)this.m_tfName, 1, 0, 1, 1, 2, 18, 1.0, 0.0, 5, 5, 0, 8, 0, 0);
        this.add(userPanel, (Component)this.m_pwdLabel, 0, 1, 1, 1, 0, 18, 0.0, 0.0, 8, 8, 5, 0, 0, 0);
        this.add(userPanel, (Component)this.m_pfPwd, 1, 1, 1, 1, 2, 18, 1.0, 0.0, 8, 5, 5, 8, 0, 0);
        if (numCats > 1) {
            this.add(userPanel, (Component)this.m_categoryLabel, 0, 2, 1, 1, 0, 18, 0.0, 0.0, 2, 8, 5, 0, 0, 0);
            this.add(userPanel, (Component)((Object)this.m_chCategory), 1, 2, 1, 1, 2, 18, 1.0, 0.0, 2, 5, 0, 8, 0, 0);
        }
        this.add((Component)settingsPanel, 0, 5, 0, 1, 0, 13, 1.0, 1.0, 8, 5, 5, 8, 0, 0);
        settingsPanel.add((Component)this.m_settingsBtn, (Object)"East");
        this.addControlListeners();
        this.showUser(this.m_bSpecified);
    }

    protected void add(Component component, int grid_x, int grid_y, int grid_width, int grid_height, int fill, int anchor, double weight_x, double weight_y, int top, int left, int bottom, int right, int padx, int pady) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = grid_x;
        c.gridy = grid_y;
        c.gridwidth = grid_width;
        c.gridheight = grid_height;
        c.fill = fill;
        c.anchor = anchor;
        c.weightx = weight_x;
        c.weighty = weight_y;
        if (top + bottom + left + right > 0) {
            c.insets = new Insets(top, left, bottom, right);
        }
        c.ipadx = padx;
        c.ipady = pady;
        this.m_gbLayout.setConstraints(component, c);
        this.dlgPanel.add(component);
    }

    protected void add(EwtContainer container, Component component, int grid_x, int grid_y, int grid_width, int grid_height, int fill, int anchor, double weight_x, double weight_y, int top, int left, int bottom, int right, int padx, int pady) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = grid_x;
        c.gridy = grid_y;
        c.gridwidth = grid_width;
        c.gridheight = grid_height;
        c.fill = fill;
        c.anchor = anchor;
        c.weightx = weight_x;
        c.weighty = weight_y;
        if (top + bottom + left + right > 0) {
            c.insets = new Insets(top, left, bottom, right);
        }
        c.ipadx = padx;
        c.ipady = pady;
        GridBagLayout gbLayout = (GridBagLayout)container.getLayout();
        gbLayout.setConstraints(component, c);
        container.add(component);
    }

    public boolean onNext() {
        boolean retVal = true;
        if (this.m_bSpecified && (this.m_tfName.getText().equals("") || this.m_pfPwd.getText().equals(""))) {
            OiifmAlert.displayAlert("Warning", "You have to sepcify the subscriber ID and password", 50, 1, 1, 10);
            if (this.m_tfName.getText().equals("")) {
                this.m_tfName.requestFocus();
            } else {
                this.m_pfPwd.requestFocus();
            }
            retVal = false;
        }
        this.m_sCategory = this.m_chCategory.getSelectedItem();
        this.m_sSubID = this.m_tfName.getText();
        this.m_sPwd = this.m_pfPwd.getText();
        return retVal;
    }

    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source == this.m_anonyRadio || source == this.m_specifyRadio) {
            this.m_bSpecified = this.m_specifyRadio.getState();
            this.showUser(this.m_bSpecified);
        }
    }

    protected void addControlListeners() {
        this.m_anonyRadio.addItemListener((ItemListener)this);
        this.m_specifyRadio.addItemListener((ItemListener)this);
    }

    private void showUser(boolean show) {
        this.m_bSpecified = show;
        this.m_categoryLabel.setEnabled(show);
        this.m_chCategory.setEnabled(show);
        this.m_nameLabel.setEnabled(show);
        this.m_tfName.setEnabled(show);
        this.m_pwdLabel.setEnabled(show);
        this.m_pfPwd.setEnabled(show);
    }

    public Boolean getAnonymousLogin() {
        return new Boolean(!this.m_bSpecified);
    }

    public String getLoginName() {
        return this.m_sSubID;
    }

    public String getPassword() {
        return this.m_sPwd;
    }

    public String getLoginCategory() {
        return this.m_sCategory;
    }

    public void setAnonymousLogin(Boolean anonLogin) {
        this.m_bSpecified = anonLogin == false;
        this.showUser(this.m_bSpecified);
    }

    public void setLoginName(String loginName) {
        if (loginName != null) {
            this.m_tfName.setText(loginName);
            this.m_tfName.repaint();
        }
    }

    public void setPassword(String password) {
        if (password != null) {
            this.m_pfPwd.setText(password);
            this.m_pfPwd.repaint();
        }
    }

    public void setLoginCategory(String loginCategory) {
        if (loginCategory != null) {
            this.m_chCategory.select(loginCategory);
        }
    }
}

