/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifp;

import java.awt.Component;
import java.awt.Font;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Vector;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.LWList;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.shuttle.ListPicker;
import oracle.ewt.shuttle.MultiItemPicker;
import oracle.ewt.shuttle.Shuttle;
import oracle.ewt.shuttle.ToMultiItemPicker;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiic.OiicStageSession;
import oracle.sysman.oii.oiif.oiifp.OiifpWizPanel;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiifpStgPLSelPanel
extends OiifpWizPanel {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 256;
    private final int HGAP = 5;
    private final int VGAP = 5;
    private final int VIS_LINES = 12;
    private boolean m_platSel;
    private Vector m_avails;
    private LWList m_availableList;
    private LWList m_selectedList;
    private ListPicker m_availablePick;
    private ListPicker m_selectedPick;
    private Shuttle m_shuttle;
    private MultiLineLabel m_promptLabel;
    private OiicStageSession m_session;

    public OiifpStgPLSelPanel(OiicPullSession session, boolean platSel) {
        super(OiixResourceBundle.getString("S_STAGE_SEL"));
        this.m_session = (OiicStageSession)session;
        this.m_platSel = platSel;
        Object[] entityName = new String[]{this.m_platSel ? OiixResourceBundle.getString("S_PLATFORMS") : OiixResourceBundle.getString("S_LANGUAGES")};
        String prompt = OiixResourceBundle.getString("S_PL_PROMPT");
        prompt = MessageFormat.format(prompt, entityName);
        this.m_promptLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), prompt);
        this.m_promptLabel.setFont(new Font(OiixResourceBundle.getFont(), 1, 14));
        this.m_promptLabel.setPreferredAspectRatio(0.0f);
        this.mainPanel.add((Component)this.m_promptLabel, (Object)"North");
        String availLabelStr = OiixResourceBundle.getString("S_AVAILABLE") + (String)entityName[0];
        String selLabelStr = OiixResourceBundle.getString("S_SELECTED") + (String)entityName[0];
        LWLabel availLabel = new LWLabel(availLabelStr);
        LWLabel selectLabel = new LWLabel(selLabelStr);
        this.m_availableList = new LWList(12, true);
        this.m_selectedList = new LWList(12, true);
        this.m_availablePick = new ListPicker(this.m_availableList);
        this.m_selectedPick = new ListPicker(this.m_selectedList);
        this.m_shuttle = new Shuttle();
        this.m_availablePick.setSortItems(true);
        this.m_selectedPick.setSortItems(true);
        this.m_shuttle.setFromHeader((Component)availLabel);
        this.m_shuttle.setToHeader((Component)selectLabel);
        this.m_shuttle.setFromPicker((MultiItemPicker)this.m_availablePick);
        this.m_shuttle.setToPicker((ToMultiItemPicker)this.m_selectedPick);
        this.m_shuttle.setMoveAllAllowed(false);
        this.m_shuttle.setReorderingAllowed(false);
        this.m_shuttle.setMode(0);
        this.m_shuttle.setHorizontalLayout(true);
        this.mainPanel.add((Component)this.m_shuttle, (Object)"Center");
    }

    public void init() {
        OiiiCompInstallID[] compIDs = this.m_session.getSelTopLevelCompIDs();
        this.m_avails = new Vector();
        for (int i = 0; i < compIDs.length; ++i) {
            Vector compAvailVect = this.m_platSel ? this.m_session.getStgCompPlats(compIDs[i]) : this.m_session.getStgCompLangs(compIDs[i]);
            OiixVectorOps.unionInPlace(this.m_avails, compAvailVect);
        }
        OiicSessionContext oContext = this.m_session.getSessionContext();
        OiisVariable oSels = oContext.getVariable(this.m_platSel ? "SELECTED_PLATFORMS" : "SELECTED_LANGUAGES");
        Vector vSels = (Vector)oSels.getValue();
        if (vSels == null) {
            vSels = new Vector();
        }
        this.populateLists(this.m_avails, vSels);
    }

    public void populateLists(Vector avails, Vector vSels) {
        this.m_availableList.removeAll();
        this.m_selectedList.removeAll();
        Vector dispAvails = this.getDisplayForm(avails);
        Vector dispSels = this.getDisplayForm(vSels);
        OiixVectorOps.subtractInPlace(dispAvails, dispSels);
        if (avails != null) {
            String displayString;
            int i;
            for (i = 0; i < dispAvails.size(); ++i) {
                displayString = (String)dispAvails.elementAt(i);
                this.m_availableList.add(displayString);
            }
            for (i = 0; i < dispSels.size(); ++i) {
                displayString = (String)dispSels.elementAt(i);
                this.m_selectedList.add(displayString);
            }
        }
    }

    private Vector getDisplayForm(Vector natFormVect) {
        int numElems = natFormVect.size();
        Vector<String> retVect = new Vector<String>(numElems);
        for (int i = 0; i < numElems; ++i) {
            if (this.m_platSel) {
                int plat = (Integer)natFormVect.elementAt(i);
                retVect.addElement(OiixPlatform.getPlatformName(plat));
                continue;
            }
            Locale loc = (Locale)natFormVect.elementAt(i);
            retVect.addElement(loc.getDisplayName());
        }
        return retVect;
    }

    private Vector getNativeForm(Vector dispFormVect) {
        int numElems = dispFormVect.size();
        Vector<Serializable> retVect = new Vector<Serializable>(numElems);
        for (int i = 0; i < numElems; ++i) {
            if (this.m_platSel) {
                int plat = OiixPlatform.getPlatformID((String)dispFormVect.elementAt(i));
                retVect.addElement(new Integer(plat));
                continue;
            }
            String locStr = (String)dispFormVect.elementAt(i);
            Locale curLoc = null;
            int numAvails = this.m_avails.size();
            for (int j = 0; j < numAvails; ++j) {
                Locale loc = (Locale)this.m_avails.elementAt(j);
                if (!loc.getDisplayName().equals(locStr)) continue;
                curLoc = loc;
                break;
            }
            retVect.addElement(curLoc);
        }
        return retVect;
    }

    public Vector getShuttleSel() {
        String[] selected = this.m_selectedList.getItems();
        Vector selDispVect = OiixVectorOps.strArr2Vect(selected);
        Vector selNatVect = this.getNativeForm(selDispVect);
        return selNatVect;
    }

    public void setShuttleSel(Vector sels) {
        this.m_selectedList.removeAll();
        Vector addVect = this.getDisplayForm(sels);
        int numSels = addVect.size();
        for (int i = 0; i < numSels; ++i) {
            this.m_selectedList.add((String)addVect.elementAt(i));
        }
    }
}

