/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifp;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Locale;
import java.util.Vector;
import oracle.ewt.button.PushButton;
import oracle.ewt.lwAWT.BufferedDialog;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.util.WindowUtils;
import oracle.sysman.oii.oiic.OiicInstallSession;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiif.oiifj.OiifjLangsDlg;
import oracle.sysman.oii.oiif.oiifm.OiifmGraphicInterfaceManager;
import oracle.sysman.oii.oiif.oiifm.OiifmInfo;
import oracle.sysman.oii.oiif.oiifm.OiifmSingleSelectPanel;
import oracle.sysman.oii.oiif.oiifp.OiifpWizPanel;
import oracle.sysman.oii.oiif.oiifw.OiifwTopLevelSelWCDE;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiPatchSetInstallID;
import oracle.sysman.oii.oiii.OiiiStageInventory;
import oracle.sysman.oii.oiis.OiisAdvisedValue;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiix.OiixLanguage;
import oracle.sysman.oii.oiix.OiixOraparam;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiifpTopLevelSelPanel
extends OiifpWizPanel
implements ActionListener,
ItemListener {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 256;
    private static final int HGAP = 5;
    private static final int VGAP = 5;
    private Vector m_compIDs = null;
    private OiicPullSession m_pullSession = null;
    private OiifmSingleSelectPanel m_compPanel = null;
    private LWContainer m_coverPanel = null;
    private Vector m_vLangs = null;
    private String m_sSelected = null;

    public OiifpTopLevelSelPanel() {
        super(OiixResourceBundle.getString("S_AVAIL_PRODS"));
    }

    public void createPanelElements() {
        this.m_pullSession = this.m_wcde.getVarOwner().getSession();
        this.m_vLangs = null;
        Vector tlcomps = this.m_pullSession.getAvailTopLevelCompIDs();
        int numTLElems = tlcomps.size();
        this.m_compIDs = new Vector(numTLElems);
        OiifmInfo[] compInfo = new OiifmInfo[numTLElems];
        for (int i = 0; i < numTLElems; ++i) {
            OiiiCompInstallID cid = (OiiiCompInstallID)tlcomps.elementAt(i);
            compInfo[i] = new OiifmInfo();
            compInfo[i].name = OiixOraparam.showVersion() ? this.getCompInvEntry(cid).getFullDisplayName(OiixOraparam.canIgnoreBuildNumber(), false) : this.getCompInvEntry(cid).getName();
            compInfo[i].desc = this.getCompInvEntry(cid).getDescription();
            this.m_compIDs.addElement(cid);
        }
        String selectPrompt = OiixResourceBundle.getString("S_CHOOSE_PROD_PROMPT");
        this.m_compPanel = new OiifmSingleSelectPanel(selectPrompt, compInfo);
        this.m_compPanel.setSelection(0);
        this.m_compPanel.setInfoHelpID("OiifdCompInfoDlg");
        this.m_compPanel.setInfoTitleID("S_PROD_INFO_LABEL");
        this.m_compPanel.addItemListener(this);
        this.m_coverPanel = new LWContainer();
        this.dlgPanel.add((Component)this.m_coverPanel, (Object)"Center");
        LWContainer bottomPanel = new LWContainer((LayoutManager)new BorderLayout());
        boolean bShowLanguageButton = ((OiifwTopLevelSelWCDE)this.m_wcde).showLanguageButton();
        if (bShowLanguageButton) {
            String str = OiixResourceBundle.getString("S_CHANGE_LANGUAGES_BUTTON");
            this.m_languageButton = new PushButton(str);
            this.m_languageButton.setEnabled(true);
            this.m_languageButton.setFocusable(true);
            this.m_languageButton.setLeftmost(true);
            this.m_languageButton.setRightmost(true);
            this.m_languageButton.addActionListener((ActionListener)this);
            this.m_languageButton.setVisible(true);
            bottomPanel.add((Component)this.m_languageButton, (Object)"East");
        }
        this.dlgPanel.add((Component)bottomPanel, (Object)"South");
        this.setLanguageButtonState();
        OiifmGraphicInterfaceManager ogim = (OiifmGraphicInterfaceManager)OiicSessionInterfaceManager.getInterfaceManager();
        ogim.getWizardDialog().setViewOnly(true);
    }

    public void validate() {
        if (this.getParent() != null && this.m_coverPanel != null) {
            Dimension cDim = this.m_coverPanel.getSize();
            if (this.compPanelTooTall(cDim)) {
                this.m_compPanel.forceListDisplay();
            }
            this.dlgPanel.remove((Component)this.m_coverPanel);
            this.dlgPanel.add((Component)((Object)this.m_compPanel));
            if (this.m_sSelected != null) {
                this.m_compPanel.setSelection(this.m_sSelected);
            } else {
                this.m_compPanel.setSelection(0);
            }
            this.m_coverPanel = null;
            this.dlgPanel.repaint();
        }
        super.validate();
    }

    private boolean compPanelTooTall(Dimension maxDim) {
        BufferedDialog dummyDlg = new BufferedDialog(WindowUtils.parentFrame((Component)((Object)this)));
        dummyDlg.setLayout((LayoutManager)new BorderLayout());
        dummyDlg.add((Component)((Object)this.m_compPanel));
        dummyDlg.pack();
        Insets i = dummyDlg.getInsets();
        Dimension dDim = new Dimension(maxDim.width + i.left + i.right, maxDim.height + i.top + i.bottom);
        dummyDlg.setSize(dDim);
        dummyDlg.validate();
        Dimension pDim = this.m_compPanel.getPreferredSize();
        if (pDim.height > maxDim.height) {
            dummyDlg.remove((Component)((Object)this.m_compPanel));
            dummyDlg.dispose();
        }
        return pDim.height > maxDim.height;
    }

    private OiiiCompInvEntry getCompInvEntry(OiiiCompInstallID cid) {
        OiiiStageInventory i = this.m_pullSession.getSourceAccess().getStageInventory();
        OiiiCompInvEntry entry = null;
        entry = i instanceof OiiiInstallInventory ? ((OiiiInstallInventory)((Object)i)).getInstallCompInvEntry(cid, 0) : i.getStageCompInvEntry(cid);
        return entry;
    }

    public OiiiCompInstallID getTopLevelComp() {
        int index;
        if (this.m_compPanel != null && (index = this.m_compPanel.getSelectionIndex()) != -1) {
            return (OiiiCompInstallID)this.m_compIDs.elementAt(index);
        }
        return null;
    }

    public void setTopLevelComp(OiiiPatchSetInstallID comp) {
        this.setTopLevelComp((OiiiCompInstallID)comp);
    }

    public void setTopLevelComp(OiiiCompInstallID comp) {
        if (this.m_compPanel != null && this.m_compIDs != null) {
            String compName;
            OiiiCompInvEntry cie = this.getCompInvEntry(comp);
            this.m_sSelected = compName = OiixOraparam.showVersion() ? cie.getFullDisplayName() : cie.getName();
            this.m_compPanel.setSelection(compName);
            ((OiifwTopLevelSelWCDE)this.m_wcde).setCompInstallID(comp);
            this.setLanguageButtonState();
        }
    }

    public Vector getLangsSel() {
        Vector validLangs = this.getValidatedLangs();
        if (validLangs == null || validLangs.size() <= 0) {
            validLangs = this.getDefaultLangs();
        }
        return validLangs;
    }

    public void setLangsSel(Vector langs) {
        this.m_vLangs = langs;
    }

    private Vector getValidatedLangs() {
        OiiiCompInstallID tlComp;
        Vector<Locale> validLangs = new Vector<Locale>();
        if (this.m_vLangs != null && this.m_vLangs.size() > 0 && (tlComp = this.getTopLevelComp()) != null) {
            Vector langs = this.m_pullSession.getStgCompLangs(tlComp);
            int size = this.m_vLangs.size();
            for (int i = 0; i < size; ++i) {
                Locale curLocale = (Locale)this.m_vLangs.elementAt(i);
                int nIndex = OiixVectorOps.vectIndexOf(langs, (Object)curLocale);
                if (nIndex == -1) continue;
                validLangs.addElement(curLocale);
            }
        }
        return validLangs;
    }

    private Vector getDefaultLangs() {
        Vector vLangs = new Vector();
        OiiiCompInstallID tlComp = this.getTopLevelComp();
        Locale l = Locale.getDefault();
        if (tlComp != null) {
            Vector langs;
            int nIndex = OiixVectorOps.vectIndexOf(langs = this.m_pullSession.getStgCompLangs(tlComp), (Object)l);
            vLangs.addElement(langs.elementAt(-1 == nIndex ? 0 : nIndex));
        } else {
            vLangs.addElement(l);
        }
        return vLangs;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_languageButton) {
            OiicInstallSession instSession = (OiicInstallSession)this.m_pullSession;
            try {
                OiicSessionContext sessionContext = instSession.getSessionContext();
                OiisVariable oTopLevelVar = sessionContext.getVariable("ToplevelComp");
                OiiiCompInstallID selectedId = this.getTopLevelComp();
                oTopLevelVar.setValue(new OiisAdvisedValue(selectedId, false));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            OiifjLangsDlg dlg = new OiifjLangsDlg((Frame)((Object)instSession.getMainFrame()), instSession);
            OiiiCompInstallID[] topLevelIDs = new OiiiCompInstallID[]{this.getTopLevelComp()};
            dlg.doModal();
            OiicSessionContext sessionContext = instSession.getSessionContext();
            OiisVariable oSelLangs = sessionContext.getVariable("SELECTED_LANGUAGES");
            String[] strLang = (String[])oSelLangs.getValue();
            Vector vLangs = OiixLanguage.getLangsVector(strLang);
            this.m_pullSession.setSelectedLanguages(vLangs);
        }
    }

    public void itemStateChanged(ItemEvent e) {
        this.setLanguageButtonState();
        OiiiCompInstallID selectedId = this.getTopLevelComp();
        ((OiifwTopLevelSelWCDE)this.m_wcde).setCompInstallID(selectedId);
    }

    private void setLanguageButtonState() {
        if (null != this.m_languageButton) {
            OiiiCompInstallID selectedId = this.getTopLevelComp();
            this.m_languageButton.setEnabled(selectedId.getCompType() != 4);
        }
    }

    public void dispose() {
        if (null != this.m_compIDs) {
            this.m_compIDs.removeAllElements();
        }
        if (null != this.m_compPanel) {
            this.m_compPanel.removeAll();
            this.m_compPanel = null;
        }
        if (this.m_coverPanel != null) {
            this.m_coverPanel.removeAll();
            this.m_coverPanel = null;
        }
        this.m_languageButton = null;
        if (this.m_vLangs != null) {
            this.m_vLangs.removeAllElements();
            this.m_vLangs = null;
        }
        this.removeAll();
        this.removeNotify();
        this.m_pullSession = null;
    }

    public void updateEnabledComponentsStatus(boolean p_bButtonStatus) {
        super.updateEnabledComponentsStatus(p_bButtonStatus);
        if (null != this.m_compPanel) {
            this.m_compPanel.setEnabled(p_bButtonStatus);
        }
        if (null != this.m_coverPanel) {
            this.m_coverPanel.setEnabled(p_bButtonStatus);
        }
    }
}

