/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifp;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Vector;
import oracle.ewt.button.PushButton;
import oracle.ewt.comboBox.ComboBox;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.textWrapper.TextWrapper;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.ewt.util.WindowUtils;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiif.oiifd.OiifdPubPS;
import oracle.sysman.oii.oiif.oiifj.OiifjDirectoryDlg;
import oracle.sysman.oii.oiif.oiifm.OiifmCursorUtil;
import oracle.sysman.oii.oiif.oiifm.OiifmGraphicInterfaceManager;
import oracle.sysman.oii.oiif.oiifm.OiifmTitlePanel;
import oracle.sysman.oii.oiif.oiifp.OiifpWizPanel;
import oracle.sysman.oii.oiif.oiifw.OiifwInstLocWCDE;
import oracle.sysman.oii.oiif.oiifw.OiifwWizDialog;
import oracle.sysman.oii.oiig.OiigAuthDetails;
import oracle.sysman.oii.oiig.OiigServerConfig;
import oracle.sysman.oii.oiig.OiigSourceConfigs;
import oracle.sysman.oii.oiii.OiiiAreaInventory;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiii.OiiiTargetAreaControl;
import oracle.sysman.oii.oiil.OiilNativeException;
import oracle.sysman.oii.oiip.oiipg.OiipgEnvironment;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiip.oiipg.OiipgOracleHomes;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixLanguage;
import oracle.sysman.oii.oiix.OiixOraparam;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifpWizLocPanel
extends OiifpWizPanel
implements ActionListener,
FilenameFilter,
ItemListener,
TextListener {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 256;
    private final int CONTENT_GAP = 3;
    private final int PANEL_GAP = 10;
    private final int BUTTON_VGAP = 10;
    private String m_strSourceLocationOld = null;
    private String m_strHomeNameOld = null;
    private String m_strHomeLocationOld = null;
    private boolean m_stgMode = false;
    private PushButton m_fromBrowse = null;
    private ComboBox m_fromCombo = null;
    private boolean m_bLoginStuffAdded = false;
    private LWLabel m_loginStatus = null;
    private PushButton m_settingsBtn = null;
    private OiifpHomePanel m_oOracleHomePanel = null;
    private OiifpHomePanel m_oApplTopPanel = null;
    private transient OiifwWizDialog m_wd;
    private OiiiInstallInventory m_inventory = null;
    private FileDialog m_fromBrowseDlg = null;
    private Font font_bold = null;
    private TextWrapper twrap = null;
    private OiiiOracleHomeInfo[] m_ohi = null;
    private OiipgFileSystem m_pgFS = null;
    private OiigSourceConfigs m_srcCfgs = null;
    private OiisVariableOwner m_vo = null;
    private char m_cIsPanelDirty = (char)78;
    private boolean m_bShowAppltop = false;

    public OiifpWizLocPanel() {
        super(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_FILE_LOC"));
        this.m_pgFS = new OiipgFileSystem();
    }

    public void createPanelElements() {
        OiiiAreaInventory tmp;
        OiiiTargetAreaControl invAreaControl;
        OiifwInstLocWCDE ilwcde = (OiifwInstLocWCDE)this.m_wcde;
        this.m_bShowAppltop = ilwcde.isShowApplTop();
        this.m_vo = ilwcde.getVarOwner();
        this.m_srcCfgs = this.m_vo.getSession().getSourceConfigs();
        this.m_cIsPanelDirty = (char)78;
        OiisVariable invLoc = this.m_vo.getVariable("INVENTORY_LOCATION");
        if (invLoc.getAdvice() && (invAreaControl = OiiiInstallAreaControl.getInventoryAreaControl()) != null && (tmp = invAreaControl.getAreaInventory()) instanceof OiiiInstallInventory) {
            this.m_inventory = (OiiiInstallInventory)tmp;
        }
        this.twrap = WordWrapper.getTextWrapper();
        this.font_bold = new Font(OiixResourceBundle.getFont(), OiixLanguage.getFontStyle(1), 14);
        this.dlgPanel.setLayout((LayoutManager)new BorderLayout(0, 0));
        LWContainer locPanel = new LWContainer((LayoutManager)new GridLayout(2, 1));
        LWContainer fromPanel = this.createFromPanel("");
        locPanel.add((Component)fromPanel);
        LWContainer toPanel = this.createToPanel("");
        locPanel.add((Component)toPanel);
        this.dlgPanel.add((Component)locPanel, (Object)"Center");
        LWContainer oPanel = new LWContainer((LayoutManager)new BorderLayout(0, 0));
        oPanel.add((Component)this.createOptionsPanel(), (Object)"East");
        this.dlgPanel.add((Component)oPanel, (Object)"South");
        OiifmGraphicInterfaceManager ogim = (OiifmGraphicInterfaceManager)OiicSessionInterfaceManager.getInterfaceManager();
        OiifwWizDialog wd = ogim.getWizardDialog();
        wd.setViewOnly(false);
        wd.setNavButtonState(8, true);
        wd.setNavButtonState(4, true);
        wd.setNavButtonState(1, true);
        wd.setNavButtonState(16, false);
        this.validate();
    }

    private LWContainer createFromPanel(String from) {
        LWContainer aPanel = new LWContainer((LayoutManager)new BorderLayout(0, 0));
        String prompt = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_FROM");
        LWLabel bodyLabel3 = new LWLabel(prompt);
        bodyLabel3.setFont(this.font_bold);
        LWContainer pPanel = new LWContainer((LayoutManager)new BorderLayout(0, 0));
        OiifmTitlePanel titlePanel = new OiifmTitlePanel((LWComponent)bodyLabel3, (LWComponent)pPanel);
        aPanel.add((Component)((Object)titlePanel), (Object)"Center");
        prompt = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_FROM_PROMPT");
        MultiLineLabel promptLabel = new MultiLineLabel(this.twrap, prompt);
        promptLabel.setPreferredAspectRatio(0.0f);
        pPanel.add((Component)promptLabel, (Object)"North");
        LWContainer dPanel = new LWContainer();
        GridBagLayout gridbag = new GridBagLayout();
        dPanel.setLayout((LayoutManager)gridbag);
        pPanel.add((Component)dPanel, (Object)"Center");
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(3, 0, 3, 3);
        c.anchor = 18;
        c.weightx = 0.01;
        c.weighty = 0.98;
        c.gridwidth = 1;
        c.fill = 2;
        String locStr = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_FROM_PATH_LABEL");
        LWLabel locLabel = new LWLabel(locStr);
        gridbag.setConstraints((Component)locLabel, c);
        dPanel.add((Component)locLabel);
        c.weightx = 0.98;
        c.gridwidth = -1;
        c.fill = 2;
        this.m_fromCombo = new ComboBox();
        this.addSrcsToCombo(this.m_fromCombo);
        String string = from = null != from ? from.trim() : "";
        if (0 >= from.length()) {
            if (this.m_fromCombo.getItemCount() > 0) {
                this.comboSelect(this.m_fromCombo, 0);
            }
        } else {
            this.comboSelect(this.m_fromCombo, from);
        }
        this.m_fromCombo.addTextListener((TextListener)this);
        this.m_fromCombo.addItemListener((ItemListener)this);
        gridbag.setConstraints((Component)this.m_fromCombo, c);
        dPanel.add((Component)this.m_fromCombo);
        locLabel.setLabelFor((Component)this.m_fromCombo);
        c.weightx = 0.01;
        c.gridwidth = 0;
        String str = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_FROM_BROWSE_BUTTON");
        this.m_fromBrowse = new PushButton(str);
        this.m_fromBrowse.setEnabled(true);
        this.m_fromBrowse.setFocusable(true);
        this.m_fromBrowse.addActionListener((ActionListener)this);
        this.m_fromBrowse.setRightmost(true);
        this.m_fromBrowse.setVisible(true);
        gridbag.setConstraints((Component)this.m_fromBrowse, c);
        dPanel.add((Component)this.m_fromBrowse);
        this.m_bLoginStuffAdded = this.pubSvrInList();
        if (this.m_bLoginStuffAdded) {
            LWContainer ePanel = new LWContainer();
            gridbag = new GridBagLayout();
            ePanel.setLayout((LayoutManager)gridbag);
            pPanel.add((Component)ePanel, (Object)"South");
            c = new GridBagConstraints();
            c.weightx = 0.4;
            c.gridwidth = 1;
            this.m_loginStatus = new LWLabel("", 40);
            gridbag.setConstraints((Component)this.m_loginStatus, c);
            ePanel.add((Component)this.m_loginStatus);
            c.weightx = 0.3;
            c.gridwidth = -1;
            LWContainer emptySpace = new LWContainer();
            gridbag.setConstraints((Component)emptySpace, c);
            ePanel.add((Component)emptySpace);
            c.weightx = 0.3;
            c.gridwidth = 0;
            str = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CHG_LOGIN_SETTINGS");
            this.m_settingsBtn = new PushButton(str);
            this.m_settingsBtn.setEnabled(true);
            this.m_settingsBtn.addActionListener((ActionListener)this);
            this.m_settingsBtn.setLeftmost(true);
            this.m_settingsBtn.setRightmost(true);
            this.m_settingsBtn.setVisible(true);
            gridbag.setConstraints((Component)this.m_settingsBtn, c);
            ePanel.add((Component)this.m_settingsBtn);
            this.calcLoginStatus();
        }
        return aPanel;
    }

    private boolean pubSvrInList() {
        return !this.m_srcCfgs.getPubSvrURLs().isEmpty();
    }

    private void addSrcsToCombo(ComboBox fromCombo) {
        this.clearList();
        Vector stgs = this.m_srcCfgs.getStgAreaURLs();
        int numStgs = stgs.size();
        for (int i = 0; i < numStgs; ++i) {
            fromCombo.add((String)stgs.elementAt(i));
        }
        Vector svrs = this.m_srcCfgs.getPubSvrURLs();
        int numSvrs = svrs.size();
        for (int i = 0; i < numSvrs; ++i) {
            fromCombo.add((String)svrs.elementAt(i));
        }
    }

    public void calcLoginStatus() {
        if (!this.m_bLoginStuffAdded) {
            return;
        }
        boolean bKnownStgArea = false;
        boolean bKnownPubSvr = false;
        String fromLoc = this.getSourceLocation();
        String statStr = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_LOGIN_STATUS");
        String status = "";
        Vector stgs = this.m_srcCfgs.getStgAreaURLs();
        int numStgs = stgs.size();
        for (int i = 0; i < numStgs; ++i) {
            if (!fromLoc.equals((String)stgs.elementAt(i))) continue;
            bKnownStgArea = true;
            break;
        }
        if (bKnownStgArea) {
            status = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_LOGIN_NA");
        } else {
            Vector svrs = this.m_srcCfgs.getPubSvrURLs();
            int numSvrs = svrs.size();
            for (int i = 0; i < numSvrs; ++i) {
                if (!fromLoc.equals((String)svrs.elementAt(i))) continue;
                bKnownPubSvr = true;
                break;
            }
            if (bKnownPubSvr) {
                OiigServerConfig svrCfg = this.m_srcCfgs.getSvrConfig(fromLoc);
                OiigAuthDetails authDets = svrCfg.getAuthDets();
                if (authDets.isAnonLogin()) {
                    status = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_LOGIN_ANONLOGIN");
                } else {
                    Object[] statParms = new String[]{authDets.getUsername(), authDets.getCategory()};
                    status = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_LOGIN_SPEC");
                    status = MessageFormat.format(status, statParms);
                }
            } else {
                status = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_LOGIN_UNSPEC");
            }
        }
        statStr = bKnownPubSvr ? MessageFormat.format(statStr, status) : "                                       ";
        this.m_loginStatus.setText(statStr);
        this.m_loginStatus.repaint();
        this.m_settingsBtn.setEnabled(bKnownPubSvr);
    }

    private LWContainer createToPanel(String to) {
        LWContainer aPanel = new LWContainer((LayoutManager)new BorderLayout(0, 0));
        int nRows = this.m_bShowAppltop ? 2 : 1;
        String prompt = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_TO");
        LWLabel bodyLabel3 = new LWLabel(prompt);
        bodyLabel3.setFont(this.font_bold);
        LWContainer oDestinationPanel = new LWContainer((LayoutManager)new GridLayout(nRows, 1));
        OiifmTitlePanel titlePanel = new OiifmTitlePanel((LWComponent)bodyLabel3, (LWComponent)oDestinationPanel);
        aPanel.add((Component)((Object)titlePanel), (Object)"Center");
        prompt = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_TO_PROMPT");
        this.m_oOracleHomePanel = new OiifpHomePanel(0, prompt);
        oDestinationPanel.add((Component)((Object)this.m_oOracleHomePanel));
        if (this.m_bShowAppltop) {
            prompt = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_APPLTOP_PROMPT");
            this.m_oApplTopPanel = new OiifpHomePanel(1, prompt);
            oDestinationPanel.add((Component)((Object)this.m_oApplTopPanel));
        }
        return aPanel;
    }

    private LWContainer createOptionsPanel() {
        LWContainer bPanel = new LWContainer();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.insets.bottom = 10;
        c.weightx = 1.0;
        c.fill = 2;
        c.gridwidth = 0;
        bPanel.setLayout((LayoutManager)gridbag);
        String str = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ABOUT_BUTTON");
        this.m_aboutButton = new PushButton(str);
        this.m_aboutButton.setEnabled(true);
        this.m_aboutButton.setFocusable(true);
        this.m_aboutButton.setLeftmost(true);
        this.m_aboutButton.setRightmost(true);
        c.weighty = 0.9;
        c.anchor = 16;
        gridbag.setConstraints((Component)this.m_aboutButton, c);
        this.m_aboutButton.addActionListener((ActionListener)this);
        this.m_aboutButton.setVisible(true);
        bPanel.add((Component)this.m_aboutButton);
        return bPanel;
    }

    public void setWizDialog(OiifwWizDialog wd) {
        this.m_wd = wd;
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        OiifmCursorUtil.setCursor(this.waitCursor, (Component)((Object)this));
        if (source == this.m_fromBrowse) {
            this.onFromBrowse();
        } else if (source == this.m_aboutButton) {
            this.getWizDialog().onAbout(false);
        } else if (source == this.m_settingsBtn) {
            OiifdPubPS ps = new OiifdPubPS(this.m_srcCfgs);
            ps.launchDialog((Component)((Object)this), true);
            this.calcLoginStatus();
            if (ps.hasDeletion()) {
                this.addSrcsToCombo(this.m_fromCombo);
            }
        }
        OiifmCursorUtil.setCursor(this.defCursor, (Component)((Object)this));
        if (source instanceof Component) {
            ((Component)source).requestFocus();
        }
    }

    private synchronized void onFromBrowse() {
        if (this.m_fromBrowseDlg == null) {
            this.m_fromBrowseDlg = new FileDialog(WindowUtils.parentFrame((Component)((Object)this)), OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_FROM"), 0);
            this.m_fromBrowseDlg.setVisible(false);
        }
        if (this.m_fromBrowseDlg.isVisible()) {
            this.m_fromBrowseDlg.toFront();
        } else {
            File curFile;
            String dirLoc;
            WindowUtils.centerWindow((Window)this.m_fromBrowseDlg, (Component)WindowUtils.parentFrame((Component)((Object)this)));
            this.m_fromBrowseDlg.setFilenameFilter(this);
            this.m_fromBrowseDlg.setFile("products.xml");
            this.comboSelect(this.m_fromCombo, this.getSourceLocation());
            String sFile = this.m_fromCombo.getSelectedItem();
            if (null == sFile) {
                sFile = System.getProperty("user.dir");
            }
            String string = dirLoc = (curFile = new File(sFile)).isDirectory() ? curFile.getPath() : curFile.getParent();
            if (null != dirLoc) {
                this.m_fromBrowseDlg.setDirectory(dirLoc);
            }
            this.m_fromBrowseDlg.setVisible(true);
            if (null != this.m_fromBrowseDlg.getDirectory() && null != this.m_fromBrowseDlg.getFile()) {
                this.comboSelect(this.m_fromCombo, this.m_fromBrowseDlg.getDirectory() + this.m_fromBrowseDlg.getFile());
            }
        }
    }

    private void clearList() {
        if (null != this.m_fromCombo) {
            this.m_fromCombo.removeAll();
        }
    }

    public boolean accept(File dir, String name) {
        return null != name ? name.equals("products.xml") : false;
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1 && e.getSource() == this.m_fromCombo) {
            this.calcLoginStatus();
        }
    }

    public void textValueChanged(TextEvent e) {
        Object baseSource;
        Object source = baseSource = e.getSource();
        if (baseSource instanceof LWTextField) {
            source = ((LWTextField)baseSource).getParent();
        }
        if (source instanceof ComboBox && e.getID() == 900 && source == this.m_fromCombo) {
            this.calcLoginStatus();
        }
    }

    public void updatePanel() {
        this.m_oOracleHomePanel.refreshCombos(0);
        if (this.m_oApplTopPanel != null) {
            this.m_oApplTopPanel.refreshCombos(1);
        }
    }

    private String getCurrentHomePath(int nHomeType) {
        String val = null;
        String sHomeVarName = "ORACLE_HOME";
        switch (nHomeType) {
            case 0: {
                sHomeVarName = "ORACLE_HOME";
                break;
            }
            case 1: {
                sHomeVarName = "APPLTOP";
            }
        }
        OiisVariable oHome = this.m_vo.getVariable(sHomeVarName);
        if (null != oHome) {
            val = (String)oHome.getValue();
        }
        return val;
    }

    private void refreshOHList() {
        Vector ouiOHs = this.m_inventory != null ? (Vector)this.m_inventory.getHomes().clone() : new Vector();
        Vector i33Homes = null;
        try {
            i33Homes = OiipgOracleHomes.getOsdOracleHomeInfo();
        }
        catch (OiilNativeException e) {
            i33Homes = null;
        }
        int ohsize = ouiOHs.size();
        if (i33Homes != null) {
            int i33Size = i33Homes.size();
            for (int j = 0; j < i33Size; ++j) {
                OiiiOracleHomeInfo i33Home = (OiiiOracleHomeInfo)i33Homes.elementAt(j);
                boolean homeExists = false;
                for (int k = 0; k < ohsize; ++k) {
                    OiiiOracleHomeInfo ohi = (OiiiOracleHomeInfo)ouiOHs.elementAt(k);
                    if (!this.m_pgFS.areLocsSame(ohi.getLocation(), i33Home.getLocation())) continue;
                    homeExists = true;
                }
                if (homeExists) continue;
                ouiOHs.addElement(i33Home);
            }
        }
        this.m_ohi = new OiiiOracleHomeInfo[ouiOHs.size()];
        ouiOHs.copyInto(this.m_ohi);
    }

    public String getSourceLocation() {
        String sLocation = this.m_fromCombo.getSelectedItem();
        if (null != sLocation) {
            sLocation = sLocation.trim();
        }
        return sLocation;
    }

    public String getOracleHome() {
        return this.m_oOracleHomePanel.getHomeLocation();
    }

    public String getOracleHomeName() {
        return this.m_oOracleHomePanel.getHomeName();
    }

    public int getToLocationIndex() {
        return this.m_oOracleHomePanel.getSelectedHomeIndex(0);
    }

    public void setSourceLocation(String from) {
        this.m_strSourceLocationOld = from;
        this.comboSelect(this.m_fromCombo, from);
    }

    public void setOracleHomeName(String name) {
        this.m_strHomeNameOld = name;
        this.m_oOracleHomePanel.setHomeName(name);
    }

    public void setOracleHome(String newLoc) {
        this.m_strHomeLocationOld = newLoc;
        this.m_oOracleHomePanel.setHomeLocation(newLoc);
    }

    public void updateEnabledComponentsStatus(boolean p_bButtonStatus) {
        super.updateEnabledComponentsStatus(p_bButtonStatus);
        if (null != this.m_fromBrowse) {
            this.m_fromBrowse.setFocusable(p_bButtonStatus);
            this.m_fromBrowse.setEnabled(p_bButtonStatus);
        }
        if (null != this.m_fromBrowseDlg) {
            this.m_fromBrowseDlg.setEnabled(p_bButtonStatus);
        }
        if (null != this.m_fromCombo) {
            this.m_fromCombo.setEnabled(p_bButtonStatus);
        }
        if (null != this.m_oOracleHomePanel) {
            this.m_oOracleHomePanel.updateEnabledComponentsStatus(p_bButtonStatus);
        }
        if (null != this.m_oApplTopPanel) {
            this.m_oApplTopPanel.updateEnabledComponentsStatus(p_bButtonStatus);
        }
    }

    public void dispose() {
        this.m_vo = null;
        this.m_inventory = null;
        this.m_wd = null;
        this.m_fromBrowse = null;
        if (null != this.m_fromBrowseDlg) {
            this.m_fromBrowseDlg.dispose();
            this.m_fromBrowseDlg = null;
        }
        this.m_fromCombo = null;
        if (null != this.m_oOracleHomePanel) {
            this.m_oOracleHomePanel.dispose();
            this.m_oOracleHomePanel = null;
        }
        if (null != this.m_oApplTopPanel) {
            this.m_oApplTopPanel.dispose();
            this.m_oApplTopPanel = null;
        }
    }

    public boolean isPanelDirty() {
        if (this.m_cIsPanelDirty == 'N') {
            this.m_cIsPanelDirty = (char)84;
            String sSourceLocationNew = this.getSourceLocation();
            String sHomeNameNew = this.getOracleHomeName();
            String sHomeLocNew = this.getOracleHome();
            if (null != sSourceLocationNew && null != this.m_strSourceLocationOld && null != sHomeNameNew && null != this.m_strHomeNameOld && null != sHomeLocNew && null != this.m_strHomeLocationOld) {
                this.m_cIsPanelDirty = (char)(sSourceLocationNew.equals(this.m_strSourceLocationOld) ? 70 : 84);
                if (this.m_cIsPanelDirty == 'F') {
                    this.m_cIsPanelDirty = (char)(sHomeNameNew.equals(this.m_strHomeNameOld) ? 70 : 84);
                    if (this.m_cIsPanelDirty == 'F') {
                        this.m_cIsPanelDirty = (char)(sHomeLocNew.equals(this.m_strHomeLocationOld) ? 70 : 84);
                        if (this.m_cIsPanelDirty == 'F') {
                            this.m_cIsPanelDirty = (char)(this.m_vo.getSession().getNumberOfTopLevelComps() <= 0 ? 84 : 70);
                        }
                    }
                }
            }
        }
        boolean retVal = this.m_cIsPanelDirty == 'T';
        this.m_vo.getSession().setDeleteLibsCopied(retVal);
        return retVal;
    }

    private class OiifpHomePanel
    extends LWContainer
    implements ActionListener,
    ItemListener {
        private ComboBox m_oLocationCombo = null;
        private ComboBox m_oNameCombo = null;
        private PushButton m_oBrowseButton = null;
        private OiifjDirectoryDlg m_oDirDlg = null;
        private String m_lastNewName = "";
        private String m_lastNewHome = "";
        private int m_nHomeType = 0;

        public OiifpHomePanel(int nHomeType, String sPrompt) {
            this.m_nHomeType = nHomeType;
            this.setLayout(new BorderLayout(0, 0));
            if (null == OiifpWizLocPanel.this.twrap) {
                OiifpWizLocPanel.this.twrap = WordWrapper.getTextWrapper();
            }
            MultiLineLabel promptLabel = new MultiLineLabel(OiifpWizLocPanel.this.twrap, sPrompt);
            promptLabel.setPreferredAspectRatio(0.0f);
            this.add((Component)promptLabel, "North");
            LWContainer dPanel = new LWContainer();
            GridBagLayout gridbag = new GridBagLayout();
            dPanel.setLayout((LayoutManager)gridbag);
            this.add((Component)dPanel, "Center");
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(3, 0, 3, 3);
            c.anchor = 18;
            c.fill = 2;
            c.weightx = 0.01;
            c.weighty = 0.01;
            c.gridwidth = 1;
            String nameStr = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_NAME_LABEL");
            LWLabel nameLabel = new LWLabel(nameStr);
            gridbag.setConstraints((Component)nameLabel, c);
            dPanel.add((Component)nameLabel);
            c.weightx = 0.98;
            c.gridwidth = -1;
            this.m_oNameCombo = !OiicPullSession.isLangAddonMode() ? new ComboBox(true) : new ComboBox(false);
            this.m_oNameCombo.addItemListener((ItemListener)this);
            gridbag.setConstraints((Component)this.m_oNameCombo, c);
            dPanel.add((Component)this.m_oNameCombo);
            nameLabel.setLabelFor((Component)this.m_oNameCombo);
            c.weightx = 0.01;
            c.gridwidth = 0;
            LWContainer spacer = new LWContainer((LayoutManager)new BorderLayout(0, 0));
            gridbag.setConstraints((Component)spacer, c);
            dPanel.add((Component)spacer);
            c.weightx = 0.01;
            c.weighty = 0.99;
            c.gridwidth = 1;
            c.gridheight = 0;
            String locStr = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_TO_PATH_LABEL");
            LWLabel locLabel = new LWLabel(locStr);
            gridbag.setConstraints((Component)locLabel, c);
            dPanel.add((Component)locLabel);
            c.weightx = 0.98;
            c.gridwidth = -1;
            this.m_oLocationCombo = !OiicPullSession.isLangAddonMode() ? new ComboBox(true) : new ComboBox(false);
            this.m_oLocationCombo.addItemListener((ItemListener)this);
            gridbag.setConstraints((Component)this.m_oLocationCombo, c);
            dPanel.add((Component)this.m_oLocationCombo);
            locLabel.setLabelFor((Component)this.m_oLocationCombo);
            c.weightx = 0.01;
            c.gridwidth = 0;
            c.anchor = 12;
            this.m_oBrowseButton = new PushButton(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_TO_BROWSE_BUTTON"));
            this.m_oBrowseButton.setEnabled(true);
            OiifpWizLocPanel.this.m_fromBrowse.setFocusable(true);
            this.m_oBrowseButton.addActionListener((ActionListener)this);
            this.m_oBrowseButton.setRightmost(true);
            this.m_oBrowseButton.setVisible(true);
            gridbag.setConstraints((Component)this.m_oBrowseButton, c);
            if (!OiicPullSession.isLangAddonMode()) {
                dPanel.add((Component)this.m_oBrowseButton);
            }
            this.refreshCombos(this.m_nHomeType);
        }

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            OiifmCursorUtil.setCursor(OiifpWizLocPanel.this.waitCursor, (Component)((Object)this));
            if (source == this.m_oBrowseButton) {
                this.onBrowse();
            }
            OiifmCursorUtil.setCursor(OiifpWizLocPanel.this.defCursor, (Component)((Object)this));
        }

        private void onBrowse() {
            File chosenDir;
            OiipgFileSystem pgFS = new OiipgFileSystem();
            this.m_oDirDlg = new OiifjDirectoryDlg(WindowUtils.parentFrame((Component)((Object)this)), OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CHOOSE_DIR"));
            String selItem = this.m_oLocationCombo.getSelectedItem();
            selItem = null != selItem ? selItem.trim() : "";
            File curDir = null;
            if (0 < selItem.length()) {
                curDir = new File(selItem);
                if (curDir.exists()) {
                    try {
                        String sFileName = OiixPathOps.getFileCanonicalPath(selItem);
                        curDir = new File(sFileName);
                    }
                    catch (IOException ie) {
                        curDir = null;
                        ie.printStackTrace();
                    }
                } else {
                    curDir = null;
                }
            }
            if (null == curDir) {
                curDir = new File(System.getProperty("user.home"));
            }
            if ((chosenDir = this.m_oDirDlg.runDialog(curDir)) != null) {
                String dirStr = chosenDir.getAbsolutePath();
                OiifpWizLocPanel.this.comboSelect(this.m_oLocationCombo, dirStr);
            }
            this.m_oDirDlg = null;
        }

        public void itemStateChanged(ItemEvent e) {
            Object source = e.getSource();
            if (e.getStateChange() == 1) {
                if (source == this.m_oLocationCombo) {
                    int selIndex = this.m_oLocationCombo.getSelectedIndex();
                    this.selectMatchingName(this.m_oLocationCombo.getSelectedItem());
                } else if (source == this.m_oNameCombo) {
                    int selIndex = this.m_oNameCombo.getSelectedIndex();
                    this.selectMatchingLoc(this.m_oNameCombo.getSelectedItem());
                }
            }
        }

        private boolean selectMatchingName(String sLocation) {
            for (int i = 0; i < OiifpWizLocPanel.this.m_ohi.length; ++i) {
                String name;
                OiiiOracleHomeInfo ohi = OiifpWizLocPanel.this.m_ohi[i];
                if (!OiifpWizLocPanel.this.m_pgFS.areLocsSame(ohi.getLocation(), sLocation) || ohi.getHomeType() != this.m_nHomeType || (name = ohi.getName()) == null || name.trim().length() <= 0) continue;
                name = name.trim();
                OiifpWizLocPanel.this.comboSelect(this.m_oNameCombo, name);
                return true;
            }
            this.m_lastNewHome = sLocation;
            return false;
        }

        private boolean selectMatchingLoc(String sHomeName) {
            for (int i = 0; i < OiifpWizLocPanel.this.m_ohi.length; ++i) {
                OiiiOracleHomeInfo ohi = OiifpWizLocPanel.this.m_ohi[i];
                String name = ohi.getName();
                if (ohi.getHomeType() != this.m_nHomeType || name == null || name.trim().length() <= 0 || !name.equalsIgnoreCase(sHomeName)) continue;
                String location = ohi.getLocation();
                OiifpWizLocPanel.this.comboSelect(this.m_oLocationCombo, location);
                return true;
            }
            this.m_lastNewName = sHomeName;
            return false;
        }

        public void refreshCombos(int nHomeType) {
            if (this.m_oLocationCombo.getItemCount() > 0) {
                this.m_oLocationCombo.removeAll();
            }
            if (this.m_oNameCombo.getItemCount() > 0) {
                this.m_oNameCombo.removeAll();
            }
            OiifpWizLocPanel.this.refreshOHList();
            int nHomesAdded = 0;
            for (int i = 0; i < OiifpWizLocPanel.this.m_ohi.length; ++i) {
                OiiiOracleHomeInfo ohi = OiifpWizLocPanel.this.m_ohi[i];
                if (ohi.getHomeType() != this.m_nHomeType) continue;
                this.m_oLocationCombo.insert(ohi.getLocation(), nHomesAdded);
                String name = ohi.getName();
                if (name != null && name.trim().length() > 0) {
                    this.m_oNameCombo.addItem(name.trim());
                }
                ++nHomesAdded;
            }
            String ohEnvPath = OiipgEnvironment.getEnv(OiiiOracleHomeInfo.getHomeEnvVar(this.m_nHomeType));
            if (ohEnvPath == null) {
                ohEnvPath = "";
            }
            String curOHome = OiifpWizLocPanel.this.getCurrentHomePath(this.m_nHomeType);
            boolean bGetRunningCountForPath = false;
            boolean bGetRunningCountForName = false;
            if (null != this.m_lastNewHome && this.m_lastNewHome.length() > 0) {
                bGetRunningCountForPath = false;
                bGetRunningCountForName = false;
            } else {
                if (null != curOHome && 0 < curOHome.length()) {
                    this.m_lastNewHome = curOHome;
                } else if (ohEnvPath.length() > 0) {
                    this.m_lastNewHome = ohEnvPath;
                } else {
                    String loc = OiiiOracleHomeInfo.getDefHomeLocation(this.m_nHomeType);
                    this.m_lastNewHome = null != loc ? loc : "";
                    bGetRunningCountForPath = true;
                }
                String name = OiiiOracleHomeInfo.getDefHomeName(OiifpWizLocPanel.this.m_inventory, this.m_nHomeType);
                bGetRunningCountForName = true;
                this.m_lastNewName = name;
            }
            if (!OiicPullSession.isLangAddonMode() && OiixOraparam.useRunningCountForDefaults()) {
                int idx = this.getRunningCount(this.m_lastNewHome, bGetRunningCountForPath, this.m_lastNewName, bGetRunningCountForName);
                if (bGetRunningCountForPath) {
                    this.m_lastNewHome = this.m_lastNewHome + "_" + idx;
                }
                if (bGetRunningCountForName) {
                    this.m_lastNewName = this.m_lastNewName + idx;
                }
            }
            OiifpWizLocPanel.this.comboSelect(this.m_oLocationCombo, this.m_lastNewHome);
            if (!this.selectMatchingName(this.m_lastNewHome)) {
                OiifpWizLocPanel.this.comboSelect(this.m_oNameCombo, this.m_lastNewName);
            }
        }

        private int getRunningCount(String sNewHome, boolean bGetRunningCountForPath, String sNewName, boolean bGetRunningCountForName) {
            int idx = 1;
            boolean bPathExists = true;
            boolean bNameExists = true;
            while (bPathExists || bNameExists) {
                if (bGetRunningCountForPath) {
                    String sPath = sNewHome + "_" + idx;
                    bPathExists = new File(sPath).exists();
                } else {
                    bPathExists = false;
                }
                if (bGetRunningCountForName) {
                    String sName = sNewName + idx;
                    bNameExists = OiifpWizLocPanel.this.m_inventory.getHomeWithName(sName) != null;
                } else {
                    bNameExists = false;
                }
                if (!bPathExists && !bNameExists) continue;
                ++idx;
            }
            return idx;
        }

        public String getHomeLocation() {
            String sLoc = this.m_oLocationCombo.getSelectedItem();
            String string = sLoc = null != sLoc ? sLoc.trim() : "";
            if (!OiifpWizLocPanel.this.m_stgMode) {
                if (this.m_oLocationCombo.getSelectedIndex() < 0) {
                    for (int i = 0; i < OiifpWizLocPanel.this.m_ohi.length; ++i) {
                        String storedLoc = OiifpWizLocPanel.this.m_ohi[i].getLocation();
                        if (!OiifpWizLocPanel.this.m_pgFS.areLocsSame(storedLoc, sLoc)) continue;
                        return storedLoc;
                    }
                }
            } else if (!sLoc.endsWith(".jar")) {
                return new File(sLoc, "products.xml").getPath();
            }
            return sLoc;
        }

        public String getHomeName() {
            String sName = this.m_oNameCombo.getSelectedItem();
            sName = null != sName ? sName.trim() : "";
            return sName;
        }

        public int getSelectedHomeIndex(int nHomeType) {
            Vector OHs;
            int nIndex = -1;
            if (OiifpWizLocPanel.this.m_inventory != null && (OHs = OiifpWizLocPanel.this.m_inventory.getHomes(this.m_nHomeType)) != null) {
                nIndex = OiiiOracleHomeInfo.getOHIndex(OHs, this.m_oLocationCombo.getSelectedItem());
            }
            return -1;
        }

        public void setHomeName(String sName) {
            OiifpWizLocPanel.this.comboSelect(this.m_oNameCombo, sName);
            if (!this.selectMatchingLoc(this.m_oNameCombo.getSelectedItem())) {
                this.m_lastNewName = sName;
            }
        }

        public void setHomeLocation(String sLoc) {
            if (sLoc != null) {
                OiifpWizLocPanel.this.comboSelect(this.m_oLocationCombo, sLoc);
            }
        }

        public void updateEnabledComponentsStatus(boolean p_bButtonStatus) {
            if (null != this.m_oBrowseButton) {
                this.m_oBrowseButton.setFocusable(p_bButtonStatus);
                this.m_oBrowseButton.setEnabled(p_bButtonStatus);
            }
            if (null != this.m_oLocationCombo) {
                this.m_oLocationCombo.setEnabled(p_bButtonStatus);
            }
            if (null != this.m_oNameCombo) {
                this.m_oNameCombo.setEnabled(p_bButtonStatus);
            }
            if (null != this.m_oDirDlg) {
                this.m_oDirDlg.setEnabled(p_bButtonStatus);
            }
        }

        public void dispose() {
            this.m_oLocationCombo = null;
            this.m_oNameCombo = null;
            this.m_oBrowseButton = null;
            this.m_lastNewName = null;
            this.m_lastNewHome = null;
        }
    }
}

