/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifr;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.util.Vector;
import oracle.ewt.graphics.ImageUtils;
import oracle.sysman.oii.oiif.oiifm.OiifmImagePanel;
import oracle.sysman.oii.oiix.OiixOraparam;
import oracle.sysman.oii.oiix.OiixPathOps;

public class OiifrAdvertisementPanel
extends OiifmImagePanel {
    private Vector m_images;
    private int m_numImages;
    private int m_curImage;
    private int m_curPercent;
    private int m_imgPercentAllocation;
    private boolean m_allowAddPercent;
    private boolean m_bImagesPresent;

    public OiifrAdvertisementPanel() {
        String dir = null;
        boolean bBootstrap = OiixOraparam.isBootstrapMode();
        dir = bBootstrap ? System.getProperty("oracle.installer.scratchPath") : System.getProperty("oracle.installer.startup_location");
        if (dir == null) {
            dir = "";
        }
        Vector imageVars = OiixOraparam.getOraparamSectionVarNames("IMAGES");
        this.m_bImagesPresent = false;
        if (imageVars != null) {
            this.m_numImages = imageVars.size();
            String[] imageLocs = new String[this.m_numImages];
            this.m_images = new Vector();
            for (int i = 0; i < this.m_numImages; ++i) {
                Image img;
                String curLoc = OiixOraparam.getOraparamProfileString("IMAGES", (String)imageVars.elementAt(i), "");
                imageLocs[i] = OiixPathOps.getNativeForm(OiixPathOps.concatPath(dir, curLoc));
                File f = new File(imageLocs[i]);
                if (!f.exists() || (img = Toolkit.getDefaultToolkit().getImage(imageLocs[i])) == null) continue;
                this.m_images.addElement(img);
                this.m_bImagesPresent = true;
            }
            this.m_numImages = this.m_images.size();
        } else {
            this.m_numImages = 0;
            this.m_images = null;
        }
        this.reset();
    }

    public void reset() {
        this.m_curImage = 0;
        this.m_curPercent = 0;
        this.m_allowAddPercent = false;
        if (this.m_numImages > 0) {
            this.m_imgPercentAllocation = 100 / this.m_numImages;
            this.setCurrentImage(0);
        } else {
            this.m_imgPercentAllocation = 0;
        }
    }

    public void setAllowAddPercent(boolean allow) {
        this.m_allowAddPercent = allow;
    }

    public boolean isImagesPresent() {
        return this.m_bImagesPresent;
    }

    public void addPercent(int percent) {
        if (this.m_curPercent <= 100 && this.m_allowAddPercent && this.m_numImages > 0) {
            this.m_curPercent += percent;
            this.updateImage();
        }
    }

    public void setPercent(int percent) {
        if (this.m_curPercent <= 100 && this.m_allowAddPercent && this.m_numImages > 0) {
            this.m_curPercent = percent;
            this.updateImage();
        }
    }

    private void updateImage() {
        int newIdx = this.m_curImage + 1;
        if (this.m_curPercent > this.m_imgPercentAllocation * newIdx && newIdx <= this.m_images.size()) {
            this.setCurrentImage(this.m_curImage + 1);
        }
    }

    private void setCurrentImage(int imgIdx) {
        if (imgIdx >= this.m_images.size()) {
            return;
        }
        if (imgIdx != this.m_curImage) {
            Image oldImage = (Image)this.m_images.elementAt(this.m_curImage);
            this.m_images.setElementAt(null, this.m_curImage);
        }
        Image newImage = (Image)this.m_images.elementAt(imgIdx);
        ImageUtils.loadImage((Image)newImage);
        if (newImage != null) {
            this.setImage(newImage);
            this.m_curImage = imgIdx;
        }
        if (this.m_curImage < this.m_images.size() - 1) {
            Image nextImage = (Image)this.m_images.elementAt(this.m_curImage + 1);
            this.prepareImage(nextImage, null);
        }
        this.repaint();
    }
}

