/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifw;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import oracle.sysman.oic.oics.OicsCheckPointFactory;
import oracle.sysman.oic.oics.OicsICheckPointIndexSession;
import oracle.sysman.oii.oiic.OiicAdditionalUtilityWCDE;
import oracle.sysman.oii.oiic.OiicConfigInitializeWCCE;
import oracle.sysman.oii.oiic.OiicDeinstallSession;
import oracle.sysman.oii.oiic.OiicDelSession;
import oracle.sysman.oii.oiic.OiicInstSaveInvWCCE;
import oracle.sysman.oii.oiic.OiicInstallSession;
import oracle.sysman.oii.oiic.OiicInstallTimeSession;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiic.OiicSessionPlan;
import oracle.sysman.oii.oiic.OiicUpdatesForInstallWCCE;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbCondIterator;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifb.OiifbProgressControl;
import oracle.sysman.oii.oiif.oiifb.OiifbWizOperation;
import oracle.sysman.oii.oiif.oiifr.OiifrProgressActionListener;
import oracle.sysman.oii.oiif.oiifw.OiifwClusterCopyWCCE;
import oracle.sysman.oii.oiif.oiifw.OiifwClusterRemoteOpsWCCE;
import oracle.sysman.oii.oiif.oiifw.OiifwClusterSaveInventoryWCCE;
import oracle.sysman.oii.oiif.oiifw.OiifwDeinstallPhaseWCCE;
import oracle.sysman.oii.oiif.oiifw.OiifwInstallPhaseWCCE;
import oracle.sysman.oii.oiif.oiifw.OiifwRemoteHomeSetupWCCE;
import oracle.sysman.oii.oiif.oiifw.OiifwRemoveHomesWCCE;
import oracle.sysman.oii.oiif.oiifw.OiifwUpdateLibrariesWCCE;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiio.oiiol.OiiolActionLogEntry;
import oracle.sysman.oii.oiio.oiiol.OiiolLogManipulator;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifwActionsPhaseWCDE
implements OiifbWizOperation {
    public static final int DEFAULT_ACTION_SIZE = 10;
    private static int s_iActionSize = 10;
    public static final int DEINSTALL = 0;
    public static final int PHASE_1 = 1;
    public static final int PHASE_LINK = 2;
    public static final int PHASE_POSTLINK = 4;
    public static final int PHASE_2 = 8;
    public static final int PHASE_LANGADDON = 16;
    public static final int FASTCOPY_DEINSTALLS = 32;
    public static Vector s_installList = null;
    public static Vector s_vDeinstallCompList = null;
    private int m_phases = 0;
    private int m_iLastPhase = 0;
    private boolean m_bNeedLinkPhase = true;
    private OiicInstallTimeSession m_instSession;
    private OiicSessionPlan m_sessionPlan;
    private int m_currentPhase = -1;
    private long m_lStartTime = 0L;
    private boolean m_bInstallInterrupted = false;
    private OiifbEndIterateException m_interruptedException = null;
    private boolean m_bSessionCancelled = false;
    private OiifbProgressControl m_progressControl;
    private OiifbCondIterator m_actionsPhaseIterator;
    private Object m_synchObject;
    private OiiolLogManipulator m_deinstLog;
    private long m_lTotalProgressBytes;

    public OiifwActionsPhaseWCDE(OiicInstallTimeSession instSession) {
        this.m_instSession = instSession;
        this.m_sessionPlan = instSession.getSessionPlan();
        this.m_bNeedLinkPhase = this.isLinkPhaseNeeded();
        this.m_progressControl = new OiifbProgressControl();
    }

    public OiicInstallTimeSession getInstallSession() {
        return this.m_instSession;
    }

    public boolean isInstallInterrupted() {
        return this.m_bInstallInterrupted;
    }

    public void setInstallInterrupted(boolean bInterrupted) {
        this.m_bInstallInterrupted = bInterrupted;
    }

    public boolean isSessionCancelled() {
        return this.m_bSessionCancelled;
    }

    public void setSessionCancelled(boolean bSessionCancelled) {
        this.m_bSessionCancelled = bSessionCancelled;
    }

    public OiifbEndIterateException getInterruptedException() {
        return this.m_interruptedException;
    }

    public void setInterruptedException(OiifbEndIterateException ex) {
        this.m_interruptedException = ex;
    }

    public OiifbProgressControl getProgressControl() {
        return this.m_progressControl;
    }

    public void setDeinstallLog(OiiolLogManipulator oDeinstLog) {
        this.m_deinstLog = oDeinstLog;
    }

    public OiiolLogManipulator getDeinstallLog() {
        return this.m_deinstLog;
    }

    public void addLogEntry(OiiiCompInstallID cid, OiiolActionLogEntry ale) throws IOException {
        this.m_deinstLog.addEntry(ale);
    }

    public void initialize() throws OiifbEndIterateException {
        try {
            if (this.m_sessionPlan.isEmpty()) {
                this.m_instSession.getSessionContext().readContext();
                this.m_sessionPlan = OiicSessionPlan.readPlan((OiicPullSession)this.m_instSession);
                this.m_instSession.setSessionPlan(this.m_sessionPlan);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new OiifbEndIterateException(e.getMessage());
        }
        String checkpointLoc = this.computeCheckPointLoc() == null ? null : this.computeCheckPointLoc();
        String componentName = "oui";
        if (checkpointLoc != null) {
            this.initializeCheckPointSession(checkpointLoc, componentName);
        }
        if (this.m_instSession instanceof OiicInstallSession) {
            ((OiicInstallSession)this.m_instSession).disposeUnusedUIObjects();
        }
        Vector<OiifbWizOperation> vInstallPhaseElements = new Vector<OiifbWizOperation>(5, 2);
        s_installList = this.m_sessionPlan.getSuccessfulAdditions(10);
        int nWizIndex = 0;
        if (s_installList.size() > 0) {
            OiifwUpdateLibrariesWCCE libsWCCE = new OiifwUpdateLibrariesWCCE(this);
            ++nWizIndex;
            vInstallPhaseElements.addElement(libsWCCE);
        }
        long lDeinstallBytes = 0L;
        OiifwDeinstallPhaseWCCE deinstallWCCE = null;
        Vector vDeinstallOneOffList = null;
        List homesToRemove = null;
        boolean isLangAddOn = OiicPullSession.isLangAddonMode();
        boolean bClusterPhaseNeeded = this.isClusterPhaseNeeded();
        long lInstallBytes = 0L;
        if (!isLangAddOn) {
            s_vDeinstallCompList = this.m_sessionPlan.getRemoves(10);
            vDeinstallOneOffList = this.m_sessionPlan.getOneoffRemoves();
            homesToRemove = this.m_sessionPlan.getHomesToRemove();
            lDeinstallBytes = s_vDeinstallCompList.size();
            if (s_vDeinstallCompList != null && s_vDeinstallCompList.size() > 0 || vDeinstallOneOffList != null && vDeinstallOneOffList.size() > 0 || homesToRemove != null && homesToRemove.size() > 0) {
                ++nWizIndex;
                deinstallWCCE = new OiifwDeinstallPhaseWCCE(this);
                vInstallPhaseElements.addElement(deinstallWCCE);
                this.m_phases |= 1;
                this.m_iLastPhase = 1;
            }
        }
        OiifwInstallPhaseWCCE installWCCE = null;
        if (s_installList.size() > 0) {
            ++nWizIndex;
            installWCCE = new OiifwInstallPhaseWCCE(this);
            vInstallPhaseElements.addElement(installWCCE);
            this.m_phases |= 0x5A;
            if (this.m_bNeedLinkPhase) {
                this.m_phases |= 4;
            }
            this.m_iLastPhase = 8;
            installWCCE.computeInstallProgressBytes(s_installList, bClusterPhaseNeeded);
            lInstallBytes = installWCCE.getInstallProgressBytes();
            this.m_lTotalProgressBytes += lInstallBytes;
            if (bClusterPhaseNeeded) {
                this.m_phases |= 0x20;
                this.m_iLastPhase = 32;
            }
            if (!isLangAddOn && (this.m_phases & 1) > 0) {
                int deinstallCount = (int)Math.max(1.0, (double)s_vDeinstallCompList.size() * 0.3);
                int installCount = s_installList.size();
                int nInstallPercent = installCount * 100 / (deinstallCount + installCount);
                lDeinstallBytes = lInstallBytes / (long)nInstallPercent * (long)(100 - nInstallPercent);
            }
        }
        if (!isLangAddOn && deinstallWCCE != null) {
            deinstallWCCE.setDeinstallProgressBytes(lDeinstallBytes);
            this.m_lTotalProgressBytes += lDeinstallBytes;
        }
        if (this.m_instSession instanceof OiicPullSession && !isLangAddOn) {
            vInstallPhaseElements.addElement(new OiifwRemoteHomeSetupWCCE(this.m_instSession.getSessionContext()));
            ++nWizIndex;
        }
        OiicSessionContext sessionContext = this.m_instSession.getSessionContext();
        int platGroup = OiixPlatform.getPlatGroup(OiixPlatform.getCurrentPlatform());
        if (this.m_instSession instanceof OiicPullSession) {
            ++nWizIndex;
            vInstallPhaseElements.addElement(new OiicInstSaveInvWCCE(sessionContext, this));
            ++nWizIndex;
            vInstallPhaseElements.addElement(new OiicAdditionalUtilityWCDE((OiicPullSession)this.m_instSession));
            ++nWizIndex;
            vInstallPhaseElements.addElement(new OiicUpdatesForInstallWCCE((OiicPullSession)this.m_instSession));
            ++nWizIndex;
            vInstallPhaseElements.addElement(new OiicConfigInitializeWCCE((OiicPullSession)this.m_instSession));
            if (Boolean.getBoolean("oracle.installer.copy")) {
                OiifwClusterCopyWCCE oClusterCopyWCCE = new OiifwClusterCopyWCCE(sessionContext, ++nWizIndex, false);
                if (installWCCE != null) {
                    oClusterCopyWCCE.setProgressRange(installWCCE.getClusterRange());
                }
                oClusterCopyWCCE.setLocalInstallStartTime(System.currentTimeMillis());
                vInstallPhaseElements.addElement(oClusterCopyWCCE);
            }
            if (platGroup == -3 && !isLangAddOn) {
                ++nWizIndex;
                OiifwClusterRemoteOpsWCCE oClusterRemotOps = new OiifwClusterRemoteOpsWCCE(this);
                vInstallPhaseElements.addElement(oClusterRemotOps);
            }
            ++nWizIndex;
            vInstallPhaseElements.addElement(new OiifwClusterSaveInventoryWCCE((OiicPullSession)this.m_instSession, -1));
        } else {
            if (platGroup == -3) {
                ++nWizIndex;
                vInstallPhaseElements.addElement(new OiifwClusterRemoteOpsWCCE(this));
            }
            if (Boolean.getBoolean("oracle.installer.copy")) {
                vInstallPhaseElements.addElement(new OiifwClusterCopyWCCE(sessionContext, ++nWizIndex, true, (OiicDeinstallSession)this.m_instSession));
            }
            ++nWizIndex;
            vInstallPhaseElements.addElement(new OiicInstSaveInvWCCE(sessionContext, this));
            ++nWizIndex;
            if (homesToRemove != null && homesToRemove.size() > 0) {
                vInstallPhaseElements.addElement(new OiifwRemoveHomesWCCE((OiicDelSession)((Object)this.m_instSession), -1));
            }
        }
        this.m_actionsPhaseIterator = new OiifbCondIterator(vInstallPhaseElements);
    }

    public int doOperation(boolean isBack) throws OiifbEndIterateException {
        this.m_bInstallInterrupted = false;
        OiicSessionInterfaceManager interfaceManager = OiicSessionInterfaceManager.getInterfaceManager();
        interfaceManager.setupInstallProgress(this, this.m_phases, this.m_iLastPhase);
        interfaceManager.getProgressListener().setTotalBytes(this.m_lTotalProgressBytes);
        this.m_lStartTime = System.currentTimeMillis();
        int retVal = this.m_actionsPhaseIterator.iterate(isBack);
        interfaceManager.getProgressListener().onDoneProgress();
        return retVal;
    }

    long getInstallStartTime() {
        return this.m_lStartTime;
    }

    public int getCurrentPhase() {
        return this.m_currentPhase;
    }

    public void setCurrentPhase(int phase) {
        this.m_currentPhase = phase;
    }

    public static int addActionSize(int sz) {
        return s_iActionSize + sz;
    }

    public static int getActionSize() {
        return s_iActionSize;
    }

    public static void setActionSize(int actionSize) {
        s_iActionSize = actionSize;
    }

    public boolean needLinkPhase() {
        return this.m_bNeedLinkPhase;
    }

    private boolean isClusterPhaseNeeded() {
        String[] asRemoteNodes = (String[])this.m_instSession.getSessionContext().getVarValue("REMOTE_NODES");
        return asRemoteNodes != null && asRemoteNodes.length > 0;
    }

    public boolean isSetupPhaseNeeded() {
        boolean bRetVal = true;
        if (System.getProperty("oracle.installer.noSetup", "false").equalsIgnoreCase("true")) {
            bRetVal = false;
        }
        return bRetVal;
    }

    private boolean isLinkPhaseNeeded() {
        boolean retVal = false;
        if (System.getProperty("oracle.installer.link", "true").equalsIgnoreCase("false")) {
            return retVal;
        }
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup(curPlatId);
        switch (curPlatGroup) {
            case -1: {
                retVal = true;
                break;
            }
        }
        return retVal;
    }

    public void dispose() {
        if (this.m_actionsPhaseIterator != null) {
            this.m_actionsPhaseIterator.dispose();
        }
    }

    public void synchInstallInventory(OiifrProgressActionListener progressListener) throws OiifbEndIterateException {
        try {
            progressListener.setStatus(OiixResourceBundle.getString("S_SYNCH_INVENTORY_WAIT"));
            OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
            iac.synchInstallInventory();
        }
        catch (IOException ioe) {
            throw new OiifbEndIterateException(ioe.getMessage());
        }
        catch (OiifbCancelException e) {
            throw new OiifbEndIterateException(e.getMessage());
        }
        progressListener.setStatus("");
    }

    public synchronized Object getSynchObject() {
        if (this.m_synchObject == null) {
            this.m_synchObject = new Object();
        }
        return this.m_synchObject;
    }

    private void initializeCheckPointSession(String checkPointLoc, String moduleName) {
        if (checkPointLoc != null && moduleName != null) {
            OiicPullSession oPullSession;
            OicsICheckPointIndexSession cpis = OicsCheckPointFactory.getIndexSession((String)checkPointLoc, (String)moduleName);
            if (this.m_instSession instanceof OiicPullSession && (oPullSession = (OiicPullSession)this.m_instSession) != null && cpis != null) {
                OiiolTextLogger.appendText("Checkpoint:Initializing checkpointindex session in oiifwactionsphasewcde.");
                OiiolTextLogger.appendText("Checkpoint:Location is- " + checkPointLoc);
                oPullSession.setCheckPointIndexSessionObj(cpis);
            }
        }
    }

    private String computeCheckPointLoc() {
        String oracleBase = null;
        String oracleHome = null;
        if (this.m_instSession.getSessionContext() != null) {
            if (this.m_instSession.getSessionContext().getVarValue("ORACLE_BASE") != null) {
                oracleBase = (String)this.m_instSession.getSessionContext().getVarValue("ORACLE_BASE");
            }
            if (this.m_instSession.getSessionContext().getVarValue("ORACLE_HOME") != null) {
                oracleHome = (String)this.m_instSession.getSessionContext().getVarValue("ORACLE_HOME");
            }
        }
        if (oracleBase != null) {
            return oracleBase;
        }
        if (oracleHome != null) {
            String temp = oracleHome;
            if (new File(temp = OiixPathOps.getNativeForm(OiixPathOps.concatPath(temp, "install"))).exists()) {
                return temp;
            }
            oracleHome = OiixPathOps.getNativeForm(OiixPathOps.concatPath(oracleHome, "inventory"));
            return oracleHome;
        }
        return null;
    }
}

