/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifw;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicAPIInstaller;
import oracle.sysman.oii.oiic.OiicClusterInstallInfo;
import oracle.sysman.oii.oiic.OiicInstaller;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifb.OiifbWizChainDlgElem;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgDetectCluster;
import oracle.sysman.oii.oiip.oiipg.OiipgOracleHomes;
import oracle.sysman.oii.oiis.OiisDlgInElem;
import oracle.sysman.oii.oiis.OiisDlgInOutElem;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixUtilityOps;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiifwAddNodeWCDE
extends OiifbWizChainDlgElem {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 1024;
    private int m_nextInd;
    private String m_sLocalNode = null;
    private String[] m_nodeList = null;
    private String[] m_newNodes = null;
    private boolean m_bCRS = false;
    private boolean m_bVendorCW = false;
    private String m_oracleHome = null;
    public static final String s_panelClass = "oracle.sysman.oii.oiif.oiifp.OiifpAddNodePanel";
    private OiicSessionInterfaceManager m_interfaceManager;

    public OiifwAddNodeWCDE(OiisVariableOwner vo, int nextInd) {
        super(vo);
        this.setWizPanelClassName(s_panelClass);
        this.setHelpKey("S_OIIFW_ADDNODE_WCDE");
        String sTitle = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_NODE_ADDITION_TITLE");
        this.setTitle(sTitle);
        this.m_nextInd = nextInd;
    }

    public void initialize() throws OiifbEndIterateException {
        OiiiInstallAreaControl oAreaControl = OiiiInstallAreaControl.getInstallAreaControl();
        OiiiInstallInventory oInventory = oAreaControl.getInstallInventory();
        String sErr = null;
        Hashtable cmdLine = null;
        cmdLine = System.getProperty("oracle.installer.ouiApiMode", "false").equalsIgnoreCase("false") ? OiicInstaller.getOiicInstallerInstance().getCommandLineArgsTable() : OiicAPIInstaller.getAPIInstallerInstance().getCommandLineArgsTable();
        this.m_oracleHome = (String)this.m_varOwner.getVariable("ORACLE_HOME").getValue();
        OiisVariable nodes = this.m_varOwner.getVariable("CLUSTER_NEW_NODES");
        try {
            if (nodes.getValue() instanceof String) {
                nodes.setValue(OiixFunctionOps.explodeString((String)nodes.getValue(), ","));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        OiiiOracleHomeInfo oInfo = oInventory.getHomeWithLocation(this.m_oracleHome);
        try {
            String[] asRemoteNodes;
            if (oInfo != null) {
                OiisVariable clusterNewNodesVar;
                Vector nodeList;
                try {
                    OiisVariable oHomeName = this.m_varOwner.getVariable("ORACLE_HOME_NAME");
                    String sOracleHomeName = oInfo.getName();
                    oHomeName.setValue(sOracleHomeName);
                }
                catch (OiisVarSettingException e) {
                    OiiolTextLogger.appendException(e);
                }
                catch (OiifbCancelException ce) {
                    OiiolTextLogger.appendException(ce);
                }
                try {
                    OiipgOracleHomes.setupRegEntriesAndContext(this.m_varOwner, false);
                }
                catch (IOException e) {
                    OiiolTextLogger.appendErrorText(e.getMessage());
                }
                if (oInfo.isCRSHome()) {
                    this.m_bCRS = true;
                }
                if ((nodeList = oInfo.getNodeList()) == null || nodeList.size() <= 0) {
                    sErr = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_NO_NODES_IN_INSTALLATION");
                    throw new OiifbEndIterateException(sErr);
                }
                this.m_nodeList = OiixVectorOps.vect2StrArr(nodeList);
                OiipgDetectCluster detectCluster = OiipgDetectCluster.getDetectCluster();
                OiisVariable oLocalNodeVar = this.m_varOwner.getVariable("LOCAL_NODE");
                if (oLocalNodeVar.isValueSetByUser()) {
                    this.m_sLocalNode = (String)oLocalNodeVar.getValue();
                    OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFW1020", new String[]{this.m_sLocalNode}));
                } else {
                    this.m_sLocalNode = oInfo.getLocalNode();
                    if (this.m_sLocalNode == null) {
                        this.m_sLocalNode = detectCluster.getLocalNodeName();
                        if (this.m_sLocalNode == null) {
                            this.m_sLocalNode = this.m_nodeList.length > 0 ? this.m_nodeList[0] : null;
                            OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFW1021", new String[]{this.m_sLocalNode}));
                        } else {
                            OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFW1024", new String[]{this.m_sLocalNode}));
                        }
                    } else {
                        OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFW1025", new String[]{this.m_sLocalNode}));
                    }
                    if (this.m_sLocalNode != null) {
                        try {
                            oLocalNodeVar.setValue(this.m_sLocalNode);
                        }
                        catch (OiifbCancelException e) {
                            OiiolTextLogger.appendException(e);
                        }
                        catch (OiisVarSettingException e) {
                            OiiolTextLogger.appendException(e);
                        }
                    }
                }
                OiicClusterInstallInfo clusterInfo = OiicClusterInstallInfo.getClusterInstallInfo();
                String[] clusterInfoList = detectCluster.getNodeNames();
                if ((clusterInfoList == null || clusterInfoList.length == 0) && (clusterNewNodesVar = this.m_varOwner.getVariable("CLUSTER_NEW_NODES")).isValueSetByUser()) {
                    String[] clusterNewNodes = (String[])clusterNewNodesVar.getValue();
                    clusterInfoList = OiixFunctionOps.union(this.m_nodeList, clusterNewNodes);
                }
                clusterInfo.setClusterNodes(clusterInfoList);
                if (this.m_sLocalNode != null) {
                    clusterInfo.setLocalNode(this.m_sLocalNode, true);
                }
                String[] asExistingRemoteNodes = OiixFunctionOps.subtractStr(this.m_nodeList, this.m_sLocalNode);
                OiisVariable oExistingRemoteNodesVar = this.m_varOwner.getVariable("EXISTING_REMOTE_NODES");
                try {
                    oExistingRemoteNodesVar.setValue(asExistingRemoteNodes);
                }
                catch (OiifbCancelException e) {
                    OiiolTextLogger.appendException(e);
                }
                catch (OiisVarSettingException e) {
                    OiiolTextLogger.appendException(e);
                }
                this.addInElem(new OiisDlgInElem("ExistingClusterNodes", this.m_nodeList));
                boolean bEnableVirtualHostNameEntry = Boolean.valueOf(System.getProperty("oracle.installer.enableVirtualHostNameEntry", "true"));
                if (this.m_bCRS && bEnableVirtualHostNameEntry) {
                    this.addInElem(new OiisDlgInElem("EnableVirtualHostNameEntry", OiixUtilityOps.booleanValueOf(bEnableVirtualHostNameEntry)));
                }
                asRemoteNodes = null;
                OiisVariable oRemoteNodesVar = this.m_varOwner.getVariable("REMOTE_NODES");
                OiisVariable oClusterNewNodesVar = this.m_varOwner.getVariable("CLUSTER_NEW_NODES");
                if (oClusterNewNodesVar.isValueSetByUser()) {
                    asRemoteNodes = (String[])oClusterNewNodesVar.getValue();
                    try {
                        oRemoteNodesVar.setValue(asRemoteNodes);
                    }
                    catch (OiifbCancelException e) {
                        OiiolTextLogger.appendException(e);
                    }
                    catch (OiisVarSettingException e) {
                        OiiolTextLogger.appendException(e);
                    }
                } else {
                    asRemoteNodes = this.getNewNodes();
                }
            } else {
                sErr = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_OH_LOCATION_ERROR");
                throw new OiifbEndIterateException(sErr);
            }
            this.addInOutElem(new OiisDlgInOutElem("NewNodes", "CLUSTER_NEW_NODES", asRemoteNodes));
        }
        catch (OiifbEndIterateException e) {
            OiifmAlert.displayError(e.getMessage());
            throw e;
        }
    }

    private String[] getVirtualHostNames(String[] asNodes) {
        if (asNodes != null) {
            String[] asVirtualHostNames = new String[asNodes.length];
            OiipgDetectCluster oDetectCluster = OiipgDetectCluster.getDetectCluster();
            for (int i = 0; i < asNodes.length; ++i) {
                asVirtualHostNames[i] = oDetectCluster.getVirtualHostName(asNodes[i]);
            }
            return asVirtualHostNames;
        }
        return null;
    }

    private String[] getPrivateNodeNames(String[] asNodes) {
        if (asNodes != null) {
            String[] asPrivateNodeNames = new String[asNodes.length];
            OiipgDetectCluster oDetectCluster = OiipgDetectCluster.getDetectCluster();
            for (int i = 0; i < asNodes.length; ++i) {
                asPrivateNodeNames[i] = oDetectCluster.getPrivateNodeName(asNodes[i]);
            }
            return asPrivateNodeNames;
        }
        return null;
    }

    public int getNext() {
        return this.m_nextInd;
    }

    public int doOperation(boolean bBack) throws OiifbEndIterateException {
        int retval = super.doOperation(bBack);
        OiisVariable oRemoteNodesVar = this.m_varOwner.getVariable("REMOTE_NODES");
        OiisVariable oClusterNewNodesVar = this.m_varOwner.getVariable("CLUSTER_NEW_NODES");
        String[] asRemoteNodes = null;
        try {
            asRemoteNodes = (String[])oClusterNewNodesVar.getValue();
            oRemoteNodesVar.setValue(asRemoteNodes);
        }
        catch (OiifbCancelException e) {
            OiiolTextLogger.appendException(e);
        }
        catch (OiisVarSettingException e) {
            OiiolTextLogger.appendException(e);
        }
        OiicClusterInstallInfo.getClusterInstallInfo().addClusterNodes(asRemoteNodes);
        OiisVariable oClusterNodesVar = this.m_varOwner.getVariable("CLUSTER_NODES");
        if (asRemoteNodes != null && asRemoteNodes.length > 0) {
            String[] asClusterNodes = new String[this.m_nodeList.length + asRemoteNodes.length];
            System.arraycopy(this.m_nodeList, 0, asClusterNodes, 0, this.m_nodeList.length);
            System.arraycopy(asRemoteNodes, 0, asClusterNodes, this.m_nodeList.length, asRemoteNodes.length);
            try {
                oClusterNodesVar.setValue(asClusterNodes);
            }
            catch (OiifbCancelException e) {
                OiiolTextLogger.appendException(e);
            }
            catch (OiisVarSettingException e) {
                OiiolTextLogger.appendException(e);
            }
        } else {
            try {
                oClusterNodesVar.setValue(this.m_nodeList);
            }
            catch (OiifbCancelException e) {
                OiiolTextLogger.appendException(e);
            }
            catch (OiisVarSettingException e) {
                OiiolTextLogger.appendException(e);
            }
        }
        return retval;
    }

    public boolean onBack() {
        boolean bRet = super.onBack();
        if (bRet) {
            OiicClusterInstallInfo.dispose();
        }
        return bRet;
    }

    public String[] getClusterNodesForHome() {
        return this.m_nodeList;
    }

    public boolean isCRSHome() {
        return this.m_bCRS;
    }

    public boolean isVendorClusterware() {
        return this.m_bVendorCW;
    }

    public String[] getNewNodes() {
        return this.m_newNodes;
    }

    public boolean showStatus() {
        OiicClusterInstallInfo clusterInfo = OiicClusterInstallInfo.getClusterInstallInfo();
        return !clusterInfo.isAvailable();
    }
}

