/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifw;

import java.io.IOException;
import java.util.List;
import java.util.Vector;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.InvalidNodeListException;
import oracle.ops.mgmt.cluster.SharedDeviceException;
import oracle.sysman.oii.oiic.OiicClusterInstallInfo;
import oracle.sysman.oii.oiic.OiicIClusterNode;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbCondWizOperation;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterChecks;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterException;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterInvSetup;
import oracle.sysman.oii.oiip.oiipg.OiipgOracleHomes;
import oracle.sysman.oii.oiip.oiipg.OiipgPropertyLoader;
import oracle.sysman.oii.oiip.oiipg.OiipgRemoteOpsException;
import oracle.sysman.oii.oiis.OiisAdvisedValue;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixOraparam;
import oracle.sysman.oii.oiix.OiixProgressListener;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiifwClusterChecksWCCE
implements OiifbCondWizOperation {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 4;
    private static final int NUM_VARIABLE_TESTS = 3;
    private final String m_sLineSeparator = System.getProperty("line.separator", "\n");
    private static final int NUM_EXISTING_NODES_TESTS = 3;
    private static final int NUM_REMOTE_NODES_TESTS = 5;
    private final int m_iPublicNodeTimeOut = Integer.getInteger("oracle.installer.timeout.publicnode", 30);
    private final int m_iPrivateNodeTimeOut = Integer.getInteger("oracle.installer.timeout.privatenode", 30);
    private final int m_iVirtualHostTimeOut = Integer.getInteger("oracle.installer.timeout.virtualhostname", 3);
    private int m_nextInd;
    private OiicSessionContext m_vo;
    private OiicPullSession m_instSession;

    public OiifwClusterChecksWCCE(OiicSessionContext vo, int nextInd) {
        this.m_vo = vo;
        this.m_instSession = vo.getSession();
        this.m_nextInd = nextInd;
    }

    public void initialize() throws OiifbEndIterateException {
    }

    public void dispose() {
    }

    private void setupOldStyleRegEntries() {
        OiisVariable oOhPath = this.m_vo.getVariable("ORACLE_HOME");
        String sOhPath = (String)oOhPath.getValue();
        OiisVariable oOhName = this.m_vo.getVariable("ORACLE_HOME_NAME");
        String sOhName = (String)oOhName.getValue();
        if (!OiipgOracleHomes.is10gRegistrySetupRequired(sOhName)) {
            OiipgOracleHomes.createOracleHomeEntry(sOhPath, sOhName);
        }
    }

    public int doOperation(boolean back) throws OiifbEndIterateException {
        String boolVal;
        int retVal = 0;
        boolean ignoreSharedInventory = false;
        if (System.getProperty("oracle.installer.ignoreSharedInventory") != null && (boolVal = System.getProperty("oracle.installer.ignoreSharedInventory")).equalsIgnoreCase("true")) {
            ignoreSharedInventory = true;
        }
        String metalink_loc = null;
        if (OiixOraparam.getOraparamProfileString("METALINK_NOTE_FOR_SHARED_INVENTORY", null) != null) {
            metalink_loc = OiixOraparam.getOraparamProfileString("METALINK_NOTE_FOR_SHARED_INVENTORY", null);
        }
        if (back) {
            return 1;
        }
        String[] allNodes = (String[])this.m_vo.getVarValue("CLUSTER_NODES");
        if (allNodes == null || allNodes.length == 0) {
            return 0;
        }
        this.setupOldStyleRegEntries();
        Object[] obj = new String[1];
        String sLocalNode = (String)this.m_vo.getVarValue("LOCAL_NODE");
        String clusterListStr = OiixFunctionOps.implodeList(allNodes, ",");
        obj[0] = OiixFunctionOps.implodeList(OiixFunctionOps.subtractStr(allNodes, sLocalNode), ",");
        OiiolTextLogger.appendText(OiixResourceBundle.getString("S_PERFORMING_AVAILABILITY_CHECKS", obj));
        String[] asRemoteNodes = (String[])this.m_vo.getVarValue("REMOTE_NODES");
        String[] asExistingNodes = (String[])this.m_vo.getVarValue("EXISTING_REMOTE_NODES");
        int nRemoteNodes = asRemoteNodes == null ? 0 : asRemoteNodes.length;
        int nExistingNodes = asExistingNodes == null ? 0 : asExistingNodes.length;
        String sInvLoc = (String)this.m_vo.getVarValue("INVENTORY_LOCATION");
        if ((sInvLoc == null || sInvLoc.equalsIgnoreCase("")) && System.getProperty("oracle.installer.invPtrLoc") != null) {
            String InvLoc = System.getProperty("oracle.installer.invPtrLoc");
            OiipgPropertyLoader iPropLoad = new OiipgPropertyLoader();
            try {
                sInvLoc = iPropLoad.getLocationFileLoc(InvLoc);
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
            }
        }
        if (!(ignoreSharedInventory || allNodes.length <= 1 || sInvLoc == null && sInvLoc.equalsIgnoreCase(""))) {
            try {
                if (Cluster.isSharedPath((String)sInvLoc, (String[])allNodes, (String)sLocalNode)) {
                    int result;
                    String sTitle = OiixResourceBundle.getString("OIIFW1002");
                    Object[] args1 = new String[1];
                    Object[] args2 = new String[1];
                    args1[0] = sInvLoc;
                    if (metalink_loc != null) {
                        args2[0] = metalink_loc;
                    }
                    StringBuffer sb = new StringBuffer("");
                    sb.append(OiixResourceBundle.getString("S_INVENTORY_SHARED_ERROR_DESCRIPTION", args1));
                    if (metalink_loc != null) {
                        sb.append(OiixResourceBundle.getString("S_INVENTORY_SHARED_ERROR_DESCRIPTION2", args2));
                    }
                    if (!OiicPullSession.isSilentMode()) {
                        sb.append(OiixResourceBundle.getString("S_CONTINUE"));
                    }
                    if ((result = OiifmAlert.displayAlert(sTitle, sb.toString(), 30, 3, 2, 10)) == 2) {
                        retVal = 1;
                    }
                    OiiolTextLogger.appendText(sb.toString());
                    return retVal;
                }
            }
            catch (SharedDeviceException e) {
                OiiolTextLogger.appendException((Exception)((Object)e));
            }
            catch (InvalidNodeListException e) {
                OiiolTextLogger.appendException((Exception)((Object)e));
            }
        }
        OiicClusterInstallInfo clusterInfo = OiicClusterInstallInfo.getClusterInstallInfo();
        clusterInfo.resetAvailability();
        OiixProgressListener progressListener = this.m_instSession.getProgressListener();
        progressListener.setStatus(OiixResourceBundle.getString("S_PERFORMING_AVAILABILITY_CHECKS", obj));
        progressListener.setTitle(OiixResourceBundle.getString("S_PERFORMING_AVAILABILITY_CHECKS", obj));
        progressListener.setTotalBytes(3 + 3 * nExistingNodes + 5 * nRemoteNodes);
        String[] asActualExistingNodes = asExistingNodes;
        String[] asActualRemoteNodes = asRemoteNodes;
        String[] asExistingDownNodes = null;
        Object asRemoteDownNodes = null;
        String[] asCleanMachines = null;
        try {
            this.validateClusterVariables(sLocalNode, asRemoteNodes, allNodes);
            progressListener.addBytes(3);
            if (asExistingNodes != null && asExistingNodes.length > 0 && (asActualExistingNodes = this.validateNodes(sLocalNode, asExistingNodes, sInvLoc, clusterInfo, progressListener)).length < asExistingNodes.length) {
                asExistingDownNodes = OiixFunctionOps.subtract(asExistingNodes, asActualExistingNodes);
            }
            if (asRemoteNodes != null && asRemoteNodes.length > 0) {
                asActualRemoteNodes = this.validateNodes(sLocalNode, asRemoteNodes, sInvLoc, clusterInfo, progressListener);
            }
            if (asActualRemoteNodes != null && asActualRemoteNodes.length > 0) {
                String sLogMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFW1009");
                OiiolTextLogger.appendText(sLogMsg);
                progressListener.setStatus(sLogMsg);
                asCleanMachines = OiipgClusterInvSetup.getCleanMachines(asActualRemoteNodes);
            }
            progressListener.addBytes(nRemoteNodes);
            if (allNodes.length > 1) {
                StringBuffer sb = new StringBuffer(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFW1014"));
                sb.append(this.m_sLineSeparator);
                if (nExistingNodes > 0) {
                    sb.append(this.getNodeStatus(clusterInfo, asExistingNodes));
                    sb.append(this.m_sLineSeparator);
                }
                sb.append(this.getNodeStatus(clusterInfo, asRemoteNodes));
                sb.append(this.m_sLineSeparator);
                sb.append(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFW1013"));
                sb.append(this.m_sLineSeparator);
                OiiolTextLogger.appendText(sb.toString());
            }
            retVal = this.processFailures(asExistingDownNodes, clusterInfo.getNodesWithErrors(asRemoteNodes));
            try {
                if (asExistingDownNodes != null && asExistingDownNodes.length > 0) {
                    OiisVariable oExistingNodesVar = this.m_vo.getVariable("EXISTING_REMOTE_NODES");
                    oExistingNodesVar.setValue(new OiisAdvisedValue(asActualExistingNodes, true));
                }
                if (asCleanMachines != null && asCleanMachines.length > 0) {
                    OiisVariable oRemoteCleanMachinesVar = this.m_vo.getVariable("REMOTE_CLEAN_MACHINES");
                    oRemoteCleanMachinesVar.setValue(new OiisAdvisedValue(asCleanMachines, true));
                }
            }
            catch (OiifbCancelException e) {
                OiiolTextLogger.appendException(e);
            }
            catch (OiisVarSettingException e) {
                OiiolTextLogger.appendException(e);
            }
        }
        catch (OiipgRemoteOpsException e) {
            String sTitle = OiixResourceBundle.getString("OIIFW1002");
            OiifmAlert.displayError(e.getErrorMessage(), sTitle);
            retVal = 1;
        }
        catch (OiipgClusterException e) {
            String sTitle = OiixResourceBundle.getString("OIIFW1002");
            OiifmAlert.displayError(e.getErrorMessage(), sTitle);
            retVal = 1;
        }
        progressListener.onDoneProgress();
        return retVal;
    }

    private String getNodeStatus(OiicClusterInstallInfo clusterInfo, String[] nodes) {
        StringBuffer sb = new StringBuffer("");
        if (nodes != null && nodes.length > 0) {
            for (int i = 0; i < nodes.length; ++i) {
                sb.append(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFW1011", new String[]{nodes[i]}));
                sb.append(this.m_sLineSeparator);
                OiicIClusterNode oNode = clusterInfo.getNode(nodes[i]);
                if (oNode == null) continue;
                if (!oNode.isAvailable()) {
                    List oErrList = oNode.getAvailabilityErrorList();
                    int iSize = oErrList.size();
                    for (int j = 0; j < iSize; ++j) {
                        sb.append(oErrList.get(j));
                        sb.append(this.m_sLineSeparator);
                    }
                    continue;
                }
                sb.append(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFW1012"));
                sb.append(this.m_sLineSeparator);
            }
        }
        return sb.toString();
    }

    private String[] validateNodes(String sLocalNode, String[] asNodes, String sInvLoc, OiicClusterInstallInfo clusterInfo, OiixProgressListener progressListener) throws OiipgClusterException, OiipgRemoteOpsException {
        String[] asActualNodes = asNodes;
        String sLogMsg = null;
        String sNodes = OiixFunctionOps.implodeList(asNodes, ",");
        sLogMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFW1005", new String[]{sNodes});
        OiiolTextLogger.appendText(sLogMsg);
        progressListener.setStatus(sLogMsg);
        sLogMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFW1006");
        OiiolTextLogger.appendText(sLogMsg);
        progressListener.setStatus(sLogMsg);
        asActualNodes = OiipgClusterChecks.getAliveNodes(asActualNodes, this.m_iPublicNodeTimeOut, clusterInfo, null);
        progressListener.addBytes(asNodes.length);
        sLogMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFW1007");
        OiiolTextLogger.appendText(sLogMsg);
        progressListener.setStatus(sLogMsg);
        String[] asNodesToTest = OiixFunctionOps.unionStr(sLocalNode, asActualNodes);
        asNodesToTest = OiipgClusterChecks.checkUserEquivalence(asNodesToTest, clusterInfo);
        asActualNodes = OiixFunctionOps.subtractStr(asNodesToTest, sLocalNode);
        progressListener.addBytes(asNodes.length);
        progressListener.addBytes(asNodes.length);
        return asActualNodes;
    }

    private boolean validateClusterVariables(String sLocalNode, String[] asRemoteNodes, String[] asClusterNodes) throws OiipgClusterException {
        Vector oClusterNodes;
        Vector oRemoteNodes = OiixVectorOps.strArr2Vect(asRemoteNodes);
        if (!OiixVectorOps.vectorSubset(oRemoteNodes, oClusterNodes = OiixVectorOps.strArr2Vect(asClusterNodes), false)) {
            String sRemoteNodes = OiixFunctionOps.implodeList(asRemoteNodes, ",");
            String sClusterNodes = OiixFunctionOps.implodeList(asClusterNodes, ",");
            Object[] args = new String[]{sRemoteNodes, sClusterNodes};
            throw new OiipgClusterException("OUI-25022", OiixResourceBundle.getString("OUI-25022", args));
        }
        boolean found = true;
        if (asClusterNodes != null && asClusterNodes.length > 0) {
            found = false;
            for (int i = 0; i < asClusterNodes.length; ++i) {
                if (!asClusterNodes[i].equalsIgnoreCase(sLocalNode)) continue;
                found = true;
                break;
            }
        }
        if (!found) {
            throw new OiipgClusterException("OUI-25023", OiixResourceBundle.getString("OUI-25023"));
        }
        boolean foundLocalNode = false;
        if (asRemoteNodes != null && asRemoteNodes.length > 0) {
            foundLocalNode = false;
            for (int i = 0; i < asRemoteNodes.length; ++i) {
                if (!asRemoteNodes[i].equalsIgnoreCase(sLocalNode)) continue;
                foundLocalNode = true;
                break;
            }
        }
        if (foundLocalNode) {
            String sRemoteNodes = OiixFunctionOps.implodeList(asRemoteNodes, ",");
            Object[] args = new String[]{sLocalNode, sRemoteNodes};
            throw new OiipgClusterException("OUI-25024", OiixResourceBundle.getString("OUI-25024", args));
        }
        return true;
    }

    private int processFailures(String[] asExistingDownNodes, String[] asRemoteDownNodes) {
        Object[] args;
        boolean bRemoteNodesDown;
        String sNodesDownMsg = "";
        int iAlertType = 10;
        int iButtons = 3;
        int iDefaultBtn = 1;
        int iUserChoice = 1;
        boolean bShowAlert = false;
        int retVal = 0;
        boolean bExistingNodesDown = asExistingDownNodes != null && asExistingDownNodes.length > 0;
        boolean bl = bRemoteNodesDown = asRemoteDownNodes != null && asRemoteDownNodes.length > 0;
        if (bExistingNodesDown) {
            String sExistingNodesDownMsg;
            args = new String[]{OiixFunctionOps.implodeList(asExistingDownNodes, ",")};
            sNodesDownMsg = sExistingNodesDownMsg = OiixResourceBundle.getString("OUI-25021", args);
            iAlertType = 10;
            iButtons = 3;
            iDefaultBtn = 1;
            bShowAlert = true;
        }
        if (bRemoteNodesDown) {
            args = new String[]{OiixFunctionOps.implodeList(asRemoteDownNodes, ",")};
            String sRemoteNodesDownMsg = OiixResourceBundle.getString("OUI-25020", args);
            if (bExistingNodesDown) {
                sNodesDownMsg = sNodesDownMsg + this.m_sLineSeparator;
            }
            sNodesDownMsg = sNodesDownMsg + sRemoteNodesDownMsg;
            iAlertType = 20;
            iButtons = 1;
            iDefaultBtn = 1;
            bShowAlert = true;
        }
        if (bShowAlert) {
            String sTitle = OiixResourceBundle.getString("OIIFW1002");
            iUserChoice = OiifmAlert.displayAlert(sTitle, sNodesDownMsg, iAlertType, iButtons, iDefaultBtn);
            retVal = iAlertType == 20 ? 1 : (iUserChoice == 1 ? 0 : 1);
        } else {
            retVal = 0;
        }
        return retVal;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public int getNext() {
        return this.m_nextInd;
    }
}

