/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifw;

import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Vector;
import oracle.ops.mgmt.cluster.ClusterInfo;
import oracle.ops.mgmt.cluster.ClusterInfoException;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbCondWizOperation;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterException;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterOps;
import oracle.sysman.oii.oiip.oiipg.OiipgDetectCluster;
import oracle.sysman.oii.oiip.oiipg.OiipgVendorClusterwareInfo;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiifwClusterHostNameCheckWCCE
implements OiifbCondWizOperation {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 4;
    private int m_nextInd;
    private OiisVariableOwner m_vo;
    private String[] m_nodeList;
    private String m_oracleHome;
    private OiicSessionInterfaceManager m_interfaceManager;

    public OiifwClusterHostNameCheckWCCE(OiisVariableOwner vo, int nextInd) {
        this.m_vo = vo;
        this.m_nextInd = nextInd;
    }

    public void initialize() throws OiifbEndIterateException {
        this.m_interfaceManager = OiicSessionInterfaceManager.getInterfaceManager();
    }

    public void dispose() {
    }

    public int doOperation(boolean back) throws OiifbEndIterateException {
        if (back) {
            return 1;
        }
        OiisVariable oOhPath = this.m_vo.getVariable("ORACLE_HOME");
        this.m_oracleHome = (String)oOhPath.getValue();
        OiisVariable oOhName = this.m_vo.getVariable("ORACLE_HOME_NAME");
        String sOhName = (String)oOhName.getValue();
        OiiiInstallAreaControl oAreaControl = OiiiInstallAreaControl.getInstallAreaControl();
        OiiiInstallInventory oInventory = oAreaControl.getInstallInventory();
        OiiiOracleHomeInfo oInfo = oInventory.getHomeWithLocation(this.m_oracleHome);
        if (oInfo != null) {
            Vector nodeList;
            if (oInfo.isCRSHome()) {
                nodeList = oInfo.getNodeList();
                if (nodeList != null && nodeList.size() > 0) {
                    this.m_nodeList = new String[nodeList.size()];
                    this.m_nodeList = OiixVectorOps.vect2StrArr(nodeList);
                    OiipgDetectCluster detectCluster = OiipgDetectCluster.getDetectCluster();
                    this.m_nodeList = detectCluster.orderNodes(this.m_nodeList);
                }
                OiisVariable oNewNodeNumbers = this.m_vo.getVariable("CLUSTER_NEW_NODE_NUMBERS");
                OiisVariable oNewNodes = this.m_vo.getVariable("CLUSTER_NEW_NODES");
                String[] newNodes = (String[])oNewNodes.getValue();
                String[] newHostNames = new String[newNodes.length];
                try {
                    newHostNames = OiipgClusterOps.getHostNamesEx(newNodes);
                }
                catch (OiipgClusterException cie) {
                    OiifmAlert.displayError(cie.getErrorMessage());
                    return 1;
                }
                String[] newNodeNumbers = null;
                try {
                    newNodeNumbers = new String[newNodes.length];
                    newNodeNumbers = this.computeNewNodeNumbers(newNodes);
                }
                catch (OiifbEndIterateException eie) {
                    return 1;
                }
                try {
                    oNewNodeNumbers.setValue(newNodeNumbers);
                }
                catch (OiisVarSettingException vse) {
                    OiiolTextLogger.appendException(vse);
                }
                catch (OiifbCancelException ce) {
                    OiiolTextLogger.appendException(ce);
                }
            }
            if ((nodeList = oInfo.getNodeList()) != null && nodeList.size() > 0) {
                OiisVariable oNewNodes = this.m_vo.getVariable("CLUSTER_NEW_NODES");
                String[] newNodes = (String[])oNewNodes.getValue();
                boolean newNodesCheck = true;
                String failedNewNodes = null;
                for (int i = 0; i < newNodes.length; ++i) {
                    if (nodeList.indexOf(newNodes[i]) <= -1) continue;
                    if (newNodesCheck) {
                        failedNewNodes = newNodes[i];
                        newNodesCheck = false;
                        continue;
                    }
                    failedNewNodes = failedNewNodes + "," + newNodes[i];
                    newNodesCheck = false;
                }
                if (!newNodesCheck) {
                    String logMsg = null;
                    logMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_VALIDATE_CLUSTER_NEW_NODES_ERROR", new String[]{failedNewNodes});
                    OiiolTextLogger.appendText(logMsg);
                    OiifmAlert.displayError(logMsg);
                    return 1;
                }
            }
        }
        return 0;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public int getNext() {
        return this.m_nextInd;
    }

    private String[] computeNewNodeNumbers(String[] newNodes) throws OiifbEndIterateException {
        String[] newNodeNumbers = null;
        if (this.m_nodeList != null && this.m_nodeList.length > 0 && newNodes != null && newNodes.length > 0) {
            newNodeNumbers = new String[newNodes.length];
            ClusterInfo oVendorClusterInfo = null;
            Hashtable vndrClusterNodeMap = null;
            boolean bVendorCluster = false;
            try {
                oVendorClusterInfo = OiipgVendorClusterwareInfo.getClusterInfo();
                vndrClusterNodeMap = oVendorClusterInfo.getClusterNodeMap();
                bVendorCluster = true;
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG1108"));
            }
            catch (ClusterInfoException e) {
                bVendorCluster = false;
                OiiolTextLogger.appendText(e.getMessage());
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG1107"));
            }
            if (bVendorCluster) {
                StringBuffer sMsgBuf = new StringBuffer("");
                boolean bError = false;
                for (int i = 0; i < newNodes.length; ++i) {
                    newNodeNumbers[i] = (String)vndrClusterNodeMap.get(newNodes[i]);
                    OiiolTextLogger.appendText("Assigning node number '" + newNodeNumbers[i] + "' to node '" + newNodes[i] + "'");
                    if (newNodeNumbers[i] != null) continue;
                    bError = true;
                    String sExp = "The node number cannot be obtained.";
                    sMsgBuf.append(MessageFormat.format("{0}: {1}\n", newNodes[i], sExp));
                }
                if (bError) {
                    String sMsg = "Unable to get node number for the following nodes:\n" + sMsgBuf.toString() + "\n. The nodes should be added to the underlying vendor clusterware before adding them to the CRS clusterware.";
                    OiifmAlert.displayError(sMsg);
                    throw new OiifbEndIterateException(sMsg);
                }
            } else {
                int i;
                String[] existingNodeNumbers = new String[this.m_nodeList.length];
                try {
                    ClusterInfo clInfo = new ClusterInfo(this.m_oracleHome);
                    for (i = 0; i < this.m_nodeList.length; ++i) {
                        existingNodeNumbers[i] = clInfo.getNodeNumber(this.m_nodeList[i]);
                    }
                }
                catch (ClusterInfoException cie) {
                    cie.printStackTrace();
                    String sErr = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_NODE_NUMBER_RETRIEVAL_ERROR");
                    this.m_interfaceManager.logMessage(sErr);
                    OiifmAlert.displayError(sErr);
                    throw new OiifbEndIterateException(sErr);
                }
                int highestNodeNumber = this.getHighestNodeNumber(existingNodeNumbers);
                for (i = 0; i < newNodes.length; ++i) {
                    newNodeNumbers[i] = Integer.toString(++highestNodeNumber);
                    OiiolTextLogger.appendText("Assigning node number '" + newNodeNumbers[i] + "' to node '" + newNodes[i] + "'");
                }
            }
        }
        return newNodeNumbers;
    }

    private int getHighestNodeNumber(String[] nodeNumbers) {
        int highest = 0;
        if (nodeNumbers != null && nodeNumbers.length > 0) {
            highest = Integer.parseInt(nodeNumbers[0]);
            for (int i = 0; i < nodeNumbers.length; ++i) {
                if (Integer.parseInt(nodeNumbers[i]) <= highest) continue;
                highest = Integer.parseInt(nodeNumbers[i]);
            }
        }
        return highest;
    }
}

