/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifw;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import oracle.sysman.emCfg.client.CfwClient;
import oracle.sysman.emCfg.client.CfwSession;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.common.IAggregate;
import oracle.sysman.emCfg.common.IAggregateReference;
import oracle.sysman.emCfg.common.IParameter;
import oracle.sysman.emCfg.common.IParameterReference;
import oracle.sysman.oii.oiic.OiicAPIInstaller;
import oracle.sysman.oii.oiic.OiicBaseApp;
import oracle.sysman.oii.oiic.OiicDeinstallSession;
import oracle.sysman.oii.oiic.OiicInstVersion;
import oracle.sysman.oii.oiic.OiicInstallSession;
import oracle.sysman.oii.oiic.OiicInstallTimeSession;
import oracle.sysman.oii.oiic.OiicInstaller;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiic.OiicSessionPlan;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbConfigController;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifb.OiifbProgressControl;
import oracle.sysman.oii.oiif.oiifb.OiifbWizOperation;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiif.oiifr.OiifrProgressActionListener;
import oracle.sysman.oii.oiif.oiifw.OiifwActionsPhaseWCDE;
import oracle.sysman.oii.oiii.OiiiCompIdOhPair;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiInstallLogManipulator;
import oracle.sysman.oii.oiii.OiiiInstallMiniPatchsetInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallOneoffInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallPatchInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallPatchSetInvEntry;
import oracle.sysman.oii.oiii.OiiiLibraryID;
import oracle.sysman.oii.oiii.OiiiOneoffIdOhPair;
import oracle.sysman.oii.oiii.OiiiOneoffInvEntry;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiii.OiiiPatchInstallID;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiij.OiijFastCopyConstants;
import oracle.sysman.oii.oiil.OiilAction;
import oracle.sysman.oii.oiil.OiilActionInputElement;
import oracle.sysman.oii.oiil.OiilDeinstallException;
import oracle.sysman.oii.oiil.OiilWinActionsDeinstall;
import oracle.sysman.oii.oiio.oiiod.OiiodDepEngine;
import oracle.sysman.oii.oiio.oiiol.OiiolActionLogEntry;
import oracle.sysman.oii.oiio.oiiol.OiiolConfigLogEntry;
import oracle.sysman.oii.oiio.oiiol.OiiolConfigLogManipulator;
import oracle.sysman.oii.oiio.oiiol.OiiolDefaultCopyGroupLogManipulator;
import oracle.sysman.oii.oiio.oiiol.OiiolLogManipulator;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiio.oiiol.OiiolXMLConfigLog;
import oracle.sysman.oii.oiip.oiipg.OiipgCFSDriveCheck;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterExecution;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterLogger;
import oracle.sysman.oii.oiis.OiisActionLibLoader;
import oracle.sysman.oii.oiis.OiisCompActions;
import oracle.sysman.oii.oiis.OiisCompContext;
import oracle.sysman.oii.oiis.OiisGenActionsReader;
import oracle.sysman.oii.oiis.OiisIdentifierOps;
import oracle.sysman.oii.oiis.OiisInstantiateInfo;
import oracle.sysman.oii.oiis.OiisMakeDeps;
import oracle.sysman.oii.oiis.OiisMakeDepsReader;
import oracle.sysman.oii.oiis.OiisPreRequisiteVar;
import oracle.sysman.oii.oiis.OiisProdHomeVar;
import oracle.sysman.oii.oiis.OiisRelinkActions;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiix.OiixCFOps;
import oracle.sysman.oii.oiix.OiixDebug;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixInstantiateOps;
import oracle.sysman.oii.oiix.OiixOraparam;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixSpawnException;
import oracle.sysman.oii.oiix.OiixSpawner;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiifwDeinstallPhaseWCCE
implements OiifbWizOperation {
    private static final String S_PAUSE_BETWEEN_DEINSTALL_PHASES = "oracle.installer.pauseBetweenDeinstallPhases";
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 1024;
    private final boolean m_bPauseBetweenDeinstallPhases = System.getProperty("oracle.installer.pauseBetweenDeinstallPhases", "false").equalsIgnoreCase("true");
    private OiicInstallTimeSession m_instSession;
    private OiicSessionPlan m_sessionPlan;
    private OiifrProgressActionListener m_progressListener;
    private OiifbProgressControl m_progressControl;
    private OiifwActionsPhaseWCDE m_actionsPhase;
    private OiicSessionInterfaceManager m_interfaceManager;
    private long m_lDeinstallProgressBytes = 0L;
    private String m_sGenActionsLoc = null;

    public OiifwDeinstallPhaseWCCE(OiifwActionsPhaseWCDE actionsPhase) {
        this.m_instSession = actionsPhase.getInstallSession();
        this.m_sessionPlan = this.m_instSession.getSessionPlan();
        this.m_progressControl = actionsPhase.getProgressControl();
        this.m_actionsPhase = actionsPhase;
        this.m_interfaceManager = OiicSessionInterfaceManager.getInterfaceManager();
        Vector vDeinstallList = this.m_sessionPlan.getRemoves(10);
        long lProgressBytes = vDeinstallList.size();
        this.setDeinstallProgressBytes(lProgressBytes);
    }

    public void initialize() {
        this.m_progressListener = (OiifrProgressActionListener)this.m_interfaceManager.getProgressListener();
        this.m_progressListener.onStartDeinstall();
        this.m_progressListener.onStartPhase(1);
    }

    public int doOperation(boolean isBack) throws OiifbEndIterateException {
        Thread main = Thread.currentThread();
        int priority = main.getPriority();
        main.setPriority(1);
        this.m_actionsPhase.setCurrentPhase(0);
        if (this.m_instSession.isDeinstallMode() && this.m_instSession instanceof OiicDeinstallSession) {
            OiicDeinstallSession deinstallSession = (OiicDeinstallSession)this.m_instSession;
            if (!this.warnRemoveAllFiles(deinstallSession)) {
                return 1;
            }
            if (!this.warnHomesContainingReferences(deinstallSession)) {
                return 1;
            }
        }
        Vector vDeinstallIdOhList = this.m_sessionPlan.getRemoves(10);
        Hashtable<Integer, Vector<OiiiCompIdOhPair>> hOHCompstable = new Hashtable<Integer, Vector<OiiiCompIdOhPair>>();
        int nCount = vDeinstallIdOhList.size();
        for (int i = 0; i < nCount; ++i) {
            OiiiCompIdOhPair deinstallIdOh = (OiiiCompIdOhPair)vDeinstallIdOhList.elementAt(i);
            int iHomeIdx = deinstallIdOh.getOHIndex();
            Vector<OiiiCompIdOhPair> vComps = (Vector<OiiiCompIdOhPair>)hOHCompstable.get(new Integer(iHomeIdx));
            if (vComps == null) {
                vComps = new Vector<OiiiCompIdOhPair>();
                hOHCompstable.put(new Integer(iHomeIdx), vComps);
            }
            vComps.add(deinstallIdOh);
        }
        Vector vDeinstallOneOffOhList = this.m_sessionPlan.getOneoffRemoves();
        try {
            OiifbCancelException exCancel;
            OiiiInstallCompInvEntry[] icies;
            block30: {
                this.m_actionsPhase.synchInstallInventory(this.m_progressListener);
                icies = this.getInstallInvEntriesForDeinstall(vDeinstallIdOhList);
                if (this.m_instSession.isDeinstallMode() && System.getProperty("oracle.installer.ouiApiMode", "false").equalsIgnoreCase("false")) {
                    this.m_progressListener.setStatus(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_LOG_DEINSTALL_CONFIG_TOOLS_BEGIN"));
                    this.doConfigDeinstallsByCF(vDeinstallIdOhList);
                }
                exCancel = null;
                try {
                    OiiiInstallInventory instInv = OiiiInstallAreaControl.getInstallAreaControl().getInstallInventory();
                    Properties backUp = new Properties();
                    Properties homeProps = null;
                    boolean relink = false;
                    Enumeration homes = hOHCompstable.keys();
                    while (homes.hasMoreElements()) {
                        Integer hIdx = (Integer)homes.nextElement();
                        int intVal = hIdx;
                        Vector vComps = (Vector)hOHCompstable.get(hIdx);
                        this.m_instSession.getSessionContext().setupGlobalVars(intVal);
                        OiilWinActionsDeinstall.readWinActions(instInv, intVal);
                        if (instInv.getAllCompsVect(intVal).size() >= vComps.size()) {
                            relink = true;
                        }
                        OiiiInstallCompInvEntry[] homeIcies = this.getInstallInvEntriesForDeinstall(vComps);
                        OiiiOracleHomeInfo ohInfo = instInv.getHomeInfo(intVal);
                        homeProps = ohInfo.getHomeProperties();
                        if (homeProps != null && homeProps.size() != 0) {
                            this.loadHomeProperties(homeProps, backUp);
                        }
                        List removeHomes = this.m_sessionPlan.getHomesToRemove();
                        int nIndex = -1;
                        if (removeHomes != null && removeHomes.size() > 0) {
                            nIndex = OiixVectorOps.vectIndexOf(removeHomes, (Object)ohInfo);
                        }
                        if (nIndex == -1) {
                            System.setProperty("oracle.installer.removeallfiles", "false");
                        }
                        if (this.m_instSession instanceof OiicDeinstallSession) {
                            OiisRelinkActions.setInstTimeSession(this.m_instSession);
                        }
                        this.m_sGenActionsLoc = null;
                        if (instInv.getHomeLocation(intVal) != null) {
                            this.m_sGenActionsLoc = OiixPathOps.concatPath(instInv.getHomeLocation(intVal), "inventory");
                            this.m_sGenActionsLoc = OiixPathOps.concatPath(this.m_sGenActionsLoc, "instantiate.xml");
                        }
                        this.doComponentDeinstalls(vComps, homeIcies);
                        if (backUp.size() == 0) continue;
                        this.unloadHomeProperties(backUp);
                    }
                    if (relink && this.m_actionsPhase.needLinkPhase() && this.m_instSession.isDeinstallMode()) {
                        this.doRelink();
                    }
                    if (this.m_instSession instanceof OiicDeinstallSession) {
                        OiisRelinkActions.setInstTimeSession(null);
                    }
                }
                catch (OiifbCancelException cancelEx) {
                    exCancel = cancelEx;
                }
                catch (Exception ex) {
                    if (OiiolTextLogger.getLogLevel() < OiiolTextLogger.LOG_TRACE) break block30;
                    OiiolTextLogger.appendException(ex);
                }
            }
            OiisRelinkActions.removeAll();
            this.deinstallUpdate(vDeinstallIdOhList, icies);
            if (this.m_bPauseBetweenDeinstallPhases) {
                OiifmAlert.displayError("Deinstall of components on current node complete.");
            }
            if (exCancel == null) {
                this.doOneoffDeinstalls(vDeinstallOneOffOhList);
            }
            if (this.m_bPauseBetweenDeinstallPhases) {
                OiifmAlert.displayError("Homes removed.");
            }
            if (this.m_instSession.isDeinstallMode()) {
                if (this.m_instSession instanceof OiicDeinstallSession) {
                    OiicDeinstallSession deinstallSession = (OiicDeinstallSession)this.m_instSession;
                    deinstallSession.clearAllLibLoaders();
                }
                this.saveInventory();
            }
            if (this.m_bPauseBetweenDeinstallPhases) {
                OiifmAlert.displayError("Inventory saved on current node.");
            }
            if (exCancel != null) {
                throw exCancel;
            }
            this.disposeHomeInvInfo();
            if (this.m_instSession instanceof OiicInstallSession) {
                OiicInstallSession installSession = (OiicInstallSession)this.m_instSession;
                OiiodDepEngine depEngine = installSession.getDepEngine();
                depEngine.dispose();
            }
            this.m_progressListener.onDoneDeinstall();
            this.m_progressListener.onDonePhase(1);
        }
        catch (OiifbEndIterateException endException) {
            throw endException;
        }
        catch (OiifbCancelException oce) {
            throw new OiifbEndIterateException(oce);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        main.setPriority(priority);
        return 0;
    }

    private boolean warnRemoveAllFiles(OiicDeinstallSession deinstallSession) {
        List removeHomes = this.m_sessionPlan.getHomesToRemove();
        int nHomes = removeHomes == null ? 0 : removeHomes.size();
        ArrayList<String> homesToDelete = new ArrayList<String>();
        ArrayList<String> warnDeletion = new ArrayList<String>();
        Object[] sArgs = new String[1];
        Properties dProps = this.getDefaultsOverriddenProps();
        boolean bCanSetRmFiles = false;
        boolean bRmfiles = Boolean.getBoolean("oracle.installer.removeallfiles");
        if (dProps != null && dProps.getProperty("oracle.installer.removeallfiles") != null) {
            bCanSetRmFiles = true;
        }
        boolean bCanSetWarnRmFiles = false;
        boolean bWarnRmfiles = Boolean.getBoolean("oracle.installer.warningonremovefiles");
        if (dProps != null && dProps.getProperty("oracle.installer.warningonremovefiles") != null) {
            bCanSetWarnRmFiles = true;
        }
        for (int i = 0; i < nHomes; ++i) {
            OiiiOracleHomeInfo oInfo = (OiiiOracleHomeInfo)removeHomes.get(i);
            String location = oInfo.getLocation();
            if (bCanSetRmFiles) {
                bRmfiles = oInfo.getBoolPropertyValue("oracle.installer.removeallfiles");
            }
            if (bRmfiles) {
                homesToDelete.add(location);
            }
            if (bCanSetWarnRmFiles) {
                bWarnRmfiles = oInfo.getBoolPropertyValue("oracle.installer.warningonremovefiles");
            }
            if (!bRmfiles || !bWarnRmfiles) continue;
            sArgs[0] = warnDeletion.size() == 0 ? location : (String)sArgs[0] + ", " + location;
            warnDeletion.add(location);
        }
        int nWarnDelHomes = warnDeletion.size();
        if (nWarnDelHomes > 0) {
            String sWarningTitle = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_WARNING");
            String sWarningMsg = nWarnDelHomes > 1 ? OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFW1018") : OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFW1017");
            int result = OiifmAlert.displayAlert(sWarningTitle, sWarningMsg = MessageFormat.format(sWarningMsg, sArgs), 30, 7, 1, 10);
            if (result == 4) {
                deinstallSession.setHomesToDelete(null);
                return false;
            }
            if (result == 2) {
                deinstallSession.setHomesToDelete(null);
                return true;
            }
        }
        deinstallSession.setHomesToDelete(homesToDelete);
        return true;
    }

    private boolean warnHomesContainingReferences(OiicDeinstallSession deinstallSession) {
        List removeHomes = this.m_sessionPlan.getHomesToRemove();
        int nHomes = removeHomes == null ? 0 : removeHomes.size();
        ArrayList<String> homesToDelete = new ArrayList<String>();
        ArrayList<String> warnDeletion = new ArrayList<String>();
        Object[] sArgs = new String[2];
        String allRefHomes = null;
        for (int i = 0; i < nHomes; ++i) {
            OiiiOracleHomeInfo oInfo = (OiiiOracleHomeInfo)removeHomes.get(i);
            String location = oInfo.getLocation();
            Vector refList = oInfo.getRefHomeList();
            if (refList != null && refList.size() > 0) {
                allRefHomes = OiifwDeinstallPhaseWCCE.getRefHomesName(refList, allRefHomes);
                sArgs[0] = warnDeletion.size() == 0 ? location : (String)sArgs[0] + ", " + location;
                warnDeletion.add(location);
                continue;
            }
            homesToDelete.add(location);
        }
        int nWarnDelHomes = warnDeletion.size();
        if (nWarnDelHomes > 0) {
            sArgs[1] = allRefHomes;
            String sErrorTitle = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ERROR");
            String sErrorMsg = nWarnDelHomes > 1 ? OiixResourceBundle.getString("S_ERR_HOME_HAS_REFERENCES2") : OiixResourceBundle.getString("S_ERR_HOME_HAS_REFERENCES1");
            sErrorMsg = MessageFormat.format(sErrorMsg, sArgs);
            int result = OiifmAlert.displayError(sErrorMsg, sErrorTitle);
        }
        return removeHomes == null || homesToDelete.size() >= removeHomes.size();
    }

    private static String getRefHomesName(Vector refList, String baseString) {
        String retVal = "";
        if (baseString != null && baseString.trim().length() > 0) {
            retVal = baseString.trim();
        }
        int numElems = refList.size();
        for (int i = 0; i < numElems; ++i) {
            String str = (String)refList.elementAt(i);
            retVal = retVal.length() > 0 ? retVal + ", " + str : str;
        }
        return retVal;
    }

    private Properties getDefaultsOverriddenProps() {
        Properties dProps = null;
        OiicBaseApp oInstaller = null;
        oInstaller = System.getProperty("oracle.installer.ouiApiMode", "false").equalsIgnoreCase("true") ? OiicAPIInstaller.getAPIInstallerInstance() : OiicInstaller.getOiicInstallerInstance();
        dProps = oInstaller.getDefaultsOverriden();
        return dProps;
    }

    private void loadHomeProperties(Properties homeProps, Properties backUp) {
        Properties sysProps = System.getProperties();
        Properties dProps = this.getDefaultsOverriddenProps();
        Enumeration<?> propNames = homeProps.propertyNames();
        while (propNames.hasMoreElements()) {
            String propVal;
            String propName = (String)propNames.nextElement();
            String sysPropVal = sysProps.getProperty(propName);
            if (sysPropVal == null) {
                if (dProps != null && dProps.getProperty(propName) != null) {
                    propVal = dProps.getProperty(propName);
                    if (propVal == null) {
                        propVal = "";
                    }
                    backUp.put(propName, propVal);
                }
            } else {
                backUp.put(propName, sysPropVal);
            }
            propVal = homeProps.getProperty(propName);
            System.setProperty(propName, propVal);
            OiiolTextLogger.appendText("Set " + propName + " to " + propVal, OiiolTextLogger.LOG_DETAILED);
        }
    }

    private void unloadHomeProperties(Properties backUp) {
        Properties sysProps = System.getProperties();
        Properties dProps = this.getDefaultsOverriddenProps();
        Enumeration<?> propNames = backUp.propertyNames();
        while (propNames.hasMoreElements()) {
            String propName = (String)propNames.nextElement();
            String propVal = backUp.getProperty(propName);
            if ("".equals(propVal) && (dProps == null || dProps.getProperty(propName) == null)) {
                sysProps.remove(propName);
                OiiolTextLogger.appendText("Remove " + propName + " from System", OiiolTextLogger.LOG_DETAILED);
                continue;
            }
            sysProps.put(propName, propVal);
            OiiolTextLogger.appendText("Set " + propName + " to " + propVal, OiiolTextLogger.LOG_DETAILED);
        }
        backUp.clear();
    }

    public void dispose() {
    }

    private void disposeHomeInvInfo() {
        OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
        OiiiInstallInventory inv = iac.getInstallInventory();
        int[] idx = new int[]{0, this.m_instSession.getOHIndex(), this.m_instSession.getAppltopIndex()};
        inv.disposeHomeInvInfo(idx);
    }

    private void doRelink() throws OiifbEndIterateException {
        block2: {
            try {
                OiisRelinkActions oRelinkActions = new OiisRelinkActions();
                oRelinkActions.init(this.m_instSession);
                oRelinkActions.setCallBack(this.m_progressListener);
                oRelinkActions.doReLinkGroupByOH();
            }
            catch (OiifbCancelException cancelEx) {
                if (!cancelEx.isCancelSession()) break block2;
                throw new OiifbEndIterateException(cancelEx.getMessage());
            }
        }
    }

    private void saveInventory() throws OiifbEndIterateException {
        try {
            OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
            iac.setSaveCloneXMLInfo(true);
            iac.setDeinstallMode(true);
            iac.saveInstallInventory();
            iac.setSaveCloneXMLInfo(false);
            boolean isAPIMode = System.getProperty("oracle.installer.ouiApiMode", "false").equalsIgnoreCase("true");
            if (this.m_instSession.isDeinstallMode() && isAPIMode) {
                iac.releaseWriterLock();
                OiiolTextLogger.appendText("Released the writer lock in deinstall mode");
            }
            iac.setDeinstallMode(false);
        }
        catch (IOException ioe) {
            throw new OiifbEndIterateException(ioe.getMessage());
        }
        catch (OiifbCancelException cancelException) {
            throw new OiifbEndIterateException(cancelException.getMessage());
        }
    }

    private void deinstallUpdate(Vector vDeinstallIdOhList, OiiiInstallCompInvEntry[] icies) {
        OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
        OiiiInstallInventory instInv = iac.getInstallInventory();
        this.m_progressListener.setStatus(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_REMOVING_DI_ENTRY"));
        int numDeinstalls = vDeinstallIdOhList.size();
        Vector oracleHomes = instInv.getHomes();
        for (int i = 0; i < numDeinstalls; ++i) {
            OiiiInstallPatchSetInvEntry pCie;
            OiiiInstallPatchInvEntry ipie;
            OiiiCompIdOhPair ohID;
            OiiiCompIdOhPair deinstallIdOh = (OiiiCompIdOhPair)vDeinstallIdOhList.elementAt(i);
            if (!deinstallIdOh.isDeinstalled()) continue;
            this.cleanCompDir(icies[i], deinstallIdOh.getOHIndex());
            OiiiCompInstallID deinstallID = deinstallIdOh.getCompID();
            int deinstOhIndex = deinstallIdOh.getOHIndex();
            Vector referencers = icies[i].getReferencers();
            Enumeration depEn = referencers.elements();
            while (depEn.hasMoreElements()) {
                int depOhIndex;
                OiiiCompIdOhPair depIdOh = (OiiiCompIdOhPair)depEn.nextElement();
                OiiiCompInstallID depID = depIdOh.getCompID();
                OiiiCompInvEntry dCie = instInv.getCompatCompEntry(depID, depOhIndex = depIdOh.getOHIndex());
                if (dCie == null) continue;
                OiiiCompIdOhPair cohpDep = new OiiiCompIdOhPair(deinstallID, deinstOhIndex);
                cohpDep = dCie.getDependee(cohpDep);
                OiiiCompIdOhPair cohpRef = icies[i].getReferencer(new OiiiCompIdOhPair(depID, depOhIndex));
                if (cohpDep != null && cohpRef != null) {
                    cohpRef.setDepType(cohpDep.getDepType());
                    cohpRef.setDepGroup(cohpDep.getDepGroup());
                    dCie.removeDependee(cohpDep);
                    continue;
                }
                dCie.removeDependee(new OiiiCompIdOhPair(depID, depOhIndex));
            }
            referencers = icies[i].getReferencers();
            icies[i].setReferencers(new Vector());
            referencers.removeElement(deinstallIdOh);
            this.m_sessionPlan.noteRefs(deinstallID, referencers);
            if (icies[i].isTopLevel()) {
                this.m_sessionPlan.addToTopLevelList(deinstallID);
            }
            Vector dependees = icies[i].getDependees();
            this.m_sessionPlan.noteDeps(deinstallID, dependees);
            depEn = dependees.elements();
            while (depEn.hasMoreElements()) {
                int depOhIndex;
                OiiiCompIdOhPair depIdOh = (OiiiCompIdOhPair)depEn.nextElement();
                OiiiCompInstallID depID = depIdOh.getCompID();
                OiiiCompInvEntry dCie = instInv.getCompatCompEntry(depID, depOhIndex = depIdOh.getOHIndex());
                if (dCie == null) continue;
                dCie.removeReferencer(new OiiiCompIdOhPair(deinstallID, deinstOhIndex));
            }
            if (deinstallID.getCompType() == 2 && (ohID = (ipie = (OiiiInstallPatchInvEntry)icies[i]).getPSetIDOH()) != null && (pCie = (OiiiInstallPatchSetInvEntry)instInv.getInstallCompInvEntry(ohID.getCompID(), ohID.getOHIndex())) != null) {
                int idx;
                pCie.removePatch((OiiiPatchInstallID)deinstallID);
                if (pCie.getPatches().size() == 0) {
                    instInv.removeCompInvEntry(ohID.getCompID(), ohID.getOHIndex());
                }
                if ((idx = OiixVectorOps.vectIndexOf(oracleHomes, (Object)new Integer(ohID.getOHIndex()))) != -1) {
                    OiiiOracleHomeInfo ohInfo = (OiiiOracleHomeInfo)oracleHomes.elementAt(idx);
                    ohInfo.setDirty(true);
                }
            }
            instInv.removeCompInvEntry(deinstallID, deinstOhIndex);
            instInv.removeCompCloneVars(deinstallID, deinstOhIndex);
        }
    }

    private void cleanCompDir(OiiiInstallCompInvEntry icie, int homeIndex) {
        OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
        String compLoc = iac.genLogLoc(icie.getLocation());
        String[] delDirNames = new String[]{"resources"};
        String[] delFileNames = new String[]{"install.log", "context.ser", "config.log"};
        this.cleanDir(compLoc, delFileNames, delDirNames);
        compLoc = icie.getLocationInXMLInventory();
        String sInvDir = iac.getInventoryLocForHome(homeIndex);
        compLoc = OiixPathOps.concatPath(sInvDir, compLoc);
        delFileNames = new String[]{"installlog.xml", "installIP1Log.xml", "installIP2Log.xml", "installLinkLog.xml", "context.xml", "configlog.xml", OiijFastCopyConstants.FASTCOPY_LOG_NAME};
        File logFilesParentDir = new File(compLoc);
        String[] langAddonLogFiles = iac.getLangAddonLogFilesForDeinstall(logFilesParentDir);
        if (langAddonLogFiles != null) {
            int i;
            String[] normalLogFiles = (String[])delFileNames.clone();
            delFileNames = null;
            delFileNames = new String[normalLogFiles.length + langAddonLogFiles.length];
            int index = 0;
            for (i = 0; i < langAddonLogFiles.length; ++i) {
                delFileNames[index++] = langAddonLogFiles[i];
            }
            for (i = 0; i < normalLogFiles.length; ++i) {
                delFileNames[index++] = normalLogFiles[i];
            }
        }
        OiicSessionContext oContext = this.m_instSession.getSessionContext();
        OiisVariable oNodeNames = oContext.getVariable("CLUSTER_NODES");
        String[] nodeMsgArr = (String[])oNodeNames.getValue();
        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
            OiiolTextLogger.appendText("node list:" + nodeMsgArr, OiiolTextLogger.LOG_DETAILED);
            if (nodeMsgArr != null) {
                OiiolTextLogger.appendText("node list:" + OiixFunctionOps.implodeList(nodeMsgArr, ","), OiiolTextLogger.LOG_DETAILED);
            }
        }
        if (nodeMsgArr != null && nodeMsgArr.length > 0) {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("Component logs not deleted");
            }
        } else {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("Local node deinstall: Component logs deleted");
            }
            this.cleanDir(compLoc, delFileNames, delDirNames);
        }
    }

    private void cleanDir(String sBaseDir, String[] delFiles, String[] delDirs) {
        String parPath;
        int i;
        sBaseDir = OiixPathOps.getNativeForm(sBaseDir);
        File delFile = null;
        for (i = 0; i < delDirs.length; ++i) {
            delFile = new File(sBaseDir, delDirs[i]);
            OiixFileOps.recdelete(delFile);
        }
        for (i = 0; i < delFiles.length; ++i) {
            delFile = new File(sBaseDir, delFiles[i]);
            delFile.delete();
        }
        while ((delFile = new File(parPath = delFile.getParent())).delete()) {
        }
    }

    private OiiiInstallCompInvEntry[] getInstallInvEntriesForDeinstall(Vector deinstallIdOhs) throws IOException {
        OiiiInstallCompInvEntry[] icies = new OiiiInstallCompInvEntry[deinstallIdOhs.size()];
        OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
        OiiiInstallInventory instInv = iac.getInstallInventory();
        int numDeinstalls = deinstallIdOhs.size();
        this.m_progressListener.setStatus(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ACCESSING_LOGS"));
        for (int i = 0; i < numDeinstalls; ++i) {
            OiiiCompIdOhPair cIdOh = (OiiiCompIdOhPair)deinstallIdOhs.elementAt(i);
            OiiiCompInstallID cid = cIdOh.getCompID();
            int compOhIndex = cIdOh.getOHIndex();
            icies[i] = instInv.getInstallCompInvEntry(cid, compOhIndex);
        }
        this.m_progressListener.setStatus("");
        return icies;
    }

    private void passComponentConfigParametersToCF(CfwSession m_cfwSession, OiiiInstallCompInvEntry[] iciesCfw) {
        int numInstalls = iciesCfw.length;
        for (int i = 0; i < numInstalls; ++i) {
            OiiiInstallCompInvEntry icie = iciesCfw[i];
            OiisCompContext compContext = OiisCompContext.createContextFromInstallInv(icie, icie.getOHIndex());
            if (null == compContext || icie.getCompProperties().getConfigToolCount() <= 0) continue;
            IAggregate cfwAggr = null;
            OiiiCompInstallID cid = icie.getCompInstallID();
            cfwAggr = OiixCFOps.getAggregate(m_cfwSession, cid.getName());
            if (cfwAggr == null) continue;
            IParameterReference[] paramRef = null;
            try {
                paramRef = cfwAggr.getParameterReferences();
            }
            catch (CfwException exc) {
                OiiolTextLogger.appendText(exc.getMessage());
            }
            if (paramRef == null) continue;
            HashMap<String, IParameter> ssnVarsHashMap = new HashMap<String, IParameter>(paramRef.length);
            for (int j = 0; j < paramRef.length; ++j) {
                IParameter param = OiixCFOps.getParameter(cfwAggr, paramRef[j]);
                ssnVarsHashMap.put(paramRef[j].getSelfID(), param);
            }
            this.handlePassParameters(compContext.getROVariables(), ssnVarsHashMap);
            OiicSessionContext ssnContext = this.m_instSession.getSessionContext();
            this.handlePassParameters(ssnContext.getAllVariables(), ssnVarsHashMap);
            this.handlePassParameters(compContext.getAllVariables(), ssnVarsHashMap);
        }
    }

    private void handlePassParameters(Enumeration varEnum, HashMap ssnVarsHashMap) {
        Enumeration e = varEnum;
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            OiisVariable v = (OiisVariable)obj;
            IParameter p = null;
            p = (IParameter)ssnVarsHashMap.get(v.getName());
            if (p == null || v.getValue() == null) continue;
            if (obj instanceof OiisProdHomeVar) {
                OiixCFOps.passParameter(p, v.getValue(), 1);
                continue;
            }
            if (obj instanceof OiisPreRequisiteVar) {
                OiixCFOps.passParameter(p, v.getValue(), 3);
                continue;
            }
            if (!(obj instanceof OiisVariable)) continue;
            OiixCFOps.passParameter(p, v.getValue(), v.getType());
        }
    }

    public OiiiInstallCompInvEntry[] getCompInvEntriesForDeinstall(Vector vDeinstCompIDOHPairListPerHome) {
        OiiiInstallCompInvEntry[] vCompEntries = new OiiiInstallCompInvEntry[vDeinstCompIDOHPairListPerHome.size()];
        OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
        OiiiInstallInventory instInv = iac.getInstallInventory();
        for (int i = 0; i < vDeinstCompIDOHPairListPerHome.size(); ++i) {
            OiiiInstallCompInvEntry icie;
            CompIDOHPair cidohp = (CompIDOHPair)vDeinstCompIDOHPairListPerHome.elementAt(i);
            OiiiCompInstallID cid = cidohp.getCompID();
            vCompEntries[i] = icie = instInv.getInstallCompInvEntry(cid, cidohp.getOHIndex());
        }
        return vCompEntries;
    }

    private void doConfigDeinstallsByCF(Vector vDeinstallIdOhList) {
        Vector vDeinstCompIDOHPairListGrpByHome = this.getDeinstCompIDOHPairListGrpByHome(vDeinstallIdOhList);
        OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
        OiiiInstallInventory instInv = iac.getInstallInventory();
        for (int i = 0; i < vDeinstCompIDOHPairListGrpByHome.size(); ++i) {
            OiiiVersion v102 = OiicInstVersion.getCompatibleInstallerVersion();
            Vector vDeinstCompIDOHPairListPerHome = (Vector)vDeinstCompIDOHPairListGrpByHome.elementAt(i);
            CompIDOHPair cidohp = (CompIDOHPair)vDeinstCompIDOHPairListPerHome.elementAt(0);
            int nOHIndex = cidohp.getOHIndex();
            OiiiCompInstallID cid = cidohp.getCompID();
            OiiiInstallCompInvEntry icie = instInv.getInstallCompInvEntry(cid, nOHIndex);
            if (icie.getInstallerVersion().laterThan(v102) || icie.getInstallerVersion().equals(v102)) {
                String sOHLoc = instInv.getHomeLocation(nOHIndex);
                Vector topLevelCompIDs = this.getTLCompIDs(vDeinstCompIDOHPairListPerHome);
                ArrayList<String> TLAggrs = new ArrayList<String>();
                for (int j = 0; j < topLevelCompIDs.size(); ++j) {
                    OiiiCompInstallID cidTL = (OiiiCompInstallID)topLevelCompIDs.elementAt(j);
                    if (cidTL.isNOHComp()) {
                        OiiolTextLogger.writeToLogAndConsole("can't run plugIns for NOH component");
                        continue;
                    }
                    String topLevelAggregateName = cidTL.getName();
                    TLAggrs.add(topLevelAggregateName);
                }
                if (TLAggrs.size() == 0) continue;
                List<Object> aggregatesToLoad = Arrays.asList(TLAggrs.toArray());
                String sConfigXMLRltPath = OiiiInstallAreaControl.getConfigXMLDirRltPath();
                sConfigXMLRltPath = OiixPathOps.getNativeForm(sConfigXMLRltPath);
                boolean bDebug = false;
                if (!new File(sOHLoc + File.separator + sConfigXMLRltPath).exists()) continue;
                String configXMLDirName = sOHLoc.concat("/").concat(sConfigXMLRltPath);
                File f = new File(configXMLDirName = OiixPathOps.getNativeForm(configXMLDirName));
                if (f.exists()) {
                    for (int ii = 0; ii < TLAggrs.size(); ++ii) {
                        String aggrName = (String)TLAggrs.get(ii);
                        OiiolTextLogger.appendText("Deleting the Instance files for the aggregate " + aggrName);
                        OiixCFOps.deleteCFInstanceFiles(configXMLDirName, aggrName);
                    }
                }
                CfwClient cfwClient = OiixCFOps.getCfwClient(bDebug, sOHLoc, sConfigXMLRltPath, sConfigXMLRltPath, aggregatesToLoad);
                CfwSession cfwSession = null;
                if (cfwClient != null) {
                    cfwSession = OiixCFOps.getCfwSession(cfwClient);
                }
                if (cfwSession == null) continue;
                if (bDebug) {
                    OiixDebug.debug("OiifwDeinstallPhaseWCCE", "not passing the session variables to cfw");
                }
                this.passComponentConfigParametersToCF(cfwSession, this.getCompInvEntriesForDeinstall(vDeinstCompIDOHPairListPerHome));
                for (int j = 0; j < topLevelCompIDs.size(); ++j) {
                    OiiiCompInstallID cidTL = (OiiiCompInstallID)topLevelCompIDs.elementAt(j);
                    IAggregate topLevelAggr = this.getAggregate(cfwSession, cidTL.getName());
                    if (null == topLevelAggr) continue;
                    OiifbConfigController controller = new OiifbConfigController();
                    controller.initializeForDeinstall(OiicPullSession.isSilentMode(), topLevelAggr, cfwSession);
                    controller.launchConfigToolsForDeinstall(this.m_progressListener);
                }
                continue;
            }
            Vector<OiiiCompIdOhPair> vDeinstallIdOHList = new Vector<OiiiCompIdOhPair>();
            for (int j = 0; j < vDeinstCompIDOHPairListPerHome.size(); ++j) {
                CompIDOHPair iohp = (CompIDOHPair)vDeinstCompIDOHPairListPerHome.elementAt(j);
                vDeinstallIdOHList.addElement(iohp.getCompIDOhPair());
            }
            OiiiInstallCompInvEntry[] icies = this.getInstallCompInvEntries(vDeinstCompIDOHPairListPerHome);
            this.doConfigDeinstalls(vDeinstallIdOHList, icies);
        }
        OiixCFOps.disconnectCfwClients();
    }

    private OiiiInstallCompInvEntry[] getInstallCompInvEntries(Vector vCompIDOHPairs) {
        OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
        OiiiInstallInventory instInv = iac.getInstallInventory();
        ArrayList<OiiiInstallCompInvEntry> lst = new ArrayList<OiiiInstallCompInvEntry>();
        for (int i = 0; i < vCompIDOHPairs.size(); ++i) {
            CompIDOHPair cidohp = (CompIDOHPair)vCompIDOHPairs.elementAt(i);
            OiiiCompInstallID cid = cidohp.getCompID();
            int nOhIndex = cidohp.getOHIndex();
            OiiiInstallCompInvEntry icie = instInv.getInstallCompInvEntry(cid, nOhIndex);
            lst.add(icie);
        }
        OiiiInstallCompInvEntry[] icies = new OiiiInstallCompInvEntry[lst.size()];
        lst.toArray(icies);
        return icies;
    }

    private IAggregate getAggregate(CfwSession cfwSession, String sCompName) {
        IAggregateReference[] aggrRef = null;
        try {
            aggrRef = cfwSession.getAggregateReferences("common");
        }
        catch (CfwException excep) {
            OiiolTextLogger.appendText(excep.getMessage());
        }
        if (aggrRef != null) {
            for (int i = 0; i < aggrRef.length; ++i) {
                if (aggrRef[i].getSelfID().compareTo(sCompName) != 0) continue;
                try {
                    return cfwSession.getAggregate(aggrRef[i]);
                }
                catch (CfwException e) {
                    OiiolTextLogger.appendText(e.getMessage());
                    return null;
                }
            }
        }
        return null;
    }

    private CfwClient getCfwClient(boolean bDebug, String sOraHome, String sAggrXMLPath, String sAggrInstancePath, List aggrsToLoad) {
        CfwClient cl = null;
        try {
            cl = CfwClient.connect((boolean)bDebug, (String)sOraHome, (String)sAggrXMLPath, (String)sAggrInstancePath, (List)aggrsToLoad);
        }
        catch (CfwException e) {
            OiiolTextLogger.appendText(e.getMessage());
            return cl;
        }
        return cl;
    }

    private Vector getTLCompIDs(Vector vCompIDOHPair) {
        Vector<OiiiCompInstallID> topLevelComps = new Vector<OiiiCompInstallID>();
        OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
        OiiiInstallInventory instInv = iac.getInstallInventory();
        for (int i = 0; i < vCompIDOHPair.size(); ++i) {
            CompIDOHPair cidohp = (CompIDOHPair)vCompIDOHPair.elementAt(i);
            OiiiCompInstallID cid = cidohp.getCompID();
            OiiiInstallCompInvEntry icie = instInv.getInstallCompInvEntry(cid, cidohp.getOHIndex());
            if (!icie.isTopLevel()) continue;
            topLevelComps.addElement(cidohp.getCompID());
        }
        return topLevelComps;
    }

    private Vector getDeinstCompIDOHPairListGrpByHome(Vector vDeinstallIdOhList) {
        ArrayList<CompIDOHPair> lst = new ArrayList<CompIDOHPair>();
        for (int i = 0; i < vDeinstallIdOhList.size(); ++i) {
            OiiiCompIdOhPair cidohpair = (OiiiCompIdOhPair)vDeinstallIdOhList.elementAt(i);
            CompIDOHPair cidohp = new CompIDOHPair(cidohpair);
            lst.add(cidohp);
        }
        Object[] cidohpList = new CompIDOHPair[lst.size()];
        lst.toArray(cidohpList);
        Arrays.sort(cidohpList);
        Vector ret = new Vector();
        Vector<Object> vCompsPerOH = new Vector<Object>();
        if (cidohpList.length == 1) {
            vCompsPerOH.addElement(cidohpList[0]);
            ret.addElement(vCompsPerOH);
            return ret;
        }
        vCompsPerOH.addElement(cidohpList[0]);
        for (int i = 0; i < cidohpList.length; ++i) {
            if (i < cidohpList.length - 1 && ((CompIDOHPair)cidohpList[i]).getOHIndex() == ((CompIDOHPair)cidohpList[i + 1]).getOHIndex()) {
                vCompsPerOH.addElement(cidohpList[i + 1]);
                continue;
            }
            if (i == cidohpList.length - 1) {
                ret.addElement(vCompsPerOH);
                continue;
            }
            ret.addElement(vCompsPerOH);
            vCompsPerOH = new Vector();
            vCompsPerOH.addElement(cidohpList[i + 1]);
        }
        return ret;
    }

    private void doConfigDeinstalls(Vector vDeinstallIdOhList, OiiiInstallCompInvEntry[] icies) {
        int numDeinstalls = vDeinstallIdOhList.size();
        for (int i = 0; i < numDeinstalls; ++i) {
            String sLogLoc;
            String sCompLoc;
            OiiiInstallAreaControl oInstAreacontrol = OiiiInstallAreaControl.getInstallAreaControl();
            OiiiCompIdOhPair oIdOhPair = (OiiiCompIdOhPair)vDeinstallIdOhList.elementAt(i);
            int nOhIndex = oIdOhPair.getOHIndex();
            Vector vConfigEntries = new Vector();
            OiiiVersion v21 = new OiiiVersion("2.1.0.4.0");
            if (v21.laterThan(icies[i].getInstallerVersion())) {
                sCompLoc = icies[i].getLocation();
                sLogLoc = oInstAreacontrol.getConfigLogLoc(sCompLoc);
                if (!new File(sLogLoc = OiixPathOps.getNativeForm(sLogLoc)).exists()) continue;
                vConfigEntries = OiiolConfigLogManipulator.readComponentToolEntries(sLogLoc);
            } else {
                sCompLoc = icies[i].getLocationInXMLInventory();
                sLogLoc = oInstAreacontrol.getXMLConfigLogLoc(nOhIndex, sCompLoc);
                if (!new File(sLogLoc = OiixPathOps.getNativeForm(sLogLoc)).exists()) continue;
                OiiolXMLConfigLog oXMLLog = new OiiolXMLConfigLog(sLogLoc);
                vConfigEntries = oXMLLog.readConfigLogEntries();
            }
            if (vConfigEntries == null) continue;
            int nConfigToolCount = vConfigEntries.size();
            for (int j = 0; j < nConfigToolCount; ++j) {
                String sMsg;
                OiiolConfigLogEntry oConfigEntry = (OiiolConfigLogEntry)vConfigEntries.elementAt(j);
                String commandLine = "";
                if (OiicPullSession.isSilentMode()) {
                    commandLine = oConfigEntry.getSilentCL();
                    if (commandLine == null || commandLine.equals("")) {
                        Object[] obj = new String[]{oConfigEntry.getName()};
                        sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CONFIG_DEINSTALL_FAILURE");
                        sMsg = MessageFormat.format(sMsg, obj);
                        OiiolTextLogger.appendText(sMsg, OiiolTextLogger.LOG_BASIC);
                        continue;
                    }
                } else {
                    commandLine = oConfigEntry.getInteractiveCL();
                }
                OiixSpawner process = new OiixSpawner();
                try {
                    sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_LOG_COMMAND_SPAWNED", new Object[]{commandLine});
                    OiiolTextLogger.appendText(sMsg, OiiolTextLogger.LOG_BASIC);
                    process.execute(commandLine);
                    continue;
                }
                catch (OiixSpawnException se) {
                    OiiolTextLogger.appendText("Command not executed due to exception :" + se.getMessage());
                }
            }
        }
    }

    public void doOneoffDeinstalls(Vector vDeinstallIdOhList) {
        OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
        OiiiInstallInventory instInv = iac.getInstallInventory();
        int iSize = vDeinstallIdOhList.size();
        for (int i = 0; i < iSize; ++i) {
            try {
                OiiiOneoffInvEntry oEntry;
                OiiiOneoffIdOhPair oPair = (OiiiOneoffIdOhPair)vDeinstallIdOhList.elementAt(i);
                if (oPair.isOneoff()) {
                    oEntry = instInv.getOneoffInvEntry(oPair.getOneoffID().getID(), oPair.getHomeIndex());
                    instInv.removeOneoffInvEntry((OiiiInstallOneoffInvEntry)oEntry);
                } else {
                    oEntry = instInv.getMiniPatchsetInvEntry(oPair.getOneoffID().getID(), oPair.getHomeIndex());
                    instInv.removeMiniPatchsetInvEntry((OiiiInstallMiniPatchsetInvEntry)oEntry);
                }
                String inventoryLocation = iac.getInventoryLocForHome(oPair.getHomeIndex());
                String oneoffLocation = iac.getXMLOneoffFullLoc(oPair.getOneoffID(), oPair.getHomeIndex());
                File oneoffDir = new File(OiixPathOps.concatPath(inventoryLocation, oneoffLocation));
                OiixFileOps.recdelete(oneoffDir);
                oneoffDir.delete();
                continue;
            }
            catch (Exception e) {
                System.err.println("Error in oneoff deinstalls :" + e.getMessage());
            }
        }
    }

    private void doComponentDeinstalls(Vector vDeinstallIdOhList, OiiiInstallCompInvEntry[] icies) throws IOException, OiifbCancelException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        int[] phases = new int[]{8, 2, 16, 1, 32};
        int numDeinstalls = vDeinstallIdOhList.size();
        this.m_progressListener.setStatus(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_STARTING_DEINSTALL"));
        if (numDeinstalls > 0 && this.m_instSession.isDeinstallMode()) {
            OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_TL_INSTALLACTIONSPHASE_BEGIN_DI"), OiiolTextLogger.LOG_BASIC);
        }
        int nPerCompProgress = (int)(this.getDeinstallProgressBytes() / (long)(numDeinstalls > 0 ? numDeinstalls : 1));
        OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
        OiiiInstallInventory instInv = iac.getInstallInventory();
        ArrayList deinstallCompsList = OiixOraparam.getDeinstallComponents();
        boolean deinstallOnUpgrade = false;
        Vector clusterNodes = new Vector(1);
        String[] clusterNodeList = null;
        String[] remoteNodes = null;
        String localNode = null;
        HashMap<OiiiCompIdOhPair, Boolean> parseTopLevel = new HashMap<OiiiCompIdOhPair, Boolean>();
        String val = OiixOraparam.getOraparamProfileString("IGNORECLUSTER", "false");
        if (!val.equalsIgnoreCase("true")) {
            OiipgCFSDriveCheck.dispose();
        }
        ArrayList instantiates = null;
        if (this.m_sGenActionsLoc != null && new File(this.m_sGenActionsLoc).exists()) {
            OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_LOADING_GLOBAL_INSTANTIATES_FROM_INV"), OiiolTextLogger.LOG_BASIC);
            OiisGenActionsReader genReader = new OiisGenActionsReader(this.m_sGenActionsLoc, false);
            genReader.loadFromFile();
            instantiates = genReader.getListInstantiates();
        }
        for (int k = 0; k < phases.length; ++k) {
            for (int i = 0; i < numDeinstalls; ++i) {
                OiiiCompIdOhPair deinstallIdOh = (OiiiCompIdOhPair)vDeinstallIdOhList.elementAt(i);
                deinstallIdOh.setDeinstalled(true);
                OiiiInstallCompInvEntry icie = icies[i];
                OiiiCompInstallID cid = icie.getCompInstallID();
                instInv.setModifiedHomesDirty(icie, deinstallIdOh.getOHIndex());
                if (deinstallCompsList != null && deinstallCompsList.contains(cid.getName().toLowerCase())) {
                    deinstallOnUpgrade = true;
                }
                if (!this.m_instSession.isDeinstallMode() && !deinstallOnUpgrade) continue;
                if (icie.isTopLevel() && !parseTopLevel.containsKey(deinstallIdOh)) {
                    try {
                        int intVal = deinstallIdOh.getOHIndex();
                        String homeLoc = instInv.getHomeLocation(intVal);
                        String sDestLoc = iac.getXMLCompFullLoc(deinstallIdOh.getCompID(), intVal);
                        String s_MakeDepsLoc = null;
                        String Loc = OiixPathOps.concatPath(sDestLoc, "useractions.properties");
                        if (new File(Loc).exists()) {
                            Properties properties = new Properties();
                            try {
                                properties.load(new FileInputStream(Loc));
                                s_MakeDepsLoc = properties.getProperty("MakeEntryXML");
                                if (s_MakeDepsLoc != null) {
                                    s_MakeDepsLoc = OiixPathOps.concatPath(sDestLoc, s_MakeDepsLoc.trim());
                                }
                            }
                            catch (Exception e) {
                                OiiolTextLogger.appendException(e);
                            }
                            if (s_MakeDepsLoc != null) {
                                OiisMakeDepsReader mdr = new OiisMakeDepsReader(s_MakeDepsLoc, homeLoc, false);
                                mdr.loadFromFile();
                            }
                        }
                        OiisMakeDeps.reverseTable();
                        ArrayList res = OiisMakeDeps.getTable();
                        ArrayList ret = OiisMakeDeps.retrieveFromHash(new Integer(intVal));
                        if (ret != null) {
                            res.addAll(ret);
                        }
                        OiisMakeDeps.setTable(res);
                        OiisMakeDeps.storeInHash(intVal);
                        OiisMakeDeps.clearCommandTable();
                        parseTopLevel.put(deinstallIdOh, new Boolean(true));
                    }
                    catch (IOException e) {
                        OiiolTextLogger.appendException(e);
                    }
                }
                if (icie.getCompInstallID().isNOHComp()) {
                    System.setProperty("oracle.installer.clusterswitch", "OFF");
                    System.setProperty("oracle.installer.clusterlist", "");
                    if (this.m_instSession instanceof OiicDeinstallSession) {
                        ((OiicDeinstallSession)this.m_instSession).setOHIndex(0);
                    }
                } else {
                    int iHomeIdx = deinstallIdOh.getOHIndex();
                    if (this.m_instSession instanceof OiicDeinstallSession) {
                        ((OiicDeinstallSession)this.m_instSession).setOHIndex(iHomeIdx);
                    }
                    OiiiOracleHomeInfo ohInfoObj = instInv.getHomeInfo(iHomeIdx);
                    clusterNodes = ohInfoObj.getNodeList();
                    OiicSessionContext oContext = this.m_instSession.getSessionContext();
                    if (clusterNodes != null && clusterNodes.size() > 0) {
                        clusterNodeList = new String[clusterNodes.size()];
                        clusterNodeList = OiixVectorOps.list2StrArr(clusterNodes);
                        String nodeListStr = OiixFunctionOps.implodeList(clusterNodeList, "|");
                        System.setProperty("oracle.installer.clusterswitch", "ON");
                        System.setProperty("oracle.installer.clusterlist", nodeListStr);
                        try {
                            oContext.setVarValue("ORACLE_HOME", ohInfoObj.getLocation());
                            if (localNode == null) {
                                oContext.setVarValue("CLUSTER_NODES", clusterNodeList);
                                localNode = ((OiicDeinstallSession)this.m_instSession).setLocalNode(ohInfoObj);
                                remoteNodes = ((OiicDeinstallSession)this.m_instSession).setRemoteNodes();
                                OiipgCFSDriveCheck.getCFSDriveChecker();
                            }
                        }
                        catch (OiisVarSettingException ve) {
                            OiiolTextLogger.appendException(ve);
                        }
                        catch (OiifbCancelException fb) {
                            OiiolTextLogger.appendException(fb);
                        }
                        OiipgClusterExecution.setComponentList(vDeinstallIdOhList);
                        OiipgClusterExecution.setDeinstallIcies(icies);
                    }
                }
                this.m_progressListener.onCurrentComponent(icie.getFullDisplayName());
                this.m_progressListener.addBytes(nPerCompProgress);
                String logText = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_TL_DEINSTALLING") + " " + icie.getFullDisplayName();
                OiiolTextLogger.appendText(logText, OiiolTextLogger.LOG_BASIC);
                this.m_progressListener.setStatus(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_DEINSTALL_ACTIONS"));
                OiisCompContext oCompContext = OiisCompContext.createContextFromInstallInv(icie, deinstallIdOh.getOHIndex());
                oCompContext.setParContext(this.m_instSession.getSessionContext());
                if (phases[k] == 32) {
                    if (deinstallIdOh.getOHIndex() > 0) {
                        boolean bCluster = remoteNodes != null && remoteNodes.length > 0;
                        this.doDefaultCopyGroupDeinstall(deinstallIdOh, oCompContext, bCluster);
                    }
                } else {
                    OiiiInstallLogManipulator installLogManip;
                    Vector installLogManips;
                    if (phases[k] == 8 && instantiates != null && instantiates.size() > 0) {
                        OiixInstantiateOps inst = new OiixInstantiateOps();
                        for (int idx = instantiates.size() - 1; idx >= 0; --idx) {
                            OiisInstantiateInfo info = (OiisInstantiateInfo)instantiates.get(idx);
                            if (!deinstallIdOh.getCompID().equals(info.getCompInstallId())) continue;
                            try {
                                inst.deInstantiate(info, this.m_instSession, oCompContext, deinstallIdOh);
                                continue;
                            }
                            catch (OiilDeinstallException de) {
                                String severity = String.valueOf(de.getExceptionSeverity());
                                Object[] exargs = new String[]{"GlobalInstantiate", de.getExceptionName(), de.getExceptionString(), severity};
                                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-35900", exargs));
                                if (OiiolTextLogger.getLogLevel() < OiiolTextLogger.LOG_TRACE) continue;
                                OiiolTextLogger.appendException(de);
                            }
                        }
                    }
                    if ((installLogManips = (installLogManip = new OiiiInstallLogManipulator(icie, deinstallIdOh, false)).getInstallLogManipulator(phases[k])) == null) {
                        logText = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_TL_DEINSTALLING") + " " + icie.getFullDisplayName() + OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_LOG_INVALID_INSTALL_LOG");
                        OiiolTextLogger.appendText(logText, OiiolTextLogger.LOG_BASIC);
                        continue;
                    }
                    int nManips = installLogManips.size();
                    block19: for (int j = 0; j < nManips; ++j) {
                        OiiolLogManipulator oLog = (OiiolLogManipulator)installLogManips.elementAt(j);
                        Enumeration en = oLog.getEntriesForDeinstall();
                        while (en.hasMoreElements()) {
                            block44: {
                                Object[] exargs;
                                Vector inputs = null;
                                Vector logObjects = null;
                                OiiolActionLogEntry ale = (OiiolActionLogEntry)en.nextElement();
                                OiiiLibraryID lid = ale.getLibraryID();
                                OiisActionLibLoader lLoader = null;
                                String actionName = null;
                                try {
                                    lLoader = this.m_instSession.getActionLibLoader(lid, deinstallIdOh.getOHIndex());
                                    actionName = ale.getActionName();
                                }
                                catch (IOException ie) {
                                    if (OiiolTextLogger.getLogLevel() < OiiolTextLogger.LOG_TRACE) continue;
                                    OiiolTextLogger.appendException(ie);
                                    continue;
                                }
                                if (actionName.equalsIgnoreCase("finalClusterSetup") && lid.getName().equalsIgnoreCase("fileActions")) continue;
                                boolean deinstallFlag = ale.getDeinstallFlag();
                                int curPlatform = OiixPlatform.getCurrentPlatform();
                                OiilAction action = lLoader.getAction(actionName, curPlatform);
                                if (!this.m_progressControl.canContinue()) {
                                    boolean cancelSession = (Boolean)this.m_progressControl.getCancelCondition();
                                    if (!cancelSession) continue block19;
                                    throw new OiifbCancelException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_USER_CANCEL"), true);
                                }
                                try {
                                    if (!deinstallFlag) break block44;
                                    inputs = ale.getInputsForDeinstall(oCompContext);
                                    OiilActionInputElement aie = new OiilActionInputElement("compIdOhPair", deinstallIdOh);
                                    aie.setImplicit(true);
                                    inputs.addElement(aie);
                                    aie = new OiilActionInputElement("compContext", oCompContext);
                                    aie.setImplicit(true);
                                    inputs.addElement(aie);
                                    if (Boolean.getBoolean("oracle.installer.removeallfiles")) {
                                        OiilActionInputElement noopActionInputElem = new OiilActionInputElement("noopForRemoveAll", "true");
                                        noopActionInputElem.setImplicit(true);
                                        inputs.addElement(noopActionInputElem);
                                    }
                                    if (remoteNodes != null && remoteNodes.length > 0) {
                                        inputs = OiilActionInputElement.addImplicitArg(inputs, remoteNodes, "remoteNodes");
                                    }
                                    logObjects = ale.getLogObjectsForDeinstall(oCompContext);
                                    OiisCompActions.toLog(ale.getLibraryID(), actionName, inputs);
                                    action.deinstallAction(inputs, logObjects);
                                }
                                catch (OiilDeinstallException de) {
                                    String severity = String.valueOf(de.getExceptionSeverity());
                                    Object[] exargs2 = new String[]{actionName, de.getExceptionName(), de.getExceptionString(), severity};
                                    OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-35900", exargs2));
                                    if (OiiolTextLogger.getLogLevel() < OiiolTextLogger.LOG_TRACE) continue;
                                    OiiolTextLogger.appendException(de);
                                    continue;
                                }
                                catch (InterruptedException ie) {
                                    exargs = new String[]{actionName};
                                    OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-35901", exargs));
                                    if (OiiolTextLogger.getLogLevel() < OiiolTextLogger.LOG_TRACE) continue;
                                    OiiolTextLogger.appendException(ie);
                                    continue;
                                }
                                catch (InvocationTargetException ie) {
                                    exargs = new String[]{actionName};
                                    OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-35901", exargs));
                                    if (OiiolTextLogger.getLogLevel() < OiiolTextLogger.LOG_TRACE) continue;
                                    OiiolTextLogger.appendException(ie);
                                    continue;
                                }
                                catch (Exception ie) {
                                    exargs = new String[]{actionName};
                                    OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-35901", exargs));
                                    if (OiiolTextLogger.getLogLevel() < OiiolTextLogger.LOG_TRACE) continue;
                                    OiiolTextLogger.appendException(ie);
                                    continue;
                                }
                            }
                            oLog.markCurrentEntry();
                            if (this.m_progressControl.canContinue()) continue;
                            boolean cancelSession = (Boolean)this.m_progressControl.getCancelCondition();
                            if (!cancelSession) continue block19;
                            throw new OiifbCancelException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_USER_CANCEL"), true);
                        }
                    }
                }
                if (8 != phases[k]) continue;
                OiilWinActionsDeinstall winActionsDeinstall = new OiilWinActionsDeinstall();
                winActionsDeinstall.runActions(icie.getCompInstallID(), oCompContext);
            }
        }
    }

    public void setDeinstallProgressBytes(long lProgressBytes) {
        this.m_lDeinstallProgressBytes = lProgressBytes;
    }

    public long getDeinstallProgressBytes() {
        return this.m_lDeinstallProgressBytes;
    }

    private void doDefaultCopyGroupDeinstall(OiiiCompIdOhPair compIdOh, OiisCompContext oContext, boolean bCluster) {
        OiiolDefaultCopyGroupLogManipulator logManip = new OiiolDefaultCopyGroupLogManipulator(compIdOh);
        logManip.readEntries();
        Iterator entries = logManip.iterator();
        if (entries == null) {
            return;
        }
        OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
        OiiiInstallInventory instInv = iac.getInstallInventory();
        String sHomeLocation = instInv.getHomeLocation(compIdOh.getOHIndex());
        while (entries.hasNext()) {
            OiipgCFSDriveCheck cfsDriveCheck;
            String sEntry = (String)entries.next();
            sEntry = OiisIdentifierOps.instantiateString(sEntry, oContext);
            sEntry = OiixPathOps.getNativeForm(sEntry);
            iac.deregisterFile(sHomeLocation, sEntry, compIdOh.getCompID());
            File fEntry = new File(sEntry);
            if (bCluster && !(cfsDriveCheck = OiipgCFSDriveCheck.getCFSDriveChecker()).isDriveOnCFS(sEntry)) {
                if (fEntry.isDirectory()) {
                    OiipgClusterLogger.logRmdirCommands(sEntry);
                } else if (fEntry.isFile()) {
                    OiipgClusterLogger.logRmfileCommands(sEntry);
                }
            }
            fEntry.delete();
            OiixFileOps.deleteParentDirs(sEntry, bCluster);
        }
    }

    private class CompIDOHPair
    implements Comparable {
        private OiiiCompInstallID cid;
        private int nOHIndex;
        private OiiiCompIdOhPair cidohpair;

        public CompIDOHPair(OiiiCompIdOhPair cidohp) {
            this.cid = cidohp.getCompID();
            this.nOHIndex = cidohp.getOHIndex();
            this.cidohpair = cidohp;
        }

        public int compareTo(Object cidohp) {
            CompIDOHPair cidohpair = (CompIDOHPair)cidohp;
            return this.nOHIndex <= cidohpair.getOHIndex() ? this.nOHIndex : cidohpair.getOHIndex();
        }

        public int getOHIndex() {
            return this.nOHIndex;
        }

        public OiiiCompInstallID getCompID() {
            return this.cid;
        }

        public OiiiCompIdOhPair getCompIDOhPair() {
            return this.cidohpair;
        }
    }
}

