/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifw;

import java.io.FileInputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicAPIInstaller;
import oracle.sysman.oii.oiic.OiicBaseApp;
import oracle.sysman.oii.oiic.OiicInstaller;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifw.OiifwLangsSelWCDE;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiSourceAccess;
import oracle.sysman.oii.oiii.OiiiStageCompInvEntry;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiis.OiisDepMode;
import oracle.sysman.oii.oiis.OiisDeps;
import oracle.sysman.oii.oiis.OiisDlgInOutElem;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixHelpDetails;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifwDepModesWCDE
extends OiifwLangsSelWCDE {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 1024;
    private OiicPullSession m_pullSession;
    private OiiiInstallInventory m_installInv;
    private OiiiCompInstallID m_comp;
    private String m_sSourceLoc;
    private int m_nextInd;
    public static final String s_panelClass = "oracle.sysman.oii.oiif.oiifp.OiifpDepModesPanel";

    public OiifwDepModesWCDE(OiisVariableOwner vo, int nextInd) {
        super(vo);
        this.m_dlgInOutElems.addElement(new OiisDlgInOutElem("InstallType", "DEP_MODE"));
        this.m_dlgInOutElems.addElement(new OiisDlgInOutElem("TopLevelInstallType", "TLDepModes"));
        this.m_pullSession = vo.getSession();
        this.setWizPanelClassName(s_panelClass);
        this.setHelpKey("OiicDepModesWCDE");
        this.m_sSourceLoc = "";
        this.m_nextInd = nextInd;
    }

    public int getNext() {
        return this.m_nextInd;
    }

    public void initialize() throws OiifbEndIterateException {
        OiisVariable oSource;
        String sSource;
        super.initialize();
        OiiiCompInstallID id = this.m_pullSession.getSelTopLevelCompID();
        if (this.m_comp == null || !this.m_comp.equals(id)) {
            this.m_comp = id;
        }
        if (!this.m_sSourceLoc.equals(sSource = (String)(oSource = this.m_pullSession.getSessionContext().getVariable("FROM_LOCATION")).getValue())) {
            this.m_sSourceLoc = sSource;
        }
        this.updateDepMode();
    }

    private void updateDepMode() {
        OiisVariable oDepMode = this.m_varOwner.getVariable("DEP_MODE");
        OiisVariable oMultiDepModes = this.m_varOwner.getVariable("TLDepModes");
        OiisVariable oRespDepMode = this.m_varOwner.getVariable("INSTALL_TYPE");
        if (this.m_comp.getCompType() == 4 || this.m_comp.getCompType() == 2) {
            try {
                String defVal = "Custom";
                oDepMode.setValue(defVal, false);
                String[] nModes = new String[]{defVal};
                oMultiDepModes.setValue(nModes, false);
            }
            catch (Exception e) {
                // empty catch block
            }
            oDepMode.setAdvice(true);
            oMultiDepModes.setAdvice(true);
            return;
        }
        try {
            oRespDepMode.setVariable(this.m_comp);
        }
        catch (Exception e) {
            // empty catch block
        }
        OiiiSourceAccess sacc = this.m_pullSession.getSourceAccess();
        OiiiStageCompInvEntry scie = sacc.getStageInventory().getStageCompInvEntry(this.m_comp);
        OiisDeps oDeps = scie.getDeps();
        if (oDeps == null) {
            oDeps = this.m_pullSession.getCompInstall(this.m_comp).getDepInfo().getDeps();
        }
        Vector dModes = oDeps.getDepModes();
        String nMode = this.getDepModeValue(dModes, oRespDepMode.getValue());
        if (!oDepMode.getAdvice()) {
            boolean bAdvice = false;
            if (nMode == null) {
                if (dModes.isEmpty()) {
                    nMode = "Custom";
                    bAdvice = true;
                } else if (dModes.size() == 1) {
                    OiisDepMode oMode = (OiisDepMode)dModes.elementAt(0);
                    nMode = oMode.getInternalName();
                    bAdvice = true;
                }
            } else {
                bAdvice = oRespDepMode.getAdvice();
            }
            try {
                oDepMode.setValue(nMode, false);
                oDepMode.setAdvice(bAdvice);
                String[] nModes = new String[]{nMode};
                oMultiDepModes.setValue(nModes, false);
                oMultiDepModes.setAdvice(bAdvice);
            }
            catch (OiisVarSettingException vse) {
            }
            catch (OiifbCancelException ce) {
                // empty catch block
            }
        }
    }

    private String getDepModeValue(Vector dModes, Object typedValue) {
        String origVal = null;
        if (typedValue instanceof String) {
            origVal = (String)typedValue;
            int nSize = dModes.size();
            if (nSize > 0) {
                for (int i = 0; i < nSize; ++i) {
                    OiisDepMode oMode = (OiisDepMode)dModes.elementAt(i);
                    if (!origVal.equalsIgnoreCase(oMode.getName()) && !origVal.equalsIgnoreCase(oMode.getNameID()) && !origVal.equalsIgnoreCase(oMode.getInternalName())) continue;
                    return oMode.getInternalName();
                }
            }
        }
        return null;
    }

    public String getDisplayName() {
        String sTitle = OiixResourceBundle.getString("S_INSTALL_TYPE");
        return sTitle;
    }

    protected void setDialogProperties() {
        super.setDialogProperties();
    }

    public OiixHelpDetails getHelpDetails() {
        OiiiCompInstallID cid = this.m_pullSession.getSelTopLevelCompID();
        OiixHelpDetails helpDetails = new OiixHelpDetails(this.m_varOwner, cid, "CompInstallTypeHelp", "OiicDepModesWCDE");
        return helpDetails;
    }

    protected void logDialog() {
        super.logDialog();
        if (this.m_comp.getCompType() != 1) {
            return;
        }
        String logStr = OiixResourceBundle.getString("S_LOG_SELECTED_INSTALL_TYPE");
        Object[] args = new String[1];
        OiisVariable var = this.m_varOwner.getVariable("DEP_MODE");
        String internalName = (String)var.getLogValue();
        if (this.m_pullSession.getCompInstall(this.m_comp) == null) {
            return;
        }
        Vector depModes = this.m_pullSession.getCompInstall(this.m_comp).getDepInfo().getDeps().getDepModes();
        for (int i = 0; i < depModes.size(); ++i) {
            OiisDepMode dm = (OiisDepMode)depModes.elementAt(i);
            if (!dm.getInternalName().equals(internalName)) continue;
            args[0] = dm.getName();
            break;
        }
        if (args[0] == null) {
            args[0] = "null";
        }
        logStr = MessageFormat.format(logStr, args);
        OiiolTextLogger.appendText(logStr);
    }

    public void dispose() {
        if (this.m_comp != null) {
            this.m_comp = null;
        }
        this.m_installInv = null;
        this.m_pullSession = null;
        super.dispose();
    }

    public int doOperation(boolean isBack) throws OiifbEndIterateException {
        int retVal = super.doOperation(isBack);
        if (retVal == 0 && this.m_pullSession.isInstallMode() && !OiicBaseApp.getAltInstallProps()) {
            OiicBaseApp o_oiicInstaller = null;
            o_oiicInstaller = System.getProperty("oracle.installer.ouiApiMode", "false").equalsIgnoreCase("true") ? OiicAPIInstaller.getHandleToAPIInstaller() : OiicInstaller.getOiicInstallerInstance();
            o_oiicInstaller.resetInstallProps();
            String sTempLoc = System.getProperty("oracle.installer.scratchPath");
            if (sTempLoc != null) {
                String localFile = OiixPathOps.concatPath(sTempLoc, "shiphomeinfo.properties");
                OiiolTextLogger.appendText("load the properties from file: " + localFile, OiiolTextLogger.LOG_DETAILED);
                Properties props = null;
                try {
                    FileInputStream fs = new FileInputStream(localFile);
                    props = new Properties();
                    props.load(fs);
                    fs.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (props != null) {
                    String propFileName;
                    OiisVariable topLevelCompName = this.m_varOwner.getVariable("ToplevelComp");
                    OiisVariable installType = this.m_varOwner.getVariable("DEP_MODE");
                    String name = ((OiiiCompInstallID)topLevelCompName.getValue()).getName();
                    if (installType != null) {
                        name = name + "_" + installType.getValueAsString();
                    }
                    if ((propFileName = props.getProperty(name = name + "_properties")) != null) {
                        String deletionFile;
                        OiiiSourceAccess sacc = this.m_pullSession.getSourceAccess();
                        propFileName = sacc.fetchShiphomeProperties(name, propFileName);
                        if (propFileName != null) {
                            OiiolTextLogger.appendText("install properties filename: " + propFileName);
                            System.setProperty("oracle.installer.shprops", propFileName);
                            o_oiicInstaller.loadInstallPropertiesFile(propFileName);
                        }
                        if ((deletionFile = System.getProperty("oracle.installer.deletionFileList", null)) != null) {
                            sacc.fetchDeletionFile(deletionFile);
                        }
                    } else {
                        System.setProperty("oracle.installer.shprops", "");
                    }
                }
            }
        }
        return retVal;
    }
}

