/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifw;

import java.io.FileInputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicExitCode;
import oracle.sysman.oii.oiic.OiicInstVersion;
import oracle.sysman.oii.oiic.OiicInstallPlan;
import oracle.sysman.oii.oiic.OiicInstallSession;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifb.OiifbUserEndException;
import oracle.sysman.oii.oiif.oiifb.OiifbWizOperation;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiii.OiiiBugListValidate;
import oracle.sysman.oii.oiii.OiiiCompIdOhPair;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiInstallPatchInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallPatchSetInvEntry;
import oracle.sysman.oii.oiii.OiiiOneoffIdOhPair;
import oracle.sysman.oii.oiii.OiiiPatchInstallID;
import oracle.sysman.oii.oiii.OiiiPatchSetInstallID;
import oracle.sysman.oii.oiii.OiiiSourceAccess;
import oracle.sysman.oii.oiii.OiiiStageCompInvEntry;
import oracle.sysman.oii.oiio.oiiod.OiiodDepEngine;
import oracle.sysman.oii.oiio.oiiod.OiiodDepException;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiis.OiisCompContext;
import oracle.sysman.oii.oiis.OiisCompInstallation;
import oracle.sysman.oii.oiis.OiisDiskLocator;
import oracle.sysman.oii.oiis.OiisFileSizeInfo;
import oracle.sysman.oii.oiis.OiisProdHomeVar;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixDebug;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixInvalidDataException;
import oracle.sysman.oii.oiix.OiixLanguage;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixProgressListener;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixSet;

public class OiifwDepSetPlanWCCE
implements OiifbWizOperation {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 0x2000400;
    private OiiodDepEngine m_depEngine;
    private OiicInstallSession m_instSession;
    private boolean m_bError;
    private OiisVariableOwner m_vo;
    private OiifbEndIterateException m_ie;
    private OiixSet m_oDisksNeeded = null;

    public OiifwDepSetPlanWCCE(OiisVariableOwner vo) {
        this.m_vo = vo;
        this.m_bError = false;
        this.m_instSession = (OiicInstallSession)vo.getSession();
        this.m_depEngine = this.m_instSession.getDepEngine();
        this.m_ie = null;
        OiifwDepSetPlanWCCE oiifwDepSetPlanWCCE = this;
        if (oiifwDepSetPlanWCCE.m_instSession.isSilentMode()) {
            try {
                this.m_oDisksNeeded = new OiixSet("java.lang.Integer");
            }
            catch (OiixInvalidDataException oiixInvalidDataException) {
                // empty catch block
            }
        }
    }

    public void dispose() {
        this.m_instSession = null;
        this.m_vo = null;
        this.m_depEngine = null;
    }

    public String getName() {
        return "";
    }

    public void initialize() {
        try {
            OiiiCompInstallID cid;
            OiiiInstallCompInvEntry icie;
            this.m_bError = false;
            this.m_ie = null;
            Vector adds = this.calcAdditions(this.m_depEngine);
            Vector patchSets = this.calPatchSets(this.m_depEngine);
            Vector rems = this.calcRemoves(this.m_depEngine);
            Vector oneoffRems = this.calcOneoffRemoves(this.m_depEngine);
            Map oConflictingOneOffs = this.getConflictingOneOffs(this.m_depEngine);
            OiicInstallPlan instPlan = (OiicInstallPlan)this.m_vo.getSession().getSessionPlan();
            OiiiInstallInventory installInv = this.m_instSession.getInstallAreaControl().getInstallInventory();
            OiifwDepSetPlanWCCE oiifwDepSetPlanWCCE = this;
            if (oiifwDepSetPlanWCCE.m_instSession.isSilentMode()) {
                Enumeration enum_1 = this.m_oDisksNeeded.elements();
                OiisDiskLocator diskLocator = new OiisDiskLocator(this.m_instSession.getSessionContext());
                String sLabel = this.m_instSession.getDiskLabel();
                while (enum_1.hasMoreElements()) {
                    int nDisk = (Integer)enum_1.nextElement();
                    if (diskLocator.isDiskAccessible(nDisk, sLabel)) continue;
                    Object[] sArgs = new Object[]{new Integer(nDisk)};
                    String sMsg = OiixResourceBundle.getString("S_DISK_NOT_FOUND", sArgs);
                    OiiolTextLogger.writeMessageToConsole("");
                    OiiolTextLogger.writeMessageToConsole(sMsg);
                    throw new OiifbCancelException(sMsg, true);
                }
            }
            instPlan.clearPlan();
            Enumeration remen = rems.elements();
            while (remen.hasMoreElements()) {
                OiiiCompIdOhPair cIdOh = (OiiiCompIdOhPair)remen.nextElement();
                instPlan.addRemoval(cIdOh);
            }
            Enumeration remoneoffen = oneoffRems.elements();
            while (remoneoffen.hasMoreElements()) {
                OiiiOneoffIdOhPair oIdOh = (OiiiOneoffIdOhPair)remoneoffen.nextElement();
                instPlan.addRemoval(oIdOh.getOneoffID(), (Object)oIdOh);
            }
            if (oConflictingOneOffs.size() > 0) {
                String sConflictDetails = this.getOneOffConflictDetails(oConflictingOneOffs);
                OiiolTextLogger.appendText(OiixResourceBundle.getString(sConflictDetails));
                String sConflictingOneOffs = this.getConflictingOneOffsList(oConflictingOneOffs);
                Object[] sArgs = new String[]{sConflictingOneOffs};
                String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ONE_OFF_CONFLICTS_FOR_UPGRADE", sArgs);
                boolean bIgnorePatchConflicts = System.getProperty("oracle.installer.ignorePatchConflicts", "false").equals("true");
                int iIgnoreConflicts = bIgnorePatchConflicts ? 1 : 2;
                String sTitle = OiixResourceBundle.getString("S_WARNING");
                iIgnoreConflicts = OiifmAlert.displayAlert(sTitle, sMsg, 30, 3, iIgnoreConflicts, 10);
                if (iIgnoreConflicts == 2) {
                    if (System.getProperty("oracle.installer.exitOnPrereqFailure", "false").equals("true")) {
                        OiicExitCode.setExitCode(-3);
                        this.m_ie = new OiifbEndIterateException(new OiifbUserEndException());
                    }
                    this.m_bError = true;
                    return;
                }
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ONE_OFF_CONFLICTS_IGNORE"));
                Set oOneOffs = oConflictingOneOffs.keySet();
                Iterator iter = oOneOffs.iterator();
                String[] asConflictingOneOffs = new String[oOneOffs.size()];
                boolean i = false;
                while (iter.hasNext()) {
                    OiiiOneoffIdOhPair oOneoffIdOhPair = (OiiiOneoffIdOhPair)iter.next();
                    instPlan.addRemoval(oOneoffIdOhPair.getOneoffID(), (Object)oOneoffIdOhPair);
                }
            }
            Enumeration pSets = patchSets.elements();
            while (pSets.hasMoreElements()) {
                icie = (OiiiInstallCompInvEntry)pSets.nextElement();
                cid = (OiiiPatchSetInstallID)icie.getCompInstallID();
                instPlan.addPatchSet((OiiiPatchSetInstallID)cid, icie);
            }
            Enumeration adden = adds.elements();
            while (adden.hasMoreElements()) {
                icie = (OiiiInstallCompInvEntry)adden.nextElement();
                cid = icie.getCompInstallID();
                instPlan.addAddition(cid, icie);
                instPlan.setAdditionPhase(cid, 5);
            }
            OiiiCompInstallID[] cids = this.m_instSession.getDepEngine().getCurrentTLIDs();
            if (cids.length == 1 && cids[0].getCompType() == 4 && adds.size() == 0) {
                String sMsg = OiixResourceBundle.getString("S_ERROR_PATCHSET_NOCMOPS");
                Object[] obj = new String[]{((OiiiInstallCompInvEntry)patchSets.elementAt(0)).getFullDisplayName()};
                sMsg = MessageFormat.format(sMsg, obj);
                throw new OiiodDepException(2, sMsg);
            }
            instPlan.setSelectedComps(cids);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            this.m_bError = true;
        }
        catch (OiiodDepException exp) {
            String sTitle = OiixResourceBundle.getString("S_ERROR");
            OiifmAlert.displayError(exp.getMessage(), sTitle);
            if (System.getProperty("oracle.installer.exitOnPrereqFailure", "false").equals("true")) {
                OiicExitCode.setExitCode(-3);
                this.m_ie = new OiifbEndIterateException(new OiifbUserEndException());
            }
            this.m_bError = true;
        }
        catch (OiifbEndIterateException exp) {
            this.m_ie = exp;
            this.m_bError = true;
        }
        catch (OiifbCancelException exp) {
            this.m_ie = new OiifbEndIterateException(exp.getMessage());
            this.m_bError = true;
            return;
        }
    }

    private String getConflictingOneOffsList(Map oConflictingOneOffs) {
        Set oOneOffs = oConflictingOneOffs.keySet();
        Iterator iter = oOneOffs.iterator();
        String[] asConflictingOneOffs = new String[oOneOffs.size()];
        int i = 0;
        while (iter.hasNext()) {
            OiiiOneoffIdOhPair oOneoffIdOhPair = (OiiiOneoffIdOhPair)iter.next();
            int ohIndex = oOneoffIdOhPair.getHomeIndex();
            asConflictingOneOffs[i] = oOneoffIdOhPair.isOneoff() ? oOneoffIdOhPair.getOneoffID().getDisplayString() : oOneoffIdOhPair.getOneoffID().getDisplayStringForMiniPatchset();
            ++i;
        }
        return OiixFunctionOps.implodeList(asConflictingOneOffs, ",");
    }

    private String getOneOffConflictDetails(Map oConflictingOneOffs) {
        StringBuffer sb = new StringBuffer();
        String sLineSeparator = System.getProperty("line.separator");
        sb.append(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ONE_OFF_CONFLICT_DETAILS"));
        sb.append(sLineSeparator);
        sb.append(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ONE_OFF_CONFLICT_DETAILS1"));
        sb.append(sLineSeparator);
        OiiiInstallInventory installInv = this.m_instSession.getInstallAreaControl().getInstallInventory();
        Set oOneOffs = oConflictingOneOffs.keySet();
        Iterator iter = oOneOffs.iterator();
        HashMap<OiiiCompInstallID, String> oCompToExtNameCache = new HashMap<OiiiCompInstallID, String>();
        while (iter.hasNext()) {
            OiiiOneoffIdOhPair oOneoffIdOhPair = (OiiiOneoffIdOhPair)iter.next();
            int ohIndex = oOneoffIdOhPair.getHomeIndex();
            String sOneOffID = oOneoffIdOhPair.getOneoffID().getDisplayString();
            List oConflictingComps = (List)oConflictingOneOffs.get(oOneoffIdOhPair);
            int nComps = oConflictingComps.size();
            String[] asConflictingComps = new String[nComps];
            for (int i = 0; i < nComps; ++i) {
                OiiiCompInstallID cid = (OiiiCompInstallID)oConflictingComps.get(i);
                if (oCompToExtNameCache.containsKey(cid)) {
                    asConflictingComps[i] = (String)oCompToExtNameCache.get(cid);
                    continue;
                }
                OiiiCompInvEntry cie = installInv.getCompInvEntry(cid, ohIndex);
                if (cie == null) continue;
                asConflictingComps[i] = cie.getFullDisplayName();
                oCompToExtNameCache.put(cid, asConflictingComps[i]);
            }
            String sComps = OiixFunctionOps.implodeList(asConflictingComps, ",");
            Object[] sArgs2 = new String[]{sOneOffID, sComps};
            sb.append(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ONE_OFF_CONFLICT_DETAILS2", sArgs2));
            sb.append(sLineSeparator);
        }
        return sb.toString();
    }

    private String getVerifyBugList() {
        String ret = "";
        ret = System.getProperty("oracle.installer.verifybuglist", "");
        if (ret != "") {
            return ret;
        }
        String sTempLoc = System.getProperty("oracle.installer.scratchPath");
        if (sTempLoc != null) {
            String localFile = OiixPathOps.concatPath(sTempLoc, "shiphomeinfo.properties");
            OiiolTextLogger.appendText("load the properties from file: " + localFile, OiiolTextLogger.LOG_DETAILED);
            Properties props = null;
            try {
                FileInputStream fs = new FileInputStream(localFile);
                props = new Properties();
                props.load(fs);
                fs.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (props != null) {
                ret = props.getProperty("oracle.installer.verifybuglist", "");
            }
        }
        return ret;
    }

    public final int doOperation(boolean isBack) throws OiifbEndIterateException {
        if (!isBack) {
            String s = this.getVerifyBugList();
            boolean isUpgrade = this.m_depEngine.isPatchSetUpgrade();
            boolean isReinstall = this.m_depEngine.isPatchSetReinstall();
            if (!this.m_bError && (isUpgrade || isReinstall) && !s.equalsIgnoreCase("false")) {
                Boolean suppress = (Boolean)this.m_instSession.getSessionContext().getVarValue("SUPPRESS_BUGLIST_WARNING");
                int ohIndex = this.m_instSession.getOHIndex();
                OiiiInstallInventory inv = this.m_instSession.getInstallAreaControl().getInstallInventory();
                Vector vDeinstallOneOffOhList = this.m_instSession.getSessionPlan().getOneoffRemoves();
                OiiiBugListValidate.setOneoffRemoves(vDeinstallOneOffOhList);
                this.m_bError = OiiiBugListValidate.validate(this.m_depEngine, ohIndex, inv, suppress);
            }
            if (this.m_bError) {
                if (this.m_ie != null) {
                    throw this.m_ie;
                }
                OiifwDepSetPlanWCCE oiifwDepSetPlanWCCE = this;
                if (oiifwDepSetPlanWCCE.m_instSession.isSilentMode() || this.m_instSession.isSuppressedSource() || !this.m_instSession.getWizardDialog().isAnyPanelVisible()) {
                    throw new OiifbEndIterateException("");
                }
                return 1;
            }
        }
        return isBack ? 1 : 0;
    }

    private Vector calcRemoves(OiiodDepEngine depEngine) {
        return depEngine.getCompsToRemove();
    }

    private Vector calcOneoffRemoves(OiiodDepEngine depEngine) {
        return depEngine.getOneoffIdOhsToDeinstall();
    }

    private Map getConflictingOneOffs(OiiodDepEngine depEngine) {
        return depEngine.getConflictingOneoffs();
    }

    private Vector calPatchSets(OiiodDepEngine depEngine) throws IOException {
        Vector ids = depEngine.getSelectedPatchSets();
        int numIDs = ids.size();
        Vector<OiiiInstallPatchSetInvEntry> ies = new Vector<OiiiInstallPatchSetInvEntry>();
        OiiiSourceAccess sacc = this.m_instSession.getSourceAccess();
        for (int i = 0; i < numIDs; ++i) {
            int nDisk;
            OiiiPatchSetInstallID cid = (OiiiPatchSetInstallID)ids.elementAt(i);
            OiiiStageCompInvEntry scie = sacc.getStageInventory().getStageCompInvEntry(cid);
            String localLoc = this.m_instSession.getInstallAreaControl().genCompInstallLocation(cid, new Vector(), false);
            int homeIndex = this.m_instSession.getHomeIndex(cid);
            String xmlLocalLoc = this.m_instSession.getInstallAreaControl().getXMLCompRelativeLoc(cid, homeIndex);
            OiifwDepSetPlanWCCE oiifwDepSetPlanWCCE = this;
            if (oiifwDepSetPlanWCCE.m_instSession.isSilentMode() && (nDisk = scie.getDiskNumber()) != 1) {
                try {
                    this.m_oDisksNeeded.addElement(new Integer(nDisk));
                }
                catch (OiixInvalidDataException e) {
                    // empty catch block
                }
            }
            OiiiInstallPatchSetInvEntry icie = new OiiiInstallPatchSetInvEntry(cid, localLoc);
            icie.setName(scie.getName());
            icie.setOHIndex(cid.isNOHComp() ? 0 : homeIndex);
            icie.setCompProperties(scie.getCompProperties());
            icie.setJarName(scie.getJarName());
            icie.setStageVersion(scie.getStageVersion());
            icie.setDescResourceId(scie.getDescResourceId());
            icie.setLocationInXMLInventory(xmlLocalLoc);
            icie.setInstallerVersion(OiicInstVersion.getInstallerVersion());
            icie.setDeinstallVersion(OiicInstVersion.getInstallerVersionForDeInstall());
            ies.addElement(icie);
            icie.setPatches(depEngine.getContainedPatches(cid));
            icie.setResourceBundle(scie.getResourceBundle());
        }
        return ies;
    }

    private Vector calcAdditions(OiiodDepEngine depEngine) throws IOException, OiiodDepException, OiifbEndIterateException, OiifbCancelException {
        OiixProgressListener progressListener;
        long lTime = 0L;
        Vector ids = depEngine.calcCompsToInstall();
        depEngine.validateForMOH();
        Vector<OiiiInstallCompInvEntry> ies = new Vector<OiiiInstallCompInvEntry>();
        int numIDs = ids.size();
        if (OiixDebug.PRINT_TIME) {
            lTime = System.currentTimeMillis();
        }
        if ((progressListener = this.m_instSession.getProgressListener()) != null && !OiicPullSession.isSilentMode()) {
            progressListener.setTotalBytes(numIDs * 6);
            progressListener.setTitle(OiixResourceBundle.getString("S_DEP_PROG_MSG"));
            progressListener.addBytes(numIDs * 3);
        }
        String sConstMsg = OiixResourceBundle.getString("S_COMP_LOAD_PROG_MSG");
        MessageFormat msgFmt = new MessageFormat(sConstMsg);
        for (int i = 0; i < numIDs; ++i) {
            int nDisk;
            OiiiCompInstallID cid = (OiiiCompInstallID)ids.elementAt(i);
            String localLoc = this.m_instSession.getInstallAreaControl().genCompInstallLocation(cid, new Vector(), false);
            int homeIndex = this.m_instSession.getHomeIndex(cid);
            String xmlLocalLoc = this.m_instSession.getInstallAreaControl().getXMLCompRelativeLoc(cid, homeIndex);
            OiiiSourceAccess sacc = this.m_instSession.getSourceAccess();
            OiiiStageCompInvEntry scie = sacc.getStageInventory().getStageCompInvEntry(cid);
            String sName = scie.getName();
            String[] obj = new String[]{sName};
            String sMsg = msgFmt.format(obj);
            if (progressListener != null) {
                progressListener.setStatus(sMsg);
                progressListener.addBytes(1);
            }
            String prodHomeVal = "";
            if (cid.isNOHComp() && (this.m_depEngine.isReinstall(cid) || this.m_depEngine.isUpgrade(cid))) {
                OiiiCompInstallID checkID;
                OiiiInstallInventory instEnv = this.m_instSession.getInstallAreaControl().getInstallInventory();
                OiiiInstallCompInvEntry icie = (OiiiInstallCompInvEntry)instEnv.getReplaceCompEntry(cid, this.m_instSession.getHomeIndex(cid));
                if (icie == null && (icie = (OiiiInstallCompInvEntry)instEnv.getReplaceCompEntry(checkID = new OiiiCompInstallID(cid.getName(), cid.getVersion(), cid.getPlatforms(), cid.getReplaceVersion(), cid.getCompType(), 2, true, cid.getReleaseLevel(), false), this.m_instSession.getOHIndex())) == null) {
                    checkID.setOracleHomeType(3);
                    icie = (OiiiInstallCompInvEntry)instEnv.getReplaceCompEntry(checkID, this.m_instSession.getAppltopIndex());
                }
                prodHomeVal = icie.getProdHomeLoc();
                OiisProdHomeVar prodHomeVar = new OiisProdHomeVar();
                prodHomeVar.init((OiisVariableOwner)this.m_instSession.getSessionContext(), cid, (OiicPullSession)this.m_instSession);
                try {
                    prodHomeVar.setValue(prodHomeVal, false);
                    prodHomeVar.setAdvice(true);
                    OiisCompInstallation ci = this.m_instSession.getCompInstall(scie, true);
                    ci.getContext(true);
                    ci.setProdHome(prodHomeVar);
                }
                catch (OiisVarSettingException e) {}
            } else {
                OiisCompInstallation ci = this.m_instSession.getCompInstall(scie, true);
                OiisCompContext oContext = ci.getContext(true);
                prodHomeVal = oContext.getProdHome();
            }
            OiifwDepSetPlanWCCE oiifwDepSetPlanWCCE = this;
            if (oiifwDepSetPlanWCCE.m_instSession.isSilentMode() && (nDisk = scie.getDiskNumber()) != 1) {
                try {
                    this.m_oDisksNeeded.addElement(new Integer(nDisk));
                }
                catch (OiixInvalidDataException e) {
                    // empty catch block
                }
            }
            OiiiInstallCompInvEntry icie = null;
            if (cid.getCompType() == 2) {
                icie = new OiiiInstallPatchInvEntry((OiiiPatchInstallID)cid, localLoc, null, new Vector(), prodHomeVal);
                ((OiiiInstallPatchInvEntry)icie).setBaseID(((OiiiPatchInstallID)cid).getCompInstallID());
            } else {
                int ohIndex = ((OiicInstallSession)this.m_vo.getSession()).getHomeIndex(cid);
                Vector vDepInfo = depEngine.getDependeeInfo(cid, ohIndex);
                icie = new OiiiInstallCompInvEntry(cid, localLoc, null, vDepInfo, prodHomeVal);
            }
            icie.setName(scie.getName());
            icie.setDescResourceId(scie.getDescResourceId());
            icie.setOHIndex(cid.isNOHComp() ? 0 : homeIndex);
            icie.setInstallerVersion(OiicInstVersion.getInstallerVersion());
            icie.setDeinstallVersion(OiicInstVersion.getInstallerVersionForDeInstall());
            icie.setResourceBundle(scie.getResourceBundle());
            icie.setClonable(scie.isClonable());
            icie.setNoPreReq(scie.isNoPreReq());
            icie.setNoProdHome(scie.isNoProdHome());
            icie.setCompProperties(scie.getCompProperties());
            OiicSessionContext sc = this.m_instSession.getSessionContext();
            OiisVariable oLangs = sc.getVariable("SELECTED_LANGUAGES");
            String[] strLang = (String[])oLangs.getValue();
            Vector vLangs = OiixLanguage.getLangsVector(strLang);
            Vector<Integer> vPlats = new Vector<Integer>(1);
            vPlats.addElement(new Integer(OiixPlatform.getCurrentPlatform()));
            OiisFileSizeInfo stageFileSizeInfo = scie.getFileSizeInfoEx();
            OiisFileSizeInfo installFileSizeInfo = stageFileSizeInfo.getFileSizeInfoForInstall(vLangs, vPlats);
            icie.setFileSizeInfoEx(installFileSizeInfo);
            icie.setPlatIndexMapping(scie.getPlatIndexMapping());
            icie.setLangIndexMapping(scie.getLangIndexMapping());
            icie.setDestIndexMapping(installFileSizeInfo.getDestIndexMapping());
            icie.setUpdateSiteLoc(scie.getUpdateSiteLoc());
            icie.setLocationInXMLInventory(xmlLocalLoc);
            icie.setDeps(scie.getDeps());
            icie.setDepInfo(scie.getDepInfo());
            icie.setJarName(scie.getJarName());
            icie.setStageVersion(scie.getStageVersion());
            ies.addElement(icie);
        }
        if (OiixDebug.PRINT_TIME) {
            OiixDebug.printTimeMsg("OiifwDepSetPlanWCCE, Loading components.jar for prod home ", System.currentTimeMillis() - lTime);
        }
        return ies;
    }

    private String getDefaultProdHomeValue(OiiiCompInstallID cid) {
        OiisProdHomeVar prodHome = new OiisProdHomeVar();
        prodHome.init((OiisVariableOwner)this.m_instSession.getSessionContext(), cid, (OiicPullSession)this.m_instSession);
        try {
            prodHome.setVariable(cid);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (String)prodHome.getValue();
    }
}

