/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifw;

import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifb.OiifbWizChainDlgElem;
import oracle.sysman.oii.oiin.OiinNetOps;
import oracle.sysman.oii.oiis.OiisDlgInOutElem;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixOraparam;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifwHostNameWCDE
extends OiifbWizChainDlgElem {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 1024;
    private static final String HOSTNAME = "HostName";
    private int m_nextInd;
    private OiisVariableOwner m_vo;
    private int m_nOraparam;
    private boolean m_bMultipleNIC;
    public static final String s_panelClass = "oracle.sysman.oii.oiif.oiifp.OiifpHostNamePanel";

    public OiifwHostNameWCDE(OiisVariableOwner vo, int nextInd) {
        super(vo);
        this.m_dlgInOutElems.addElement(new OiisDlgInOutElem(HOSTNAME, "ORACLE_HOSTNAME"));
        this.setHelpKey("OiifwHostNameWCDE");
        this.setWizPanelClassName(s_panelClass);
        this.m_nextInd = nextInd;
        this.m_vo = vo;
    }

    public void initialize() throws OiifbEndIterateException {
        super.initialize();
        OiisVariable oVar = this.m_vo.getVariable("ORACLE_HOSTNAME");
        OiisVariable oVar1 = this.m_vo.getVariable("OUI_HOSTNAME");
        oVar1.setValueWithoutValidation(oVar1.getValueAsString());
        boolean bVarSet = oVar.getAdvice();
        this.m_nOraparam = OiixOraparam.getShowHostNameValue();
        this.m_bMultipleNIC = OiinNetOps.getNetOps().hasMultipleNICs();
        if (!oVar.getAdvice()) {
            OiicPullSession oSession = this.m_vo.getSession();
            String sPersistedHost = oSession.getHostNameForCurrentOH();
            if (sPersistedHost != null && !oSession.isCloneMode()) {
                try {
                    oVar.setValue(sPersistedHost, false);
                    oVar.setValueTypeAsCloneXML();
                    oVar.setUserInputFromCloneXML(false);
                    oVar1.setValue(sPersistedHost, false);
                    oVar1.setValueTypeAsCloneXML();
                    oVar1.setUserInputFromCloneXML(false);
                }
                catch (Exception ex) {}
            } else {
                OiinNetOps netOps = OiinNetOps.getNetOps();
                String sHostName = netOps.getHostName();
                if (sHostName != null) {
                    try {
                        oVar.setValue(sHostName, false);
                        oVar1.setValue(sHostName, false);
                        if (!netOps.canUseHostName() || this.m_nOraparam == 0 || !this.canShowConditionally(sHostName)) {
                            oVar.setAdvice(true);
                            oVar1.setAdvice(true);
                        } else if (this.m_nOraparam == 1 || this.canShowConditionally(sHostName) || !OiicPullSession.isSilentMode()) {
                            oVar.setAdvice(false);
                            oVar1.setAdvice(false);
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public int doOperation(boolean isBack) throws OiifbEndIterateException {
        int retVal = super.doOperation(isBack);
        if (retVal != 1) {
            OiisVariable oVar = this.m_vo.getVariable("ORACLE_HOSTNAME");
            String sHostName = (String)oVar.getValue();
            OiinNetOps netops = OiinNetOps.getNetOps();
            netops.setHostName(sHostName);
        }
        return retVal;
    }

    public int getNext() {
        return this.m_nextInd;
    }

    protected boolean canShowWCDE() {
        OiinNetOps netOps = OiinNetOps.getNetOps();
        OiisVariable oVar = this.m_vo.getVariable("ORACLE_HOSTNAME");
        boolean bVarSet = oVar.getAdvice();
        String sHostName = (String)oVar.getValue();
        if (!netOps.canUseHostName() || this.m_nOraparam == 0 || !this.canShowConditionally(sHostName)) {
            return false;
        }
        boolean bOraparam = this.m_nOraparam == 1 || this.canShowConditionally(sHostName);
        boolean bShowWCDE = !bVarSet && (bVarSet || bOraparam);
        return bShowWCDE;
    }

    public boolean isPreConditionsSet() {
        return super.isPreConditionsSet();
    }

    public boolean validate() throws OiifbCancelException, OiifbEndIterateException {
        OiinNetOps netOps = OiinNetOps.getNetOps();
        OiisVariable oVar = this.m_vo.getVariable("ORACLE_HOSTNAME");
        OiisVariable oVar1 = this.m_vo.getVariable("OUI_HOSTNAME");
        boolean bVarSet = oVar.getAdvice();
        String sHostName = (String)oVar.getValue();
        if (!netOps.canUseHostName() || this.m_nOraparam == 0 || !this.canShowConditionally(sHostName)) {
            return true;
        }
        boolean bRet = true;
        bRet = OiicSessionInterfaceManager.getInterfaceManager().validateHostName(sHostName, bVarSet);
        if (this.isWCDEDisplayed() && !bRet) {
            oVar.setAdvice(false);
            oVar1.setAdvice(false);
        }
        return bRet;
    }

    public String getDisplayName() {
        String sTitle = OiixResourceBundle.getString("S_HOSTNAME_TITLE");
        return sTitle;
    }

    private boolean canShowConditionally(String sHostName) {
        return this.m_nOraparam == 1 || this.m_nOraparam == 2 && (this.m_bMultipleNIC || !OiinNetOps.isFQDN((String)sHostName));
    }
}

