/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifw;

import java.io.File;
import java.util.Vector;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifb.OiifbWizChainDlgElem;
import oracle.sysman.oii.oiif.oiifp.OiifpWizLocPanel;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiii.OiiiTargetAreaControl;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiis.OiisDlgInOutElem;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixOraparam;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifwInstLocWCDE
extends OiifbWizChainDlgElem {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 1024;
    private boolean m_bNeedLogin = false;
    private int m_nextInd = -1;
    private boolean m_bInvLocSet = false;
    private String[] m_nodeList = null;
    public static final String s_panelClass = "oracle.sysman.oii.oiif.oiifp.OiifpWizLocPanel";
    private static final String SOURCE_LOCATION = "SourceLocation";
    private static final String ORACLE_HOME = "OracleHome";
    private static final String ORACLE_HOME_NAME = "OracleHomeName";
    private boolean m_bShowAppltop = false;

    public OiifwInstLocWCDE(OiisVariableOwner vo, int nextInd) {
        super(vo);
        this.m_dlgInOutElems.addElement(new OiisDlgInOutElem(SOURCE_LOCATION, "FROM_LOCATION"));
        this.m_dlgInOutElems.addElement(new OiisDlgInOutElem(ORACLE_HOME, "ORACLE_HOME"));
        this.m_dlgInOutElems.addElement(new OiisDlgInOutElem(ORACLE_HOME_NAME, "ORACLE_HOME_NAME"));
        this.setWizPanelClassName(s_panelClass);
        this.m_bShowAppltop = OiixOraparam.isApplTopStage();
        this.setHelpKey("OiifwInstLocWCDE");
        if (this.m_bShowAppltop) {
            this.m_dlgInOutElems.addElement(new OiisDlgInOutElem("AppltopLocation", "APPLTOP"));
            this.m_dlgInOutElems.addElement(new OiisDlgInOutElem("AppltopName", "APPLTOP_NAME"));
            this.setHelpKey("OiifwInstLocWCDE_Appltop");
        }
        this.m_nextInd = nextInd;
    }

    public String getDisplayName() {
        String sTitle = OiixResourceBundle.getString("S_FILE_LOC");
        return sTitle;
    }

    public void setWizPanel() {
    }

    public void initialize() throws OiifbEndIterateException {
        super.initialize();
        OiisVariable oInvLoc = this.m_varOwner.getVariable("INVENTORY_LOCATION");
        this.m_bInvLocSet = oInvLoc.getAdvice();
        this.initHomeVariables();
    }

    private void initHomeVariables() {
        this.initHomeVariables(0);
        if (this.m_bShowAppltop) {
            this.initHomeVariables(1);
        }
    }

    private void initHomeVariables(int nHomeType) {
        String sLoc;
        String sHomeName = null;
        String sHomeLoc = null;
        if (nHomeType == 1) {
            sHomeName = "APPLTOP_NAME";
            sHomeLoc = "APPLTOP";
        } else if (nHomeType == 0) {
            sHomeName = "ORACLE_HOME_NAME";
            sHomeLoc = "ORACLE_HOME";
        }
        OiisVariable oOhLoc = this.m_varOwner.getVariable(sHomeLoc);
        OiisVariable oOhName = this.m_varOwner.getVariable(sHomeName);
        boolean bLocSet = oOhLoc.isValueSet();
        boolean bNameSet = oOhName.isValueSet();
        String sOhName = (String)oOhName.getValue();
        String sOhLoc = (String)oOhLoc.getValue();
        if (bLocSet && !bNameSet) {
            String sName = this.getHomeValue(sOhName, sOhLoc, 2, nHomeType);
            if (sName != null && !sName.equals("")) {
                try {
                    oOhName.setValue(sName, false);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (sName == null && System.getProperty("oracle.installer.defaultHomeName", "false").equals("true")) {
                try {
                    oOhName.setValue(this.getDefaultHomeName(), true);
                }
                catch (OiifbCancelException e) {
                }
                catch (OiisVarSettingException e) {}
            }
        } else if (!bLocSet && bNameSet && (sLoc = this.getHomeValue(sOhName, sOhLoc, 1, nHomeType)) != null && !sLoc.equals("")) {
            try {
                oOhLoc.setValue(sLoc, false);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private String getDefaultHomeName() {
        OiiiInstallAreaControl oAreaControl = (OiiiInstallAreaControl)OiiiInstallAreaControl.getInventoryAreaControl();
        OiiiInstallInventory oInventory = oAreaControl.getInstallInventory();
        String name = OiiiOracleHomeInfo.getDefHomeName(oInventory, 0);
        int idx = 1;
        boolean bNameExists = true;
        while (bNameExists) {
            String sName = name + idx;
            bNameExists = oInventory.getHomeWithName(sName) != null;
            if (!bNameExists) continue;
            ++idx;
        }
        return name + idx;
    }

    private String getHomeValue(String sName, String sLoc, int nCheck, int nHomeType) {
        String sRet = null;
        OiiiInstallAreaControl oAreaControl = (OiiiInstallAreaControl)OiiiInstallAreaControl.getInventoryAreaControl();
        OiiiInstallInventory oInventory = oAreaControl.getInstallInventory();
        if (oInventory != null) {
            Vector vHomes = oInventory.getHomes();
            int nHomeCount = vHomes.size();
            OiipgFileSystem oFileOps = new OiipgFileSystem();
            String sAbsHomeLoc = "";
            if (sLoc != null) {
                sAbsHomeLoc = OiixPathOps.getAbsolutePath(sLoc);
            }
            for (int i = 0; i < nHomeCount; ++i) {
                OiiiOracleHomeInfo oInfo = (OiiiOracleHomeInfo)vHomes.elementAt(i);
                String sHomeLoc = OiixPathOps.getAbsolutePath(oInfo.getLocation());
                String sHomeName = oInfo.getName();
                int nExistingHomeType = oInfo.getHomeType();
                if (nHomeType != nExistingHomeType) continue;
                if (nCheck == 1) {
                    if (!sName.equals(sHomeName)) continue;
                    sRet = sHomeLoc;
                    break;
                }
                if (nCheck != 2 || !oFileOps.areLocsSame(sHomeLoc, sAbsHomeLoc)) continue;
                sRet = sHomeName;
                break;
            }
        }
        return sRet;
    }

    protected void setDialogProperties() {
        super.setDialogProperties();
        this.m_session.getWizardDialog().setEnabledButton(8, true);
    }

    public int getNext() {
        OiifpWizLocPanel v_wizPanel;
        OiifwInstLocWCDE oiifwInstLocWCDE = this;
        if (!oiifwInstLocWCDE.m_session.isSilentMode() && (v_wizPanel = (OiifpWizLocPanel)this.m_session.getWizardDialog().getWizardPanel()) != null && v_wizPanel.isPanelDirty()) {
            this.m_session.onBackIntoLocations();
        }
        return this.m_nextInd;
    }

    private long getLibrariesSize(String sStageDir) {
        long lDirsTotalSize = 0L;
        for (int i = 0; i < OiiiTargetAreaControl.LIBS_LOC.length; ++i) {
            String sLoc = OiixPathOps.concatPath(sStageDir, OiiiTargetAreaControl.LIBS_LOC[i]);
            File fNew = new File(sLoc);
            lDirsTotalSize += OiixFileOps.getTotalFileSize(fNew, true);
        }
        return lDirsTotalSize;
    }

    private long getCompDefnSize(String sStageDir) {
        return OiixFileOps.getTotalFileSize(new File(sStageDir), false);
    }

    public void dispose() {
        super.dispose();
        this.m_varOwner = null;
    }

    public boolean isShowApplTop() {
        return this.m_bShowAppltop;
    }
}

