/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifw;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import oracle.sysman.oic.oics.OicsCheckPointException;
import oracle.sysman.oic.oics.OicsCheckPointFactory;
import oracle.sysman.oic.oics.OicsICheckPoint;
import oracle.sysman.oic.oics.OicsICheckPointIndexSession;
import oracle.sysman.oic.oics.OicsICheckPointProperty;
import oracle.sysman.oic.oics.OicsICheckPointSession;
import oracle.sysman.oii.oiic.OiicExitCode;
import oracle.sysman.oii.oiic.OiicExitOps;
import oracle.sysman.oii.oiic.OiicInstallCancelHandler;
import oracle.sysman.oii.oiic.OiicInstallSession;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiic.OiicSessionPlan;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbCondIterator;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifb.OiifbIRetry;
import oracle.sysman.oii.oiif.oiifb.OiifbProgressControl;
import oracle.sysman.oii.oiif.oiifb.OiifbWizOperation;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiif.oiifr.OiifrProgressActionListener;
import oracle.sysman.oii.oiif.oiifr.OiifrProgressPhases;
import oracle.sysman.oii.oiif.oiifw.OiifwActionsPhaseWCDE;
import oracle.sysman.oii.oiif.oiifw.OiifwHomeSetupWCCE;
import oracle.sysman.oii.oiif.oiifw.OiifwReadmeWCCE;
import oracle.sysman.oii.oiii.OiiiAreaInventory;
import oracle.sysman.oii.oiii.OiiiCompIdOhPair;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiInstallPatchInvEntry;
import oracle.sysman.oii.oiii.OiiiInventoryHelper;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiii.OiiiPatchInstallID;
import oracle.sysman.oii.oiii.OiiiStageInventory;
import oracle.sysman.oii.oiij.OiijFastCopyData;
import oracle.sysman.oii.oiij.OiijFastCopyPhase;
import oracle.sysman.oii.oiil.OiilActionException;
import oracle.sysman.oii.oiil.OiilWinActionsInstall;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiio.oiiol.OiiolXMLInstallLog;
import oracle.sysman.oii.oiip.oiipg.OiipgCFSDriveCheck;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiip.osd.unix.OiipuUnixOps;
import oracle.sysman.oii.oiis.OiisCompActions;
import oracle.sysman.oii.oiis.OiisCompContext;
import oracle.sysman.oii.oiis.OiisCompInstallation;
import oracle.sysman.oii.oiis.OiisFileDeletionReader;
import oracle.sysman.oii.oiis.OiisGenActionsReader;
import oracle.sysman.oii.oiis.OiisInstantiateInfo;
import oracle.sysman.oii.oiis.OiisMakeConfig;
import oracle.sysman.oii.oiis.OiisMakeDepsReader;
import oracle.sysman.oii.oiis.OiisRelinkActions;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiix.OiixDebug;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixInstantiateOps;
import oracle.sysman.oii.oiix.OiixLanguage;
import oracle.sysman.oii.oiix.OiixOraparam;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixSpawnException;
import oracle.sysman.oii.oiix.OiixSpawnOps;
import oracle.sysman.oii.oiix.OiixUtilityOps;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiifwInstallPhaseWCCE
implements OiifbWizOperation {
    OiicPullSession m_session;
    OiicSessionPlan m_sessionPlan;
    private OiifrProgressActionListener m_progressListener;
    private OiifbProgressControl m_progressControl;
    private OiifwActionsPhaseWCDE m_actionsPhase;
    private OiicSessionInterfaceManager m_interfaceManager;
    OiifbCondIterator m_installPhaseIterator;
    private long m_nIP1FlowCount = 0L;
    private long m_nLinkFlowCount = 0L;
    private long m_nIP2FlowCount = 0L;
    private int m_nSaveInvFactor = 1;
    private OiiiOracleHomeInfo ohInfo = null;
    private boolean m_bFastMode;
    private int m_iClusterRange = 0;
    private long m_lTotalBytesForProgress = 0L;
    private String m_sSourceStage;
    private String m_sFastCopyListFile;
    private String m_sFastCopyDirListFile;
    private String m_sTLDepMode;
    private OiijFastCopyPhase m_oFastCopyPhase;
    private String m_sGenFile = null;
    private String sOBase = null;
    private String sGlobalContextXML;
    private String sOHomeLoc = null;
    private final String sComponent = "oui";
    private String sOHomeName;
    private String sFileName;
    private String chkpointFile;
    private static OicsICheckPointIndexSession cpis = null;
    private OicsICheckPointSession cps = null;

    public OiifwInstallPhaseWCCE(OiifwActionsPhaseWCDE actionsPhase) {
        this.m_session = (OiicPullSession)actionsPhase.getInstallSession();
        this.m_sessionPlan = this.m_session.getSessionPlan();
        this.m_actionsPhase = actionsPhase;
        this.m_interfaceManager = OiicSessionInterfaceManager.getInterfaceManager();
        this.m_progressControl = this.m_actionsPhase.getProgressControl();
    }

    public void initialize() {
        OiisVariable ohVar;
        String oracleHomeString;
        OiiiOracleHomeInfo homeInfo;
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup(curPlatId);
        if (curPlatGroup == -3) {
            this.isVC8Installed();
        }
        this.initializeCheckPointSession();
        this.m_progressListener = (OiifrProgressActionListener)this.m_interfaceManager.getProgressListener();
        this.m_progressListener.setStatus(OiixResourceBundle.getString("S_START_INSTALL"));
        Vector vInstallList = this.m_sessionPlan.getSuccessfulAdditions(10);
        this.m_progressControl.init();
        OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
        OiiiInstallInventory instInv = iac.getInstallInventory();
        int ohIndex = this.m_session.getOHIndex();
        Vector oracleHomes = instInv.getHomes();
        int idx = OiixVectorOps.vectIndexOf(oracleHomes, (Object)new Integer(ohIndex));
        if (idx != -1) {
            OiiiOracleHomeInfo ohInfo;
            this.ohInfo = ohInfo = (OiiiOracleHomeInfo)oracleHomes.elementAt(idx);
            ohInfo.setDirty(true);
        }
        if ((homeInfo = instInv.getHomeWithLocation(oracleHomeString = (String)(ohVar = this.m_session.getSessionContext().getVariable("ORACLE_HOME")).getValue())) != null) {
            boolean bPluginHome = Boolean.getBoolean("oracle.installer.plugin");
            if (bPluginHome) {
                homeInfo.setPluginHome(true);
            } else {
                homeInfo.setPluginHome(false);
            }
        }
        Vector<OiifbWizOperation> installPhases = new Vector<OiifbWizOperation>(5, 2);
        if (this.m_session.isInstallMode()) {
            String explicitLibPermsDef = "0555";
            String explicitLibExtnsDef = ".sl,.sl.11.1";
            String explicitLibPerms = System.getProperty("oracle.installer.LibPerms", explicitLibPermsDef);
            String explicitLibExtns = System.getProperty("oracle.installer.LibExtns", explicitLibExtnsDef);
            OiixFileOps.setExplicitLibPerms(explicitLibPerms);
            OiixFileOps.setExplicitLibExtns(explicitLibExtns);
            this.addFastCopyPhase(installPhases);
        }
        installPhases.add(new OiifwHomeSetupWCCE(this.m_session.getSessionContext()));
        if (this.m_session.isInstallMode()) {
            OiiiStageInventory oStageInv = this.m_session.getSourceAccess().getStageInventory();
            installPhases.add(new OiifwReadmeWCCE(this.m_session.getSessionContext(), oStageInv));
        }
        installPhases.addElement(new OiifwComponentIP1WCCE(iac, vInstallList));
        if (!OiicPullSession.isLangAddonMode()) {
            if (this.m_actionsPhase.needLinkPhase()) {
                OiiolTextLogger.appendText("Link phase has been specified as needed");
                installPhases.addElement(new OiifwComponentLinkWCCE(iac, vInstallList));
            }
            if (this.m_actionsPhase.isSetupPhaseNeeded()) {
                OiiolTextLogger.appendText("Setup phase has been specified as needed");
                installPhases.addElement(new OiifwComponentIP2WCCE(iac, vInstallList));
            }
        }
        this.m_installPhaseIterator = new OiifbCondIterator(installPhases);
    }

    private void cleanUpDeleteFileList(ArrayList delFileList) {
        int iSize = delFileList == null ? 0 : delFileList.size();
        for (int i = 0; i < iSize; ++i) {
            String loc = (String)delFileList.get(i);
            File f = new File(loc);
            if (!f.exists()) {
                OiiolTextLogger.appendText("No File found for delete at " + loc);
                continue;
            }
            if (f.isFile() && !f.delete()) {
                OiiolTextLogger.appendText("registering File at  " + loc + " for delete on reboot");
                OiipgFileSystem.registerFileToDelete(f);
            }
            if (!f.isDirectory()) continue;
            OiixFileOps.cleanupdelete(f);
        }
    }

    private void addFastCopyPhase(Vector installPhases) {
        this.setFastModeProperties();
        if (this.m_bFastMode) {
            OiicInstallSession instSession = (OiicInstallSession)this.m_session;
            OiisVariable oHomeVar = this.m_session.getSessionContext().getVariable("ORACLE_HOME");
            boolean bInstantiateRAC = false;
            OiisVariable oNodeNames = this.m_session.getSessionContext().getVariable("CLUSTER_NODES");
            String[] nodeArr = (String[])oNodeNames.getValue();
            boolean bPatchSetInstall = instSession.getFastModeType() == 2;
            String val = OiixOraparam.getOraparamProfileString("IGNORECLUSTER", "false");
            boolean isIgnoreCluster = val.equalsIgnoreCase("true");
            if (nodeArr != null && nodeArr.length > 1 && !bPatchSetInstall && !isIgnoreCluster) {
                String sHome;
                OiipgCFSDriveCheck cfsDriveCheck = OiipgCFSDriveCheck.getCFSDriveChecker();
                if (!cfsDriveCheck.isDriveOnCFS(sHome = (String)oHomeVar.getValue())) {
                    bInstantiateRAC = true;
                    OiiolTextLogger.appendText("FASTCOPYRAC : Oracle Home < " + sHome + " >is not shared. Instantiating RAC files");
                } else {
                    OiiolTextLogger.appendText("FASTCOPYRAC : Oracle Home < " + sHome + " >is shared. Instantiating RAC files");
                }
            }
            this.m_oFastCopyPhase = new OiijFastCopyPhase(instSession.getFastCopyData(), 1, (String)oHomeVar.getValue(), this.m_sSourceStage, this.m_sTLDepMode, bInstantiateRAC);
            this.m_oFastCopyPhase.setActionsWCDE(this.m_actionsPhase);
            this.m_oFastCopyPhase.setSelectedComps(this.getSelCompsMap());
        }
    }

    private HashMap getSelCompsMap() {
        Vector vInstallList = this.m_sessionPlan.getSuccessfulAdditions(10);
        int len = vInstallList.size();
        HashMap<String, OiiiCompInstallID> hMap = new HashMap<String, OiiiCompInstallID>(len);
        for (int i = 0; i < len; ++i) {
            OiiiCompInvEntry oEntry = (OiiiCompInvEntry)vInstallList.elementAt(i);
            String sCompName = oEntry.getCompInstallID().getName();
            String sVer = oEntry.getCompInstallID().getVersion().toString();
            hMap.put(sCompName + ":" + sVer, oEntry.getCompInstallID());
        }
        return hMap;
    }

    private void setFastModeProperties() {
        if (!Boolean.getBoolean("oracle.installer.fastcopy")) {
            this.m_bFastMode = false;
            return;
        }
        OiicInstallSession instSession = (OiicInstallSession)this.m_session;
        if (this.m_session.isAutoOUI() || this.m_session.isAdditionalComps()) {
            OiiolTextLogger.appendText("Install mode is not fastcopy, as AUTO OUI or Additional Component Install is done");
            instSession.setFastMode(0);
            this.m_bFastMode = false;
            return;
        }
        OiijFastCopyData ofcd = instSession.getFastCopyData();
        if (ofcd == null || !ofcd.isProcessingSuccess() || !ofcd.isFastCopyCompatible()) {
            OiiolTextLogger.appendText("Install mode is not fastcopy.");
            instSession.setFastMode(0);
            this.m_bFastMode = false;
            return;
        }
        this.m_sSourceStage = instSession.getSourceAccess().getSourceRoot();
        if (OiiolTextLogger.getLogLevel() > OiiolTextLogger.LOG_DETAILED) {
            OiiolTextLogger.writeLogWithTimeAndTrace("FastCopyMode, the source stage location :" + this.m_sSourceStage, OiiolTextLogger.STR_LOG_DETAILED);
        }
        boolean bPatchSet = false;
        OiicSessionContext oContext = instSession.getSessionContext();
        OiisVariable oTopLevelVar = oContext.getVariable("ToplevelComp");
        OiiiCompInstallID oID = (OiiiCompInstallID)oTopLevelVar.getValue();
        String sTopLevel = oID.getName();
        if (oID.getCompType() == 4) {
            bPatchSet = true;
        }
        String sInstallType = "";
        if (!bPatchSet) {
            OiisVariable oInstTypeVar = oContext.getVariable("DEP_MODE");
            sInstallType = (String)oInstTypeVar.getValue();
            this.m_sTLDepMode = sTopLevel + "_" + sInstallType;
        } else {
            this.m_sTLDepMode = sTopLevel;
        }
        if (ofcd.getFCCompDetails(this.m_sTLDepMode) == null) {
            instSession.setFastMode(0);
            this.m_bFastMode = false;
            return;
        }
        Object[] args = new Object[]{sTopLevel, sInstallType};
        OiiolTextLogger.appendText(OiixResourceBundle.getString("S_FASTCOPY_MODE", args));
        ofcd.setTLDepMode(this.m_sTLDepMode);
        this.m_bFastMode = true;
        if (!bPatchSet) {
            instSession.setFastMode(1);
        } else {
            instSession.setFastMode(2);
        }
    }

    private boolean isRemoteOpsNeeded() {
        boolean retVal = false;
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup(curPlatId);
        switch (curPlatGroup) {
            case -3: {
                retVal = true;
                break;
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doOperation(boolean isBack) throws OiifbEndIterateException {
        int i;
        OiiiInstallAreaControl iac;
        String sFallBackRoot;
        this.m_actionsPhase.synchInstallInventory(this.m_progressListener);
        Object object = this.m_actionsPhase.getSynchObject();
        synchronized (object) {
            if (!this.m_actionsPhase.isInstallInterrupted()) {
                this.m_session.getDepEngine().dispose();
            }
        }
        this.m_session.registerCopyLogInfo();
        if (this.m_session.isCloneMode() && new File(sFallBackRoot = (iac = OiiiInstallAreaControl.getInstallAreaControl()).getTemplatesLoc(this.m_session.getOHIndex())).exists()) {
            OiiolTextLogger.appendText(OiixResourceBundle.getString("S_CLONE_UPDATE_ALL_TEMPLATES"), OiiolTextLogger.LOG_BASIC);
            try {
                OiixFileOps.copyDir(new File(sFallBackRoot), new File(this.ohInfo.getLocation()), true, true);
            }
            catch (IOException exp) {
                throw new OiifbEndIterateException(OiixResourceBundle.getString("S_ERR_CLONE_UPDATE_ALL_TEMPLATES"));
            }
        }
        OiiiCompInstallID[] ci = this.m_session.getSelTopLevelCompIDs();
        String xmlLoc = "";
        String Loc = "";
        String homeLoc = "";
        int iSize = ci == null ? 0 : ci.length;
        String overRideMakeXML = System.getProperty("oracle.installer.overRideXML", "");
        if (this.m_session.isCloneMode()) {
            for (i = 0; i < iSize / 2; ++i) {
                OiiiCompInstallID tempcid = ci[i];
                ci[i] = ci[iSize - i - 1];
                ci[iSize - i - 1] = tempcid;
            }
        }
        for (i = 0; i < iSize; ++i) {
            try {
                OiisMakeDepsReader mdr;
                OiisCompContext cContext;
                OiisCompInstallation ciObj;
                int idx = this.m_session.getOHIndex();
                OiiiInstallAreaControl iac2 = OiiiInstallAreaControl.getInstallAreaControl();
                OiiiInstallInventory instInv = iac2.getInstallInventory();
                homeLoc = instInv.getHomeLocation(idx);
                String sTempLoc = System.getProperty("oracle.installer.scratchPath");
                if (!this.m_session.isCloneMode()) {
                    this.m_sGenFile = OiixPathOps.concatPath(sTempLoc, "instantiate.xml");
                    xmlLoc = OiixPathOps.concatPath(sTempLoc, "UserActions");
                    xmlLoc = OiixPathOps.concatPath(xmlLoc, ci[i].getName());
                    Loc = OiixPathOps.concatPath(xmlLoc, "useractions.properties");
                } else {
                    xmlLoc = iac2.getXMLCompFullLoc(ci[i], idx);
                    Loc = OiixPathOps.concatPath(xmlLoc, "useractions.properties");
                    this.m_sGenFile = OiixPathOps.concatPath(homeLoc, "inventory");
                    this.m_sGenFile = OiixPathOps.concatPath(this.m_sGenFile, "instantiate.xml");
                }
                if (ci[i].getCompType() == 4 && new File(overRideMakeXML).exists()) {
                    if (Boolean.getBoolean("oracle.installer.debug")) {
                        OiiolTextLogger.appendText("Reading From" + overRideMakeXML, 0);
                    }
                    cContext = (ciObj = this.m_session.getCompInstall(ci[i])) != null ? ciObj.getContext() : null;
                    mdr = new OiisMakeDepsReader(overRideMakeXML, homeLoc, true, cContext);
                    mdr.loadFromFile();
                    continue;
                }
                if (new File(Loc).exists()) {
                    OiisCompInstallation ciObj2;
                    String s_MakeDepsLoc = null;
                    if (!new File(Loc).exists()) continue;
                    Properties properties = new Properties();
                    try {
                        properties.load(new FileInputStream(Loc));
                        s_MakeDepsLoc = properties.getProperty("MakeEntryXML");
                        if (s_MakeDepsLoc != null) {
                            xmlLoc = OiixPathOps.concatPath(xmlLoc, s_MakeDepsLoc.trim());
                        }
                    }
                    catch (Exception e) {
                        OiiolTextLogger.appendException(e);
                    }
                    if (s_MakeDepsLoc == null) continue;
                    if (Boolean.getBoolean("oracle.installer.debug")) {
                        OiiolTextLogger.appendText("Reading From" + xmlLoc, 0);
                    }
                    OiisCompContext cContext2 = (ciObj2 = this.m_session.getCompInstall(ci[i])) != null ? ciObj2.getContext() : null;
                    OiisMakeDepsReader mdr2 = new OiisMakeDepsReader(xmlLoc, homeLoc, true, cContext2);
                    mdr2.loadFromFile();
                    continue;
                }
                if (ci[i].getCompType() != 4) continue;
                Loc = OiiiInstallAreaControl.getMakeDirForHome(homeLoc);
                Loc = OiixPathOps.concatPath(Loc, "makeorder.xml");
                if (!new File(Loc = OiixPathOps.getNativeForm(Loc)).exists()) continue;
                if (Boolean.getBoolean("oracle.installer.debug")) {
                    OiiolTextLogger.appendText("Reading From" + Loc, 0);
                }
                cContext = (ciObj = this.m_session.getCompInstall(ci[i])) != null ? ciObj.getContext() : null;
                mdr = new OiisMakeDepsReader(Loc, homeLoc, true, cContext);
                mdr.loadFromFile();
                continue;
            }
            catch (IOException e) {
                OiiolTextLogger.appendException(e);
            }
        }
        OiisMakeConfig.sOHLoc = homeLoc;
        int retVal = this.m_installPhaseIterator.iterate(isBack);
        String loc = System.getProperty("oracle.installer.deletionFileList", null);
        if (loc != null) {
            String sTempLoc = System.getProperty("oracle.installer.scratchPath");
            loc = OiixPathOps.getFileName(loc);
            if (new File(loc = OiixPathOps.concatPath(sTempLoc, loc)).exists()) {
                OiisFileDeletionReader fdr = new OiisFileDeletionReader(loc, homeLoc);
                try {
                    fdr.loadFromFile();
                }
                catch (IOException e) {
                    // empty catch block
                }
                ArrayList delFileList = fdr.getFilesToDelete();
                this.cleanUpDeleteFileList(delFileList);
            } else {
                OiiolTextLogger.appendText("File not found at " + loc);
            }
        }
        this.m_session.getPgActionsPhase().restoreRootSh();
        return retVal;
    }

    public void dispose() {
        if (this.cps != null) {
            try {
                this.cps.closeCheckPointSession();
            }
            catch (OicsCheckPointException e) {
                OiiolTextLogger.appendText(e.getMessage());
            }
        }
        if (this.m_installPhaseIterator != null) {
            this.m_installPhaseIterator.dispose();
        }
    }

    long getInstallProgressBytes() {
        return this.m_lTotalBytesForProgress;
    }

    int getClusterRange() {
        return this.m_iClusterRange;
    }

    long computeInstallProgressBytes(Vector installIEs, boolean bCluster) {
        long lTotalFlowCount;
        int nCnt = installIEs.size();
        this.m_nIP1FlowCount = 0L;
        this.m_nLinkFlowCount = 0L;
        this.m_nIP2FlowCount = 0L;
        for (int i = 0; i < nCnt; ++i) {
            OiiiInstallCompInvEntry icie = (OiiiInstallCompInvEntry)installIEs.elementAt(i);
            OiiiCompInstallID cid = icie.getCompInstallID();
            OiisCompInstallation ci = this.m_session.getCompInstall(cid);
            OiisCompContext cxt = ci.getContext();
            this.m_nIP1FlowCount += (long)cxt.getIP1FlowCount();
            this.m_nLinkFlowCount += (long)cxt.getLKPFlowCount();
            this.m_nIP2FlowCount += (long)cxt.getIP2FlowCount();
        }
        if (!this.m_actionsPhase.needLinkPhase()) {
            this.m_nLinkFlowCount = 0L;
        }
        long lTotalBytes = this.m_session.getDepEngine().getTotalRequiredSpace();
        long lClusterBytes = 0L;
        if (bCluster) {
            String sOHPath = (String)this.m_session.getContext().getVarValue("ORACLE_HOME");
            OiipgCFSDriveCheck oCFSDriveCheck = OiipgCFSDriveCheck.getCFSDriveChecker();
            lClusterBytes = oCFSDriveCheck.isDriveOnCFS(sOHPath) ? 0L : lTotalBytes;
            lTotalBytes += lClusterBytes;
        }
        if ((lTotalFlowCount = this.m_nIP1FlowCount + this.m_nLinkFlowCount + this.m_nIP2FlowCount) > 0L) {
            long lActionBytes = lTotalBytes / 3L;
            OiifwActionsPhaseWCDE.setActionSize((int)Math.max(10L, lActionBytes / lTotalFlowCount));
            int iFactor = bCluster && this.isRemoteOpsNeeded() ? 2 : 1;
            lTotalBytes += (long)OiifwActionsPhaseWCDE.getActionSize() * lTotalFlowCount * (long)iFactor;
        }
        int iSaveInvFactor = this.m_nSaveInvFactor + (bCluster ? 1 : 0);
        this.m_lTotalBytesForProgress = lTotalBytes = lTotalBytes * 100L / (long)(100 - iSaveInvFactor);
        this.m_iClusterRange = (int)(bCluster ? lClusterBytes * 100L / lTotalBytes : 0L);
        return lTotalBytes;
    }

    private void initializeCheckPointSession() {
        if (this.m_session != null) {
            String checkpointLoc;
            OiiolTextLogger.appendText("Checkpoint:Initializing checkpoint session in oiifwinstallphasewcce.");
            if (this.m_session.getContext().getVarValue("ORACLE_BASE") != null) {
                this.sOBase = (String)this.m_session.getContext().getVarValue("ORACLE_BASE");
            }
            if (this.m_session.getContext().getVarValue("ORACLE_HOME") != null) {
                this.sOHomeLoc = (String)this.m_session.getContext().getVarValue("ORACLE_HOME");
            }
            if (this.m_session.getContext().getVarValue("ORACLE_HOME_NAME") != null) {
                this.sOHomeName = (String)this.m_session.getContext().getVarValue("ORACLE_HOME_NAME");
            }
            this.sGlobalContextXML = System.getProperty("oracle.installer.globalcontextxml");
            String string = checkpointLoc = this.computeCheckPointLoc() == null ? null : this.computeCheckPointLoc();
            if (checkpointLoc != null) {
                this.sFileName = OiixPathOps.getNativeForm(OiixPathOps.concatPath(checkpointLoc, "checkpoints"));
                this.sFileName = OiixPathOps.getNativeForm(OiixPathOps.concatPath(this.sFileName, "oui"));
                this.chkpointFile = "checkpoint_" + this.sOHomeName + ".xml";
                this.sFileName = OiixPathOps.getNativeForm(OiixPathOps.concatPath(this.sFileName, this.chkpointFile));
                cpis = this.m_session.getCheckPointIndexSessionObj();
                if (cpis != null) {
                    OiicExitOps.getExitOps().addIndexSessionObj(cpis);
                }
            }
        }
    }

    private String computeCheckPointLoc() {
        String oracleBase = null;
        String oracleHome = null;
        if (this.m_session.getContext().getVarValue("ORACLE_BASE") != null) {
            oracleBase = (String)this.m_session.getContext().getVarValue("ORACLE_BASE");
        }
        if (this.m_session.getContext().getVarValue("ORACLE_HOME") != null) {
            oracleHome = (String)this.m_session.getContext().getVarValue("ORACLE_HOME");
        }
        if (oracleBase != null) {
            return oracleBase;
        }
        if (oracleHome != null) {
            String temp = oracleHome;
            if (new File(temp = OiixPathOps.getNativeForm(OiixPathOps.concatPath(temp, "install"))).exists()) {
                return temp;
            }
            oracleHome = OiixPathOps.getNativeForm(OiixPathOps.concatPath(oracleHome, "inventory"));
            return oracleHome;
        }
        return null;
    }

    private void isVC8Installed() {
        String MSVCREDIST_INSTALL = OiixOraparam.getOraparamProfileString("MSVCREDIST_INSTALL", "false");
        String cmdToRun = "";
        if (MSVCREDIST_INSTALL.equalsIgnoreCase("true")) {
            String MSVCREDIST_LOC = OiixOraparam.getOraparamProfileString("MSVCREDIST_LOC", null);
            String MSVCREDIST_FLAGS = OiixOraparam.getOraparamProfileString("MSVCREDIST_FLAGS", null);
            if (MSVCREDIST_FLAGS != null && MSVCREDIST_LOC != null) {
                OiixFunctionOps.setSystemProperty("oracle.installer.msvcredist_flags", MSVCREDIST_FLAGS);
                OiixFunctionOps.setSystemProperty("oracle.installer.msvcredist_loc", MSVCREDIST_LOC);
                OiixFunctionOps.setSystemProperty("oracle.installer.msvcredist_install", "true");
                if (OiixUtilityOps.geVC8CommandLine() == null) {
                    OiiolTextLogger.appendText("OUI not installing VC8 as commandline is not available for VC8 runtime");
                    return;
                }
                cmdToRun = OiixUtilityOps.geVC8CommandLine();
                OiiolTextLogger.appendText("OUI using runAnyCmdOnNodes functionality from srvm to install VC8 runtime on this node.");
                OiiolTextLogger.appendText("command to run is  " + cmdToRun);
                try {
                    OiixSpawnOps.spawn(cmdToRun);
                }
                catch (OiixSpawnException e) {
                    OiiolTextLogger.appendException(e);
                }
            } else {
                OiiolTextLogger.appendText("MSVCREDIST_INSTALL is set true from oraparam.ini but the location of exe and flag not found. Not installing VC8 runtime now.");
            }
        }
    }

    private class OiifwComponentLinkWCCE
    extends OiifwComponentInstallPhaseWCCE {
        public OiifwComponentLinkWCCE(OiiiInstallAreaControl installAreaControl, Vector icies) {
            super(installAreaControl, icies);
            this.setPhase(2);
            this.setPreReqPhase(20);
            this.setPhaseTobeCompleted(30);
            this.setCurrentProgressPhase(4);
        }

        public int doOperation(boolean isBack) throws OiifbEndIterateException {
            block4: {
                super.doOperation(isBack);
                try {
                    boolean isDebugTMD = OiixDebug.PRINT_TIME || OiixDebug.PRINT_MEMORY || OiixDebug.PRINT_DISKUSAGE;
                    long lTime = 0L;
                    Vector vVolumes = null;
                    String sDebugTMDMsg = null;
                    if (isDebugTMD) {
                        vVolumes = OiifwInstallPhaseWCCE.this.m_session.getVolumeInfo();
                        sDebugTMDMsg = "Start of " + this.getRelinkPhaseString();
                        lTime = System.currentTimeMillis();
                        OiixDebug.printDebugTMDMesages(sDebugTMDMsg, lTime, 0L, vVolumes);
                    }
                    OiisRelinkActions link = new OiisRelinkActions();
                    link.init(OiifwInstallPhaseWCCE.this.m_session);
                    link.setCallBack(OiifwInstallPhaseWCCE.this.m_progressListener);
                    link.doReLink();
                    if (isDebugTMD) {
                        sDebugTMDMsg = "End of " + this.getRelinkPhaseString();
                        long lCurTime = System.currentTimeMillis();
                        OiixDebug.printDebugTMDMesages(sDebugTMDMsg, lCurTime, lCurTime - lTime, vVolumes);
                    }
                }
                catch (Exception e) {
                    if (this.handleException(e)) break block4;
                    OiifwInstallPhaseWCCE.this.m_progressListener.onResume();
                }
            }
            this.endOfPhaseProgressUpdate(true);
            return 0;
        }

        protected void performStateChangeActions(OiisCompInstallation ci, OiiiInstallCompInvEntry icie) throws OiilActionException, OiifbCancelException, IOException, OiisVarSettingException {
            super.performStateChangeActions(ci, icie);
            OiisCompActions oCompActions = ci.getActions();
            if (oCompActions != null) {
                oCompActions.preStateChangePhaseLinkActions();
                oCompActions.stateChangePhaseLinkActions();
                oCompActions.postStateChangePhaseLinkActions();
            }
            ci.disposeUnusedObjects(2);
        }

        public String getPhaseString() {
            return OiixResourceBundle.getString("S_TL_PH_LINK");
        }

        public String getRelinkPhaseString() {
            return "Relink Phase";
        }

        protected void endOfPhaseProgressUpdate() {
            this.endOfPhaseProgressUpdate(false);
        }

        private void endOfPhaseProgressUpdate(boolean bDoneRelink) {
            if (bDoneRelink) {
                super.endOfPhaseProgressUpdate();
            } else {
                OiifwInstallPhaseWCCE.this.m_progressListener.setStatus(OiifrProgressPhases.getPhaseInProgressString(this.m_iCurrProgressPhase));
            }
        }
    }

    private class OiifwComponentIP2WCCE
    extends OiifwComponentInstallPhaseWCCE {
        private ArrayList m_vInstantiates;

        public OiifwComponentIP2WCCE(OiiiInstallAreaControl installAreaControl, Vector icies) {
            super(installAreaControl, icies);
            this.m_vInstantiates = null;
            this.setPhase(8);
            int preReqPhase = 20;
            if (OiifwInstallPhaseWCCE.this.m_actionsPhase.needLinkPhase()) {
                preReqPhase = 30;
            }
            this.setPreReqPhase(preReqPhase);
            this.setPhaseTobeCompleted(40);
            this.setCurrentProgressPhase(8);
        }

        public int doOperation(boolean isBack) throws OiifbEndIterateException {
            OicsICheckPointProperty cpp = null;
            OicsICheckPoint cp2 = null;
            String chkPointName2 = null;
            if (cpis != null) {
                cpp = OiifwInstallPhaseWCCE.this.sOBase != null ? OicsCheckPointFactory.constructStringProperty((String)"ORACLE_BASE", (String)OiifwInstallPhaseWCCE.this.sOBase) : OicsCheckPointFactory.constructStringProperty((String)"ORACLE_BASE", (String)"");
                chkPointName2 = OiifwInstallPhaseWCCE.this.m_session.isCloneMode() ? "oracle.installer.clone" : "oracle.installer.install";
                OiifwInstallPhaseWCCE.this.cps = cpis.initCheckPointSession(OiifwInstallPhaseWCCE.this.sFileName);
                if (OiifwInstallPhaseWCCE.this.cps != null && (cp2 = OiifwInstallPhaseWCCE.this.cps.getCheckPoint(chkPointName2)) == null) {
                    cp2 = OicsCheckPointFactory.constructCheckPoint((int)1, (String)chkPointName2, (String)"This is the Install Phase.");
                    cp2.setCheckPointState(2);
                    cp2.addCheckPointProperty(cpp);
                    cpp = OicsCheckPointFactory.constructStringProperty((String)"ORACLE_HOME_NAME", (String)OiifwInstallPhaseWCCE.this.sOHomeName);
                    cp2.addCheckPointProperty(cpp);
                    cpp = OicsCheckPointFactory.constructStringProperty((String)"GLOBALCONTEXT_XML", (String)OiifwInstallPhaseWCCE.this.sGlobalContextXML);
                    cp2.addCheckPointProperty(cpp);
                    cpp = OicsCheckPointFactory.constructStringProperty((String)"ORACLE_HOME", (String)OiifwInstallPhaseWCCE.this.sOHomeLoc);
                    cp2.addCheckPointProperty(cpp);
                    if (OiifwInstallPhaseWCCE.this.cps != null && cp2 != null) {
                        OiifwInstallPhaseWCCE.this.cps.addCheckPoint(cp2);
                    }
                }
            }
            if (!OiifwInstallPhaseWCCE.this.m_session.isCloneMode()) {
                OiilWinActionsInstall.readWinActions(OiifwInstallPhaseWCCE.this.m_session.getSourceAccess());
            } else {
                OiilWinActionsInstall.setCloneMode(true);
                OiilWinActionsInstall.readWinActions(OiifwInstallPhaseWCCE.this.m_session.getInstallInventory(), OiifwInstallPhaseWCCE.this.m_session.getOHIndex());
            }
            if (OiifwInstallPhaseWCCE.this.m_sGenFile != null && new File(OiifwInstallPhaseWCCE.this.m_sGenFile).exists()) {
                if (Boolean.getBoolean("oracle.installer.debug")) {
                    OiiolTextLogger.appendText("Reading From" + OiifwInstallPhaseWCCE.this.m_sGenFile, 0);
                }
                OiisGenActionsReader genReader = new OiisGenActionsReader(OiifwInstallPhaseWCCE.this.m_sGenFile, true);
                try {
                    genReader.loadFromFile();
                }
                catch (IOException e) {
                    Object[] args = new String[]{OiifwInstallPhaseWCCE.this.m_sGenFile, e.getMessage()};
                    OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_INSTANTIATEFILE_UNABLE_TO_LOAD_XML", args), 0);
                }
                this.m_vInstantiates = genReader.getListInstantiates();
                OiifwInstallPhaseWCCE.this.m_session.setListInstantiates(this.m_vInstantiates);
            }
            int iprevRet = super.doOperation(isBack);
            if (OiixPlatform.getCurrentPlatform() == 421) {
                this.changeDynamicSharedInstallNames();
            }
            if (cp2 != null && OiifwInstallPhaseWCCE.this.cps != null) {
                cp2.setCheckPointState(3);
                OiifwInstallPhaseWCCE.this.cps.addCheckPoint(cp2);
                OiifwInstallPhaseWCCE.this.cps.saveCheckPointSession();
            }
            return iprevRet;
        }

        private void changeDynamicSharedInstallNames() {
            OiisVariable oHomeVar = OiifwInstallPhaseWCCE.this.m_session.getSessionContext().getVariable("ORACLE_HOME");
            String sHome = (String)oHomeVar.getValue();
            String libLoc = System.getProperty("oracle.installer.library_loc");
            String sLibPath = OiixPathOps.getAbsolutePath(libLoc);
            String toLoad = OiixPathOps.concatPath(sLibPath, "install_name.pl");
            String cmd = toLoad + "  " + sHome;
            try {
                OiipuUnixOps.sysFunction(cmd);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        protected void performStateChangeActions(OiisCompInstallation ci, OiiiInstallCompInvEntry icie) throws OiilActionException, OiifbCancelException, IOException, OiisVarSettingException {
            super.performStateChangeActions(ci, icie);
            this.execWinActions(ci);
            OiisCompActions oCompActions = ci.getActions();
            if (oCompActions != null) {
                oCompActions.preStateChangePhase2Actions();
                if (this.m_vInstantiates != null) {
                    OiixInstantiateOps inst = new OiixInstantiateOps();
                    for (int idx = 0; idx < this.m_vInstantiates.size(); ++idx) {
                        OiisInstantiateInfo info = (OiisInstantiateInfo)this.m_vInstantiates.get(idx);
                        if (!icie.getCompInstallID().equals(info.getCompInstallId())) continue;
                        inst.instantiate(info, ci, OiifwInstallPhaseWCCE.this.m_session, OiifwInstallPhaseWCCE.this.m_progressListener);
                    }
                }
                oCompActions.stateChangePhase2Actions();
                oCompActions.postStateChangePhase2Actions();
            }
            ci.disposeUnusedObjects(8);
            int installOHIndex = OiifwInstallPhaseWCCE.this.m_session.getHomeIndex(icie.getCompInstallID());
            try {
                String sContextXMLPath = this.m_installAreaControl.getXMLContextLoc(installOHIndex, icie.getLocationInXMLInventory());
                ci.getContext().writeXMLContext(sContextXMLPath);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                OiiiInventoryHelper.writeXMLConfigLog(installOHIndex, ci, icie);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                String sMessage = OiixResourceBundle.getString("S_ERROR_CONFIG_LOG");
                Object[] vArgs = new String[]{icie.getFullDisplayName(), ioe.getMessage()};
                sMessage = MessageFormat.format(sMessage, vArgs);
                OiiolTextLogger.appendText(sMessage, OiiolTextLogger.LOG_BASIC);
            }
        }

        private void execWinActions(OiisCompInstallation ci) throws OiifbCancelException {
            OiiiCompInstallID cid = ci.getCompInstallID();
            OiisCompContext context = ci.getContext();
            OiilWinActionsInstall installWinActions = new OiilWinActionsInstall();
            installWinActions.runActions(cid, context);
        }

        public String getPhaseString() {
            return OiixResourceBundle.getString("S_TL_PH_2");
        }
    }

    private class OiifwComponentIP1WCCE
    extends OiifwComponentInstallPhaseWCCE {
        private boolean _bStartedProgressUpdate;

        public OiifwComponentIP1WCCE(OiiiInstallAreaControl installAreaControl, Vector icies) {
            super(installAreaControl, icies);
            this.setPhase(1);
            this.setPreReqPhase(10);
            this.setPhaseTobeCompleted(20);
            this.setCurrentProgressPhase(2);
        }

        public int doOperation(boolean isBack) throws OiifbEndIterateException {
            int retVal;
            this.execPreCopyScript();
            if (OiifwInstallPhaseWCCE.this.m_bFastMode) {
                this.startOfPhaseProgressUpdate();
                OiifwInstallPhaseWCCE.this.m_oFastCopyPhase.initialize();
                OiifwInstallPhaseWCCE.this.m_oFastCopyPhase.doFastModeOperations(1);
                this._bStartedProgressUpdate = true;
            }
            if ((retVal = super.doOperation(isBack)) == 0) {
                this.execPostCopyScript();
            }
            return retVal;
        }

        private int runScript(String cmd) throws Exception {
            int exitVal = 0;
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(cmd);
            exitVal = process.waitFor();
            return exitVal;
        }

        private void instantiateScript(String sScriptLoc) throws FileNotFoundException, IOException, OiifbCancelException {
            String sTmpLoc = System.getProperty("oracle.installer.scratchPath");
            String sTmpFile = OiixPathOps.concatPath(sTmpLoc, "tmpScript");
            HashMap<String, String> varMap = new HashMap<String, String>();
            Iterator keys = OiifwInstallPhaseWCCE.this.m_session.getSessionContext().getVariablesMap().values().iterator();
            while (keys.hasNext()) {
                OiisVariable oVar = (OiisVariable)keys.next();
                if (null == oVar || oVar.getValue() == null) continue;
                varMap.put("%" + oVar.getName().toLowerCase() + "%", oVar.getValueAsString());
            }
            OiixFileOps.instantiateFile(sScriptLoc, sTmpFile, varMap, "%");
            OiixFileOps.copyFile(sTmpFile, sScriptLoc, true, true, false, true, "0744", null, null, null, false);
        }

        private void execPostCopyScript() throws OiifbEndIterateException {
            OiiiInstallInventory inv = OiifwInstallPhaseWCCE.this.m_session.getInstallInventory();
            String sOHLoc = inv.getHomeLocation(OiifwInstallPhaseWCCE.this.m_session.getOHIndex());
            OiiolTextLogger.appendText("Going to execute the post copy script");
            if (Boolean.getBoolean("oracle.installer.suppressPostCopyScript")) {
                OiiolTextLogger.appendText("suppresPostCopyScript is true, so skipping the post copy script execution");
                return;
            }
            String sPostCopyScriptLoc = System.getProperty("postCopyScript.install.loc");
            OiiolTextLogger.appendText("Post copy script loc : " + sPostCopyScriptLoc);
            if (null != sPostCopyScriptLoc && !sPostCopyScriptLoc.trim().equals("")) {
                if (OiifwInstallPhaseWCCE.this.m_session.isCloneMode()) {
                    sPostCopyScriptLoc = OiixPathOps.concatPath(OiixPathOps.concatPath(sOHLoc, "inventory"), OiixPathOps.concatPath("Scripts", sPostCopyScriptLoc));
                    OiiolTextLogger.appendText("For clone mode, Post copy script loc : " + sPostCopyScriptLoc);
                }
                if (!new File(sPostCopyScriptLoc).exists()) {
                    OiiolTextLogger.appendText("Post copy script loc : " + sPostCopyScriptLoc + " doesnt exist");
                    return;
                }
                String sScriptName = OiixPathOps.getFileName(sPostCopyScriptLoc);
                String sPath = OiixPathOps.concatPath(OiixPathOps.concatPath(sOHLoc, "inventory"), OiixPathOps.concatPath("Scripts", sScriptName));
                try {
                    boolean retry;
                    if (!OiifwInstallPhaseWCCE.this.m_session.isCloneMode()) {
                        OiixFileOps.copyFile(sPostCopyScriptLoc, sPath, true, true);
                    }
                    if (Boolean.getBoolean("postCopyScript.install.instantiate")) {
                        OiiolTextLogger.appendText("Instantiating Post copy script " + sPostCopyScriptLoc);
                        this.instantiateScript(sPostCopyScriptLoc);
                    }
                    if (Boolean.getBoolean("postCopyScript.install.runAsRoot")) {
                        OiiolTextLogger.appendText(sPostCopyScriptLoc + "  to be executed as root ");
                        OiifwInstallPhaseWCCE oiifwInstallPhaseWCCE = OiifwInstallPhaseWCCE.this;
                        if (oiifwInstallPhaseWCCE.m_session.isSilentMode()) {
                            String msg = OiixResourceBundle.getString("S_POSTCOPY_SILENT_ROOT_MSG");
                            Object[] args = new String[]{sPath};
                            OiiolTextLogger.writeToLogAndConsole(MessageFormat.format(msg, args));
                            OiiolTextLogger.appendText("Exiting");
                            throw new OiifbEndIterateException("Run Installer after the execution of the script");
                        }
                        Object[] args = new String[]{sPostCopyScriptLoc};
                        String msg = MessageFormat.format(OiixResourceBundle.getString("S_POSTCOPY_GUI_ROOT_MSG"), args);
                        int retVal = OiifmAlert.displayAlert(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_WARNING"), msg, 10, 5, 1, 10);
                        if (1 == retVal) {
                            return;
                        }
                        int buttons = 0;
                        buttons |= 4;
                        OiicInstallCancelHandler cancel = OiicSessionInterfaceManager.getInterfaceManager().getInstallCancelHandler(buttons |= 1, "", 0);
                        int retval = cancel.doCancelOperation();
                        switch (retval) {
                            case 4: {
                                return;
                            }
                            case 1: {
                                OiiolTextLogger.appendText("Run installer with -suppressPostCopyScript option tosuppress the script execution");
                                throw new OiifbEndIterateException("Installation cancelled by the user");
                            }
                        }
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ie) {
                        OiiolTextLogger.appendException(ie);
                    }
                    String sShellPath = System.getProperty("postCopyScript.install.shellPath");
                    String cmd = sShellPath != null && sShellPath.trim().length() > 0 ? sShellPath + " " + sPostCopyScriptLoc : sPostCopyScriptLoc;
                    OiiolTextLogger.appendText("executing PostCopyScript");
                    OiiolTextLogger.appendText(cmd);
                    do {
                        int exitVal = 0;
                        try {
                            retry = false;
                            exitVal = this.runScript(cmd);
                        }
                        catch (Exception e) {
                            OiiolTextLogger.appendException(e);
                            int buttonOps = 0;
                            buttonOps = 0;
                            buttonOps |= 2;
                            retry = this.showRetryDialog(buttonOps |= 4, "Error in execution of script " + e.getMessage());
                        }
                        if (0 == exitVal) continue;
                        OiifwInstallPhaseWCCE oiifwInstallPhaseWCCE = OiifwInstallPhaseWCCE.this;
                        if (oiifwInstallPhaseWCCE.m_session.isSilentMode()) {
                            OiiolTextLogger.writeToLogAndConsole("Error in execution of the postCopyScript");
                            OiiolTextLogger.writeToLogAndConsole("Exiting");
                            throw new OiifbEndIterateException("Execution of postcopy script failed");
                        }
                        int buttonOps = 0;
                        buttonOps = 0;
                        buttonOps |= 2;
                        retry = this.showRetryDialog(buttonOps |= 4, "Error in execution of script");
                    } while (retry);
                }
                catch (IOException e) {
                    OiiolTextLogger.appendException(e);
                }
                catch (OiifbCancelException e) {
                    OiiolTextLogger.appendException(e);
                }
            }
        }

        private void execPreCopyScript() throws OiifbEndIterateException {
            if (Boolean.getBoolean("oracle.installer.suppressPreCopyScript")) {
                return;
            }
            String sPreCopyScriptLoc = System.getProperty("preCopyScript.install.loc");
            if (null != sPreCopyScriptLoc && !sPreCopyScriptLoc.trim().equals("")) {
                if (!new File(sPreCopyScriptLoc).exists()) {
                    return;
                }
                String sScriptName = OiixPathOps.getFileName(sPreCopyScriptLoc);
                OiiiInstallInventory inv = OiifwInstallPhaseWCCE.this.m_session.getInstallInventory();
                String sOHLoc = inv.getHomeLocation(OiifwInstallPhaseWCCE.this.m_session.getOHIndex());
                String sPath = OiixPathOps.concatPath(OiixPathOps.concatPath(sOHLoc, "inventory"), OiixPathOps.concatPath("Scripts", sScriptName));
                try {
                    boolean retry;
                    String sShellPath;
                    if (Boolean.getBoolean("preCopyScript.install.instantiate")) {
                        this.instantiateScript(sPreCopyScriptLoc);
                    }
                    OiixFileOps.copyFile(sPreCopyScriptLoc, sPath, true, true);
                    if (Boolean.getBoolean("preCopyScript.install.runAsRoot")) {
                        OiifwInstallPhaseWCCE oiifwInstallPhaseWCCE = OiifwInstallPhaseWCCE.this;
                        if (oiifwInstallPhaseWCCE.m_session.isSilentMode()) {
                            String msg = OiixResourceBundle.getString("S_PRECOPY_SILENT_ROOT_MSG");
                            Object[] args = new String[]{sPath};
                            OiiolTextLogger.writeToLogAndConsole(MessageFormat.format(msg, args));
                            OiiolTextLogger.appendText("Exiting");
                            throw new OiifbEndIterateException("Run Installer after the execution of the script");
                        }
                        Object[] args = new String[]{sPreCopyScriptLoc};
                        String msg = MessageFormat.format(OiixResourceBundle.getString("S_PRECOPY_GUI_ROOT_MSG"), args);
                        int retVal = OiifmAlert.displayAlert(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_WARNING"), msg, 10, 5, 1, 10);
                        if (1 == retVal) {
                            return;
                        }
                        int buttons = 0;
                        buttons |= 4;
                        OiicInstallCancelHandler cancel = OiicSessionInterfaceManager.getInterfaceManager().getInstallCancelHandler(buttons |= 1, "", 0);
                        int retval = cancel.doCancelOperation();
                        switch (retval) {
                            case 4: {
                                return;
                            }
                            case 1: {
                                OiiolTextLogger.appendText("Run installer with -suppressPreCopyScript option tosuppress the script execution");
                                throw new OiifbEndIterateException("Installation cancelled by the user");
                            }
                        }
                    }
                    String cmd = (sShellPath = System.getProperty("preCopyScript.install.shellPath")) != null && sShellPath.trim().length() > 0 ? sShellPath + " " + sPreCopyScriptLoc : sPreCopyScriptLoc;
                    OiiolTextLogger.appendText("executing preCopyScript");
                    OiiolTextLogger.appendText(cmd);
                    do {
                        int exitVal = 0;
                        try {
                            retry = false;
                            exitVal = this.runScript(cmd);
                        }
                        catch (Exception e) {
                            OiiolTextLogger.appendException(e);
                            int buttonOps = 0;
                            buttonOps = 0;
                            buttonOps |= 2;
                            retry = this.showRetryDialog(buttonOps |= 4, "Error in execution of script " + e.getMessage());
                        }
                        if (0 == exitVal) continue;
                        OiifwInstallPhaseWCCE oiifwInstallPhaseWCCE = OiifwInstallPhaseWCCE.this;
                        if (oiifwInstallPhaseWCCE.m_session.isSilentMode()) {
                            OiiolTextLogger.writeToLogAndConsole("Error in execution of the preCopyScript");
                            OiiolTextLogger.writeToLogAndConsole("Exiting");
                            throw new OiifbEndIterateException("Execution of precopy script failed");
                        }
                        int buttonOps = 0;
                        buttonOps = 0;
                        buttonOps |= 2;
                        retry = this.showRetryDialog(buttonOps |= 4, "Error in execution of script");
                    } while (retry);
                }
                catch (IOException e) {
                    OiiolTextLogger.appendException(e);
                }
                catch (OiifbCancelException e) {
                    OiiolTextLogger.appendException(e);
                }
            }
        }

        private boolean showRetryDialog(int buttonOps, String prompt) throws OiifbEndIterateException {
            int userInput = 0;
            boolean retry = false;
            try {
                OiifbIRetry actionDlg = OiicSessionInterfaceManager.getInterfaceManager().getRetryHandler(prompt, buttonOps, 1);
                userInput = actionDlg.doModal();
                actionDlg = null;
                Thread.yield();
            }
            catch (Exception e) {
                OiiolTextLogger.appendException(e);
            }
            switch (userInput) {
                case 2: {
                    retry = true;
                    break;
                }
                case 4: {
                    retry = false;
                    break;
                }
                case 32: {
                    throw new OiifbEndIterateException(prompt);
                }
                case 16: {
                    throw new OiifbEndIterateException(prompt);
                }
            }
            return retry;
        }

        protected void performStateChangeActions(OiisCompInstallation ci, OiiiInstallCompInvEntry icie) throws OiilActionException, OiifbCancelException, IOException, OiisVarSettingException {
            super.performStateChangeActions(ci, icie);
            OiisCompActions oCompActions = ci.getActions();
            if (oCompActions != null) {
                oCompActions.preStateChangeActions();
                oCompActions.stateChangeActions();
                oCompActions.postStateChangeActions();
            }
            ci.disposeUnusedObjects(1, OiifwInstallPhaseWCCE.this.m_actionsPhase.needLinkPhase());
        }

        protected void ensureValidDiskAndPerformFastCopy(OiisCompInstallation ci, OiiiInstallCompInvEntry icie) throws OiifbCancelException, OiifbEndIterateException {
            if (!OiifwInstallPhaseWCCE.this.m_bFastMode || !OiifwInstallPhaseWCCE.this.m_session.isInstallMode()) {
                return;
            }
            OiicInstallSession instSession = (OiicInstallSession)OiifwInstallPhaseWCCE.this.m_session;
            int nCompDisk = ci.getDiskNumber();
            if (instSession.getCurrentDiskNumber() != nCompDisk) {
                OiijFastCopyData ofmd = instSession.getFastCopyData();
                if (ofmd.isFastCopyDone(nCompDisk)) {
                    return;
                }
                OiisCompActions oCompActions = ci.getActions();
                oCompActions.ensureValidDisk(nCompDisk);
                try {
                    OiifwInstallPhaseWCCE.this.m_oFastCopyPhase.setSourceStage(instSession.getSourceAccess().getDiskSourceRoot(nCompDisk));
                }
                catch (IOException ioe) {
                    throw new OiifbEndIterateException(ioe);
                }
                boolean bLastDisk = nCompDisk == ofmd.getMaxDiskNumber();
                int nMode = 134;
                if (bLastDisk) {
                    nMode |= 0x20;
                }
                OiifwInstallPhaseWCCE.this.m_oFastCopyPhase.setMode(nMode);
                OiifwInstallPhaseWCCE.this.m_oFastCopyPhase.doFastModeOperations(nCompDisk);
            }
        }

        public String getPhaseString() {
            return OiixResourceBundle.getString("S_TL_PH_1");
        }
    }

    private abstract class OiifwComponentInstallPhaseWCCE
    implements OiifbWizOperation {
        private int m_phase = -1;
        protected int m_iCurrProgressPhase = 0;
        private int m_preReqPhase = -1;
        private int m_phaseTobeCompleted = -1;
        private OiiiInstallInventory m_installInventory;
        protected OiiiInstallAreaControl m_installAreaControl;
        private Vector m_vInstallInvEntries;
        private static final String DEBUG_SEPERATOR = "_";
        protected static final String START_TMD_MESSAGE = "Start of ";
        protected static final String END_TMD_MESSAGE = "End of ";

        public OiifwComponentInstallPhaseWCCE(OiiiInstallAreaControl installAreaControl, Vector icies) {
            this.m_installAreaControl = installAreaControl;
            this.m_installInventory = this.m_installAreaControl.getInstallInventory();
            this.m_vInstallInvEntries = icies;
        }

        public int getPhase() {
            return this.m_phase;
        }

        public void setPhase(int phase) {
            this.m_phase = phase;
        }

        public void setCurrentProgressPhase(int phase) {
            this.m_iCurrProgressPhase = phase;
        }

        public int getPreReqPhase() {
            return this.m_preReqPhase;
        }

        public void setPreReqPhase(int phase) {
            this.m_preReqPhase = phase;
        }

        public int getPhaseTobeCompleted() {
            return this.m_phaseTobeCompleted;
        }

        public void setPhaseTobeCompleted(int phase) {
            this.m_phaseTobeCompleted = phase;
        }

        protected void startOfPhaseProgressUpdate() {
            OiifwInstallPhaseWCCE.this.m_progressListener.onStartPhase(this.m_iCurrProgressPhase);
            OiifwInstallPhaseWCCE.this.m_progressListener.setStatus(OiifrProgressPhases.getPhaseInProgressString(this.m_iCurrProgressPhase));
        }

        protected void endOfPhaseProgressUpdate() {
            OiifwInstallPhaseWCCE.this.m_progressListener.onDonePhase(this.m_iCurrProgressPhase);
        }

        private void logStartOfPhase(OiiiCompInstallID cid) {
            String phaseStr = this.getPhaseString();
            StringBuffer tempBuff = new StringBuffer();
            tempBuff.append(OiixResourceBundle.getString("S_TL_START_INSTALL") + phaseStr + OiixResourceBundle.getString("S_TL_OF_COMP"));
            tempBuff.append(OiifwInstallPhaseWCCE.this.m_session.getStgCompName(cid));
            OiiolTextLogger.writeLogWithTimeAndTrace(new String(tempBuff), OiiolTextLogger.STR_LOG_BASIC);
        }

        private String getStartOfPhaseDebugMessage() {
            return OiixResourceBundle.getString("S_TL_START_INSTALL") + this.getPhaseString();
        }

        protected void currentCompProgressUpdate(OiiiInstallCompInvEntry icie) {
            OiifwInstallPhaseWCCE.this.m_progressListener.onCurrentComponent(icie.getFullDisplayName());
        }

        public void initialize() throws OiifbEndIterateException {
        }

        public int doOperation(boolean isBack) throws OiifbEndIterateException {
            boolean isDebugTMD = OiixDebug.PRINT_TIME || OiixDebug.PRINT_MEMORY || OiixDebug.PRINT_DISKUSAGE;
            long lTime = 0L;
            Vector vVolumes = null;
            String sDebugTMDMsg = null;
            if (isDebugTMD) {
                vVolumes = OiifwInstallPhaseWCCE.this.m_session.getVolumeInfo();
                sDebugTMDMsg = START_TMD_MESSAGE + this.getPhaseString();
                lTime = System.currentTimeMillis();
                OiixDebug.printDebugTMDMesages(sDebugTMDMsg, lTime, 0L, vVolumes);
            }
            this.startOfPhaseProgressUpdate();
            OiifwInstallPhaseWCCE.this.m_actionsPhase.setCurrentPhase(this.m_phase);
            OiiiCompInstallID cid = null;
            int nInstallCount = this.m_vInstallInvEntries.size();
            for (int i = nInstallCount - 1; i >= 0; --i) {
                long lCurCompTime;
                block17: {
                    lCurCompTime = 0L;
                    if (isDebugTMD) {
                        lCurCompTime = System.currentTimeMillis();
                    }
                    try {
                        OiiiInstallCompInvEntry icie = (OiiiInstallCompInvEntry)this.m_vInstallInvEntries.elementAt(i);
                        cid = icie.getCompInstallID();
                        OiisCompInstallation ci = OiifwInstallPhaseWCCE.this.m_session.getCompInstall(cid);
                        try {
                            this.ensureValidDiskAndPerformFastCopy(ci, icie);
                        }
                        catch (OiifbCancelException oce) {
                            if (System.getProperty("oracle.installer.exitOnStopInstall", "false").equals("true")) {
                                OiicExitCode.setExitCode(-4);
                            }
                            throw new OiifbEndIterateException(oce);
                        }
                        this.currentCompProgressUpdate(icie);
                        this.logStartOfPhase(cid);
                        if (!(OiicPullSession.isLangAddonMode() || OiifwInstallPhaseWCCE.this.m_sessionPlan.getAdditionPhase(cid) >= this.m_preReqPhase && this.allDepsPastPhase(icie, this.m_phaseTobeCompleted))) {
                            OiiolTextLogger.appendText("Skipping component :" + cid);
                            OiiolTextLogger.appendText(" Has completed the interview phase " + (OiifwInstallPhaseWCCE.this.m_sessionPlan.getAdditionPhase(cid) < this.m_preReqPhase));
                            continue;
                        }
                        if (!OiifwInstallPhaseWCCE.this.m_session.isCloneMode()) {
                            this.initInstallXMLLog(cid, icie, this.m_phase);
                        }
                        ci.getActions().setCallBack(OiifwInstallPhaseWCCE.this.m_progressListener);
                        Exception installException = null;
                        try {
                            this.performStateChangeActions(ci, icie);
                        }
                        catch (Exception e) {
                            installException = e;
                        }
                        if (!OiifwInstallPhaseWCCE.this.m_session.isCloneMode()) {
                            OiifwInstallPhaseWCCE.this.m_actionsPhase.getDeinstallLog().close();
                        }
                        ci.releaseFileMap();
                        if (OiifwInstallPhaseWCCE.this.m_actionsPhase.isInstallInterrupted() && !OiifwInstallPhaseWCCE.this.m_actionsPhase.isSessionCancelled()) {
                            OiifwInstallPhaseWCCE.this.m_actionsPhase.setInstallInterrupted(false);
                            OiifwInstallPhaseWCCE.this.m_progressControl.init();
                            OiifwInstallPhaseWCCE.this.m_progressListener.onResume();
                            continue;
                        }
                        if (!this.handleException(installException)) {
                            OiifwInstallPhaseWCCE.this.m_progressListener.onResume();
                        }
                        break block17;
                    }
                    catch (IOException ioe) {
                        if (this.handleException(ioe)) break block17;
                    }
                    continue;
                }
                OiifwInstallPhaseWCCE.this.m_sessionPlan.setAdditionPhase(cid, this.m_phaseTobeCompleted);
                if (!isDebugTMD) continue;
                long lElapsedCompTime = System.currentTimeMillis();
                String sDebugCompString = cid.getName() + DEBUG_SEPERATOR + cid.getVersion().toString();
                OiixDebug.printDebugTMDMesages(sDebugCompString, lElapsedCompTime, lElapsedCompTime - lCurCompTime, vVolumes);
            }
            if (OiifwInstallPhaseWCCE.this.m_session.getPgActionsPhase().canClearLibLoaders()) {
                OiifwInstallPhaseWCCE.this.m_session.clearLibLoaders(1);
                OiifwInstallPhaseWCCE.this.m_session.clearLibLoaders(0);
            }
            if (isDebugTMD) {
                sDebugTMDMsg = END_TMD_MESSAGE + this.getPhaseString();
                long lCurTime = System.currentTimeMillis();
                OiixDebug.printDebugTMDMesages(sDebugTMDMsg, lCurTime, lCurTime - lTime, vVolumes);
            }
            this.endOfPhaseProgressUpdate();
            OiiolTextLogger.appendText(this.getPhaseString() + " JRE files in Scratch :" + OiixFileOps.countFiles(System.getProperties().getProperty("oracle.installer.scratchPath") + "/jre"));
            return 0;
        }

        public void dispose() {
        }

        protected void ensureValidDiskAndPerformFastCopy(OiisCompInstallation ci, OiiiInstallCompInvEntry icie) throws OiifbCancelException, OiifbEndIterateException {
        }

        private boolean allDepsInstalled(OiiiAreaInventory areaInv, OiiiCompInvEntry cie, int ohIndex) {
            Vector dependees = cie.getDependees();
            int numDeps = dependees.size();
            for (int i = 0; i < numDeps; ++i) {
                int depHomeIndex;
                OiiiCompIdOhPair depIdOh = (OiiiCompIdOhPair)dependees.elementAt(i);
                OiiiCompInstallID depID = depIdOh.getCompID();
                if (areaInv.getCompatCompEntry(depID, depHomeIndex = OiifwInstallPhaseWCCE.this.m_session.getHomeIndex(depID)) != null || depIdOh.getDepType() == 0) continue;
                return false;
            }
            return true;
        }

        public boolean allDepsPastPhase(OiiiCompInvEntry cie, int phase) {
            OiiiCompInstallID baseId;
            OiiiCompInstallID id;
            boolean bAllDepsPast = true;
            Vector dependees = cie.getDependees();
            int numDeps = dependees.size();
            OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
            OiiiInstallInventory instInv = iac.getInstallInventory();
            for (int i = 0; i < numDeps; ++i) {
                OiiiCompIdOhPair depIdOh = (OiiiCompIdOhPair)dependees.elementAt(i);
                OiiiCompInstallID depID = depIdOh.getCompID();
                if (OiifwInstallPhaseWCCE.this.m_sessionPlan.getAdditionPhase(depID) >= phase || instInv.getCompatCompEntry(depID, depIdOh.getOHIndex()) != null || depIdOh.getDepType() == 0) continue;
                bAllDepsPast = false;
                OiiolTextLogger.appendText("Dependent component failed to install before this phase :" + depID);
                break;
            }
            if ((id = cie.getCompInstallID()).getCompType() == 2 && OiifwInstallPhaseWCCE.this.m_sessionPlan.getAdditionPhase(baseId = ((OiiiPatchInstallID)id).getCompInstallID()) < phase) {
                if (baseId.isAppltopComponent()) {
                    if (instInv.getCompatCompEntry(baseId, OiifwInstallPhaseWCCE.this.m_session.getAppltopIndex()) == null) {
                        bAllDepsPast = false;
                    }
                } else if (instInv.getCompatCompEntry(baseId, OiifwInstallPhaseWCCE.this.m_session.getOHIndex()) == null) {
                    OiiiInstallPatchInvEntry oEntry = null;
                    OiiiCompInstallID pBaseID = null;
                    try {
                        oEntry = (OiiiInstallPatchInvEntry)cie;
                        boolean bFail = true;
                        if (oEntry != null && (pBaseID = oEntry.getBaseID()) != null) {
                            OiiolTextLogger.appendText("Base component ID for Patch:" + oEntry.getBaseID());
                            if (instInv.getCompatCompEntry(pBaseID, OiifwInstallPhaseWCCE.this.m_session.getOHIndex()) != null) {
                                ((OiiiPatchInstallID)id).setBaseVersion(pBaseID.getVersion());
                                ((OiiiPatchInstallID)id).setCompVersion(pBaseID.getVersion());
                                bFail = false;
                            }
                        }
                        if (bFail) {
                            bAllDepsPast = false;
                            OiiolTextLogger.appendText("Base component failed or not in inventory :" + baseId);
                        }
                    }
                    catch (Exception ex) {
                        bAllDepsPast = false;
                        OiiolTextLogger.appendText("Base component failed or not in inventory :" + baseId);
                    }
                    catch (Throwable t) {
                        bAllDepsPast = false;
                        OiiolTextLogger.appendText("Base component failed or not in inventory :" + baseId);
                    }
                }
            }
            return bAllDepsPast;
        }

        protected void initInstallXMLLog(OiiiCompInstallID cid, OiiiInstallCompInvEntry icie) throws IOException {
            int installOHIndex = OiifwInstallPhaseWCCE.this.m_session.getHomeIndex(cid);
            String xmlLogLoc = this.m_installAreaControl.getXMLLogLoc(installOHIndex, icie.getLocationInXMLInventory());
            OiifwInstallPhaseWCCE.this.m_actionsPhase.setDeinstallLog(new OiiolXMLInstallLog(xmlLogLoc));
        }

        protected void initInstallXMLLog(OiiiCompInstallID cid, OiiiInstallCompInvEntry icie, int phase) throws IOException {
            int installOHIndex = OiifwInstallPhaseWCCE.this.m_session.getHomeIndex(cid);
            String xmlLogLoc = null;
            xmlLogLoc = OiicPullSession.isLangAddonMode() ? this.m_installAreaControl.getLangAddonXMLLogLoc(installOHIndex, icie.getLocationInXMLInventory()) : this.m_installAreaControl.getXMLLogLoc(installOHIndex, icie.getLocationInXMLInventory(), this.getPhase());
            OiifwInstallPhaseWCCE.this.m_actionsPhase.setDeinstallLog(new OiiolXMLInstallLog(xmlLogLoc));
            OiifwInstallPhaseWCCE.this.m_actionsPhase.getDeinstallLog().startWrite();
        }

        protected boolean handleException(Exception installException) throws OiifbEndIterateException {
            boolean bProceed = true;
            if (installException != null) {
                if (OiifwInstallPhaseWCCE.this.m_actionsPhase.isInstallInterrupted()) {
                    if (OiifwInstallPhaseWCCE.this.m_actionsPhase.isSessionCancelled()) {
                        installException = new OiifbCancelException(OiixResourceBundle.getString("S_USER_CANCEL_INS"), true);
                    } else {
                        OiifwInstallPhaseWCCE.this.m_actionsPhase.setInstallInterrupted(false);
                        bProceed = false;
                        return bProceed;
                    }
                }
                if (!(installException instanceof OiifbCancelException) && !(installException instanceof OiifbEndIterateException)) {
                    installException.printStackTrace();
                    String title = OiixResourceBundle.getString("S_ERROR");
                    String sMsg = installException.getMessage();
                    if (sMsg == null || sMsg.length() == 0) {
                        sMsg = installException.toString();
                    }
                    Object[] msgArr = new String[]{sMsg};
                    String message = MessageFormat.format(OiixResourceBundle.getString("S_UNSUCCESS_MSG"), msgArr);
                    int result = OiifmAlert.displayAlert(title, message, 50, 3, 2, 10);
                    switch (result) {
                        case 1: {
                            installException = new OiifbCancelException(installException.getMessage(), true);
                            break;
                        }
                        case 2: {
                            installException = new OiifbCancelException(installException.getMessage(), false);
                        }
                    }
                }
                if (installException instanceof OiifbCancelException) {
                    OiifbCancelException ce = (OiifbCancelException)installException;
                    if (ce.isCancelSession()) {
                        installException = new OiifbEndIterateException(ce);
                    } else {
                        bProceed = false;
                    }
                }
                if (installException instanceof OiifbEndIterateException) {
                    if (System.getProperty("oracle.installer.exitOnStopInstall", "false").equals("true")) {
                        OiicExitCode.setExitCode(-4);
                    }
                    throw (OiifbEndIterateException)installException;
                }
            }
            return bProceed;
        }

        protected abstract String getPhaseString();

        protected void performStateChangeActions(OiisCompInstallation ci, OiiiInstallCompInvEntry icie) throws OiilActionException, OiifbCancelException, IOException, OiisVarSettingException {
            if (OiifwInstallPhaseWCCE.this.m_session.isCloneMode()) {
                Vector vLangs = icie.getLanguages();
                OiisVariable varSelLangs = ci.getContext().getVariable("SELECTED_LANGUAGES");
                varSelLangs.setValue(OiixLanguage.getStringArray(vLangs));
            }
        }
    }
}

