/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifw;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import oracle.ewt.button.PushButton;
import oracle.ewt.lwAWT.LWContainer;
import oracle.sysman.oii.oiif.oiifm.OiifmKeyActionConverter;
import oracle.sysman.oii.oiif.oiifm.OiifmMnemonicOps;
import oracle.sysman.oii.oiif.oiifm.OiifmNavigationBarLayout;
import oracle.sysman.oii.oiif.oiifp.OiifpWizPanel;
import oracle.sysman.oii.oiif.oiifw.OiifwWizDialog;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifwNavigationPanel
extends LWContainer
implements ActionListener {
    private static final int HGAP = 20;
    private static final int VGAP = 10;
    private static final int BUTTON_GAP = 10;
    private OiifwWizDialog m_wizDlg = null;
    private PushButton m_exit = null;
    private PushButton m_help = null;
    private PushButton m_view = null;
    private PushButton m_next = null;
    private PushButton m_back = null;
    private PushButton m_install = null;
    private boolean m_bBackBtnState = false;
    private boolean m_bNextBtnState = false;
    private boolean m_bExitBtnState = false;
    private boolean m_bViewBtnState = false;
    private boolean m_bInstallBtnState = false;
    private boolean m_bHelpBtnState = false;
    private boolean m_bNextBtnFocused = false;
    private boolean m_bBackBtnFocused = false;
    private boolean m_bViewBtnFocused = false;
    public static final int HELP_BTN = 0;
    public static final int VIEW_BTN = 1;
    public static final int BACK_BTN = 2;
    public static final int NEXT_BTN = 4;
    public static final int EXIT_BTN = 8;
    public static final int INSTALL_BTN = 16;

    public OiifwNavigationPanel(OiifwWizDialog dlg) {
        this.m_wizDlg = dlg;
        String str = OiixResourceBundle.getString("S_CANCEL_BUTTON");
        this.m_exit = new PushButton(str);
        this.m_exit.setLeftmost(true);
        this.m_exit.setRightmost(true);
        this.m_exit.addActionListener((ActionListener)this);
        this.m_exit.setFocusable(true);
        str = OiixResourceBundle.getString("S_HELP_NAV_BUTTON");
        this.m_help = new PushButton(str);
        this.m_help.setRightmost(true);
        this.m_help.setLeftmost(true);
        this.m_help.addActionListener((ActionListener)this);
        this.m_help.setFocusable(true);
        str = OiixResourceBundle.getString("S_INVENTORY_BUTTON");
        this.m_view = new PushButton(str);
        this.m_view.setLeftmost(true);
        this.m_view.setRightmost(true);
        this.m_view.addActionListener((ActionListener)this);
        this.m_view.setFocusable(true);
        str = OiixResourceBundle.getString("S_PREVIOUS_BUTTON");
        this.m_back = new PushButton(str);
        this.m_back.setLeftmost(true);
        this.m_back.addActionListener((ActionListener)this);
        this.m_back.setFocusable(true);
        str = OiixResourceBundle.getString("S_NEXT_BUTTON");
        this.m_next = new PushButton(str);
        this.m_next.setRightmost(true);
        this.m_next.addActionListener((ActionListener)this);
        this.m_next.setFocusable(true);
        str = OiixResourceBundle.getString("S_INSTALL_BUTTON");
        this.m_install = new PushButton(str);
        this.m_install.setRightmost(true);
        this.m_install.setLeftmost(true);
        this.m_install.addActionListener((ActionListener)this);
        this.m_install.setFocusable(true);
        this.m_install.setEnabled(false);
        this.layoutButtons();
    }

    public void setKeyActionConverter(OiifmKeyActionConverter kac) {
        if (kac != null) {
            kac.setActionListener(this);
            kac.setCancelButton(this.m_exit);
            kac.setHelpButton(this.m_help);
        }
    }

    private void layoutButtons() {
        this.setLayout(new OiifmNavigationBarLayout(10));
        this.add((Component)this.m_help, "Help");
        this.add((Component)this.m_view, "View");
        this.add((Component)this.m_back, "Back");
        this.add((Component)this.m_next, "Next");
        this.add((Component)this.m_install, "Install");
        this.add((Component)this.m_exit, "Cancel");
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (this.m_help != source) {
            ((OiifpWizPanel)this.m_wizDlg.getWizardPanel()).updateEnabledComponentsStatus(false);
            this.m_wizDlg.disableButtons();
        }
        this.onActionPerformed(event);
    }

    private void onActionPerformed(ActionEvent event) {
        Object source = event.getSource();
        int mod = event.getModifiers();
        if (this.m_next == source || this.m_install == source) {
            this.m_wizDlg.onNext();
        } else if (this.m_back == source) {
            this.m_wizDlg.onBack();
        } else if (this.m_exit == source) {
            this.m_wizDlg.onExit();
        } else if (this.m_view == source) {
            this.m_wizDlg.onView();
        } else if (this.m_help == source) {
            if ((mod & 1) != 0 && (mod & 2) != 0) {
                this.m_wizDlg.onAbout(true);
            } else {
                this.m_wizDlg.onHelp();
            }
        }
    }

    public void setFocusToButton(int p_iButton) {
        switch (p_iButton) {
            case 0: {
                this.m_help.requestFocus();
                break;
            }
            case 1: {
                this.m_view.requestFocus();
                break;
            }
            case 2: {
                this.m_back.requestFocus();
                break;
            }
            case 4: {
                this.m_next.requestFocus();
                break;
            }
            case 8: {
                this.m_exit.requestFocus();
                break;
            }
            case 16: {
                this.m_install.requestFocus();
            }
        }
    }

    public boolean setEnabledButton(int p_iButton, boolean p_bEnabled) {
        boolean bPrevState = false;
        switch (p_iButton) {
            case 0: {
                bPrevState = this.m_help.isEnabled();
                this.m_help.setEnabled(p_bEnabled);
                break;
            }
            case 1: {
                bPrevState = this.m_view.isEnabled();
                this.m_view.setEnabled(p_bEnabled);
                break;
            }
            case 2: {
                bPrevState = this.m_back.isEnabled();
                this.m_back.setEnabled(p_bEnabled);
                break;
            }
            case 4: {
                bPrevState = this.m_next.isEnabled();
                this.m_next.setEnabled(p_bEnabled);
                break;
            }
            case 8: {
                bPrevState = this.m_exit.isEnabled();
                this.m_exit.setEnabled(p_bEnabled);
                break;
            }
            case 16: {
                bPrevState = this.m_install.isEnabled();
                this.m_install.setEnabled(p_bEnabled);
            }
        }
        return bPrevState;
    }

    public void updateExitLabel() {
        this.m_exit.setLabel(OiixResourceBundle.getString("S_EXIT_BUTTON"));
        OiifmMnemonicOps.processMnemonic(this.m_exit);
    }

    public void updateCancelLabel() {
        this.m_exit.setLabel(OiixResourceBundle.getString("S_CANCEL_BUTTON"));
        this.m_exit.setMnemonicChar('\u0000');
        OiifmMnemonicOps.processMnemonic(this.m_exit);
    }

    public void disableButtons() {
        this.m_bNextBtnFocused = this.m_next.hasGlobalFocus();
        this.m_bBackBtnFocused = this.m_back.hasGlobalFocus();
        this.m_bViewBtnFocused = this.m_view.hasGlobalFocus();
        this.m_help.setEnabled(false);
        this.m_view.setEnabled(false);
        this.m_install.setEnabled(false);
        this.m_exit.setEnabled(false);
        this.m_back.setEnabled(false);
        this.m_next.setEnabled(false);
    }

    public void restoreButtons() {
        this.m_help.setEnabled(true);
        this.m_back.setEnabled(this.m_bBackBtnState);
        this.m_next.setEnabled(this.m_bNextBtnState);
        this.m_view.setEnabled(this.m_bViewBtnState);
        this.m_exit.setEnabled(this.m_bExitBtnState);
        this.m_install.setEnabled(this.m_bInstallBtnState);
        if (this.m_bBackBtnFocused && this.m_back.isEnabled()) {
            this.m_back.requestFocus();
        } else if (this.m_next.isEnabled()) {
            this.m_next.requestFocus();
        } else if (this.m_bViewBtnFocused && this.m_view.isEnabled()) {
            this.m_view.requestFocus();
        }
    }

    public void setNavButtonState(int p_iButton, boolean p_bState) {
        switch (p_iButton) {
            case 0: {
                this.m_bHelpBtnState = true;
                break;
            }
            case 1: {
                this.m_bViewBtnState = p_bState;
                break;
            }
            case 2: {
                this.m_bBackBtnState = p_bState;
                break;
            }
            case 4: {
                this.m_bNextBtnState = p_bState;
                break;
            }
            case 8: {
                this.m_bExitBtnState = p_bState;
                break;
            }
            case 16: {
                this.m_bInstallBtnState = p_bState;
            }
        }
    }

    public void setFocusableButtonState(int p_iButton, boolean p_bFocusable) {
        switch (p_iButton) {
            case 0: {
                this.m_help.setFocusable(p_bFocusable);
                break;
            }
            case 1: {
                this.m_view.setFocusable(p_bFocusable);
                break;
            }
            case 2: {
                this.m_back.setFocusable(p_bFocusable);
                break;
            }
            case 4: {
                this.m_next.setFocusable(p_bFocusable);
                break;
            }
            case 8: {
                this.m_exit.setFocusable(p_bFocusable);
                break;
            }
            case 16: {
                this.m_install.setFocusable(p_bFocusable);
            }
        }
    }
}

