/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifw;

import java.util.Enumeration;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifw.OiifwLangsSelWCDE;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiis.OiisAdvisedValue;
import oracle.sysman.oii.oiis.OiisDlgInElem;
import oracle.sysman.oii.oiis.OiisDlgInOutElem;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixOraparam;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixUtilityOps;

public class OiifwOHLocWCDE
extends OiifwLangsSelWCDE {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 1024;
    private int m_nextInd = -1;
    private String m_sTitle = null;
    private boolean m_bShowAppltop = false;
    public static final String s_panelClass = "oracle.sysman.oii.oiif.oiifp.OiifpOHLocPanel";
    private static final String ORACLE_HOME = "OracleHome";
    private static final String ORACLE_HOME_NAME = "OracleHomeName";
    private static final String ORACLE_BASE = "OracleBase";
    private static final String READONLY_OH_LOC = "ReadOnlyOHLoc";

    public OiifwOHLocWCDE(OiisVariableOwner vo, int nextInd) {
        super(vo);
        this.m_dlgInOutElems.addElement(new OiisDlgInOutElem(ORACLE_HOME, "ORACLE_HOME"));
        this.m_dlgInOutElems.addElement(new OiisDlgInOutElem(ORACLE_HOME_NAME, "ORACLE_HOME_NAME"));
        this.setWizPanelClassName(s_panelClass);
        this.m_bShowAppltop = OiixOraparam.isApplTopStage();
        this.setHelpKey("OiifwOHLocWCDE");
        if (this.m_bShowAppltop) {
            this.m_dlgInOutElems.addElement(new OiisDlgInOutElem("AppltopLocation", "APPLTOP"));
            this.m_dlgInOutElems.addElement(new OiisDlgInOutElem("AppltopName", "APPLTOP_NAME"));
            this.setHelpKey("OiifwInstLocWCDE_Appltop");
        }
        this.m_nextInd = nextInd;
    }

    public String getDisplayName() {
        return OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_OH_DETAILS");
    }

    public void setWizPanel() {
    }

    public void initialize() throws OiifbEndIterateException {
        super.initialize();
        String s = System.getProperty("oracle.installer.useORACLE_BASE");
        if (s != null && s.equalsIgnoreCase("true")) {
            this.m_dlgInOutElems.addElement(new OiisDlgInOutElem(ORACLE_BASE, "ORACLE_BASE"));
            this.setHelpKey("OiifwOHLocWCDE_Base");
        } else {
            OiisDlgInOutElem ob_elem = new OiisDlgInOutElem(ORACLE_BASE, "ORACLE_BASE");
            if (this.m_dlgInOutElems.contains(ob_elem)) {
                this.m_dlgInOutElems.removeElement(ob_elem);
            }
        }
        this.initHomeVariables();
    }

    private void initHomeVariables() {
        this.initHomeVariables(0);
        if (this.m_bShowAppltop) {
            this.initHomeVariables(1);
        }
    }

    private void initHomeVariables(int nHomeType) {
        String sLoc;
        OiiiInstallAreaControl oAreaControl;
        OiiiInstallInventory oInventory;
        OiiiOracleHomeInfo ohi;
        String sHomeName = null;
        String sHomeLoc = null;
        if (nHomeType == 1) {
            sHomeName = "APPLTOP_NAME";
            sHomeLoc = "APPLTOP";
        } else if (nHomeType == 0) {
            sHomeName = "ORACLE_HOME_NAME";
            sHomeLoc = "ORACLE_HOME";
        }
        OiisVariable oOhLoc = this.m_varOwner.getVariable(sHomeLoc);
        OiisVariable oOhName = this.m_varOwner.getVariable(sHomeName);
        OiisVariable prodHome = this.m_varOwner.getVariable("PROD_HOME");
        if (prodHome != null) {
            prodHome.setAdvice(false);
        }
        boolean bLocSet = oOhLoc.isValueSet() && oOhLoc.getAdvice();
        boolean bNameSet = oOhName.isValueSet() && oOhName.getAdvice();
        String sOhName = (String)oOhName.getValue();
        String sOhLoc = (String)oOhLoc.getValue();
        if (Boolean.getBoolean("oracle.srvm.formCluster") && (ohi = (oInventory = (oAreaControl = (OiiiInstallAreaControl)OiiiInstallAreaControl.getInventoryAreaControl()).getInstallInventory()).getCRSHomeInfo()) != null) {
            OiiolTextLogger.appendText("setting oracle.installer.homepermissioncheck value to false.");
            System.setProperty("oracle.installer.homepermissioncheck", "FALSE");
            if (!bLocSet && !bNameSet) {
                try {
                    oOhName.setValue(new OiisAdvisedValue(ohi.getName(), false), false);
                    oOhLoc.setValue(new OiisAdvisedValue(ohi.getLocation(), false), false);
                    this.addInElem(new OiisDlgInElem(READONLY_OH_LOC, OiixUtilityOps.booleanValueOf(true)));
                }
                catch (OiifbCancelException e) {
                    OiiolTextLogger.appendException(e);
                }
                catch (OiisVarSettingException e) {
                    OiiolTextLogger.appendException(e);
                }
            }
            return;
        }
        if (bLocSet && !bNameSet) {
            String sName = this.getHomeValue(sOhName, sOhLoc, 2, nHomeType);
            if (sName != null && !sName.equals("")) {
                try {
                    oOhName.setValue(sName, false);
                }
                catch (Exception e) {}
            } else if (System.getProperty("oracle.installer.defaultHomeName", "false").equals("true")) {
                try {
                    oOhName.setValue(this.getDefaultHomeName(), true);
                }
                catch (OiifbCancelException e) {
                }
                catch (OiisVarSettingException e) {}
            }
        } else if (!bLocSet && bNameSet && (sLoc = this.getHomeValue(sOhName, sOhLoc, 1, nHomeType)) != null && !sLoc.equals("")) {
            try {
                oOhLoc.setValue(sLoc, false);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private String getDefaultHomeName() {
        OiiiInstallAreaControl oAreaControl = (OiiiInstallAreaControl)OiiiInstallAreaControl.getInventoryAreaControl();
        OiiiInstallInventory oInventory = oAreaControl.getInstallInventory();
        String name = OiiiOracleHomeInfo.getDefHomeName(oInventory, 0);
        String sName = null;
        int idx = 1;
        while (oInventory.getHomeWithName(sName = name + idx) != null) {
            ++idx;
        }
        return sName;
    }

    private String getHomeValue(String sName, String sLoc, int nCheck, int nHomeType) {
        String sRet = null;
        OiiiInstallAreaControl oAreaControl = (OiiiInstallAreaControl)OiiiInstallAreaControl.getInventoryAreaControl();
        OiiiInstallInventory oInventory = oAreaControl.getInstallInventory();
        if (oInventory != null) {
            Vector vHomes = oInventory.getHomes();
            int nHomeCount = vHomes.size();
            OiipgFileSystem oFileOps = new OiipgFileSystem();
            String sAbsHomeLoc = "";
            if (sLoc != null) {
                sAbsHomeLoc = OiixPathOps.getAbsolutePath(sLoc);
            }
            for (int i = 0; i < nHomeCount; ++i) {
                OiiiOracleHomeInfo oInfo = (OiiiOracleHomeInfo)vHomes.elementAt(i);
                String sHomeLoc = OiixPathOps.getAbsolutePath(oInfo.getLocation());
                String sHomeName = oInfo.getName();
                int nExistingHomeType = oInfo.getHomeType();
                if (nHomeType != nExistingHomeType) continue;
                if (nCheck == 1) {
                    if (!sName.equals(sHomeName)) continue;
                    sRet = sHomeLoc;
                    break;
                }
                if (nCheck != 2 || !oFileOps.areLocsSame(sHomeLoc, sAbsHomeLoc)) continue;
                sRet = sHomeName;
                break;
            }
        }
        return sRet;
    }

    public Vector getAllUnInitializedElems() {
        if (this.m_dlgInOutElems == null) {
            return null;
        }
        Vector<OiisDlgInOutElem> vNotsetProps = new Vector<OiisDlgInOutElem>(this.m_dlgInOutElems.size());
        Enumeration e = this.m_dlgInOutElems.elements();
        while (e.hasMoreElements()) {
            OiisVariable v;
            OiisDlgInOutElem elem = (OiisDlgInOutElem)e.nextElement();
            if (OiicPullSession.isSilentMode() && elem.getVarName().equalsIgnoreCase("ORACLE_BASE") || (v = this.m_varOwner.getVariable(elem.getVarName())).isValueSet() && v.getAdvice()) continue;
            vNotsetProps.addElement(elem);
        }
        return vNotsetProps;
    }

    protected void setDialogProperties() {
        super.setDialogProperties();
        this.m_session.getWizardDialog().setEnabledButton(8, true);
    }

    public int getNext() {
        this.m_session.refreshOHFiles();
        return this.m_nextInd;
    }

    public void dispose() {
        super.dispose();
    }

    public boolean isShowApplTop() {
        return this.m_bShowAppltop;
    }

    public boolean canShowWCDE() {
        boolean bCanShowWCDE = super.canShowWCDE();
        return bCanShowWCDE;
    }
}

