/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifw;

import java.text.MessageFormat;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicExitCode;
import oracle.sysman.oii.oiic.OiicInstallSession;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbCondWizOperation;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiio.oiiod.OiiodDepEngine;
import oracle.sysman.oii.oiio.oiiod.OiiodDepException;
import oracle.sysman.oii.oiis.OiisDepInfo;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiifwPostDepModesWCCE
implements OiifbCondWizOperation {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 1024;
    private OiiodDepEngine m_depEngine;
    private OiisVariableOwner m_vo = null;
    private OiiiCompInstallID[] m_comps = null;
    private String[] m_nModeIds = null;
    private boolean m_compsChanged = false;
    private boolean m_depModesChanged = false;
    private boolean m_validationFailed = false;
    private Vector m_changedDepModes = null;
    private OiicInstallSession m_instSession;
    private int m_moreQnsInd = -1;
    private int m_noMoreQnsInd = -1;

    public OiifwPostDepModesWCCE(OiisVariableOwner vo, int moreQnsInd, int noMoreQnsInd) {
        this.m_vo = vo;
        this.m_comps = null;
        this.m_nModeIds = null;
        this.m_instSession = (OiicInstallSession)this.m_vo.getSession();
        this.m_depEngine = this.m_instSession.getDepEngine();
        this.m_moreQnsInd = moreQnsInd;
        this.m_noMoreQnsInd = noMoreQnsInd;
    }

    public void dispose() {
        this.m_instSession = null;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public void initialize() {
        this.m_compsChanged = false;
        this.m_depModesChanged = false;
        OiiiCompInstallID[] comps = this.m_instSession.getSelTopLevelCompIDs();
        String[] modeIDs = (String[])this.m_vo.getVariable("TLDepModes").getValue();
        OiisVariable selVar = this.m_vo.getVariable("DEP_MODE");
        if (modeIDs == null) {
            modeIDs = new String[]{(String)selVar.getValue()};
        } else {
            try {
                selVar.setValue(modeIDs[0], false);
                selVar.setAdvice(false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.m_compsChanged = !OiixVectorOps.arraysEqual(this.m_comps, comps)) {
            this.m_depModesChanged = true;
        } else {
            this.m_changedDepModes = OiiodDepEngine.getChangedDepModes(this.m_comps, this.m_nModeIds, comps, modeIDs);
            this.m_depModesChanged = !this.m_changedDepModes.isEmpty();
        }
        this.m_comps = comps;
        this.m_nModeIds = modeIDs;
    }

    private int handleOiiodDepException(OiiodDepException exp) throws OiifbEndIterateException {
        this.m_validationFailed = true;
        this.showAlert(OiixResourceBundle.getString("S_DEP_TITLE"), exp.getMessage(), false);
        if (System.getProperty("oracle.installer.exitOnPrereqFailure", "false").equals("true")) {
            OiicExitCode.setExitCode(-3);
            throw new OiifbEndIterateException("");
        }
        OiifwPostDepModesWCCE oiifwPostDepModesWCCE = this;
        if (oiifwPostDepModesWCCE.m_instSession.isSilentMode() || this.m_instSession.isSuppressedSource() || !this.m_instSession.getWizardDialog().isAnyPanelVisible()) {
            throw new OiifbEndIterateException("");
        }
        return 1;
    }

    public final int doOperation(boolean isBack) throws OiifbEndIterateException {
        if (!isBack) {
            if (this.m_instSession.isInvChanged()) {
                try {
                    this.m_depEngine.depBuild();
                }
                catch (OiiodDepException exp) {
                    return this.handleOiiodDepException(exp);
                }
                this.m_depModesChanged = true;
                this.m_instSession.setInvChanged(false);
            }
            if (this.m_depModesChanged || this.m_validationFailed) {
                int numComps = this.m_comps.length;
                for (int i = 0; i < numComps; ++i) {
                    if (!this.m_compsChanged && !this.m_changedDepModes.contains(new Integer(i))) continue;
                    String modeID = this.m_nModeIds[i];
                    OiiiCompInstallID cid = this.m_comps[i];
                    if (cid.getCompType() == 4 || cid.getCompType() == 2) continue;
                    OiisDepInfo tlDInfo = this.m_instSession.getCompInstall(cid).getDepInfo();
                    tlDInfo.setDepModeName(modeID);
                }
            }
            try {
                this.m_depEngine.depModeApply(true);
            }
            catch (OiiodDepException exp) {
                return this.handleOiiodDepException(exp);
            }
            catch (OiifbCancelException exp) {
                throw new OiifbEndIterateException(exp.getMessage());
            }
            int v_retValue = this.validateModes();
            if (v_retValue == -1) {
                OiifwPostDepModesWCCE oiifwPostDepModesWCCE = this;
                if (oiifwPostDepModesWCCE.m_instSession.isSilentMode() || this.m_instSession.isSuppressedSource() || !this.m_instSession.getMainFrame().isVisible()) {
                    throw new OiifbEndIterateException("");
                }
                return 1;
            }
            this.m_validationFailed = false;
        }
        return isBack ? 1 : 0;
    }

    public int validateModes() {
        Vector vIncorrectList = new Vector();
        this.m_depEngine.checkTreeCorrectness(vIncorrectList);
        if (vIncorrectList.size() > 0) {
            OiisVariable oVar = this.m_vo.getVariable("DEP_MODE");
            oVar.setAdvice(false);
            String msg = OiixResourceBundle.getString("S_DEP_CONFLICT_ERROR");
            Object[] arr = new String[]{vIncorrectList.toString()};
            msg = MessageFormat.format(msg, arr);
            this.showAlert(OiixResourceBundle.getString("S_DEP_CONFLICT"), msg, false);
            return -1;
        }
        return 0;
    }

    public int getNext() {
        if (this.m_depEngine.moreQuestions()) {
            return this.m_moreQnsInd;
        }
        return this.m_noMoreQnsInd;
    }

    public int showAlert(String sTitle, String sMessage, boolean bCancel) {
        if (bCancel) {
            return OiifmAlert.displayAlert(sTitle, sMessage, 50, 3, 1);
        }
        return OiifmAlert.displayError(sMessage, sTitle);
    }
}

