/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifw;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import oracle.sysman.oii.oiic.OiicInstallSession;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifw.OiifwBaseHomeSetupWCCE;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiDocDetails;
import oracle.sysman.oii.oiii.OiiiReleaseNotesInfo;
import oracle.sysman.oii.oiii.OiiiShipHomeInfo;
import oracle.sysman.oii.oiii.OiiiStageInventory;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterLogger;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixDebug;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixProgressListener;
import oracle.sysman.oii.oiix.OiixResourceBundle;

class OiifwReadmeWCCE
extends OiifwBaseHomeSetupWCCE {
    private OiiiShipHomeInfo oShipHomeInfo = null;
    private OiicInstallSession m_oSession = null;
    private OiixProgressListener m_progressListener = null;
    private OiicSessionInterfaceManager m_interfaceManager = null;
    private OiisVariable m_oTopLevelCompName = null;
    private OiisVariable m_oInstallType = null;
    private String m_sTopLevelName = null;
    private String m_sInstallType = null;
    private String m_sStageParentDir = null;

    OiifwReadmeWCCE(OiisVariableOwner oVarOwner, OiiiStageInventory oStageInv) {
        super(oVarOwner);
        if (oStageInv == null) {
            return;
        }
        this.oShipHomeInfo = oStageInv.getSHPropObj();
        this.m_interfaceManager = OiicSessionInterfaceManager.getInterfaceManager();
        this.m_oSession = (OiicInstallSession)this.m_interfaceManager.getSession();
        if (this.m_oSession == null) {
            return;
        }
        this.m_progressListener = this.m_interfaceManager.getProgressListener();
    }

    public int doOperation(boolean isBack) throws OiifbEndIterateException {
        if (this.oShipHomeInfo != null) {
            this.m_oTopLevelCompName = this.m_oVarOwner.getVariable("ToplevelComp");
            this.m_oInstallType = this.m_oVarOwner.getVariable("DEP_MODE");
            this.m_sTopLevelName = ((OiiiCompInstallID)this.m_oTopLevelCompName.getValue()).getName();
            this.m_sInstallType = (String)this.m_oInstallType.getValue();
            String sStageLoc = (String)this.m_oVarOwner.getVariable("FROM_LOCATION").getValue();
            try {
                String sStageCanPath = OiixPathOps.getCanonicalPath(sStageLoc);
                this.m_sStageParentDir = OiixPathOps.getParentDir(sStageCanPath);
                this.copyReleaseNotesFolder();
                this.copyDocFolder();
                this.copyAccessibilityFolder();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    private void copyReleaseNotesFolder() {
        List vReadmeDetails = this.oShipHomeInfo.getReadmeInfoOfTLcomps();
        if (vReadmeDetails == null || vReadmeDetails.size() == 0) {
            return;
        }
        String sReadmeToBeShown = "";
        boolean bShowReadme = false;
        OiiiReleaseNotesInfo oReleaseNotesInfo = null;
        for (int i = 0; i < vReadmeDetails.size(); ++i) {
            oReleaseNotesInfo = (OiiiReleaseNotesInfo)vReadmeDetails.get(i);
            if (!this.m_sTopLevelName.equals(oReleaseNotesInfo.getTLReadmeCmpName())) continue;
            if (oReleaseNotesInfo.getReadmeLoc() == null || oReleaseNotesInfo.getReadmeLoc().trim().length() == 0) {
                return;
            }
            Map hReadmeFiles = oReleaseNotesInfo.getReadmeDetails();
            sReadmeToBeShown = hReadmeFiles.containsKey(this.m_sInstallType) ? (String)hReadmeFiles.get(this.m_sInstallType) : oReleaseNotesInfo.getDefaultReadme();
            if (sReadmeToBeShown == null || sReadmeToBeShown.trim().length() <= 0) continue;
            oReleaseNotesInfo.setShowReadme(true);
            break;
        }
        if (oReleaseNotesInfo != null && oReleaseNotesInfo.isReadmeTobeShown()) {
            File fReleaseNotesDir = null;
            try {
                String sReleaseNotesLoc = OiixPathOps.getCanonicalPath(this.m_sStageParentDir + File.separator + oReleaseNotesInfo.getReadmeLoc());
                fReleaseNotesDir = new File(sReleaseNotesLoc);
                if (fReleaseNotesDir.exists() && fReleaseNotesDir.isDirectory()) {
                    String sDebugTMDMsg;
                    Object[] args = new Object[]{this.oShipHomeInfo.getName()};
                    String sMsg = OiixResourceBundle.getString("S_COPY_README", args);
                    this.m_progressListener.setStatus(sMsg);
                    String sToLoc = OiixPathOps.getCanonicalPath(this.oShipHomeInfo.getLocation() + File.separator + oReleaseNotesInfo.getReadmeLoc());
                    boolean isDebugTMD = OiixDebug.PRINT_TIME || OiixDebug.PRINT_MEMORY || OiixDebug.PRINT_DISKUSAGE;
                    long lCurTime = 0L;
                    if (isDebugTMD) {
                        lCurTime = System.currentTimeMillis();
                        sDebugTMDMsg = "README Folder,Copy started at: ";
                        OiixDebug.printDebugTMDMesages(sDebugTMDMsg, lCurTime, 0L, null);
                    }
                    OiixFileOps.copyDir(fReleaseNotesDir, new File(sToLoc));
                    OiipgClusterLogger.logDirCommands(oReleaseNotesInfo.getReadmeLoc());
                    if (isDebugTMD) {
                        long lTime = System.currentTimeMillis();
                        sDebugTMDMsg = "README Folder,Copy Ended at : ";
                        OiixDebug.printDebugTMDMesages(sDebugTMDMsg, lTime, lTime - lCurTime, null);
                    }
                    oReleaseNotesInfo.setReadmeFileTobeShown(sToLoc + File.separator + sReadmeToBeShown);
                    this.m_oSession.setReadmeInfo(oReleaseNotesInfo);
                } else {
                    Object[] mArgs = new Object[]{fReleaseNotesDir};
                    String sMesg = OiixResourceBundle.getString("S_README_COPY_ERROR", mArgs);
                    OiiolTextLogger.appendText(OiixResourceBundle.getString(sMesg));
                    oReleaseNotesInfo.setShowReadme(false);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void copyDocFolder() {
        List vDocDetails = this.oShipHomeInfo.getDocInfoOfTLComps();
        if (vDocDetails == null || vDocDetails.size() == 0) {
            return;
        }
        String sDocFolderName = null;
        OiiiDocDetails oDocInfo = null;
        for (int i = 0; i < vDocDetails.size(); ++i) {
            oDocInfo = (OiiiDocDetails)vDocDetails.get(i);
            if (!this.m_sTopLevelName.equals(oDocInfo.getTLDocCompName())) continue;
            if (oDocInfo.getDocLoc() == null || oDocInfo.getDocLoc().trim().length() == 0) {
                return;
            }
            Map hDocFolder = oDocInfo.getDocDetails();
            sDocFolderName = hDocFolder.containsKey(this.m_sInstallType) ? (String)hDocFolder.get(this.m_sInstallType) : oDocInfo.getDefaultDoc();
            if (sDocFolderName != null) break;
        }
        if (sDocFolderName != null && oDocInfo != null) {
            File fDocDir = null;
            try {
                String sDocLoc = OiixPathOps.getCanonicalPath(this.m_sStageParentDir + File.separator + oDocInfo.getDocLoc() + File.separator + sDocFolderName);
                fDocDir = new File(sDocLoc);
                if (fDocDir.exists() && fDocDir.isDirectory()) {
                    String sDebugTMDMsg;
                    Object[] args = new Object[]{this.oShipHomeInfo.getName()};
                    String sMsg = OiixResourceBundle.getString("S_COPY_DOC", args);
                    this.m_progressListener.setStatus(sMsg);
                    String sToLoc = OiixPathOps.getCanonicalPath(this.oShipHomeInfo.getLocation() + File.separator + oDocInfo.getDocLoc() + File.separator + sDocFolderName);
                    boolean isDebugTMD = OiixDebug.PRINT_TIME || OiixDebug.PRINT_MEMORY || OiixDebug.PRINT_DISKUSAGE;
                    long lCurTime = 0L;
                    if (isDebugTMD) {
                        lCurTime = System.currentTimeMillis();
                        sDebugTMDMsg = "DOC Folder , Copy started at: ";
                        OiixDebug.printDebugTMDMesages(sDebugTMDMsg, lCurTime, 0L, null);
                    }
                    OiixFileOps.copyDir(fDocDir, new File(sToLoc));
                    OiipgClusterLogger.logDirCommands(oDocInfo.getDocLoc() + File.separator + sDocFolderName);
                    if (isDebugTMD) {
                        long lTime = System.currentTimeMillis();
                        sDebugTMDMsg = "DOC Folder , Copy Ended at : ";
                        OiixDebug.printDebugTMDMesages(sDebugTMDMsg, lTime, lTime - lCurTime, null);
                    }
                } else {
                    Object[] mArgs = new Object[]{fDocDir};
                    String sMesg = OiixResourceBundle.getString("S_DOC_COPY_ERROR", mArgs);
                    OiiolTextLogger.appendText(OiixResourceBundle.getString(sMesg));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void copyAccessibilityFolder() {
        String sAccessFileName = this.oShipHomeInfo.getAccessFileName();
        String sAccessFileLoc = this.oShipHomeInfo.getAccessLoc();
        if (sAccessFileName == null || sAccessFileLoc == null) {
            return;
        }
        File fAccessDir = null;
        if (sAccessFileName != null && sAccessFileLoc != null) {
            try {
                String sFromLoc = OiixPathOps.getCanonicalPath(this.m_sStageParentDir + File.separator + sAccessFileLoc);
                fAccessDir = new File(sFromLoc);
                if (fAccessDir.exists() && fAccessDir.isDirectory()) {
                    String sDebugTMDMsg;
                    Object[] args = new Object[]{this.oShipHomeInfo.getName()};
                    String sMsg = OiixResourceBundle.getString("S_COPY_QIG", args);
                    this.m_progressListener.setStatus(sMsg);
                    String sToLoc = OiixPathOps.getCanonicalPath(this.oShipHomeInfo.getLocation() + File.separator + sAccessFileLoc);
                    boolean isDebugTMD = OiixDebug.PRINT_TIME || OiixDebug.PRINT_MEMORY || OiixDebug.PRINT_DISKUSAGE;
                    long lCurTime = 0L;
                    if (isDebugTMD) {
                        lCurTime = System.currentTimeMillis();
                        sDebugTMDMsg = "Access Folder,Copy started at:";
                        OiixDebug.printDebugTMDMesages(sDebugTMDMsg, lCurTime, 0L, null);
                    }
                    OiixFileOps.copyDir(fAccessDir, new File(sToLoc));
                    OiipgClusterLogger.logDirCommands(sAccessFileLoc);
                    if (isDebugTMD) {
                        long lTime = System.currentTimeMillis();
                        sDebugTMDMsg = "Access Folder,Copy Ended at : ";
                        OiixDebug.printDebugTMDMesages(sDebugTMDMsg, lTime, lTime - lCurTime, null);
                    }
                } else {
                    Object[] mArgs = new Object[]{fAccessDir};
                    String sMesg = OiixResourceBundle.getString("S_ACCESS_COPY_ERROR", mArgs);
                    OiiolTextLogger.appendText(OiixResourceBundle.getString(sMesg));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void dispose() {
    }
}

