/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifw;

import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicPSetStagingPlanInfo;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiic.OiicSessionPlan;
import oracle.sysman.oii.oiic.OiicStagePlan;
import oracle.sysman.oii.oiic.OiicStageSession;
import oracle.sysman.oii.oiic.OiicStagingPlanInfo;
import oracle.sysman.oii.oiic.OiicStagingProgressListener;
import oracle.sysman.oii.oiif.oiifb.OiifbWizChainCondElem;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiPatchInstallID;
import oracle.sysman.oii.oiii.OiiiStageCompInvEntry;
import oracle.sysman.oii.oiii.OiiiStageInventory;
import oracle.sysman.oii.oiii.OiiiStagePatchInvEntry;
import oracle.sysman.oii.oiio.oiiod.OiiodDepEngineHelper;
import oracle.sysman.oii.oiis.OiisCompJarLoader;
import oracle.sysman.oii.oiis.OiisCompLoadingException;
import oracle.sysman.oii.oiis.OiisCompStaging;
import oracle.sysman.oii.oiis.OiisDeps;
import oracle.sysman.oii.oiis.OiisPatchDeps;
import oracle.sysman.oii.oiis.OiisPatchSetContents;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixDebug;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiifwStgDepSetPlanWCCE
extends OiifbWizChainCondElem {
    private static final boolean s_debug = true;
    private static final int s_debugCategory = 1024;
    private OiicStageSession m_stgSession;
    OiisVariableOwner m_vo;
    private OiicStagingProgressListener m_stgProgListener;

    public OiifwStgDepSetPlanWCCE(OiisVariableOwner vo) {
        super(vo);
        this.m_vo = vo;
        this.m_stgSession = (OiicStageSession)vo.getSession();
    }

    public void setStagingProgressListener(OiicStagingProgressListener lstnr) {
        this.m_stgProgListener = lstnr;
    }

    private Vector getStagingPlats() {
        OiicSessionContext sCntxt = this.m_stgSession.getSessionContext();
        OiisVariable selPlats = sCntxt.getVariable("SELECTED_PLATFORMS");
        String[] selPlatCNs = (String[])selPlats.getValue();
        Vector retVect = OiixPlatform.platCommonNamesToIDVect(selPlatCNs);
        if (retVect == null) {
            retVect = OiixVectorOps.arrayToVect(OiixPlatform.getPlatforms());
        }
        return retVect;
    }

    public void initialize() {
        try {
            OiiiCompInstallID cid;
            OiicStagingPlanInfo stgPlanInfo;
            Vector[] addRems = this.calcAddRemoves(this.getStagingPlats());
            OiicStagePlan sessionPlan = (OiicStagePlan)this.m_stgSession.getSessionPlan();
            sessionPlan.clearPlan();
            Enumeration remen = addRems[1].elements();
            while (remen.hasMoreElements()) {
                stgPlanInfo = (OiicStagingPlanInfo)remen.nextElement();
                cid = stgPlanInfo.getInvEntry().getCompInstallID();
                OiixDebug.debug("OiifwStgDepSetPlanWCCE", "** In Set Plan : Need to remove " + stgPlanInfo.toString());
                sessionPlan.addRemoval(cid, (Object)stgPlanInfo);
            }
            Enumeration adden = addRems[0].elements();
            while (adden.hasMoreElements()) {
                stgPlanInfo = (OiicStagingPlanInfo)adden.nextElement();
                cid = stgPlanInfo.getInvEntry().getCompInstallID();
                OiixDebug.debug("OiifwStgDepSetPlanWCCE", "** In Set Plan : Need to add (" + cid.getCompType() + ")" + stgPlanInfo.toString());
                sessionPlan.addAddition(cid, stgPlanInfo);
            }
            sessionPlan.setSelectedComps(this.m_stgSession.getSelTopLevelCompIDs());
        }
        catch (OiisCompLoadingException cle) {
            cle.printStackTrace();
        }
    }

    private Vector[] calcAddRemoves(Vector plats) throws OiisCompLoadingException {
        Vector[] retVect = new Vector[2];
        OiiiCompInstallID[] topLevIDs = this.m_stgSession.getSelTopLevelCompIDs();
        Hashtable idsToDeps = new Hashtable();
        Hashtable idsToRecDeps = new Hashtable();
        Vector allCIds = this.computeAllDependedIDs(topLevIDs, idsToDeps, idsToRecDeps, plats);
        Vector cidGps = OiiodDepEngineHelper.groupCIdsVect(allCIds);
        cidGps = OiiodDepEngineHelper.sortCIDGpsList(cidGps, idsToRecDeps);
        OiiiStageInventory srcStgInv = this.m_stgSession.getSourceAccess().getStageInventory();
        OiiiStageInventory trgtStgInv = this.m_stgSession.getStageAreaControl().getStageInventory();
        Vector addInfos = new Vector();
        Vector remInfos = new Vector();
        int numIDGps = cidGps.size();
        for (int i = 0; i < numIDGps; ++i) {
            Vector idGp = (Vector)cidGps.elementAt(i);
            this.computePlanInfosForIDGp(idGp, srcStgInv, trgtStgInv, addInfos, remInfos, plats, idsToDeps);
        }
        this.setPreserveFlags(remInfos, addInfos);
        retVect[0] = addInfos;
        retVect[1] = remInfos;
        return retVect;
    }

    private Vector computeAllDependedIDs(OiiiCompInstallID[] topLevIDs, Hashtable idsToDeps, Hashtable idsToRecDeps, Vector plats) throws OiisCompLoadingException {
        Vector<OiiiCompInstallID> allCIds = new Vector<OiiiCompInstallID>();
        for (int i = 0; i < topLevIDs.length; ++i) {
            if (allCIds.contains(topLevIDs[i])) continue;
            allCIds.addElement(topLevIDs[i]);
            OiixVectorOps.unionInPlace(allCIds, this.getRecursiveDependees(topLevIDs[i], idsToDeps, idsToRecDeps, plats));
        }
        return allCIds;
    }

    private Vector getRecursiveDependees(OiiiCompInstallID cid, Hashtable idsToDeps, Hashtable idsToRecDeps, Vector plats) throws OiisCompLoadingException {
        Vector recDepsHere = new Vector();
        Vector depsHere = new Vector();
        String idHashStr = OiiodDepEngineHelper.computeIDGpHashStr(cid);
        if (idsToRecDeps.get(idHashStr) == null) {
            int srchPlat;
            OiiiStageInventory si = this.m_stgSession.getSourceAccess().getStageInventory();
            OiiiStageCompInvEntry remscie = (OiiiStageCompInvEntry)si.getCompatCompEntry(cid, 0, srchPlat = ((Integer)this.getStagingPlats().firstElement()).intValue());
            if (remscie == null) {
                System.err.println("Skipping over " + cid + " in getRecursiveDependees");
                return recDepsHere;
            }
            cid = remscie.getCompInstallID();
            if (this.m_stgProgListener != null) {
                Object[] args = new String[]{remscie.getFullDisplayName()};
                String msg = OiixResourceBundle.getString("S_COMPUTE_DEPS");
                msg = MessageFormat.format(msg, args);
                this.m_stgProgListener.setStatus(msg);
            }
            if (cid.getCompType() == 4) {
                OiisCompStaging compStage = this.m_stgSession.getCompStage(remscie);
                OiisCompJarLoader cjLoader = compStage.getCompJarLoader();
                try {
                    OiisPatchSetContents psConts = cjLoader.loadPSetContents();
                    depsHere = psConts.getContainedPatches();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new OiisCompLoadingException(e.toString());
                }
                idsToDeps.put(idHashStr, (Vector)depsHere.clone());
                this.addRecDeps(depsHere, recDepsHere, idsToDeps, idsToRecDeps, plats);
            } else {
                Vector compStages = this.m_stgSession.getCompStages(cid);
                int numMatches = compStages.size();
                for (int i = 0; i < numMatches; ++i) {
                    OiisCompStaging compStage = (OiisCompStaging)compStages.elementAt(i);
                    OiiiStageCompInvEntry invEntry = compStage.getStageCompInvEntry();
                    Vector entryPlats = invEntry.getPlatforms();
                    if (OiixVectorOps.intersect(entryPlats, plats).size() == 0) continue;
                    if (cid.getCompType() == 2) {
                        OiisPatchDeps patchDeps = ((OiiiStagePatchInvEntry)invEntry).getPatchDeps();
                        depsHere = patchDeps.getDependeeIDs();
                    } else {
                        OiisDeps deps = compStage.getDepInfo().getDeps();
                        depsHere = deps.getAllDependees();
                    }
                    this.addRecDeps(depsHere, recDepsHere, idsToDeps, idsToRecDeps, plats);
                }
            }
            idsToRecDeps.put(idHashStr, recDepsHere);
        } else {
            recDepsHere = (Vector)idsToRecDeps.get(cid);
        }
        OiixDebug.debug("OiicStgDepWizEngine", "Returning from getRecursiveDependees for cid : " + cid + ", recdeps : " + recDepsHere);
        return recDepsHere;
    }

    private void addRecDeps(Vector depsHere, Vector recDepsHere, Hashtable idsToDeps, Hashtable idsToRecDeps, Vector plats) throws OiisCompLoadingException {
        for (int j = 0; j < depsHere.size(); ++j) {
            OiiiCompInstallID origDepID = (OiiiCompInstallID)depsHere.elementAt(j);
            OiiiCompInstallID depID = this.getIDFromInvEntry(origDepID);
            if (depID == null) {
                System.err.println("Could not find any dependee entry for " + origDepID);
                continue;
            }
            if (depID.getCompType() == 2) {
                depsHere.addElement(((OiiiPatchInstallID)depID).getCompInstallID());
            }
            if (recDepsHere.contains(depID)) continue;
            recDepsHere.addElement(depID);
            String depIdHashStr = OiiodDepEngineHelper.computeIDGpHashStr(depID);
            Vector depRecDeps = (Vector)idsToRecDeps.get(depIdHashStr);
            if (depRecDeps == null) {
                depRecDeps = this.getRecursiveDependees(depID, idsToDeps, idsToRecDeps, plats);
            }
            OiixVectorOps.unionInPlace(recDepsHere, depRecDeps);
        }
    }

    private OiiiCompInstallID getIDFromInvEntry(OiiiCompInstallID cid) {
        int srchPlat;
        OiiiStageInventory si = this.m_stgSession.getSourceAccess().getStageInventory();
        OiiiStageCompInvEntry remscie = (OiiiStageCompInvEntry)si.getCompatCompEntry(cid, 0, srchPlat = ((Integer)this.getStagingPlats().firstElement()).intValue());
        if (remscie == null) {
            return null;
        }
        return remscie.getCompInstallID();
    }

    private void computePlanInfosForIDGp(Vector idGp, OiiiStageInventory srcStgInv, OiiiStageInventory trgtStgInv, Vector addInfos, Vector remInfos, Vector plats, Hashtable idsToDeps) {
        Vector gpPlats = new Vector();
        Vector srcSIs = new Vector();
        Vector trgtSIs = new Vector();
        Hashtable platsToSrcSInvEnts = new Hashtable();
        Hashtable platsToTrgtSInvEnts = new Hashtable();
        int numIDs = idGp.size();
        if (numIDs <= 0) {
            return;
        }
        OiiiCompInstallID cid = (OiiiCompInstallID)idGp.elementAt(0);
        if (cid.getCompType() == 4) {
            if (numIDs != 1) {
                System.out.println("!!!!! More than one patch set in a group !!!!");
            }
            String idHashStr = OiiodDepEngineHelper.computeIDGpHashStr(cid);
            Vector depsHere = (Vector)idsToDeps.get(idHashStr);
            OiiiStageInventory si = this.m_stgSession.getSourceAccess().getStageInventory();
            OiiiStageCompInvEntry remscie = si.getStageCompInvEntry(cid);
            OiicSessionPlan sessionPlan = this.m_stgSession.getSessionPlan();
            addInfos.addElement(new OiicPSetStagingPlanInfo(remscie, depsHere));
        } else {
            for (int j = 0; j < numIDs; ++j) {
                Vector trgtMatchInvEntries;
                cid = (OiiiCompInstallID)idGp.elementAt(j);
                Vector srcMatchInvEntries = srcStgInv.getCompatCompEntries(cid, 0);
                if (srcMatchInvEntries.isEmpty()) {
                    srcMatchInvEntries = srcStgInv.getCompatCompEntries2(cid, 0);
                }
                if ((trgtMatchInvEntries = trgtStgInv.getCompatCompEntries(cid, 0)).isEmpty()) {
                    trgtMatchInvEntries = trgtStgInv.getCompatCompEntries2(cid, 0);
                }
                OiixVectorOps.unionInPlace(srcSIs, srcMatchInvEntries);
                OiixVectorOps.unionInPlace(trgtSIs, trgtMatchInvEntries);
            }
            this.buildEntryAccessHashtables(srcSIs, trgtSIs, plats, gpPlats, platsToSrcSInvEnts, platsToTrgtSInvEnts);
            System.out.println("For IDs " + idGp.firstElement() + ", missing platforms : " + OiixVectorOps.subtract(plats, gpPlats));
            this.updatePlanInfosForIntPlats(gpPlats, platsToSrcSInvEnts, platsToTrgtSInvEnts, addInfos, remInfos);
        }
    }

    private void buildEntryAccessHashtables(Vector srcSIs, Vector trgtSIs, Vector plats, Vector gpPlats, Hashtable platsToSrcSInvEnts, Hashtable platsToTrgtSInvEnts) {
        int numAllMatches = srcSIs.size();
        for (int i = 0; i < numAllMatches; ++i) {
            OiiiStageCompInvEntry matchIE = (OiiiStageCompInvEntry)srcSIs.elementAt(i);
            Vector iePlats = matchIE.getPlatforms();
            Vector intPlats = OiixVectorOps.intersect(iePlats, plats);
            if (intPlats.isEmpty()) continue;
            OiixVectorOps.unionInPlace(gpPlats, intPlats);
            int numIntPlats = intPlats.size();
            for (int j = 0; j < numIntPlats; ++j) {
                platsToSrcSInvEnts.put(intPlats.elementAt(j), matchIE);
            }
        }
        int numTrgtMatches = trgtSIs.size();
        for (int i = 0; i < numTrgtMatches; ++i) {
            OiiiStageCompInvEntry matchIE = (OiiiStageCompInvEntry)trgtSIs.elementAt(i);
            Vector iePlats = matchIE.getPlatforms();
            Vector intPlats = OiixVectorOps.intersect(iePlats, gpPlats);
            if (intPlats.isEmpty()) continue;
            int numIntPlats = intPlats.size();
            for (int j = 0; j < numIntPlats; ++j) {
                platsToTrgtSInvEnts.put(intPlats.elementAt(j), matchIE);
            }
        }
    }

    private void updatePlanInfosForIntPlats(Vector gpPlats, Hashtable platsToSrcSInvEnts, Hashtable platsToTrgtSInvEnts, Vector addInfos, Vector remInfos) {
        int numPlats = gpPlats.size();
        for (int i = 0; i < numPlats; ++i) {
            Integer platInt = (Integer)gpPlats.elementAt(i);
            OiiiStageCompInvEntry srcSInvEntry = (OiiiStageCompInvEntry)platsToSrcSInvEnts.get(platInt);
            OiiiStageCompInvEntry trgtSInvEntry = (OiiiStageCompInvEntry)platsToTrgtSInvEnts.get(platInt);
            if (trgtSInvEntry != null) {
                if (srcSInvEntry.equalTags(trgtSInvEntry) || !this.replaceForPlat(trgtSInvEntry, srcSInvEntry, platInt)) continue;
                this.addPlatPlanInfo(remInfos, trgtSInvEntry, platInt);
                this.addPlatPlanInfo(addInfos, srcSInvEntry, platInt);
                continue;
            }
            this.addPlatPlanInfo(addInfos, srcSInvEntry, platInt);
        }
    }

    private boolean replaceForPlat(OiiiStageCompInvEntry trgtIE, OiiiStageCompInvEntry srcIE, Integer platInt) {
        int stageCompare;
        boolean replaceVal = false;
        int saveCompare = trgtIE.compareTagDate(srcIE, 1);
        if (saveCompare < 0) {
            replaceVal = true;
        } else if (saveCompare == 0 && (stageCompare = trgtIE.compareTagDate(srcIE, 2)) < 0) {
            replaceVal = true;
        }
        return replaceVal;
    }

    private void addPlatPlanInfo(Vector planInfos, OiiiStageCompInvEntry scie, Integer platInt) {
        int curPos = OiixVectorOps.vectIndexOf(planInfos, (Object)scie);
        OiicStagingPlanInfo planInfo = null;
        if (curPos == -1) {
            planInfo = new OiicStagingPlanInfo(scie);
            planInfos.addElement(planInfo);
        } else {
            planInfo = (OiicStagingPlanInfo)planInfos.elementAt(curPos);
        }
        planInfo.addPlatform(platInt);
    }

    private void setPreserveFlags(Vector remInfos, Vector addInfos) {
        int numRemInfos = remInfos.size();
        for (int i = 0; i < numRemInfos; ++i) {
            OiiiStageCompInvEntry remIE;
            OiicStagingPlanInfo remInfo = (OiicStagingPlanInfo)remInfos.elementAt(i);
            if (!remInfo.isRemovingAllPlats() || OiixVectorOps.vectIndexOf(addInfos, (Object)(remIE = remInfo.getInvEntry())) == -1) continue;
            remInfo.setPreserveEntry(true);
        }
    }

    public int getNext() {
        return -1;
    }
}

