/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifw;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicInstallSession;
import oracle.sysman.oii.oiic.OiicLangAddonSession;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiic.OiicSummaryInformation;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifb.OiifbWizChainDlgElem;
import oracle.sysman.oii.oiii.OiiiCompIdOhPair;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiOneoffIdOhPair;
import oracle.sysman.oii.oiii.OiiiOneoffInstallID;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiii.OiiiSourceAccess;
import oracle.sysman.oii.oiii.OiiiStageCompInvEntry;
import oracle.sysman.oii.oiii.OiiiStageInventory;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiio.oiiod.OiiodDepEngine;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiis.OiisCompContext;
import oracle.sysman.oii.oiis.OiisCompInstallation;
import oracle.sysman.oii.oiis.OiisDepInfo;
import oracle.sysman.oii.oiis.OiisDepMode;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixLanguage;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifwSummaryWCDE
extends OiifbWizChainDlgElem {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 1024;
    OiicInstallSession m_instSession;
    boolean m_bRecord = false;
    public static final String s_panelClass = "oracle.sysman.oii.oiif.oiifp.OiifpSummaryPanel";
    private OiicSessionInterfaceManager m_interfaceManager;
    private OiiiInstallInventory m_inventory;
    private OiiiStageInventory m_stageInventory;
    private int m_iNextIndex;
    private String m_sSummaryFile = null;
    private Vector m_oSummaryText = null;
    private HashMap m_oVariables = null;
    private static long s_lStartTime;
    private static final String s_sSpace = "   ";
    private static final String s_sLineSeparator;
    private static final String s_sDelim = "-----------------------------------------------------------------------------";
    private static final String s_sSummaryDir = "summaryDir";
    private static final String s_sSummaryFile = "summaryFile";
    private static final String s_sSummaryFileExtn = "summaryFileExtn";
    private static final String s_sCharset = "UTF-8";
    private static final String s_sDelimiter = "%";
    private static final String s_sDelimiter2 = ":";
    private static final String s_sConnector = "_";
    private static final String s_sShInfoFile = "shiphomeinfo.properties";
    private OiicSummaryInformation m_summaryInfo;
    private boolean m_errorRemoteDiskSpace = false;
    private String m_errorRemoteDiskSpaceMessage = "";

    public OiifwSummaryWCDE(OiisVariableOwner vo) {
        this(vo, -1);
    }

    public OiifwSummaryWCDE(OiisVariableOwner vo, int nextIndex) {
        super(vo);
        this.m_instSession = (OiicInstallSession)vo.getSession();
        this.setDisplayControlVariable("SHOW_SUMMARY_PAGE");
        this.setHelpKey("OiifwSummaryWCDE");
        this.setWizPanelClassName(s_panelClass);
        this.m_wizardPageID = 101;
        this.m_iNextIndex = nextIndex;
    }

    public void initialize() throws OiifbEndIterateException {
        String sTempLoc;
        OiiodDepEngine depEngine = this.m_instSession.getDepEngine();
        depEngine.invalidateVolumeInfo();
        super.initialize();
        if (!OiicPullSession.isLangAddonMode() && (sTempLoc = System.getProperty("oracle.installer.scratchPath")) != null) {
            String localFile = OiixPathOps.concatPath(sTempLoc, s_sShInfoFile);
            Properties props = null;
            try {
                FileInputStream fs = new FileInputStream(localFile);
                props = new Properties();
                props.load(fs);
                fs.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (props != null) {
                OiiiSourceAccess sacc;
                String propFileName;
                OiisVariable topLevelCompName = this.m_varOwner.getVariable("ToplevelComp");
                OiisVariable installType = this.m_varOwner.getVariable("DEP_MODE");
                String name = ((OiiiCompInstallID)topLevelCompName.getValue()).getName();
                if (installType != null) {
                    name = name + s_sConnector + installType.getValueAsString();
                }
                if ((propFileName = (sacc = this.m_session.getSourceAccess()).fetchSummaryFile(props.getProperty(name + s_sConnector + s_sSummaryDir), props.getProperty(name + s_sConnector + s_sSummaryFile), props.getProperty(name + s_sConnector + s_sSummaryFileExtn))) != null) {
                    OiiolTextLogger.appendText("summary properties filename: " + propFileName);
                    System.setProperty("oracle.installer.shsummary", propFileName);
                    this.m_sSummaryFile = propFileName;
                    if (this.m_sSummaryFile.length() == 0) {
                        this.m_sSummaryFile = null;
                    }
                } else {
                    System.setProperty("oracle.installer.shsummary", "");
                }
            }
        }
    }

    public Vector getSummaryText() {
        return this.m_oSummaryText;
    }

    public void processSummaryFile() {
        if (this.m_sSummaryFile != null) {
            this.getText();
            this.getVariables();
            this.getInstantiatedText();
        }
    }

    private void getText() {
        block3: {
            this.m_oSummaryText = new Vector();
            this.m_oVariables = new HashMap();
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.m_sSummaryFile), s_sCharset));
                String str = null;
                while ((str = br.readLine()) != null) {
                    this.m_oSummaryText.add(str);
                    OiixFileOps.getVariablesFromString(str, this.m_oVariables, s_sDelimiter);
                }
                br.close();
            }
            catch (Exception err) {
                if (OiiolTextLogger.getLogLevel() < OiiolTextLogger.LOG_DETAILED) break block3;
                OiiolTextLogger.appendText(err.getMessage(), OiiolTextLogger.LOG_DETAILED);
            }
        }
    }

    private void getVariables() {
        int numVar = this.m_oVariables.size();
        Object[] varArr = this.m_oVariables.keySet().toArray();
        for (int i = 0; i < numVar; ++i) {
            String sSubstitute;
            String replace = sSubstitute = (String)varArr[i];
            int len = sSubstitute.length();
            String sVar = sSubstitute.substring(1, len - 1);
            StringTokenizer st = new StringTokenizer(sVar, s_sDelimiter2);
            int numTokens = st.countTokens();
            if (numTokens >= 3) {
                OiisVariable oCompVar;
                OiisCompContext oContext;
                String version;
                String compName = st.nextToken();
                OiiiCompInstallID c = new OiiiCompInstallID(compName, new OiiiVersion(version = st.nextToken()), OiixPlatform.getCurrentPlatformVector());
                OiisCompInstallation oCompIns = this.m_session.getCompInstall(c);
                if (oCompIns != null && (oContext = oCompIns.getContext()) != null && (oCompVar = oContext.getVariable(st.nextToken())) != null) {
                    replace = oCompVar.getValueAsString();
                }
            } else {
                OiisVariable oVal = this.m_varOwner.getVariable(sVar);
                if (oVal != null) {
                    replace = oVal.getValueAsString();
                }
            }
            if (replace == null) {
                replace = sSubstitute;
            }
            this.m_oVariables.put(sSubstitute.toLowerCase(), replace);
        }
    }

    private void getInstantiatedText() {
        Vector<String> oInstantiatedText = new Vector<String>();
        int numLines = this.m_oSummaryText.size();
        for (int i = 0; i < numLines; ++i) {
            oInstantiatedText.add(OiixFileOps.processString((String)this.m_oSummaryText.elementAt(i), this.m_oVariables, s_sDelimiter));
        }
        this.m_oSummaryText = oInstantiatedText;
    }

    public void dispose() {
        super.dispose();
    }

    public void setWizPanel() {
    }

    public int getNext() {
        return this.m_iNextIndex;
    }

    public int doOperation(boolean isBack) throws OiifbEndIterateException {
        this.m_interfaceManager = OiicSessionInterfaceManager.getInterfaceManager();
        this.m_inventory = this.m_instSession.getInstallAreaControl().getInstallInventory();
        this.m_stageInventory = this.m_instSession.getSourceAccess().getStageInventory();
        int retVal = super.doOperation(isBack);
        if (retVal != 1) {
            this.record();
            System.getProperties().setProperty("oracle.installer.exitonback", "false");
            OiicSessionContext oContext = this.m_instSession.getSessionContext();
            OiisVariable ohomeLoc = oContext.getVariable("ORACLE_HOME");
            String sHomeLoc = OiixPathOps.getNativeCanonicalPath((String)ohomeLoc.getValue());
            Hashtable vNewHomes = this.m_instSession.getOhLocName();
            int nNewHomes = vNewHomes.size();
            if (vNewHomes.remove(sHomeLoc) == null) {
                Enumeration locs = vNewHomes.keys();
                OiiiInstallAreaControl oAreaControl = (OiiiInstallAreaControl)OiiiInstallAreaControl.getInventoryAreaControl();
                OiiiInstallInventory oInventory = oAreaControl.getInstallInventory();
                Vector vHomes = oInventory.getHomes();
                int iSize = vHomes != null ? vHomes.size() : 0;
                for (int i = 0; i < nNewHomes; ++i) {
                    String sUnusedLoc = (String)locs.nextElement();
                    OiiiOracleHomeInfo homeInfo = oInventory.getHomeWithLocation(sUnusedLoc);
                    if (homeInfo == null) continue;
                    OiiolTextLogger.appendText("removing the new home entry from inventory: " + homeInfo.getLocation(), OiiolTextLogger.LOG_TRACE);
                    vHomes.removeElement(homeInfo);
                    break;
                }
            }
            Hashtable entries = this.m_instSession.getCopiedLibs();
            entries.remove(new Integer(this.m_instSession.getOHIndex()));
            this.m_instSession.deleteUnusedLibs();
            this.m_instSession.deleteUnusedOHData((String)ohomeLoc.getValue());
            this.m_instSession.resetParams();
        }
        if (OiicPullSession.isSilentMode() && this.m_errorRemoteDiskSpace) {
            String mesg;
            this.logMessage(this.m_errorRemoteDiskSpaceMessage);
            boolean bIgnore = Boolean.getBoolean("oracle.installer.ignoreDiskWarning");
            if (bIgnore) {
                mesg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_NOT_ENOUGH_DISK_SPACE_REMOTE_CONTINUE");
                this.logMessage(mesg);
            } else {
                mesg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_NOT_ENOUGH_DISK_SPACE_REMOTE_ERROR");
                this.logMessage(mesg);
                throw new OiifbEndIterateException(mesg);
            }
        }
        return retVal;
    }

    public String getDisplayName() {
        String sTitle = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_SUMMARY");
        return sTitle;
    }

    public void record() {
        if (OiicPullSession.isRecordMode()) {
            try {
                if (!this.m_bRecord) {
                    this.m_instSession.record();
                    this.m_bRecord = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void logDialog() {
        super.logDialog();
        this.writeSummaryInformation(OiicPullSession.isSilentMode());
    }

    private void writeSummaryInformation(boolean bSilent) {
        System.setProperty("oracle.installer.reinstallsession", "false");
        this.m_summaryInfo = new OiicSummaryInformation(this.m_instSession);
        StringBuffer sb = new StringBuffer(s_sLineSeparator + s_sDelim);
        sb.append(s_sLineSeparator);
        sb.append(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_SUMMARY"));
        sb.append(s_sLineSeparator);
        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
            OiiolTextLogger.appendText("Summary info started being written", OiiolTextLogger.LOG_DETAILED);
        }
        this.writeGlobalSettingsInfo(sb);
        if (OiicPullSession.isLangAddonMode()) {
            this.writeUpgradedLangsInfo(sb);
            this.writeSpaceInfo(sb);
            this.writeLangAddonProductInfos(sb);
        } else {
            this.writeProductLanguageInfo(sb);
            this.writeSpaceInfo(sb);
            this.writeProductInfo(sb);
            this.writeInstallSummaryInfo(sb);
        }
        sb.append(s_sDelim);
        this.logMessage(sb.toString());
    }

    private void writeInstallSummaryInfo(StringBuffer sb) {
        if (this.m_oSummaryText == null) {
            this.processSummaryFile();
        }
        if (this.m_oSummaryText != null) {
            int numLines = this.m_oSummaryText.size();
            sb.append(s_sLineSeparator);
            for (int i = 0; i < numLines; ++i) {
                sb.append(this.m_oSummaryText.elementAt(i) + s_sLineSeparator);
            }
        }
    }

    private void writeProductInfo(StringBuffer sb) {
        int k;
        String sProductInformation;
        String deinstallStr = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ONEOFF_DEINSTALL_STRING");
        String reinstallStr = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_REINSTALL");
        String downgradeStr = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_DOWNGRADES");
        String upgradeStr = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_UPGRADES");
        String newStr = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_NEW_INSTALL");
        String inMachineStr = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_INMACHINE");
        int nReIns = 0;
        int nDowngrades = 0;
        int nUpgrades = 0;
        int nNew = 0;
        int nInMachine = 0;
        int nDeIns = 0;
        OiiodDepEngine depEngine = this.m_instSession.getDepEngine();
        Vector installIEs = this.m_instSession.getSessionPlan().getSuccessfulAdditions(10);
        Vector comps = depEngine.getCompsToInstallAsOhVector();
        Vector vPatchSets = depEngine.getSelectedPatchSetsAsOhVector();
        List vNewInstalls = this.m_summaryInfo.getComponentsForInstall();
        List vReinstalls = this.m_summaryInfo.getComponentsForReinstall();
        List vUpgrades = this.m_summaryInfo.getComponentsForUpgrade();
        List vDowngrades = this.m_summaryInfo.getComponentsForDowngrade();
        nNew = vNewInstalls.size();
        nReIns = vReinstalls.size();
        nUpgrades = vUpgrades.size();
        nDowngrades = vDowngrades.size();
        Integer nProds = null;
        Vector oOneoffs = depEngine.getOneoffsToDeinstall();
        Vector oMiniPatchsets = depEngine.getMiniPatchsetsToDeinstall();
        Map oConflictingOneoffs = depEngine.getConflictingOneoffs();
        Set oOneOffsList = oConflictingOneoffs.keySet();
        nDeIns = oOneOffsList.size() + oOneoffs.size();
        if (nDeIns != 0) {
            OiiiOneoffInstallID oID;
            int k2;
            nProds = new Integer(nDeIns);
            sProductInformation = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_PRODUCTS", new Object[]{nProds});
            sb.append(deinstallStr);
            sb.append(sProductInformation);
            sb.append(s_sLineSeparator);
            Iterator iter = oOneOffsList.iterator();
            while (iter.hasNext()) {
                OiiiOneoffIdOhPair oOneoffIdOhPair = (OiiiOneoffIdOhPair)iter.next();
                OiiiOneoffInstallID oID2 = oOneoffIdOhPair.getOneoffID();
                sb.append(s_sSpace);
                if (oOneoffIdOhPair.isOneoff()) {
                    sb.append(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CONFLICTING_ONE_OFF", new String[]{oID2.getDisplayString()}));
                } else {
                    sb.append(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CONFLICTING_MINIPS", new String[]{oID2.getDisplayStringForMiniPatchset()}));
                }
                sb.append(s_sLineSeparator);
            }
            int iSize = oOneoffs.size();
            for (k2 = 0; k2 < iSize; ++k2) {
                oID = (OiiiOneoffInstallID)oOneoffs.get(k2);
                sb.append(s_sSpace);
                sb.append(oID.getDisplayString());
                sb.append(s_sLineSeparator);
            }
            iSize = oMiniPatchsets.size();
            for (k2 = 0; k2 < iSize; ++k2) {
                oID = (OiiiOneoffInstallID)oMiniPatchsets.get(k2);
                sb.append(s_sSpace);
                sb.append(oID.getDisplayStringForMiniPatchset());
                sb.append(s_sLineSeparator);
            }
        }
        if (nNew != 0) {
            nProds = new Integer(nNew);
            sProductInformation = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_PRODUCTS", new Object[]{nProds});
            sb.append(newStr);
            sb.append(sProductInformation);
            sb.append(s_sLineSeparator);
            int iSize = vNewInstalls.size();
            for (k = 0; k < iSize; ++k) {
                sb.append(this.getCompDisplayName((OiiiCompInstallID)vNewInstalls.get(k), true));
                sb.append(s_sLineSeparator);
            }
        }
        if (nReIns != 0) {
            nProds = new Integer(nReIns);
            sProductInformation = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_PRODUCTS", new Object[]{nProds});
            sb.append(reinstallStr);
            sb.append(sProductInformation);
            sb.append(s_sLineSeparator);
            int iSize = vReinstalls.size();
            for (k = 0; k < iSize; ++k) {
                sb.append(this.getCompDisplayName((OiiiCompInstallID)vReinstalls.get(k), true));
                sb.append(s_sLineSeparator);
            }
        }
        if (nUpgrades != 0) {
            nProds = new Integer(nUpgrades);
            sProductInformation = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_PRODUCTS", new Object[]{nProds});
            sb.append(upgradeStr);
            sb.append(sProductInformation);
            sb.append(s_sLineSeparator);
            int iSize = vUpgrades.size();
            for (k = 0; k < iSize; ++k) {
                sb.append(this.getCompDisplayName((OiiiCompInstallID)vUpgrades.get(k), true));
                sb.append(s_sLineSeparator);
            }
        }
        if (nDowngrades != 0) {
            nProds = new Integer(nDowngrades);
            sProductInformation = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_PRODUCTS", new Object[]{nProds});
            sb.append(downgradeStr);
            sb.append(sProductInformation);
            sb.append(s_sLineSeparator);
            int iSize = vDowngrades.size();
            for (k = 0; k < iSize; ++k) {
                sb.append(this.getCompDisplayName((OiiiCompInstallID)vDowngrades.get(k), true));
                sb.append(s_sLineSeparator);
            }
        }
        if ((nInMachine = (comps = depEngine.getAlreadyIntalledCompsAsOhVector()).size()) != 0) {
            nProds = new Integer(nInMachine);
            sProductInformation = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_PRODUCTS", new Object[]{nProds});
            sb.append(inMachineStr);
            sb.append(sProductInformation);
            sb.append(s_sLineSeparator);
            for (int k3 = 0; k3 < nInMachine; ++k3) {
                OiiiCompIdOhPair coh = (OiiiCompIdOhPair)comps.elementAt(k3);
                OiiiCompInstallID cid = coh.getCompID();
                sb.append(this.getCompDisplayName(cid, false));
                sb.append(s_sLineSeparator);
            }
        }
    }

    private void writeLangAddonProductInfos(StringBuffer sb) {
        String upgradedComponents = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFP1001");
        sb.append(upgradedComponents);
        sb.append(s_sLineSeparator);
        Vector installIEs = this.m_instSession.getSessionPlan().getSuccessfulAdditions(10);
        for (int i = 0; i < installIEs.size(); ++i) {
            OiiiCompInstallID compID = ((OiiiCompInvEntry)installIEs.elementAt(i)).getCompInstallID();
            String currentCompName = this.getCompDisplayName(compID, true);
            sb.append(currentCompName);
            sb.append(s_sLineSeparator);
        }
    }

    private void writeSpaceInfo(StringBuffer sb) {
        sb.append(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_SUMMARY_TREE_SPACE"));
        sb.append(s_sLineSeparator);
        Map volumesLocal = this.m_summaryInfo.getVolumeDetailsLocal();
        Iterator iter = volumesLocal.keySet().iterator();
        while (iter.hasNext()) {
            String sLabel;
            Object[] obj;
            String sVolume = (String)iter.next();
            long[] volDetails = (long[])volumesLocal.get(sVolume);
            long lReqSize = volDetails[0];
            long lTempSize = volDetails[1];
            long lSpacePerDrive = volDetails[2];
            long lAvailSpace = volDetails[3];
            String sReqSpace = OiixPathOps.getDiskSpaceString(lSpacePerDrive, 1);
            String sTempSpace = OiixPathOps.getDiskSpaceString(lTempSize, 2);
            String sAvailSpace = lSpacePerDrive > lAvailSpace ? OiixPathOps.getDiskSpaceString(lAvailSpace, 2) : OiixPathOps.getDiskSpaceString(lAvailSpace, 1);
            if (lTempSize > 0L) {
                obj = new String[]{sVolume, sReqSpace, sTempSpace, sAvailSpace};
                if (lSpacePerDrive > lTempSize) {
                    sLabel = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_SUMMARY_INFO_SPACE2");
                    sLabel = MessageFormat.format(sLabel, obj);
                } else {
                    obj[1] = sTempSpace;
                    sLabel = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_SUMMARY_INFO_SPACE3");
                    sLabel = MessageFormat.format(sLabel, obj);
                }
            } else {
                obj = new String[]{sVolume, sReqSpace, sAvailSpace};
                sLabel = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_SUMMARY_INFO_SPACE");
                sLabel = MessageFormat.format(sLabel, obj);
            }
            if (lSpacePerDrive <= 0L) continue;
            sb.append(s_sSpace);
            sb.append(sLabel);
            sb.append(s_sLineSeparator);
        }
        if (this.m_summaryInfo.displayClusterSpace() && !this.m_summaryInfo.allVolsShared()) {
            String[] remoteNodes = this.m_summaryInfo.getRemoteNodeNames();
            String clusterNodes = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_REMOTE_NODES");
            sb.append(clusterNodes);
            sb.append(s_sLineSeparator);
            String sClusterLabel = null;
            long lAvailSpaceCluster = 0L;
            String sAvailSpaceCluster = null;
            for (int j = 0; j < remoteNodes.length; ++j) {
                sb.append("            ");
                sb.append(remoteNodes[j]);
                sb.append(s_sLineSeparator);
                Map volumeRemote = this.m_summaryInfo.getVolumeDetailsRemote(remoteNodes[j]);
                Iterator remoteIter = volumeRemote.keySet().iterator();
                while (remoteIter.hasNext()) {
                    String sVolume = (String)remoteIter.next();
                    if (this.m_summaryInfo.isVolumeOnCFS(sVolume)) continue;
                    long[] volDetails = (long[])volumeRemote.get(sVolume);
                    lAvailSpaceCluster = volDetails[0];
                    long lReqSize = volDetails[1];
                    String sReqSpace = OiixPathOps.getDiskSpaceString(lReqSize, 1);
                    sAvailSpaceCluster = OiixPathOps.getDiskSpaceString(lAvailSpaceCluster, 1);
                    if (lReqSize > lAvailSpaceCluster) {
                        sAvailSpaceCluster = OiixPathOps.getDiskSpaceString(lAvailSpaceCluster, 2);
                        this.m_errorRemoteDiskSpace = true;
                        Object[] msgArr1 = new String[]{sVolume, remoteNodes[j]};
                        String errMsg = MessageFormat.format(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_NOT_ENOUGH_DISK_SPACE_REMOTE_MESSAGE"), msgArr1);
                        this.m_errorRemoteDiskSpaceMessage = this.m_errorRemoteDiskSpaceMessage + errMsg;
                    } else {
                        sAvailSpaceCluster = OiixPathOps.getDiskSpaceString(lAvailSpaceCluster, 1);
                    }
                    Object[] clusterobj = new String[]{sVolume, sReqSpace, sAvailSpaceCluster};
                    sClusterLabel = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLUSTER_SUMMARY_INFO_SPACE");
                    sClusterLabel = MessageFormat.format(sClusterLabel, clusterobj);
                    sb.append("                ");
                    sb.append(sClusterLabel);
                    sb.append(s_sLineSeparator);
                }
            }
        }
    }

    private void writeProductLanguageInfo(StringBuffer sb) {
        sb.append(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_SUMMARY_TREE_LANG"));
        sb.append(s_sLineSeparator);
        OiicSessionContext oContext = this.m_instSession.getSessionContext();
        Vector sLangs = null;
        if (this.m_instSession.getSelTopLevelCompID().getCompType() == 4) {
            sLangs = this.getPatchsetLangs();
        } else {
            OiisVariable oLangs = oContext.getVariable("SELECTED_LANGUAGES");
            String[] strLangs = (String[])oLangs.getValue();
            sLangs = OiixLanguage.getLangsVector(strLangs);
        }
        for (int i = 0; i < sLangs.size(); ++i) {
            Locale l = (Locale)sLangs.elementAt(i);
            String displayString = OiixLanguage.getDisplayName(l);
            if (displayString == null) {
                displayString = l.getDisplayLanguage();
            }
            sb.append(s_sSpace);
            sb.append(displayString);
            sb.append(s_sLineSeparator);
        }
    }

    private void writeUpgradedLangsInfo(StringBuffer sb) {
        sb.append(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFP1000"));
        sb.append(s_sLineSeparator);
        OiicSessionContext oContext = this.m_instSession.getSessionContext();
        Vector tlcIntersectionVector = ((OiicLangAddonSession)this.m_instSession).getTopLevelComponentIntersection();
        for (int i = 0; i < tlcIntersectionVector.size(); ++i) {
            OiiiCompInstallID compInstallID = (OiiiCompInstallID)tlcIntersectionVector.elementAt(i);
            if (compInstallID.getCompType() == 4 && tlcIntersectionVector.size() > 1) continue;
            Vector upgradedLangs = null;
            if (compInstallID.getCompType() == 4) {
                OiisVariable oLangs = oContext.getVariable("SELECTED_LANGUAGES");
                String[] strLangs = (String[])oLangs.getValue();
                upgradedLangs = OiixLanguage.getLangsVector(strLangs);
            } else {
                OiisCompInstallation oCompInstall = this.m_instSession.getCompInstall(compInstallID);
                upgradedLangs = oCompInstall.getUpgradeLangs();
            }
            if (upgradedLangs == null) continue;
            String tlcHeading = this.getCompDisplayName(compInstallID, true);
            sb.append(tlcHeading);
            sb.append(s_sLineSeparator);
            for (int j = 0; j < upgradedLangs.size(); ++j) {
                Locale l = (Locale)upgradedLangs.elementAt(j);
                String displayString = OiixLanguage.getDisplayName(l);
                if (displayString == null) {
                    displayString = l.getDisplayLanguage();
                }
                sb.append("      " + displayString);
                sb.append(s_sLineSeparator);
            }
        }
    }

    public Vector getPatchsetLangs() {
        Vector installIEs = this.m_instSession.getSessionPlan().getSuccessfulAdditions(10);
        Hashtable<Locale, Locale> hLangs = new Hashtable<Locale, Locale>(5);
        int iSize = installIEs.size();
        for (int i = 0; i < iSize; ++i) {
            OiiiCompInvEntry oEntry = (OiiiCompInvEntry)installIEs.elementAt(i);
            if (oEntry.getCompInstallID().getCompType() != 2) continue;
            Vector vLangs = oEntry.getLanguages();
            int iLangs = vLangs.size();
            for (int j = 0; j < iLangs; ++j) {
                Locale l = (Locale)vLangs.elementAt(j);
                if (hLangs.get(l) != null) continue;
                hLangs.put(l, l);
            }
        }
        Vector retVect = new Vector(hLangs.size());
        Enumeration eLangs = hLangs.keys();
        while (eLangs.hasMoreElements()) {
            retVect.addElement(eLangs.nextElement());
        }
        return retVect;
    }

    private void writeGlobalSettingsInfo(StringBuffer sb) {
        OiiiCompInstallID[] cids;
        OiiiCompInstallID tlComp;
        sb.append(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_SUMMARY_TREE_GS"));
        sb.append(s_sLineSeparator);
        OiicSessionContext oContext = this.m_instSession.getSessionContext();
        OiisVariable oSource = oContext.getVariable("FROM_LOCATION");
        Object[] msgArr = new String[]{(String)oSource.getValue()};
        String sStgLabel = MessageFormat.format(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_SUMMARY_INFO_STAGE"), msgArr);
        sb.append("    ");
        sb.append(sStgLabel);
        sb.append(s_sLineSeparator);
        String s = System.getProperty("oracle.installer.useORACLE_BASE");
        if (s != null && s.equalsIgnoreCase("true")) {
            OiisVariable ob = oContext.getVariable("ORACLE_BASE");
            Object[] msgArr1 = new String[2];
            msgArr1[0] = (String)ob.getValue();
            String sOBLabel = MessageFormat.format(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_SUMMARY_INFO_OB"), msgArr1);
            sb.append("    ");
            sb.append(sOBLabel);
            sb.append(s_sLineSeparator);
        }
        OiisVariable oOH = oContext.getVariable("ORACLE_HOME");
        OiisVariable oOHNameVar = oContext.getVariable("ORACLE_HOME_NAME");
        Object[] msgArr1 = new String[]{(String)oOH.getValue(), (String)oOHNameVar.getValue()};
        String sOHLabel = MessageFormat.format(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_SUMMARY_INFO_OH"), msgArr1);
        sb.append("    ");
        sb.append(sOHLabel);
        sb.append(s_sLineSeparator);
        String[] remoteNodes = (String[])oContext.getVarValue("REMOTE_NODES");
        String localNode = (String)oContext.getVarValue("LOCAL_NODE");
        if (localNode != null && localNode.trim().length() > 0 || remoteNodes != null && remoteNodes.length > 0) {
            String[] nodeList = OiixFunctionOps.unionStr(localNode, remoteNodes);
            Object[] sNodeMsg = new String[1];
            for (int i = 0; i < nodeList.length; ++i) {
                sNodeMsg[0] = nodeList[i];
                String sNodeNamesLabel = MessageFormat.format(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_SUMMARY_NODES_INFO"), sNodeMsg);
                sb.append("    ");
                sb.append(sNodeNamesLabel);
                sb.append(s_sLineSeparator);
            }
        }
        if (!OiicPullSession.isLangAddonMode() && (tlComp = (cids = this.m_instSession.getSelTopLevelCompIDs())[0]).getCompType() == 1) {
            OiiiStageInventory stageInventory = this.m_instSession.getSourceAccess().getStageInventory();
            OiiiStageCompInvEntry entry = stageInventory.getStageCompInvEntry(tlComp);
            OiisVariable oDepMode = oContext.getVariable("DEP_MODE");
            String nMode = (String)oDepMode.getValue();
            OiisDepInfo depInfo = entry.getDepInfo();
            OiisDepMode oMode = depInfo.getDepMode(nMode);
            Object[] msgArr2 = new String[]{oMode.getName()};
            String sModeLabel = MessageFormat.format(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_SUMMARY_INFO_IT"), msgArr2);
            sb.append("    ");
            sb.append(sModeLabel);
            sb.append(s_sLineSeparator);
        }
    }

    private void logMessage(String sMessage) {
        boolean isAPIMode = System.getProperty("oracle.installer.ouiApiMode", "false").equalsIgnoreCase("true");
        if (!isAPIMode || isAPIMode && System.getProperty("oracle.installer.debug", "false").equalsIgnoreCase("true") && System.getProperty("oracle.installer.logLevel", "INFO").equalsIgnoreCase("FINEST")) {
            this.m_interfaceManager.logMessage(sMessage);
        }
    }

    private String getCompDisplayName(OiiiCompInstallID cid, boolean bStageInv) {
        OiiiCompInvEntry entry = bStageInv ? this.m_stageInventory.getStageCompInvEntry(cid) : this.m_inventory.getCompInvEntry(cid, this.m_instSession.getHomeIndex(cid));
        return s_sSpace + entry.getFullDisplayName();
    }

    static {
        s_sLineSeparator = System.getProperty("line.separator", "\n");
    }
}

