/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifw;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicInstallSession;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiif.oiifw.OiifwLangsSelWCDE;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiis.OiisAdvisedValue;
import oracle.sysman.oii.oiis.OiisDlgInOutElem;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixHelpDetails;
import oracle.sysman.oii.oiix.OiixLanguage;
import oracle.sysman.oii.oiix.OiixOraparam;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiifwTopLevelSelWCDE
extends OiifwLangsSelWCDE {
    private int m_nextInd = -1;
    public static final String s_panelClass = "oracle.sysman.oii.oiif.oiifp.OiifpTopLevelSelPanel";
    private OiiiCompInstallID m_cid = null;

    public OiifwTopLevelSelWCDE(OiisVariableOwner vo, int nextInd) {
        super(vo);
        this.m_dlgInOutElems.addElement(new OiisDlgInOutElem("TopLevelComp", "ToplevelComp"));
        this.setHelpKey("OiicTopLevelSelWCDE");
        this.setWizPanelClassName(s_panelClass);
        this.m_wizardPageID = OiicInstallSession.STG_PICK_COMP_IND;
        this.m_nextInd = nextInd;
    }

    public String getDisplayName() {
        String sTitle = OiixResourceBundle.getString("S_AVAIL_PRODS");
        return sTitle;
    }

    public void initialize() throws OiifbEndIterateException {
        super.initialize();
        OiicInstallSession oSession = (OiicInstallSession)this.m_varOwner.getSession();
        oSession.setInvChanged(false);
    }

    public int getNext() {
        return this.m_nextInd;
    }

    private void checkForLanguageConflicts(OiiiCompInstallID selectedId, OiisVariable varLangs) throws OiifbCancelException {
        OiicInstallSession oSession = (OiicInstallSession)this.m_varOwner.getSession();
        Vector vSupportedLangs = oSession.getStgCompLangs(selectedId);
        String[] strList = (String[])varLangs.getValue();
        Vector vSelectedLangs = OiixLanguage.getLangsVector(strList);
        StringBuffer sErrLangs = new StringBuffer();
        Vector<Locale> vErrLangs = new Vector<Locale>(5, 5);
        int size = vSelectedLangs.size();
        for (int i = 0; i < size; ++i) {
            Locale l = (Locale)vSelectedLangs.elementAt(i);
            int nIndex = OiixVectorOps.vectIndexOf(vSupportedLangs, (Object)l);
            if (nIndex != -1) continue;
            vErrLangs.addElement(l);
            String sLang = OiixLanguage.getDisplayName(l);
            if (sLang == null) {
                sLang = l.getDisplayLanguage();
            }
            sErrLangs.append(sLang + " ");
        }
        if (vErrLangs.size() > 0) {
            String sLangConflictMsg = OiixResourceBundle.getString("S_LANGS_SELECTION_CONFLICT_WARNING");
            Object[] sArgs = new String[]{sErrLangs.toString()};
            String sMsg = MessageFormat.format(sLangConflictMsg, sArgs);
            OiifmAlert.displayAlert(OiixResourceBundle.getString("S_INFORMATION"), sMsg, 40, 1, 1, 10);
            size = vErrLangs.size();
            for (int i = 0; i < size; ++i) {
                vSelectedLangs.removeElement(vErrLangs.elementAt(i));
            }
            String[] selLangs = OiixLanguage.getStringArray(vSelectedLangs);
            try {
                varLangs.setValue(new OiisAdvisedValue(selLangs, false), true);
                OiicSessionContext oContext = oSession.getSessionContext();
                OiisVariable compLangVar = oContext.getVariable("COMPONENT_LANGUAGES");
                compLangVar.setValue(new OiisAdvisedValue(selLangs, true), true);
            }
            catch (OiisVarSettingException e) {
                e.printStackTrace();
            }
        }
    }

    public void dispose() {
        super.dispose();
    }

    public boolean validate() throws OiifbCancelException, OiifbEndIterateException {
        boolean bRet = true;
        OiicInstallSession instSession = (OiicInstallSession)this.m_varOwner.getSession();
        OiisVariable topLevel = this.m_varOwner.getVariable("ToplevelComp");
        OiiiCompInstallID id = (OiiiCompInstallID)topLevel.getValue();
        if (!OiixOraparam.isApplTopStage() && id.isAppltopComponent()) {
            Object[] sArgs = new String[]{id.getName()};
            String sMsg = MessageFormat.format(OiixResourceBundle.getString("S_INVALID_STAGE_APPLTOP_COMP"), sArgs);
            if (OiicPullSession.isSilentMode()) {
                throw new OiifbEndIterateException(sMsg);
            }
            OiifmAlert.displayAlert(OiixResourceBundle.getString("S_ERROR"), sMsg, 40, 1, 20);
            return false;
        }
        OiiiCompInstallID selectedId = id;
        OiisVariable varLangs = null;
        try {
            varLangs = this.m_varOwner.getVariable("SELECTED_LANGUAGES");
            String[] strList = instSession.getDefaultLanguageSelection(selectedId);
            if (!varLangs.getAdvice()) {
                varLangs.setValue(new OiisAdvisedValue(strList, false), true);
            }
        }
        catch (Exception e) {
            if (OiicPullSession.isSilentMode()) {
                throw new OiifbEndIterateException(e.getMessage());
            }
            bRet = false;
        }
        if (bRet && selectedId.getCompType() != 4) {
            try {
                this.checkForLanguageConflicts(selectedId, varLangs);
            }
            catch (ClassCastException cle) {
                // empty catch block
            }
        }
        return bRet;
    }

    public void setCompInstallID(OiiiCompInstallID cid) {
        this.m_cid = cid;
    }

    public OiixHelpDetails getHelpDetails() {
        OiixHelpDetails helpDetails = new OiixHelpDetails(this.getVarOwner(), this.m_cid, "CompTopLevelHelp", "OiicTopLevelSelWCDE");
        return helpDetails;
    }

    public void onView(Vector vIds) {
        OiicInstallSession oSession = (OiicInstallSession)this.getVarOwner().getSession();
        if (vIds != null && vIds.size() > 0) {
            oSession.setInvChanged(true);
        }
    }
}

