/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifw;

import java.text.MessageFormat;
import java.util.Properties;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicInstallSession;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifb.OiifbWizOperation;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiStageCompInvEntry;
import oracle.sysman.oii.oiii.OiiiStageInventory;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgDetectCluster;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixOraparam;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifwValidateClusterArgsWCCE
implements OiifbWizOperation {
    private static final boolean s_debug = false;
    private OiisVariableOwner m_vo;

    public OiifwValidateClusterArgsWCCE(OiisVariableOwner vo, int nextInd) {
        this.m_vo = vo;
    }

    public void initialize() {
    }

    public int doOperation(boolean isBack) throws OiifbEndIterateException {
        if (isBack) {
            return 1;
        }
        OiipgDetectCluster detectCluster = OiipgDetectCluster.getDetectCluster();
        boolean bCluster = detectCluster.isCluster();
        boolean bFormCluster = Boolean.getBoolean("oracle.srvm.formCluster");
        String[] sClusterwareInfo = OiixOraparam.getClusterwareInfo();
        if (bCluster) {
            String[] nodeList = detectCluster.getNodeNames();
            String sNodeList = null;
            String sLogTxt = null;
            if (nodeList != null && nodeList.length > 0) {
                sNodeList = OiixFunctionOps.implodeList(nodeList, ",");
            }
            Object[] obj = new Object[]{sNodeList};
            sLogTxt = sClusterwareInfo != null && sClusterwareInfo.length == 2 ? MessageFormat.format(OiixResourceBundle.getString("S_OLSNODES_OUTPUT_LOG"), obj) : MessageFormat.format(OiixResourceBundle.getString("S_LSNODES_OUTPUT_LOG"), obj);
            OiiolTextLogger.appendText(sLogTxt, OiiolTextLogger.LOG_BASIC);
        }
        if (bFormCluster) {
            OiiiStageCompInvEntry compEntry;
            Vector plats = OiixPlatform.getCurrentPlatformVector();
            OiiiVersion version = new OiiiVersion(sClusterwareInfo[1]);
            OiiiCompInstallID cid = new OiiiCompInstallID(sClusterwareInfo[0], version, plats, new OiiiVersion("0.0.0.0.0"), 1, 1, 0);
            OiiiStageInventory m_stageInventory = ((OiicInstallSession)this.m_vo.getSession()).getSourceAccess().getStageInventory();
            if (m_stageInventory != null && (compEntry = m_stageInventory.getStageCompInvEntry(cid)) == null) {
                String message = OiixResourceBundle.getString("S_NO_CRS_PRODUCT_TO_INSTALL");
                int nRet = OiifmAlert.displayAlert(OiixResourceBundle.getString("S_ERROR"), message, 30, 1, 2, 20);
                if (nRet == 1) {
                    return 1;
                }
                throw new OiifbEndIterateException(message);
            }
        }
        if (!bCluster && bFormCluster) {
            String sSSHProg = System.getProperty("oracle.srvm.remoteShell");
            String sSCPProg = System.getProperty("oracle.srvm.remoteCopy");
            if (sSSHProg != null || sSCPProg != null) {
                String message = OiixResourceBundle.getString("S_SSH_SCP_ARGS_ERROR");
                int nRet = OiifmAlert.displayAlert(OiixResourceBundle.getString("S_ERROR"), message, 30, 5, 2, 20);
                if (nRet == 1) {
                    Properties props = System.getProperties();
                    props.remove("oracle.srvm.remoteShell");
                    props.remove("oracle.srvm.remoteCopy");
                    return 0;
                }
                throw new OiifbEndIterateException(message);
            }
        }
        return 0;
    }

    public void dispose() {
    }
}

