/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifw;

import java.util.List;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicInstallSession;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifb.OiifbWizOperation;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiio.oiiod.OiiodDepEngine;
import oracle.sysman.oii.oiio.oiiod.OiiodVolumeInfo;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixDebug;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifwValidateDiskSpaceWCCE
implements OiifbWizOperation {
    private boolean m_bShow = true;
    private OiisVariableOwner m_vo;

    public OiifwValidateDiskSpaceWCCE(OiisVariableOwner vo) {
        this.m_vo = vo;
    }

    public void initialize() {
        if (OiicPullSession.isSilentMode()) {
            this.m_bShow = false;
        }
    }

    public boolean isDiskFull() {
        boolean bDiskFull = false;
        OiiodDepEngine depEngine = this.m_vo.getSession().getDepEngine();
        List oVolumeInfo = depEngine.getRequiredSpace(false);
        int nSize = oVolumeInfo.size();
        for (int i = 0; i < nSize; ++i) {
            OiiodVolumeInfo oVolInfo = (OiiodVolumeInfo)oVolumeInfo.get(i);
            if (oVolInfo.getTotalRequiredSpace(true) <= oVolInfo.getAvailableSpace()) continue;
            bDiskFull = true;
            oVolInfo.invalidateAvailableSpace();
        }
        return bDiskFull;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int doOperation(boolean isBack) throws OiifbEndIterateException {
        if (isBack) {
            return 1;
        }
        boolean retVal = false;
        boolean isSilentModeEnabled = System.getProperty("oracle.installer.silent", "false").equalsIgnoreCase("true");
        boolean isAPIModeEnabled = System.getProperty("oracle.installer.ouiApiMode", "false").equalsIgnoreCase("true");
        OiicInstallSession instSession = (OiicInstallSession)this.m_vo.getSession();
        if (this.isDiskFull()) {
            if (!this.m_bShow || isSilentModeEnabled && isAPIModeEnabled) {
                OiiolTextLogger.writeMessageToConsole(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_SUMMARY_DISK_FULL"));
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_SUMMARY_DISK_FULL"));
                boolean bIgnore = Boolean.getBoolean("oracle.installer.ignoreDiskWarning");
                if (!bIgnore) {
                    String mesg = "Installation cannot continue. To Ignore Disk Warning, please use \"-ignoreDiskWarning\" command line option.\n";
                    OiiolTextLogger.appendText(mesg);
                    throw new OiifbEndIterateException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_SUMMARY_DISK_FULL"));
                }
                String mesg = "Ignoring the Disk Warning and continuing with install as the \"-ignoreDiskWarning\" option was specified on the command line.\n";
                OiiolTextLogger.appendText(mesg);
            } else {
                int nResult = OiifmAlert.displayAlert(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CAUTION"), OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_SUMMARY_DISK_FULL"), 30, 3, 2, 10);
                if (nResult == 2) {
                    return 1;
                }
            }
        }
        if (OiixDebug.PRINT_DISKUSAGE) {
            OiiodDepEngine depEngine = this.m_vo.getSession().getDepEngine();
            List oVolumeInfo = depEngine.getRequiredSpace(false);
            int nSize = oVolumeInfo.size();
            Vector<String> vVolumes = new Vector<String>(nSize);
            for (int i = 0; i < nSize; ++i) {
                OiiodVolumeInfo oVolInfo = (OiiodVolumeInfo)oVolumeInfo.get(i);
                vVolumes.addElement(oVolInfo.getVolumeName());
            }
            instSession.setVolumeInfo(vVolumes);
            OiixDebug.printDiskUsageHdr(vVolumes);
        }
        if (!isBack) return 0;
        return 1;
    }

    public void dispose() {
        OiicInstallSession instSession = (OiicInstallSession)this.m_vo.getSession();
        instSession.disposeUnusedCompInstalls();
        this.m_vo = null;
    }
}

