/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifw;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import oracle.ewt.lwAWT.BufferedDialog;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.meter.BoundedRangeModelImpl;
import oracle.ewt.meter.ProgressBar;
import oracle.ewt.meter.StringRangeModel;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.statusBar.StatusBar;
import oracle.ewt.statusBar.StatusBarItem;
import oracle.ewt.statusBar.StatusBarTextItem;
import oracle.ewt.util.WindowUtils;
import oracle.sysman.oii.oiic.OiicExitOps;
import oracle.sysman.oii.oiic.OiicInstallSession;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbSpawnReadme;
import oracle.sysman.oii.oiif.oiifb.OiifbSyncObject;
import oracle.sysman.oii.oiif.oiifj.OiifjCreditsDlg;
import oracle.sysman.oii.oiif.oiifj.OiifjInventoryDialog;
import oracle.sysman.oii.oiif.oiifj.OiifjLangsDlg;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiif.oiifm.OiifmCursorUtil;
import oracle.sysman.oii.oiif.oiifm.OiifmGraphicInterfaceManager;
import oracle.sysman.oii.oiif.oiifm.OiifmGraphicPageHandler;
import oracle.sysman.oii.oiif.oiifm.OiifmKeyActionConverter;
import oracle.sysman.oii.oiif.oiifm.OiifmMainFrame;
import oracle.sysman.oii.oiif.oiifm.OiifmMnemonicOps;
import oracle.sysman.oii.oiif.oiifm.OiifmSplashScreen;
import oracle.sysman.oii.oiif.oiifp.OiifpWizPanel;
import oracle.sysman.oii.oiif.oiifw.OiifwExitEventListener;
import oracle.sysman.oii.oiif.oiifw.OiifwNavigationPanel;
import oracle.sysman.oii.oiif.oiifw.OiifwWizActionListener;
import oracle.sysman.oii.oiip.oiipg.OiipgBootstrap;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiix.OiixLanguage;
import oracle.sysman.oii.oiix.OiixProgressListener;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixSpawner;

public class OiifwWizDialog
extends LWContainer
implements WindowListener,
OiixProgressListener {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 1024;
    private static final int BUFFER_WIDTH = 50;
    private static final int BUFFER_HEIGHT = 5;
    private static final int PROGRESS_WIDTH_MARGIN = 10;
    public static final String DLG_PROG_LEN_STR = "8888888888888888888888888888888888888888888888888888";
    public static final String PANEL_PROG_LEN_STR = "8888888888888888888888888888888888888888";
    public static final int NONE = -1;
    public static final int HELP = 2;
    public static final int EXIT = 3;
    public static final int OPTIONS = 4;
    public static final int VIEW = 5;
    public static final int NEXT = 0;
    public static final int BACK = 1;
    private boolean m_autoHide = false;
    private OiifbSyncObject syncObj = null;
    private OiifbCancelException m_cancEx = null;
    private LWContainer m_firstPanel = null;
    private LWContainer m_wizardPanel = null;
    private int m_buttonPressed = -1;
    private boolean m_viewOnly = false;
    private OiifwNavigationPanel m_navPanel = null;
    private LWContainer m_progressPanel = null;
    private LWContainer m_placeHolderPanel = null;
    private LWContainer m_wholePanel = null;
    private LWContainer m_mainPanel = null;
    private LWContainer m_northPanel = null;
    private LWContainer m_dlgPanel = null;
    private OiifmMainFrame m_frame = null;
    private ProgressBar m_progressBar = null;
    private BoundedRangeModelImpl m_oRangemodel = null;
    private boolean m_bDlgProgressBar = false;
    private LWLabel m_statusLabel = null;
    private Color m_defColor = null;
    private boolean m_bProgPanelAdded = false;
    private OiifmSplashScreen m_splashScr = null;
    private BufferedDialog m_progressDlg = null;
    private OiifjCreditsDlg m_creditsDlg = null;
    private Thread m_invTree = null;
    private boolean m_bFirstPop = true;
    private boolean m_bIsWindowClosing = false;
    private static final int HGAP = 5;
    private static final int VGAP = 5;
    private static final int INSET = 5;
    private static final int WIDTH = 640;
    private static final int HEIGHT = 480;
    private Dimension m_prefSize = null;
    private Cursor waitCursor = null;
    private Cursor defCursor = null;
    private OiifwWizActionListener _listener = null;
    private OiifwExitEventListener m_exitActions = null;
    private OiicSessionInterfaceManager m_osim = null;
    private StatusBar m_statusBar = null;
    private boolean m_bDialogShown = false;
    private int m_iCursorType = -1;
    private int m_nPageCounter = 0;
    private boolean m_bNavigationBtnsDisabled = false;
    private long m_totalBytes = 0L;
    private long m_addedBytes = 0L;
    private boolean bDoneProg = false;

    public boolean areNavigationBtnsDisabled() {
        return this.m_bNavigationBtnsDisabled;
    }

    public void setNavigationBtnsDisabled(boolean disabled) {
        this.m_bNavigationBtnsDisabled = disabled;
    }

    public OiifwWizDialog(OiifmMainFrame f) {
        this.m_frame = f;
        this.m_viewOnly = false;
        this.waitCursor = Cursor.getPredefinedCursor(3);
        this.defCursor = Cursor.getPredefinedCursor(0);
        this.m_prefSize = new Dimension(640, 480);
        this.m_creditsDlg = null;
        this.setLayout(new BorderLayout(5, 5));
        this.setBorderPainter((BorderPainter)new FixedBorderPainter(5, 5, 5, 5));
        this.m_wholePanel = new LWContainer();
        this.m_wholePanel.setLayout((LayoutManager)new BorderLayout());
        this.add((Component)this.m_wholePanel, "Center");
        this.m_mainPanel = new LWContainer();
        this.m_mainPanel.setLayout((LayoutManager)new BorderLayout(5, 5));
        this.m_mainPanel.setBorderPainter((BorderPainter)new FixedBorderPainter(5, 5, 17, 5));
        this.m_northPanel = new LWContainer();
        this.m_northPanel.setLayout((LayoutManager)new BorderLayout(5, 5));
        this.m_northPanel.setBorderPainter((BorderPainter)new FixedBorderPainter(0, 10, 0, 10));
        this.m_mainPanel.add((Component)this.m_northPanel, (Object)"North");
        this.m_statusLabel = new LWLabel(" ");
        this.m_statusLabel.setFocusable(true);
        Font plainFont = new Font("Dialog", 0, 10);
        this.m_statusLabel.setFont(plainFont);
        this.m_defColor = this.m_statusLabel.getForeground();
        this.m_progressPanel = new LWContainer();
        this.m_progressPanel.setLayout((LayoutManager)new BorderLayout(5, 5));
        this.m_progressPanel.add((Component)this.m_statusLabel, (Object)"North");
        this.m_progressBar = new ProgressBar();
        this.m_progressPanel.add((Component)this.m_progressBar, (Object)"South");
        this.m_placeHolderPanel = new LWContainer();
        this.m_placeHolderPanel.setBorderPainter((BorderPainter)new FixedBorderPainter(5, 50, 20, 20));
        this.m_northPanel.add((Component)this.m_placeHolderPanel, (Object)"East");
        this.m_wizardPanel = new LWContainer();
        this.m_wizardPanel.setLayout(null);
        this.m_mainPanel.add((Component)this.m_wizardPanel, (Object)"Center");
        this.m_navPanel = new OiifwNavigationPanel(this);
        this.m_mainPanel.add((Component)((Object)this.m_navPanel), (Object)"South");
        OiifmMnemonicOps.processMnemonic((Container)((Object)this.m_navPanel));
        this.m_wholePanel.add((Component)this.m_mainPanel, (Object)"Center");
        this.m_statusBar = new StatusBar(1);
        this.m_statusBar.addItem((StatusBarItem)new StatusBarTextItem(""));
        this.m_statusBar.setVisible(false);
        this.m_wholePanel.add((Component)this.m_statusBar, (Object)"South");
        this.m_mainPanel.validate();
        this.syncObj = new OiifbSyncObject();
        this.m_autoHide = true;
        f.addWizardDialog(this);
        this.m_progressDlg = new BufferedDialog((Frame)((Object)f));
        this.m_progressDlg.setLayout((LayoutManager)new BorderLayout(5, 5));
        this.m_dlgPanel = new LWContainer();
        this.m_dlgPanel.setLayout((LayoutManager)new BorderLayout(5, 5));
        this.m_dlgPanel.setBorderPainter((BorderPainter)new FixedBorderPainter(10, 10, 15, 10));
        this.m_progressDlg.add((Component)this.m_dlgPanel, (Object)"Center");
        this.m_bDlgProgressBar = false;
        this.m_buttonPressed = -1;
    }

    public OiifwWizDialog(OiifmMainFrame f, boolean autoHide, OiifmSplashScreen splashScr) {
        this(f);
        this.m_autoHide = autoHide;
        this.m_splashScr = splashScr;
    }

    public void setNavigationKeyActionConverter(OiifmKeyActionConverter kac) {
        this.m_navPanel.setKeyActionConverter(kac);
    }

    public LWContainer getWizardPanel() {
        return this.m_wizardPanel;
    }

    public void onNext() {
        boolean travel = false;
        this.setPanelCursor(this.waitCursor);
        try {
            if (this._listener != null) {
                travel = this._listener.onNext();
            }
        }
        catch (OiifbCancelException ce) {
            this.m_cancEx = ce;
            travel = false;
            this.syncObj.signal();
        }
        if (travel) {
            if (this.m_autoHide) {
                this.setVisible(false);
            }
            this.m_buttonPressed = 0;
            this.setNavButtonState(2, true);
            this.syncObj.signal();
        } else {
            this.m_buttonPressed = -1;
            this.setPanelCursor(this.defCursor);
        }
    }

    public void onBack() {
        boolean travel;
        this.setPanelCursor(this.waitCursor);
        boolean bl = travel = null != this._listener ? this._listener.onBack() : false;
        if (travel) {
            if (this.m_autoHide) {
                this.setVisible(false);
            }
            this.m_buttonPressed = 1;
            this.setNavButtonState(4, true);
            this.syncObj.signal();
        }
    }

    public void onExit() {
        OiifmCursorUtil.setCursor(this.waitCursor, (Component)((Object)this));
        this.m_buttonPressed = 3;
        String title = OiixResourceBundle.getString("S_EXIT_TITLE");
        String message = OiixResourceBundle.getString("S_EXIT_CONFIRM_PROMPT");
        OiifmCursorUtil.setCursor(this.defCursor, (Component)((Object)this));
        if (this._listener != null) {
            this._listener.onExit();
        }
        int nResult = 1;
        OiicPullSession session = (OiicPullSession)this.m_osim.getSession();
        this.getWizardPanel();
        LWComponent component = LWContainer.getFocusedComponent();
        if (session.isRebootInfoSet() && session.isSuccessfullInstallation()) {
            nResult = this.m_osim.doRebootOperations();
        } else if (OiicSessionContext.isDlgToBeShown("SHOW_EXIT_CONFIRMATION")) {
            nResult = OiifmAlert.displayAlert(title, message, 30, 3, 1, 10);
        }
        switch (nResult) {
            case 1: {
                if (this.m_autoHide) {
                    this.setVisible(false);
                }
                this.m_buttonPressed = 3;
                this.setVisible(false);
                this.m_frame.setVisible(false);
                if (null != this._listener) {
                    this._listener.onExitConfirm();
                }
                this.executeOnExitRebootConfigTools(session);
                if (session.isInstallMode()) {
                    ((OiicInstallSession)session).runOuica(true);
                }
                this.syncObj.signal();
                OiicExitOps.getExitOps().exit();
                break;
            }
            case 2: {
                if (this._listener == null) break;
                this._listener.onExitCancel();
            }
        }
        if (component != null) {
            component.requestFocus();
        }
    }

    private void executeOnExitRebootConfigTools(OiicPullSession session) {
        Vector vExitTools;
        String sExitToolsLoc = System.getProperty("oracle.installer.exit_config_loc");
        if (null != sExitToolsLoc && 0 < sExitToolsLoc.length() && !session.isRebootInfoSet() && session.isSuccessfullInstallation() && null != (vExitTools = session.getOnRebootExitTools()) && 0 < vExitTools.size()) {
            int iSize = vExitTools.size();
            try {
                for (int i = 0; i < iSize; ++i) {
                    OiixSpawner oSpawner = new OiixSpawner();
                    oSpawner.beginExecute((String)vExitTools.elementAt(i));
                }
            }
            catch (Exception e) {
                System.err.println("Exception in spawning the exit tools set to execute after reboot :" + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onView() {
        if (this.m_invTree != null && this.m_invTree.isAlive()) {
            if (this.m_bFirstPop) {
                this.m_bFirstPop = false;
                return;
            }
            try {
                this.m_invTree.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            this.m_invTree = null;
        }
        OiifwWizDialog oiifwWizDialog = this;
        synchronized (oiifwWizDialog) {
            if (this.m_bDialogShown) {
                return;
            }
            this.m_bDialogShown = true;
        }
        OiifmCursorUtil.setCursor(this.waitCursor, (Component)((Object)this));
        if (this.m_bFirstPop) {
            this.m_invTree = new Thread(new PrepareInventoryTree(this));
            this.m_invTree.setName("PrepareInvTreeThread");
            this.m_invTree.start();
        } else {
            this.onViewPrivate();
        }
        this.m_bDialogShown = false;
    }

    private void onViewPrivate() {
        OiifjInventoryDialog invDlg = new OiifjInventoryDialog((Frame)((Object)this.m_frame), this.m_viewOnly);
        boolean v_bFirstPop = this.m_bFirstPop;
        if (this._listener != null) {
            this._listener.onViewSetup();
        }
        do {
            if (v_bFirstPop != this.m_bFirstPop) {
                ((OiifpWizPanel)this.m_wizardPanel).updateEnabledComponentsStatus(false);
                this.disableButtons();
            }
            v_bFirstPop = this.m_bFirstPop;
            invDlg.doModal(!this.m_bFirstPop);
            this.restoreButtons();
            OiifmCursorUtil.setCursor(this.defCursor, (Component)((Object)this));
            if (this._listener == null) continue;
            OiifmGraphicPageHandler v_graphicPageHandler = null;
            int v_iFocusedButton = 8;
            if (this.m_bFirstPop) {
                v_graphicPageHandler = (OiifmGraphicPageHandler)this._listener;
                v_iFocusedButton = v_graphicPageHandler.getDefaultFocusBearingButton();
                this.setFocusableButtonState(1, false);
            }
            this._listener.onView(invDlg.getDeinstallComps());
            if (v_graphicPageHandler == null) continue;
            v_graphicPageHandler.setDefaultFocusBearingButton(v_iFocusedButton);
            this.setFocusToButton(v_iFocusedButton);
            this.setFocusableButtonState(1, true);
        } while (v_bFirstPop != this.m_bFirstPop);
        this.m_bFirstPop = false;
        invDlg.dispose();
        invDlg = null;
    }

    public void onAbout(boolean bShowPeople) {
        if (null == this.m_creditsDlg) {
            OiifmCursorUtil.setCursor(this.waitCursor, (Component)((Object)this));
            this.m_creditsDlg = new OiifjCreditsDlg((Frame)((Object)this.m_frame), bShowPeople);
            OiifmCursorUtil.setCursor(this.defCursor, (Component)((Object)this));
            this.m_creditsDlg.runDialog();
            this.m_creditsDlg = null;
        }
    }

    public void onLanguage() {
        OiicInstallSession instSession = (OiicInstallSession)this.m_osim.getSession();
        OiicSessionContext sessionContext = instSession.getSessionContext();
        OiifjLangsDlg dlg = new OiifjLangsDlg((Frame)((Object)instSession.getMainFrame()), instSession);
        dlg.doModal();
        OiisVariable oSelLangs = sessionContext.getVariable("SELECTED_LANGUAGES");
        String[] strLang = (String[])oSelLangs.getValue();
        Vector vLangs = OiixLanguage.getLangsVector(strLang);
        instSession.setSelectedLanguages(vLangs);
    }

    public void onHelp() {
        if (this._listener != null) {
            this._listener.onHelp();
        }
    }

    public void onAccess(String sAccessFileName) {
        OiicPullSession oSession = (OiicPullSession)this.m_osim.getSession();
        if (oSession != null) {
            OiifmMainFrame oMainFrame = oSession.getMainFrame();
            OiifbSpawnReadme oSpwanAccessFile = new OiifbSpawnReadme();
            oSpwanAccessFile.displayFile(oMainFrame, sAccessFileName);
        }
    }

    public int doModal() throws OiifbCancelException {
        this.m_cancEx = null;
        if (this.m_buttonPressed == 1) {
            --this.m_nPageCounter;
        } else if (this.m_buttonPressed == 0) {
            ++this.m_nPageCounter;
        }
        if (!OiicPullSession.isSilentMode()) {
            if (null != this.m_frame) {
                if (!this.m_frame.isVisible()) {
                    this.hideSplashScr();
                    this.m_frame.show();
                    this.m_frame.repaint();
                    this.m_firstPanel = this.m_wizardPanel;
                    this.m_nPageCounter = 0;
                } else if (null == this.m_firstPanel) {
                    this.m_firstPanel = this.m_wizardPanel;
                    this.m_nPageCounter = 0;
                } else if (1 == this.m_nPageCounter && ((OiifpWizPanel)this.m_firstPanel).getTitleLabel().equals(((OiifpWizPanel)this.m_wizardPanel).getTitleLabel()) && ((OiifpWizPanel)this.m_firstPanel).getSubTitleLabel().equals(((OiifpWizPanel)this.m_wizardPanel).getSubTitleLabel())) {
                    this.m_nPageCounter = 0;
                }
            }
            if (0 == this.m_nPageCounter) {
                boolean bBack = Boolean.getBoolean("oracle.installer.exitonback");
                if (!bBack) {
                    this.setEnabledButton(2, false);
                    this.setNavButtonState(2, false);
                } else {
                    this.setEnabledButton(2, true);
                    this.setNavButtonState(2, true);
                }
            }
            this.setVisible(true);
            this.syncObj.sync();
            this.setPanelCursor(this.waitCursor);
        } else {
            this.onNext();
        }
        if (this.m_cancEx != null) {
            throw this.m_cancEx;
        }
        return this.m_buttonPressed;
    }

    public void clearCancelException() {
        this.m_cancEx = null;
    }

    public OiifbCancelException getCancelException() {
        return this.m_cancEx;
    }

    public int getButtonPressed() {
        return this.m_buttonPressed;
    }

    public void hideSplashScr() {
        if (null != this.m_splashScr) {
            this.m_splashScr.setVisible(false);
            this.m_splashScr = null;
        }
    }

    public void addWizardActionListener(OiifwWizActionListener lnr) {
        this._listener = lnr;
    }

    public void setExitActions(OiifwExitEventListener exitActions) {
        this.m_exitActions = exitActions;
    }

    public void setStateImage(Image stateImage) {
    }

    public void incrementPageCount() {
        ++this.m_nPageCounter;
    }

    public void decrementPageCount() {
        if (this.m_nPageCounter > 0) {
            --this.m_nPageCounter;
        }
    }

    public void addWizardPanel(LWContainer wizPanel) {
        this.m_mainPanel.setVisible(false);
        if (this.m_bProgPanelAdded) {
            this.m_bProgPanelAdded = false;
            this.m_northPanel.remove((Component)this.m_progressPanel);
            this.m_northPanel.add((Component)this.m_placeHolderPanel, (Object)"East");
        }
        this.m_mainPanel.remove((Component)this.m_wizardPanel);
        this.m_wizardPanel = wizPanel;
        OiifmMnemonicOps.processMnemonic((Container)this.m_wizardPanel);
        this.m_mainPanel.add((Component)this.m_wizardPanel, (Object)"Center");
        this.m_frame.addWizardDialog(this);
        this.m_wizardPanel.validate();
        StatusBarTextItem wizardPageLabel = (StatusBarTextItem)this.m_statusBar.getItem(0);
        String sPageTitle = ((OiifpWizPanel)this.m_wizardPanel).getTitleLabel();
        Object[] args = new String[]{sPageTitle};
        wizardPageLabel.setText(OiixResourceBundle.getString("S_WIZARD_PAGE_ACCESSIBLE_NAME", args));
        this.setPanelCursor(this.defCursor);
        this.m_mainPanel.setVisible(true);
        this.m_frame.toFront();
        this.m_osim = OiicSessionInterfaceManager.getInterfaceManager();
        OiifmGraphicInterfaceManager ogif = (OiifmGraphicInterfaceManager)this.m_osim;
        ((OiifpWizPanel)this.m_wizardPanel).setKeyActionConverter(ogif.getKeyActionConverter());
        ogif.disposeNextSessionProgress();
    }

    public boolean setEnabledButton(int p_iButton, boolean p_bEnabled) {
        return this.m_navPanel.setEnabledButton(p_iButton, p_bEnabled);
    }

    public void setBusy(boolean busy) {
        this.setPanelCursor(this.waitCursor);
    }

    public void setViewOnly(boolean viewOnly) {
        this.m_viewOnly = viewOnly;
    }

    public void updateExitLabel() {
        this.m_navPanel.updateExitLabel();
    }

    public void updateCancelLabel() {
        this.m_navPanel.updateCancelLabel();
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.m_bIsWindowClosing = true;
        ((OiifpWizPanel)this.m_wizardPanel).updateEnabledComponentsStatus(false);
        this.disableButtons();
        this.onExit();
        this.m_bIsWindowClosing = false;
        this.restoreButtons();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
        this.m_navPanel.setFocusToButton(4);
    }

    public void setFocusToButton(int p_iButton) {
        this.m_navPanel.setFocusToButton(p_iButton);
    }

    public void setFocusableButtonState(int p_iButton, boolean p_bFocusable) {
        this.m_navPanel.setFocusableButtonState(p_iButton, p_bFocusable);
    }

    public Dimension getPreferredSize() {
        return this.m_prefSize;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setTotalBytes(long bytes) {
        if (this.isProgressShown()) {
            if (this.m_bDlgProgressBar) {
                this.m_bProgPanelAdded = true;
                if (this.m_progressDlg.isVisible()) {
                    this.m_addedBytes = 0L;
                    this.m_oRangemodel.setValue(0);
                    this.m_progressBar.paintImmediate();
                    this.m_totalBytes = bytes;
                    return;
                }
                this.m_statusLabel.setForeground(this.m_defColor);
                String sText = this.m_statusLabel.getText();
                this.m_statusLabel.setText(DLG_PROG_LEN_STR);
                this.m_dlgPanel.add((Component)this.m_progressPanel, (Object)"Center");
                this.m_progressDlg.pack();
                this.m_statusLabel.setText(sText);
                this.m_progressDlg.setTitle(OiixResourceBundle.getString("S_STGINV_PROG_TITLE"));
                WindowUtils.centerWindow((Window)this.m_progressDlg, (Component)((Object)this.m_frame));
                this.m_progressDlg.setVisible(true);
            } else if (!this.m_bProgPanelAdded) {
                this.m_bProgPanelAdded = true;
                this.m_statusLabel.setForeground(this.m_defColor);
                this.m_northPanel.setVisible(false);
                this.m_northPanel.remove((Component)this.m_placeHolderPanel);
                String sText = this.m_statusLabel.getText();
                this.m_statusLabel.setText(PANEL_PROG_LEN_STR);
                this.m_northPanel.add((Component)this.m_progressPanel, (Object)"West");
                this.m_northPanel.validate();
                this.m_statusLabel.setText(sText);
                this.m_northPanel.setVisible(true);
            }
            this.m_addedBytes = 0L;
            this.m_oRangemodel = new BoundedRangeModelImpl(0, 100, 1);
            this.m_progressBar.setModel((StringRangeModel)this.m_oRangemodel);
            this.m_progressBar.paintImmediate();
            this.m_totalBytes = bytes;
        }
    }

    public void setStatus(String sMsg) {
        if (this.isProgressShown()) {
            this.m_statusLabel.setText(sMsg);
            this.m_statusLabel.requestFocus();
        }
    }

    public void onDoneProgress() {
        if (this.isProgressShown()) {
            if (this.m_totalBytes > 0L) {
                this.m_oRangemodel.setValue(100);
                this.m_progressBar.paintImmediate();
            }
            if (this.m_bDlgProgressBar) {
                this.m_bProgPanelAdded = false;
                if (this.bDoneProg || !this.isProgPropSet()) {
                    this.m_progressDlg.setVisible(false);
                    this.m_dlgPanel.remove((Component)this.m_progressPanel);
                }
                this.bDoneProg = true;
            } else if (this.m_bProgPanelAdded) {
                this.m_bProgPanelAdded = false;
                this.m_northPanel.setVisible(false);
                this.m_northPanel.remove((Component)this.m_progressPanel);
                this.m_northPanel.add((Component)this.m_placeHolderPanel, (Object)"East");
                this.m_northPanel.validate();
                this.m_northPanel.setVisible(true);
            }
            this.m_totalBytes = 0L;
            this.m_addedBytes = 0L;
        }
    }

    public void removeBytes(int bytes) {
        if (this.isProgressShown()) {
            this.m_addedBytes -= (long)bytes;
            if (this.m_addedBytes < 0L) {
                this.m_addedBytes = 0L;
            }
        }
    }

    public void addBytes(int bytes) {
        if (this.isProgressShown()) {
            if (!this.m_bProgPanelAdded) {
                this.m_bProgPanelAdded = true;
                this.m_northPanel.setVisible(false);
                if (this.m_totalBytes != 0L) {
                    int percent = (int)(this.m_addedBytes * 100L / this.m_totalBytes);
                    this.m_oRangemodel.setValue(percent);
                }
                this.m_northPanel.remove((Component)this.m_placeHolderPanel);
                String sText = this.m_statusLabel.getText();
                this.m_statusLabel.setText(PANEL_PROG_LEN_STR);
                this.m_northPanel.add((Component)this.m_progressPanel, (Object)"West");
                this.m_northPanel.validate();
                this.m_statusLabel.setText(sText);
                this.m_northPanel.setVisible(true);
            }
            if (this.m_totalBytes > 0L) {
                this.m_addedBytes += (long)bytes;
                int percent = (int)(this.m_addedBytes * 100L / this.m_totalBytes);
                this.m_oRangemodel.setValue(percent);
                OiipgBootstrap pgb = new OiipgBootstrap();
                if (pgb.isRepaintRequired()) {
                    this.m_progressBar.paintImmediate();
                }
            }
        }
    }

    public boolean isDialogProgressBar() {
        return this.m_bDlgProgressBar;
    }

    public void setDialogProgressBar(boolean bFlag) {
        this.m_bDlgProgressBar = bFlag;
    }

    public boolean isProgPropSet() {
        boolean bShowProp = Boolean.getBoolean("oracle.installer.showLoadProgress");
        boolean bRspSet = OiicSessionContext.isResponseFileUsed();
        return bShowProp && bRspSet;
    }

    public boolean isProgressShown() {
        boolean bShowProp = this.isProgPropSet();
        boolean bShown = false;
        if (!OiicPullSession.isSilentMode() && (this.m_frame.isVisible() || bShowProp)) {
            bShown = true;
            if (bShowProp) {
                this.m_bDlgProgressBar = true;
            }
        }
        return bShown;
    }

    public void setFirstPanel(LWContainer firstPanel) {
        this.m_firstPanel = firstPanel;
    }

    public boolean isAnyPanelVisible() {
        return this.m_firstPanel != null;
    }

    public void setTitle(String s) {
        if (null != this.m_frame) {
            this.m_frame.setTitle(null != s ? s : OiixResourceBundle.getString("S_TITLE"));
        }
    }

    public final String getTitle() {
        return null != this.m_frame ? this.m_frame.getTitle() : null;
    }

    public void disableButtons() {
        if (!this.m_bNavigationBtnsDisabled) {
            this.m_bNavigationBtnsDisabled = true;
            this.m_navPanel.disableButtons();
        }
    }

    public void restoreButtons() {
        if (this.m_bNavigationBtnsDisabled && !this.m_bIsWindowClosing) {
            this.m_navPanel.restoreButtons();
            this.m_bNavigationBtnsDisabled = false;
        }
    }

    public void setNavButtonState(int nButton, boolean bState) {
        this.m_navPanel.setNavButtonState(nButton, bState);
    }

    private void setPanelCursor(Cursor cursor) {
        int iType = cursor.getType();
        if (iType != this.m_iCursorType) {
            this.m_iCursorType = iType;
            OiifmCursorUtil.setCursor(cursor, (Component)this.m_wholePanel);
        }
    }

    public void setNewSessionProperties() {
        this.setFirstPanel(null);
        this.m_navPanel.updateCancelLabel();
        this.setNavButtonState(4, true);
        this.setNavButtonState(8, true);
        this.setNavButtonState(1, true);
        this.setViewOnly(false);
    }

    public final boolean isPrepareInventoryTreeThreadCreated() {
        return null != this.m_invTree;
    }

    public final boolean isFirstPopDone() {
        return this.m_bFirstPop;
    }

    public void addPercentage(int percent) {
        this.addBytes((int)((long)percent * this.m_totalBytes / 100L));
    }

    public boolean canNavigateBack() {
        boolean bBack = Boolean.getBoolean("oracle.installer.exitonback");
        return this.m_nPageCounter == 0 && bBack;
    }

    private class PrepareInventoryTree
    implements Runnable {
        OiifwWizDialog m_wd = null;

        PrepareInventoryTree(OiifwWizDialog p_oiifwWizDialog) {
            this.m_wd = p_oiifwWizDialog;
        }

        public void run() {
            this.m_wd.onViewPrivate();
        }
    }
}

