/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiig;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import oracle.sysman.oii.oiig.OiigAvailSoftware;
import oracle.sysman.oii.oiig.OiigXmlOps;
import oracle.sysman.oii.oiix.OiixVectorOps;
import oracle.sysman.oix.oixp.OixpIElement;
import oracle.sysman.oix.oixw.OixwIXmlWriter;

public class OiigAvailSoftRequest
implements OixwIXmlWriter {
    private Vector m_reqSets = new Vector();
    private long[] m_knownComps = null;
    private long[] m_knownSets = null;
    private int m_numLevels = -1;
    public static final String MAIN_TAG_TYPE = "AvailSoftReq";
    public static final String KNOWNSETS_TAG = "KnownSets";
    public static final String KNOWNCOMPS_TAG = "KnownComps";
    public static final String REQSETS_TAG = "ReqSets";
    private static final String NUMLEVELS_ATTR = "NumLevels";

    public OiigAvailSoftRequest() {
    }

    public OiigAvailSoftRequest(OiigAvailSoftware availSoft) {
        this();
        this.setKnownComps(availSoft.getAllCompIDs());
        this.setKnownSets(availSoft.getAllSetIDs());
    }

    public OiigAvailSoftRequest(OixpIElement el) {
        this();
        String numLevStr = el.getAttribValue(NUMLEVELS_ATTR);
        this.setNumLevels(Integer.parseInt(numLevStr));
    }

    public void setReqSets(Vector reqSets) {
        this.m_reqSets = reqSets;
    }

    public void addSetRequest(int setIndex) {
        Integer setInt = new Integer(setIndex);
        if (!this.m_reqSets.contains(setInt)) {
            this.m_reqSets.addElement(setInt);
        }
    }

    public void setKnownComps(long[] knownComps) {
        this.m_knownComps = knownComps;
    }

    public void setKnownSets(long[] knownSets) {
        this.m_knownSets = knownSets;
    }

    public void setNumLevels(int numLevels) {
        this.m_numLevels = numLevels;
    }

    public Vector getReqSets() {
        return this.m_reqSets;
    }

    public long[] getKnownComps() {
        return this.m_knownComps;
    }

    public long[] getKnownSets() {
        return this.m_knownSets;
    }

    public int getNumLevels() {
        return this.m_numLevels;
    }

    public void writeXmlForm(PrintWriter pw) throws IOException {
        pw.println("<AvailSoftReq NumLevels=\"" + this.m_numLevels + "\">");
        if (this.m_knownSets != null) {
            pw.println("<KnownSets>" + OiigXmlOps.stringWithNumArr(this.m_knownSets) + "</" + KNOWNSETS_TAG + ">");
        }
        if (this.m_knownComps != null) {
            pw.println("<KnownComps>" + OiigXmlOps.stringWithNumArr(this.m_knownComps) + "</" + KNOWNCOMPS_TAG + ">");
        }
        if (this.m_reqSets != null) {
            pw.println("<ReqSets>" + OiigXmlOps.stringWithNumVect(this.m_reqSets) + "</" + REQSETS_TAG + ">");
        }
        pw.println("</AvailSoftReq>");
    }

    public String toString() {
        return "[AvailSoftwareRequest ::  ReqSets : " + OiixVectorOps.objToString(this.m_reqSets) + " NumLevels : " + this.m_numLevels + " KnownSets : " + OiixVectorOps.objToString(this.m_knownSets) + " KnownComps : " + OiixVectorOps.objToString(this.m_knownComps) + "]";
    }
}

