/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiig;

import java.util.Vector;
import oracle.sysman.oii.oiig.OiigAvailSoftware;
import oracle.sysman.oii.oiig.OiigCompInfo;
import oracle.sysman.oii.oiig.OiigSetInfo;
import oracle.sysman.oii.oiig.OiigXmlOps;
import oracle.sysman.oix.oixp.OixpIElement;
import oracle.sysman.oix.oixp.OixpIRegHandler;

public class OiigAvailSoftXmlHandler
implements OixpIRegHandler {
    private OiigAvailSoftware m_availSoft;
    private OiigCompInfo m_comp;
    private OiigSetInfo m_set;
    private String m_text;
    private Vector m_addedComps;
    private Vector m_addedSets;
    private static final String[] s_hndlTags = new String[]{"AvailSoft"};

    public OiigAvailSoftXmlHandler(OiigAvailSoftware availSoft) {
        this.m_availSoft = availSoft;
        this.m_addedSets = new Vector();
        this.m_addedComps = new Vector();
    }

    public OiigAvailSoftXmlHandler() {
        this(new OiigAvailSoftware());
    }

    public boolean doStartTag(OixpIElement el) {
        String type = el.getType();
        if (type.equalsIgnoreCase("AvailSoft")) {
            el.setObject(this.m_availSoft);
        } else if (type.equalsIgnoreCase("Comp")) {
            this.m_comp = new OiigCompInfo(el);
            el.setObject(this.m_comp);
        } else if (type.equalsIgnoreCase("Set")) {
            this.m_set = new OiigSetInfo(el);
            el.setObject(this.m_set);
        }
        return false;
    }

    public boolean doText(OixpIElement el, String text) {
        this.m_text = text;
        this.debug("In doText text=" + this.m_text);
        return false;
    }

    public boolean doEndTag(OixpIElement el) {
        String type = el.getType();
        this.debug("In doETag, Element type=" + type);
        if (type.equalsIgnoreCase("Comp")) {
            this.m_availSoft.addComp(this.m_comp);
            this.m_addedComps.addElement(new Long(this.m_comp.getIndex()));
        } else if (type.equalsIgnoreCase("Set")) {
            this.m_availSoft.addSet(this.m_set);
            this.m_addedSets.addElement(new Long(this.m_set.getIndex()));
        } else if (type.equalsIgnoreCase("CSets")) {
            this.m_set.setChildrenSets(OiigXmlOps.parseLongArrFromString(this.m_text));
        } else if (type.equalsIgnoreCase("CComps")) {
            this.m_set.setChildrenComps(OiigXmlOps.parseLongArrFromString(this.m_text));
        }
        return false;
    }

    public String[] getTagsForRegistration() {
        return s_hndlTags;
    }

    public OiigAvailSoftware getAvailSoftware() {
        return this.m_availSoft;
    }

    public Vector getAddedSets() {
        return this.m_addedSets;
    }

    public Vector getAddedComps() {
        return this.m_addedComps;
    }

    private void debug(String msg) {
    }
}

